<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\ArticleModelDB;
use admin_application\AdminPublicDB;
use admin_application\link\ArticleLink;

class KeywordsOptimization {

	public function __construct() {
		$exclude_method = array('listKeywordsOptimization', 'KeywordsOptimizationSearchOut', 'saveKeywordsOptimization', 'setKeywordsOptimization');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listKeywordsOptimization() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng'";
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$mid = $_REQUEST['mid'];
			if (espcms_ismatches($mid) && $mid) {
				$db_where .= " AND mid=$mid";
			}
			$islink = $_REQUEST['islink'];
			if (espcms_ismatches($islink)) {
				$db_where .= " AND islink=$islink";
			}
			$istop = $_REQUEST['istop'];
			if (espcms_ismatches($istop)) {
				$db_where .= " AND istop=$istop";
			}
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$search_key = $_REQUEST['search_key'];
			if (isset($search_key) && espcms_ismatches($_REQUEST['issearch'])) {
				$db_where .= " AND keywordname LIKE '%$search_key%'";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('kid', 'pid', 'mid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "kid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = ArticleLink::KeywordsOptimization_link_array('edit', $fetch_row);
				$fetch_row['modelname'] = ArticleModelDB::get_mid_view($fetch_row['mid'], 'modelname');
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$list_type = $_GET['list_type'];
			$templates = $list_type == 'select' ? 'article/keywords_optimization_list_select' : 'article/keywords_optimization_list';
		} elseif ($out_type == 'select') {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$_REQUEST['list_type'] = 'select';
			$espcms_admin_templates->into('link', ArticleLink::KeywordsOptimization_link_array(false, $_REQUEST));
			$espcms_admin_templates->into('inputname', $_GET['inputname']);
			$espcms_admin_templates->into('iframes_name', $_GET['iframeName']);
			$templates = 'article/keywords_optimization_index_select';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', ArticleLink::KeywordsOptimization_link_array(false, $_REQUEST));
			$templates = 'article/keywords_optimization_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function KeywordsOptimizationSearchOut() {
		global $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$select_id_list = $_GET['select_id_list'];
		if (!preg_match("/^[\d\,]+$/i", $select_id_list)) {
			exit('');
		}
		$db_sql = "SELECT keywordname FROM $db_table WHERE kid IN ($select_id_list) ORDER BY kid DESC";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row['keywordname'];
		}
		$out_str = is_array($array) ? implode(',', $array) : '';
		exit($out_str);
	}

	public static function addKeywordsOptimization() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', ArticleLink::KeywordsOptimization_link_array());
		$espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/keywords_optimization_add');
	}

	public static function editKeywordsOptimization() {
		global $espcms_admin_templates;
		$kid = $_GET['kid'];
		if (!$kid || !espcms_ismatches($kid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($kid));
		}
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$db_where = " WHERE kid=$kid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list($read['mid']));
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', ArticleLink::KeywordsOptimization_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/keywords_optimization_edit');
	}

	public static function saveKeywordsOptimization() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['mid']) || empty($_POST['mid']) || !espcms_ismatches($_POST['islink'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addKeywordsOptimization')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			if (!espcms_ismatches($_POST['add_list_id'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['add_list_id']));
			}
			if ($_POST['add_list_id'] == 0 || count($_POST['keywordname']) == 1) {
				$_POST['keywordname'] = $_POST['keywordname'][0];
				$postvalue = espcms_post($_POST, $talbe_field_array, true);
				if (!$postvalue || !is_array($postvalue)) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
				espcms_log_install('article_pack-espcms_keywords_optimization_button_add', $_POST['keywordname']);
				espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_keywords_optimization_add_save_ok_message', 'true', array($_POST['keywordname']));
			} elseif ($_POST['add_list_id'] > 0 && is_array($_POST['keywordname']) && count($_POST['keywordname']) > 1) {
				foreach ($_POST['keywordname'] as $key => $value) {
					$_POST['keywordname'] = $value;
					$postvalue = espcms_post($_POST, $talbe_field_array, true);
					if (!$postvalue || !is_array($postvalue)) {
						continue;
					}
					$install_id = espcms_db_install_save($db_table, $postvalue);
				}
				espcms_log_install('article_pack-espcms_keywords_optimization_button_add_bat');
				espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_keywords_optimization_add_bat_save_ok_message', 'true');
			}
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editKeywordsOptimization')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$kid = $_POST['kid'];
			if (empty($kid) || !espcms_ismatches($kid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($kid));
			}
			$db_where = "WHERE kid=$kid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($kid));
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('article_pack-espcms_keywords_optimization_button_edit', $_POST['keywordname']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_keywords_optimization_edit_save_ok_message', 'true', array($_POST['keywordname']));
		}
	}

	public static function setKeywordsOptimization() {
		if (!ESPCMS_AdminAuthority::authorityVerify('editKeywordsOptimization')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE kid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
			}
		}
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('article_pack-espcms_keywords_optimization_button_set', "$field=$field_value" . " mid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'article_pack-espcms_keywords_optimization_set_message', 'true', array($field));
	}

	public static function delKeywordsOptimization() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delKeywordsOptimizationDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('article_pack-espcms_recommend_tags_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_recommend_tags_del_message', 'true', array(), 'json', $return);
	}

	private static function delKeywordsOptimizationDB($kid = 0) {
		if (!$kid || !espcms_ismatches($kid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $kid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		$del_query = espcms_db_del($db_table, 'kid', $kid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $kid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $kid);
			return $return_array;
		}
	}

	public static function sortKeywordsOptimization() {
		if (!ESPCMS_AdminAuthority::authorityVerify('editKeywordsOptimization')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		$db_table = ESPCMS_DB_PREFIX . "keylink";
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
				espcms_db_update_set_save($db_table, "WHERE kid=$value", "pid=$pid");
			}
		}
		espcms_log_install('article_pack-espcms_keywords_optimization_button_sort', 'kid=' . $value);
		exit('true');
	}

}
