<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\ApplyDB;
use admin_application\AdminPublicDB;
use application\ESPCMS_FileTool;
use application\ESPCMS_Core;
use admin_application\link\SettingLink;

class LanguagePack {

	public function __construct() {
		$exclude_method = array('saveLanguagePack', 'verifyLanguagePack');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listLanguagePack() {
		global $espcms_admin_templates, $espcms_link_db, $espcms_command;
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = !empty($lng) && preg_match("/^[a-z0-9]{2,50}$/i", $lng) ? " AND lng='$lng'" : (!empty($espcms_command['DEFAULT_LNG']) && preg_match("/^[a-z0-9]{2,50}$/i", $espcms_command['DEFAULT_LNG']) ? " AND lng='$espcms_command[DEFAULT_LNG]'" : " AND lng='cn'");
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$typeid = $_REQUEST['typeid'];
			if (espcms_ismatches($typeid) && !empty($typeid)) {
				$db_where .= " AND typeid=$typeid";
			}
			$typeclass = $_REQUEST['typeclass'];
			if (espcms_isact($typeclass, "/^[\w]+$/i") && $typeclass) {
				$db_where .= " AND typeclass='$typeclass'";
			}
			$lockin = $_REQUEST['lockin'];
			if (espcms_ismatches($lockin)) {
				$db_where .= " AND lockin=$lockin";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('lpid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "lpid";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = SettingLink::LanguagePack_link_array('edit', $fetch_row);
				$fetch_row['copyadd'] = SettingLink::LanguagePack_link_array('copyadd', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/language_pack_list';
		} else {
			$espcms_admin_templates->into('apply_list', ApplyDB::get_apply_list());
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::LanguagePack_link_array(false, $_REQUEST));
			$templates = 'admin/language_pack_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addLanguagePack() {
		global $espcms_admin_templates, $espcms_command;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$type = $_GET['type'];
		$type = empty($type) ? 'add' : 'copy';
		if ($type == 'copy') {
			$lpid = $_GET['lpid'];
			if (!$lpid || !espcms_ismatches($lpid)) {
				espcms_message_err('public_pack-espcms_input_parameter_fail', array($lpid));
			}
			$db_table = ESPCMS_DB_PREFIX . "lngpack";
			$db_where = " WHERE lpid=$lpid";
			$talbe_field_array = espcms_field_out($db_table, false);
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
			}
			$lan_array = AdminPublicDB::get_lan_list($read['lng'], false, false, true);
			$espcms_admin_templates->into('lan_array', $lan_array);
			$espcms_admin_templates->into('read', $read);
		} else {
			$lan_array = AdminPublicDB::get_lan_list($espcms_command['DEFAULT_LNG'], false, false, true);
			$espcms_admin_templates->into('lan_array', $lan_array);
		}
		$espcms_admin_templates->into('apply_list', ApplyDB::get_apply_list());
		$espcms_admin_templates->into('link', SettingLink::LanguagePack_link_array());
		$espcms_admin_templates->into('type', $type);
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_pack_add');
	}

	public static function editLanguagePack() {
		global $espcms_admin_templates;
		$lpid = $_GET['lpid'];
		if (!$lpid || !espcms_ismatches($lpid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($lpid));
		}
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$db_where = " WHERE lpid=$lpid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$lan_array = AdminPublicDB::get_lan_list($read['lng'], false, false, true);
		$espcms_admin_templates->into('lan_array', $lan_array);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('apply_list', ApplyDB::get_apply_list($read['typeclass']));
		$espcms_admin_templates->into('link', SettingLink::LanguagePack_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_pack_edit');
	}

	public static function saveLanguagePack() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$talbe_field_array = espcms_field_out($db_table, true);
		$creat_path = ESPCMS_FILE_ROOT . 'espcms_datacache/';
		if (!ESPCMS_FileTool::filemode($creat_path)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_filedir_write_err', 'false', array($creat_path));
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addLanguagePack')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['typeid'] = 0;
			$_POST['lockin'] = 1;
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if (!ESPCMS_Core::creat_lanpack($_POST['lng'])) {
				espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_setting_creat_err', 'false', array('/espcms_datacache/' . $_POST['lng'] . '_pack.php'));
			}
			espcms_log_install('setting_pack-espcms_language_pack_button_add', $_POST['title']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_pack_add_save_ok_message', 'true', array($_POST['title']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editLanguagePack')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$lpid = $_POST['lpid'];
			if (empty($lpid) || !espcms_ismatches($lpid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lpid));
			}
			$db_where = "WHERE lpid=$lpid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lpid));
			}
			if ($read['lockin']) {
				$_POST['typeid'] = 0;
			} else {
				$_POST['lng'] = $read['lng'];
				$_POST['title'] = $read['title'];
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if (!ESPCMS_Core::creat_lanpack($_POST['lng'])) {
				espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_setting_creat_err', 'false', array('/espcms_datacache/' . $_POST['lng'] . '_pack.php'));
			}
			espcms_log_install('setting_pack-espcms_language_pack_button_edit', $_POST['title']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_pack_edit_save_ok_message', 'true', array($_POST['title']));
		}
	}

	public static function delLanguagePack() {
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delLanguagePackDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_language_pack_button_del', $espcms_del_id);
		if ($delcount > 0) {
			ESPCMS_Core::creat_lanpack($operate_result['lng']);
		}
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_pack_del_message', 'true', array(), 'json', $return);
	}

	public static function delLanguagePackDB($lpid = 0) {
		if (!$lpid || !espcms_ismatches($lpid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $lpid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE lockin=1 AND lpid=$lpid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $lpid);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'lpid', $lpid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $lpid, 'lng' => $read['lng']);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $lpid, 'lng' => $read['lng']);
			return $return_array;
		}
	}

	public static function verifyLanguagePack($verify_key = false, $verify_value = false) {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$lng = $_REQUEST['lng'];
		$field_array = array('keycode');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			$renturn_value = 'false';
		}
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$lpid = intval($_REQUEST['lpid']);
		$db_where = " AND lng='$lng'";
		if (empty($lpid) || !espcms_ismatches($lpid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND lpid!=$lpid" : " AND $verifyKey='$verifyValue' AND lpid!=$lpid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		exit($db_num);
	}

}
