<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_AdminAuthority;
use admin_application\AdminPublicDB;
use admin_application\IndexFile;
use admin_application\ApplyDB;
use application\ESPCMS_FileTool;
use admin_application\link\SettingLink;

class LanguageSite {

	private static $language_site_list_cache_key;
	private static $language_site_read_cache_key;

	public function __construct() {
		$exclude_method = array('saveLanguageSite', 'verifyLanguageSite');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$language_site_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'lng_';
		self::$language_site_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'lng_';
	}

	public static function listLanguageSite() {
		global $espcms_admin_templates, $espcms_link_db, $espcms_command;
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;
			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;
			$islink = $_REQUEST['islink'];
			if (espcms_ismatches($islink)) {
				$db_where .= " AND islink=$islink";
			}
			$lockin = $_REQUEST['lockin'];
			if (espcms_ismatches($lockin)) {
				$db_where .= " AND lockin=$lockin";
			}
			$iswap = $_REQUEST['iswap'];
			if (espcms_ismatches($iswap)) {
				$db_where .= " AND iswap=$iswap";
			}
			$isopen = $_REQUEST['isopen'];
			if (espcms_ismatches($isopen)) {
				$db_where .= " AND isopen=$isopen";
			}
			$ispack = $_REQUEST['ispack'];
			if (espcms_ismatches($ispack)) {
				$db_where .= " AND ispack=$ispack";
			}
			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}
			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('lan_id');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "lan_id";
			}
			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = SettingLink::LanguageSite_link_array('edit', $fetch_row);
				$fetch_row['copy_pack'] = SettingLink::LanguageSite_link_array('copy_pack', $fetch_row);
				$fetch_row['copy_template'] = SettingLink::LanguageSite_link_array('copy_template', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('isalong', $espcms_command['IS_ALONELNG']);
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/language_site_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::LanguageSite_link_array(false, $_REQUEST));
			$templates = 'admin/language_site_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addLanguageSite() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', SettingLink::LanguageSite_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_site_add');
	}

	public static function editLanguageSite() {
		global $espcms_admin_templates;
		$lan_id = $_GET['lan_id'];
		if (!$lan_id || !espcms_ismatches($lan_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($lan_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$db_where = " WHERE lan_id=$lan_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::LanguageSite_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_site_edit');
	}

	public static function copyLanguagePack() {
		global $espcms_admin_templates;
		$lan_id = $_GET['lan_id'];
		if (!$lan_id || !espcms_ismatches($lan_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($lan_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$db_where = " WHERE lan_id=$lan_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$lan_array = AdminPublicDB::get_lan_exclude_list(false, $read['lng']);
		$espcms_admin_templates->into('lan_array', $lan_array);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::LanguageSite_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_site_copy_lanpack');
	}

	public static function copyTemplatePack() {
		global $espcms_admin_templates;
		$lan_id = $_GET['lan_id'];
		if (!$lan_id || !espcms_ismatches($lan_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($lan_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$db_where = " WHERE lan_id=$lan_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$lan_array = AdminPublicDB::get_lan_exclude_list(false, $read['lng']);
		$espcms_admin_templates->into('lan_array', $lan_array);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::LanguageSite_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/language_site_copy_template');
	}

	public static function saveLanguageSite() {
		global $espcms_db_cache, $espcms_command;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$talbe_field_array = espcms_field_out($db_table, true);
		if ($saveType == 'add' || $saveType == 'edit') {
			$_POST['ispack'] = $_POST['ispack'];
			if (!espcms_ismatches($_POST['ispack'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['ispack']));
			}
			if (!$_POST['ispack']) {
				$_POST['packname'] = '';
			}
			$_POST['islink'] = $_POST['islink'];
			if (!espcms_ismatches($_POST['islink'])) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_POST['islink']));
			}
			if (!$_POST['islink']) {
				$_POST['url'] = '';
			}
			$html_creat_path = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
			if (!ESPCMS_FileTool::filemode($html_creat_path)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_filedir_write_err', 'false', array($html_creat_path));
			}
			$html_creat_dir = $_POST['ispack'] ? $html_creat_path . $_POST['packname'] : $html_creat_path . $_POST['lng'];
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addLanguageSite')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['iswap'] = 1;
			$_POST['isopen'] = 1;
			if (!is_dir($html_creat_dir)) {
				$mkdir_return = mkdir($html_creat_dir);
				if (!$mkdir_return) {
					espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_dircreat_err', 'false', array($html_creat_dir));
				}
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$language_site_list_cache_key, true);
			espcms_log_install('setting_pack-espcms_language_site_button_add', $_POST['lngtitle']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_site_add_save_ok_message', 'true', array($_POST['lngtitle']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editLanguageSite')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$lan_id = $_POST['lan_id'];
			if (empty($lan_id) || !espcms_ismatches($lan_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lan_id));
			}
			$db_where = "WHERE lan_id=$lan_id";
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if (!is_dir($html_creat_dir)) {
				$mkdir_return = mkdir($html_creat_dir);
				if (!$mkdir_return) {
					espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_dircreat_err', 'false', array($html_creat_dir));
				}
			}
			$espcms_db_cache->cacheDEL(self::$language_site_read_cache_key . $lan_id);
			$espcms_db_cache->cacheDEL(self::$language_site_read_cache_key . $_POST['lng']);
			$espcms_db_cache->cacheDEL(self::$language_site_list_cache_key, true);
			espcms_log_install('setting_pack-espcms_language_site_button_edit', $_POST['lngtitle']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_site_edit_save_ok_message', 'true', array($_POST['lngtitle']));
		} elseif ($saveType == 'copy_pack') {
			if (!ESPCMS_AdminAuthority::authorityVerify('copyLanguagePack')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$lan_id = $_POST['lan_id'];
			if (!$lan_id || !espcms_ismatches($lan_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lan_id));
			}
			if (!$_POST['tolng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['tolng'])) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_to_lng_validation_msg', 'false');
			}
			$db_where = "WHERE lan_id=$lan_id";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if ($_POST['tolng'] == $read['lng']) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err', 'false');
			}
			$db_table_lngpack = ESPCMS_DB_PREFIX . 'lngpack';
			$db_where_lngpack = " AND lng='$read[lng]'";
			$talbe_field_lngpack_array = espcms_field_out($db_table_lngpack, true);
			$pack_array = espcms_db_list_array($db_table_lngpack, $talbe_field_lngpack_array, $db_where_lngpack, "lpid ASC");
			if (!is_array($pack_array) || count($pack_array) < 1) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err2', 'false');
			}
			$pack_install_array = array();
			foreach ($pack_array as $key => $value) {
				if (!self::countLanPack($_POST['tolng'], $value['keycode'])) {
					continue;
				}
				$install_post['lng'] = $_POST['tolng'];
				$install_post['pid'] = $value['pid'];
				$install_post['title'] = $value['title'];
				$install_post['keycode'] = $value['keycode'];
				$install_post['langstr'] = $value['langstr'];
				$install_post['lockin'] = $value['lockin'];
				$install_post['typeid'] = $value['typeid'];
				$pack_install_array[] = espcms_post($install_post, $talbe_field_lngpack_array, true, true);
			}
			if (is_array($pack_install_array)) {
				$install_id = espcms_db_install_array_save($db_table_lngpack, $pack_install_array);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err2', 'false');
			}
			espcms_log_install('setting_pack-espcms_language_site_button_copypack', $_POST['tolng']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_site_tolng_message_ok', 'true');
		} elseif ($saveType == 'copy_template') {
			if (!ESPCMS_AdminAuthority::authorityVerify('copyTemplatePack')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$lan_id = $_POST['lan_id'];
			if (!$lan_id || !espcms_ismatches($lan_id)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lan_id));
			}
			if (!$_POST['tolng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_POST['tolng'])) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_to_lng_validation_msg', 'false');
			}
			$db_where = "WHERE lan_id=$lan_id";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if ($_POST['tolng'] == $read['lng']) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err', 'false');
			}
			$db_table_template_pack = ESPCMS_DB_PREFIX . 'templates';
			$db_where_template_pack = " AND lng='$read[lng]'";
			if ($_POST['copytype'] == 1) {
				$db_where_template_pack .= " AND styleclass='sms'";
			} elseif ($_POST['copytype'] == 2) {
				$db_where_template_pack .= " AND styleclass='email'";
			}
			$talbe_field_template_array = espcms_field_out($db_table_template_pack, true);
			$template_array = espcms_db_list_array($db_table_template_pack, $talbe_field_template_array, $db_where_template_pack, "tmid ASC");
			if (!is_array($template_array) || count($template_array) < 1) {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err3', 'false');
			}
			$install_array = array();
			foreach ($template_array as $key => $value) {
				if (!self::countTemplate($_POST['tolng'], $value['templatecode'], $value['styleclass'])) {
					continue;
				}
				$install_post['lng'] = $_POST['tolng'];
				$install_post['templatename'] = $value['templatename'];
				$install_post['templatecode'] = $value['templatecode'];
				$install_post['title'] = $value['title'];
				$install_post['templatecontent'] = $value['templatecontent'];
				$install_post['typeclass'] = $value['typeclass'];
				$install_post['styleclass'] = $value['styleclass'];
				$install_post['lockin'] = $value['lockin'];
				$install_post['addtime'] = $value['addtime'];
				$install_post['isclass'] = $value['isclass'];
				$install_array[] = espcms_post($install_post, $talbe_field_template_array, true, true);
			}
			if (is_array($install_array)) {
				$install_id = espcms_db_install_array_save($db_table_template_pack, $install_array);
			} else {
				espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_tolng_message_err2', 'false');
			}
			espcms_log_install('setting_pack-espcms_language_site_button_copytemplates', $_POST['tolng']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_language_site_copytemplate_message_ok', 'true');
		}
	}

	private static function countLanPack($lng = false, $keycode = false) {
		if (!preg_match("/^[a-z0-9]{2,50}$/i", $lng) || !preg_match("/^[\w]+$/i", $keycode)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "lngpack";
		$db_where = " AND lng='$lng' AND keycode='$keycode'";
		$db_num = espcms_db_num($db_table, $db_where);
		if ($db_num) {
			return false;
		} else {
			return true;
		}
	}

	private static function countTemplate($lng = false, $templatecode = false, $styleclass = false) {
		if (!preg_match("/^[a-z0-9]{2,50}$/i", $lng) || !preg_match("/^[\w]+$/i", $templatecode)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "templates";
		$db_where = " AND lng='$lng' AND templatecode='$templatecode' AND styleclass='$styleclass'";
		$db_num = espcms_db_num($db_table, $db_where);
		if ($db_num) {
			return false;
		} else {
			return true;
		}
	}

	public static function delLanguageSite() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delLanguageSiteDB($value);
			if ($operate_result['code'] == 'true') {
				$espcms_db_cache->cacheDEL(self::$language_site_read_cache_key . $value, true);
				$delcount++;
			}
		}
		if ($delcount > 0) {
			$espcms_db_cache->cacheDEL(self::$language_site_list_cache_key, true);
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_language_site_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_language_site_del_message', 'true', array(), 'json', $return);
	}

	public static function delLanguageSiteDB($lan_id = 0) {
		if (!$lan_id || !espcms_ismatches($lan_id)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $lan_id);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE lockin=0 AND lan_id=$lan_id";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $lan_id);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'lan_id', $lan_id);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $lan_id);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $lan_id);
			return $return_array;
		}
	}

	public static function setLanguageSite() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE lan_id=$value", "$field='$field_value'");
			if ($update_key) {
				$espcms_db_cache->cacheDEL(self::$language_site_read_cache_key . $value, true);
				$update_count++;
			}
		}
		if ($update_count > 0) {
			$espcms_db_cache->cacheDEL(self::$language_site_list_cache_key, true);
		}
		$set_info_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_language_site_button_set', "$field=$field_value" . " lan_id=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_language_site_set_message', 'true', array($field));
	}

	public static function verifyLanguageSite($verify_key = false, $verify_value = false) {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$field_array = array('lng', 'url', 'packname');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			$renturn_value = 'false';
		}
		$db_table = ESPCMS_DB_PREFIX . "lng";
		$lan_id = intval($_REQUEST['lan_id']);
		if (empty($lan_id) || !espcms_ismatches($lan_id)) {
			if ($verifyKey == 'lng' || $verifyKey == 'packname') {
				$db_where = $verifyType ? " AND (lng!='$verifyValue' OR packname!='$verifyValue')" : " AND (lng='$verifyValue' OR packname='$verifyValue')";
			} else {
				$db_where = $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
			}
		} else {
			if ($verifyKey == 'lng' || $verifyKey == 'packname') {
				$db_where = $verifyType ? " AND (lng!='$verifyValue' OR packname!='$verifyValue') AND lan_id!=$lan_id" : " AND (lng='$verifyValue' OR packname='$verifyValue') AND lan_id!=$lan_id";
			} else {
				$db_where = $verifyType ? " AND $verifyKey!='$verifyValue' AND lan_id!=$lan_id" : " AND $verifyKey='$verifyValue' AND lan_id!=$lan_id";
			}
		}
		$db_num = espcms_db_num($db_table, $db_where);
		exit($db_num);
	}

	public static function creatIndexFile() {
		global $espcms_command;
		if (!$espcms_command['IS_ALONELNG']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		$lan_id = $_POST['lan_id'];
		if (empty($lan_id) || !espcms_ismatches($lan_id)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($lan_id));
		}
		$lan_read = AdminPublicDB::get_lan_view($lan_id);
		if (!$lan_read || !is_array($lan_read)) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
		}
		$html_creat_path = !$espcms_command['IS_HTMLDIR'] ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . $espcms_command['FILE_HTMLDIR'];
		if (!ESPCMS_FileTool::filemode($html_creat_path)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_filedir_write_err', 'false', array($html_creat_path));
		}
		$html_creat_dir = $lan_read['ispack'] ? $html_creat_path . $lan_read['packname'] . '/' : $html_creat_path . $lan_read['lng'] . '/';
		$file_templates = IndexFile::index_template($lan_read['lng']);
		$file_index_name = $html_creat_dir . $espcms_command['ENTRANCE_FILE'] . '.php';
		if (!is_dir($html_creat_dir)) {
			if (!@mkdir($html_creat_dir, 0777, true)) {
				espcms_public_dialog('info_set_ok', 'setting_pack-espcms_language_site_dircreat_err', 'false', array($html_creat_dir));
			}
		}
		if (!ESPCMS_FileTool::writeFile($file_index_name, $file_templates)) {
			espcms_public_dialog('info_set_ok', 'setting_pack-espcms_language_site_creat_message_no', 'false');
		}
		espcms_log_install('setting_pack-espcms_language_site_button_creat', "$lan_id=" . $lan_id);
		espcms_public_dialog('info_set_ok', 'setting_pack-espcms_language_site_creat_message_ok', 'true');
	}

}
