<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/




use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\link\OrderLink;
use admin_application\link\SettingLink;

class OrderPay {

	private static $order_pay_list_cache_key;
	private static $order_pay_read_cache_key;

	public function __construct() {
		global $module_array;
		$exclude_method = array('listOrderPay', 'addOrderPay', 'editOrderPay', 'saveOrderPay', 'setOrderPay', 'sortOrderPay', 'delOrderPay', 'ajaxOrderPay');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		if (!ESPCMS_AdminAuthority::authorityVerify('editSetting')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup']) {
			espcms_message_err('public_pack-espcms_module_file_err', array($module_array['module']));
		}
		self::$order_pay_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'order_pay';
		self::$order_pay_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'order_pay_';
	}

	public static function listOrderPay() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$ismoblie = $_REQUEST['ismoblie'];
			if (espcms_ismatches($ismoblie)) {
				$db_where .= " AND ismoblie=$ismoblie";
			}

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('opid', 'pid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "opid";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = OrderLink::Pay_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'order/order_pay_list';
		} else {
			$espcms_admin_templates->into('link', OrderLink::Pay_link_array(false, $_REQUEST));
			$templates = 'order/order_pay_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addOrderPay() {
		global $espcms_admin_templates;
		$pay_plug_dir = ESPCMS_FILE_ROOT . 'espcms_includes/payment/';
		$pluglist = ESPCMS_Core::get_plug_list($pay_plug_dir);
		$espcms_admin_templates->into('pluglist', $pluglist);
		$espcms_admin_templates->into('link', OrderLink::Pay_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('order/order_pay_add');
	}

	public static function editOrderPay() {
		global $espcms_admin_templates;
		$opid = $_GET['opid'];
		if (!$opid || !espcms_ismatches($opid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($opid));
		}
		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		$db_where = " WHERE opid=$opid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}

		$paycode = $read['paycode'];
		if (!$paycode || !preg_match("/^[\w]+$/", $paycode)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($paycode));
		}
		$plug_file = ESPCMS_FILE_ROOT . 'espcms_includes/payment/' . $paycode . '.php';
		if (!is_file($plug_file)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($paycode));
		}
		$pluglist = $read['pluglist'] ? unserialize($read['pluglist']) : array();

		$modulesid = true;
		$modules = array();
		require_once $plug_file;
		$config = $modules[0]['config'];
		if (!is_array($config) || count($config) <= 0) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($paycode));
		}
		$json_array = $modules[0];
		$out_html = '';
		foreach ($config as $value) {
			$input_value = $pluglist[$value['name']] ? $pluglist[$value['name']] : '';
			$out_html .= '<div class="form-group"><label class="col-sm-2 control-label">' . $value['botname'] . '</label><div class="col-sm-9">';
			if ($value['type'] == 'text') {
				$out_html .= '<input type="text" name="' . $value['name'] . '" value="' . $input_value . '" class="form-control" id="' . $value['name'] . '" data-validation="' . $value['input_validation'] . '" placeholder="' . $value['input_tite'] . '" title="' . $value['input_tite'] . '" data-validation-msg="' . $value['input_err'] . '"/>';
			} elseif ($value['type'] == 'textarea') {
				$out_html .= '<textarea type="text" name="' . $value['name'] . '" style="width:100%;height:120px" class="form-control" id="' . $value['name'] . '" data-validation-minlength="' . $value['data-validation-minlength'] . '" data-validation-maxlength="' . $value['data-validation-maxlength'] . '" placeholder="' . $value['input_tite'] . '" title="' . $value['input_tite'] . '" data-validation-msg="' . $value['input_err'] . '"/>' . $input_value . '</textarea>';
			} else {
				$out_html .= '<select class="form-control" name="' . $value['name'] . '" id="' . $value['name'] . '" data-size="8" title="' . $value['input_tite'] . '" data-validation="' . $value['input_validation'] . '" data-validation-msg="' . $value['input_err'] . '">';
				foreach ($value['sevalue'] as $opt_id => $opt_name) {
					if ($pluglist[$value['name']] == $opt_id) {
						$out_html .= '<option value = "' . $opt_id . '" selected>' . $opt_name . '</option >';
					} else {
						$out_html .= '<option value = "' . $opt_id . '" >' . $opt_name . '</option >';
					}
				}
				$out_html .= '</select>';
			}
			$out_html .= '</div></div>';
		}
		$json_array['out_html'] = $out_html;
		$espcms_admin_templates->into('json_array', $json_array);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', OrderLink::Pay_link_array());
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('order/order_pay_edit');
	}

	public static function saveOrderPay() {
		global $espcms_db_cache;

		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['payis']) || !espcms_ismatches($_POST['ismoblie']) || !$_POST['payname'] || !$_POST['paycode']) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		unset($_POST['isclass'], $_POST['pid'], $_POST['addtime'], $_POST['token_name'], $_POST['token_key'], $_POST['savetype']);
		$_POST['pluglist'] = serialize($_POST);
		if ($saveType == 'add') {
			$_POST['pid'] = 0;
			$_POST['addtime'] = time();
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$order_pay_list_cache_key, true);
			espcms_log_install('order_pack-espcms_order_pay_button_add', $_POST['payname']);
			espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_pay_add_save_ok_message', 'true', array($_POST['payname']));
		} elseif ($saveType == 'edit') {
			$opid = $_POST['opid'];
			if (empty($opid) || !espcms_ismatches($opid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($opid));
			}
			$db_where = "WHERE opid=$opid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($opid));
			}
			unset($_POST['isqrcode']);
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$order_pay_read_cache_key . $opid);
			$espcms_db_cache->cacheDEL(self::$order_pay_list_cache_key, true);
			espcms_log_install('order_pack-espcms_order_pay_button_edit', $_POST['payname']);
			espcms_public_dialog('espcms_info_save_ok', 'order_pack-espcms_order_pay_edit_save_ok_message', 'true', array($_POST['payname']));
		}
	}

	public static function setOrderPay() {
		global $espcms_db_cache;
		$lng = AdminPublicDB::get_lancode();
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}

		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		$talbe_field_array = array('ismoblie', 'isclass');
		if (!in_array($field, $talbe_field_array)) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}

		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE opid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
				$espcms_db_cache->cacheDEL(self::$order_pay_read_cache_key . $value);
			}
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$order_pay_list_cache_key, true);
		espcms_log_install('order_pack-espcms_order_pay_button_set', "$field=$field_value" . " opid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'order_pack-espcms_order_pay_set_message', 'true', array($field));
	}

	public static function delOrderPay() {
		global $espcms_db_cache;
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delOrderPayDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('order_pack-espcms_order_pay_button_del', $espcms_del_id);

		$return['count'] = $delcount;
		$espcms_db_cache->cacheDEL(self::$order_pay_list_cache_key, true);
		espcms_public_dialog('espcms_public_dialog', 'order_pack-espcms_order_pay_del_message', 'true', array(), 'json', $return);
	}

	private static function delOrderPayDB($opid = 0) {
		global $espcms_db_cache;
		if (!$opid || !espcms_ismatches($opid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $opid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		$del_query = espcms_db_del($db_table, 'opid', $opid);
		if ($del_query) {
			$espcms_db_cache->cacheDEL(self::$order_pay_read_cache_key . $opid);
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $opid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $opid);
			return $return_array;
		}
	}

	public static function sortOrderPay() {
		global $espcms_db_cache;
		$aid_array = $_POST['id_array'];
		if (!is_array($aid_array) || count($aid_array) <= 0) {
			exit('false');
		}
		$db_table = ESPCMS_DB_PREFIX . "order_pay";
		foreach ($aid_array as $key => $value) {
			$pid = $key;
			if (espcms_ismatches($pid) && espcms_ismatches($value) && $value) {
				espcms_db_update_set_save($db_table, "WHERE opid=$value", "pid=$pid");
			}
		}
		$espcms_db_cache->cacheDEL(self::$order_pay_list_cache_key, true);
		espcms_log_install('order_pack-espcms_order_pay_button_sort', 'opid=' . $value);
		exit('true');
	}

	public static function ajaxOrderPay() {
		$paycode = $_GET['paycode'];
		if (!$paycode || !preg_match("/^[\w]+$/", $paycode)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($paycode));
		}
		$plug_file = ESPCMS_FILE_ROOT . 'espcms_includes/payment/' . $paycode . '.php';
		if (!is_file($plug_file)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($paycode));
		}
		$modulesid = true;
		$modules = array();
		require_once $plug_file;
		$config = $modules[0]['config'];
		if (!is_array($config) || count($config) <= 0) {
			exit('false');
		}
		$json_array = $modules[0];
		$out_html = '';
		foreach ($config as $value) {
			$out_html .= '<div class="form-group"><label class="col-sm-2 control-label">' . $value['botname'] . '</label><div class="col-sm-9">';
			if ($value['type'] == 'text') {
				$out_html .= '<input type="text" name="' . $value['name'] . '" class="form-control" id="' . $value['name'] . '" data-validation="' . $value['input_validation'] . '" placeholder="' . $value['input_tite'] . '" title="' . $value['input_tite'] . '" data-validation-msg="' . $value['input_err'] . '"/>';
			} elseif ($value['type'] == 'textarea') {
				$out_html .= '<textarea type="text" name="' . $value['name'] . '" style="width:100%;height:120px" class="form-control" id="' . $value['name'] . '" data-validation-minlength="' . $value['data-validation-minlength'] . '" data-validation-maxlength="' . $value['data-validation-maxlength'] . '" placeholder="' . $value['input_tite'] . '" title="' . $value['input_tite'] . '" data-validation-msg="' . $value['input_err'] . '"/></textarea>';
			} else {
				$out_html .= '<select class="form-control" name="' . $value['name'] . '" id="' . $value['name'] . '" data-size="8" title="' . $value['input_tite'] . '" data-validation="' . $value['input_validation'] . '" data-validation-msg="' . $value['input_err'] . '">';
				foreach ($value['sevalue'] as $opt_id => $opt_name) {
					$out_html .= '<option value = "' . $opt_id . '">' . $opt_name . '</option >';
				}
				$out_html .= '</select>';
			}
			$out_html .= '</div></div>';
		}
		$json_array['out_html'] = $out_html;
		$message_out_json = json_encode($json_array);
		echo $message_out_json;
	}

}
