<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\link\UserMainLink;
use admin_application\link\UpdateSoftLink;
use admin_application\link\MenuLink;
use admin_application\link\SettingLink;
class Portal {
	public function __construct() {
		global $module_array;
		$exclude_method = array('login', 'verification_code', 'loginAuthority', 'loginMini', 'userLoginVerify', 'userQuit', 'Join');
		if (!in_array($module_array['method'], $exclude_method)) {
			ESPCMS_AdminAuthority::authorityBaseVerify();
		}
	}
	public static function login() {
		global $espcms_admin_templates, $espcms_command;
		$admin_username = ESPCMS_AdminAuthority::getUserLoginInfo('admin_username');
		$login_ip = ESPCMS_AdminAuthority::getUserLoginInfo('login_ip', 'info');
		if (!empty($admin_username) && !empty($login_ip)) {
			header('location:' . UserMainLink::getLink('center'));
			exit();
		}
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->into('espcms_login', UserMainLink::getLink('login'));
		$espcms_admin_templates->into('espcms_login_verify', UserMainLink::getLink('login_verify'));
		$espcms_admin_templates->into('verification_code', UserMainLink::getLink('verification'));
		$espcms_admin_templates->into('verify_isopen', $espcms_command['SAFETY_ISVERIFICATION_CODE']);
		$espcms_admin_templates->output('login');
	}
	public static function userLoginVerify() {
		global $espcms_command;
		$goback_url = UserMainLink::getLink('login');
		$admin_center = UserMainLink::getLink('center');
		$input_type = $_POST['inputtype'] ? $_POST['inputtype'] : 'web';
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			if ($input_type == 'json') {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail_small', 'false', array($_POST['admin_username']), 'json', false, true);
			} else {
				espcms_message_page_err('public_pack-espcms_input_repeat_fail_small', $goback_url, array($_POST['admin_username']));
			}
		}
		if ($espcms_command['SAFETY_ISVERIFICATION_CODE']) {
			require_once( ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php' );
			$espcms_login_verification_code_cookie = $_COOKIE['espcms_admin_login_verification_code'];
			if ($espcms_login_verification_code_cookie) {
				$espcms_login_verification_code = espcms_decrypt($espcms_login_verification_code_cookie, ESPCMS_ENCRYPT_CODE);
			} else {
				espcms_message_page_err('login_pack-espcms_login_user_verification_code_err', $goback_url, array($_POST['user_verification_code']));
			}
			$code = new ESPCMS_VerificationCode();
			$code->seccodeconvert($espcms_login_verification_code);
			$_POST['user_verification_code'] = $_POST['user_verification_code'] ? strtoupper($_POST['user_verification_code']) : '';
			if ($espcms_login_verification_code != $_POST['user_verification_code']) {
				espcms_message_page_err('login_pack-espcms_login_user_verification_code_err', $goback_url, array($_POST['user_verification_code']));
			}
		}
		if (!preg_match('/^[\w\@\.]{2,50}$/i', $_POST['admin_username'])) {
			if ($input_type == 'json') {
				espcms_public_dialog('espcms_public_dialog', 'login_pack-espcms_login_username_fail_small', 'false', array($_POST['admin_username']), 'json', false, true);
			} else {
				espcms_message_page_err('login_pack-espcms_login_username_fail_small', $goback_url, array($_POST['admin_username']));
			}
		}
		$admin_username = $_POST['admin_username'];
		$admin_password_len = strlen($_POST['admin_password']);
		if ($admin_password_len < 6 || $admin_password_len > 30) {
			if ($input_type == 'json') {
				espcms_public_dialog('espcms_public_dialog', 'login_pack-espcms_login_password_fail_small', 'false', array($_POST['admin_username']), 'json', false, true);
			} else {
				espcms_message_page_err('login_pack-espcms_login_password_fail_small', $goback_url, array($_POST['admin_username']));
			}
		}
		$admin_password = md5($_POST['admin_password']);
		$db_where = "WHERE admin_username='$admin_username' AND admin_password='$admin_password' AND admin_isclass=1";
		$SAFETY_LOGIN_ERR_NUM = espcms_ismatches($espcms_command['SAFETY_LOGIN_ERR_NUM']) ? $espcms_command['SAFETY_LOGIN_ERR_NUM'] : 3;
		$SAFETY_LOGIN_ERR_TIME = espcms_ismatches($espcms_command['SAFETY_LOGIN_ERR_TIME']) ? $espcms_command['SAFETY_LOGIN_ERR_TIME'] * 60 : 60;
		$SAFETY_PASSWORD_TIME = espcms_ismatches($espcms_command['SAFETY_PASSWORD_TIME']) && $espcms_command['SAFETY_PASSWORD_TIME'] > 0 ? $espcms_command['SAFETY_PASSWORD_TIME'] : 3600 * 24 * 30;
		$user_login_err_info = ESPCMS_AdminAuthority::getLogingInfo($admin_username);
		$espcms_user_login_err_num = $user_login_err_info['user_login_err_num'];
		$espcms_user_login_err_time = $user_login_err_info['user_login_err_time'];
		if ($espcms_user_login_err_num <= 0) {
			$now_time = time();
			$confine_end_time = $espcms_user_login_err_time + $SAFETY_LOGIN_ERR_TIME;
			if ($confine_end_time > $now_time) {
				$difference_time = $confine_end_time - $now_time;
				$difference_time_lan = $difference_time . espcms_lan_pack('public_pack-espcms_second_title');
				if ($input_type == 'json') {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_login_verification_time_fail_small', 'false', array($difference_time_lan), 'json', false, true);
				} else {
					espcms_message_page_err('public_pack-espcms_login_verification_time_fail_small', $goback_url, array($difference_time_lan));
				}
			} else {
				$espcms_user_login_err_num = $SAFETY_LOGIN_ERR_NUM;
			}
		}
		$db_table = ESPCMS_DB_PREFIX . 'admin_member';
		$talbe_field_array = 'admin_member_id,power_groups_id,admin_username,admin_name,admin_sex,admin_intotime,admin_intime,admin_outtime,admin_ipadd,admin_hit,admin_isclass,admin_isremote';
		$admin_user_read = espcms_db_read($db_table, $db_where, $talbe_field_array, true);
		if ($admin_user_read) {
			$session_id = espcms_set_cookie('espcms_admin_user_info', espcms_encrypt($admin_user_read, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
			if (!$session_id) {
				if ($input_type == 'json') {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_cookie_save_err', 'false', array(), 'json', false, true);
				} else {
					espcms_message_err('public_pack-espcms_cookie_save_err');
				}
			}
			$user_login_info = array();
			$user_login_info['login_ip'] = real_remote_ip();
			$user_login_info['login_time'] = time();
			$espcms_set_cookie = espcms_set_cookie('espcms_admin_user_server_info', espcms_encrypt($user_login_info, ESPCMS_ENCRYPT_CODE), $SAFETY_PASSWORD_TIME);
			if ($espcms_set_cookie) {
				ESPCMS_AdminAuthority::delLogingInfo($admin_username);
			}
			espcms_log_install('login_pack-espcms_lable_user_login_log_title', $_POST['admin_username'], $admin_user_read['admin_member_id']);
			self::espcms_login_log_save($admin_user_read['admin_member_id']);
			if ($input_type == 'json') {
				espcms_public_dialog('seapo a_public_dialog', 'login_pack-espcms_login_verification_ok_small', 'true', array($_POST['admin_username']), 'json', false, true);
			} else {
				header('location:' . $admin_center);
				exit();
			}
		} else {
			$login_second_num = $espcms_user_login_err_num ? $espcms_user_login_err_num - 1 : $SAFETY_LOGIN_ERR_NUM - 1;
			if ($login_second_num == 0) {
				ESPCMS_AdminAuthority::setLogingInfo($admin_username, $login_second_num, true);
			} else {
				ESPCMS_AdminAuthority::setLogingInfo($admin_username, $login_second_num);
			}
			if ($SAFETY_LOGIN_ERR_NUM > 0) {
				if ($input_type == 'json') {
					espcms_public_dialog('espcms_public_dialog', 'login_pack-espcms_login_verification_fail_small', 'false', array($_POST['admin_username'], $login_second_num), 'json', false, true);
				} else {
					espcms_message_page_err('login_pack-espcms_login_verification_fail_small', $goback_url, array($_POST['admin_username'], $login_second_num));
				}
			} else {
				if ($input_type == 'json') {
					espcms_public_dialog('espcms_public_dialog', 'login_pack-espcms_login_verification_fail_small_nomin', 'false', array($_POST['admin_username'], $login_second_num), 'json', false, true);
				} else {
					espcms_message_page_err('login_pack-espcms_login_verification_fail_small_nomin', $goback_url, array($_POST['admin_username'], $login_second_num));
				}
			}
		}
	}
	public static function mainCenter() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$db_table = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = " WHERE admin_member_id=$admin_member_id";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$read['power_groups_name'] = AdminPublicDB::get_power_groups_view($read['power_groups_id'], 'power_groups_name');
		$widget_array = ESPCMS_Core::get_widget_list();
		if (is_array($widget_array)) {
			$widget_list = array();
			$widget_key = 0;
			foreach ($widget_array as $value) {
				$file = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/control/' . $value['widget_file'] . '.php';
				if (!is_file($file)) {
					continue;
				}
				if (!ESPCMS_AdminAuthority::authorityVerify($value['widget_code'])) {
					continue;
				}
				include_once($file);
				$module_key = espcms_action_url($value['widget_fun']);
				if (!method_exists($module_key['module'], $module_key['method'])) {
					continue;
				}
				$module = $module_key['module'];
				$method = $module_key['method'];
				$control = new $module;
				$out_html = $control->$method();
				$widget_list[$widget_key]['gethtml'] = $out_html;
				$widget_list[$widget_key]['ajaxlink'] = MenuLink::getLink('ajaxlink', $value);
				$widget_key++;
			}
		}
		$espcms_admin_templates->libfile = false;
		$widget_bt_array = ESPCMS_Core::get_widget_bt_list();
		if (is_array($widget_bt_array)) {
			$widget_bt_array_out = array();
			foreach ($widget_bt_array as $key => $value) {
				$file = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/control/' . $value['widget_bt_code'] . '.php';
				if (!is_file($file)) {
					continue;
				}
				if (!ESPCMS_AdminAuthority::authorityVerify($value['widget_bt_code'])) {
					continue;
				}
				$value['btlink'] = MenuLink::getLink('btlink', $value);
				$widget_bt_array_out[] = $value;
			}
			$espcms_admin_templates->into('widget_bt_array', $widget_bt_array_out);
		}
		$server_info = array();
		$server_info['php_ver'] = PHP_OS . ' / PHP v' . PHP_VERSION;
		$server_info['upload_size'] = ini_get('file_uploads') ? ini_get('upload_max_filesize') : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['gd_ver'] = GD_VERSION;
		$server_info['sql_ver'] = espcms_db_ver();
		$server_info['gzip'] = strstr($_SERVER["HTTP_ACCEPT_ENCODING"], "gzip") ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['mcrypt'] = extension_loaded('mcrypt') ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['curl'] = extension_loaded('curl') ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['sockets'] = extension_loaded('sockets') ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['fsockopen'] = function_exists('fsockopen') ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$server_info['pfsockopen'] = function_exists('pfsockopen') ? '<font class="text-green">' . espcms_lan_pack('public_pack-espcms_lable_open_fun') . '</font>' : '<font class="text-red">' . espcms_lan_pack('public_pack-espcms_lable_disable_fun') . '</font>';
		$espcms_admin_templates->into('server_info', $server_info);
		$espcms_admin_templates->into('widget_list', $widget_list);
		$espcms_admin_templates->into('espcms_login', UserMainLink::getLink('login'));
		$espcms_admin_templates->into('espcms_login_verify', UserMainLink::getLink('login_verify'));
		$espcms_admin_templates->into('verification_code', UserMainLink::getLink('verification'));
		$espcms_admin_templates->into('updatesoft', UserMainLink::get_user_link_array('UpgradeSoft'));
		$espcms_admin_templates->into('link', SettingLink::join_link_array());
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->output('admin/admin_center');
	}
	public static function mainQuit() {
		$login_url = UserMainLink::getLink('login');
		$admin_username = ESPCMS_AdminAuthority::getUserLoginInfo('admin_username');
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if ($admin_username && $admin_member_id) {
			self::espcms_login_log_save($admin_member_id, 2);
			espcms_set_cookie('espcms_admin_user_server_info', false);
			espcms_set_cookie('espcms_admin_user_info', false);
		}
		if ($_POST['outtype'] == 'mini') {
			exit('true');
		} else {
			header('location:' . $login_url);
			exit();
		}
	}
	public static function viewSoftInfo() {
		global $espcms_admin_templates, $espcms_command;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('espcms_vol', vsprintf(espcms_lan_pack('setting_pack-espcms_about_vol'), array($espcms_command['CON_VOLSTR'])));
		$espcms_status = ESPCMS_Core::connect_service('LicenceVerify');
		if (is_array($espcms_status) && $espcms_status['uid'] && espcms_ismatches($espcms_status['uid'])) {
			$espcms_autho = vsprintf(espcms_lan_pack('setting_pack-espcms_about_autho_ye'), array($espcms_status['softkey']));
			$espcms_admin_templates->into('espcms_autho', $espcms_autho);
			$espcms_admin_templates->into('espcms_status', $espcms_status);
		} else {
			$espcms_admin_templates->into('espcms_autho', espcms_lan_pack('setting_pack-espcms_about_autho_no'));
		}
		$espcms_admin_templates->into('link', UpdateSoftLink::UpdateSoft_link_array());
		$espcms_admin_templates->output('admin/espcms_about');
	}
	public static function espcms_login_log_save($admin_member_id = 0, $login_log_type = 1) {
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			return false;
		}
		$db_table_user = ESPCMS_DB_PREFIX . "admin_member";
		$db_where = "WHERE admin_member_id=$admin_member_id";
		$ip = real_remote_ip();
		$time = time();
		if ($login_log_type == 1) {
			$updateid = espcms_db_update_set_save($db_table_user, $db_where, "admin_hit=admin_hit+1,admin_intime=$time,admin_ipadd='$ip'");
		} elseif ($login_log_type == 2) {
			$updateid = espcms_db_update_set_save($db_table_user, $db_where, "admin_outtime=$time");
		}
		if (!$updateid) {
			return false;
		} else {
			return true;
		}
	}
	public static function Join() {
		$server_status = ESPCMS_Core::connect_service('Join', array(), false);
		die($server_status);
	}
	public static function verification_code() {
		global $espcms_command;
		require_once( ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_VerificationCode.php' );
		$seccode = rand(100000, 999999);
		$verification_code = md5($seccode);
		espcms_set_cookie('espcms_admin_login_verification_code', espcms_encrypt($seccode, ESPCMS_ENCRYPT_CODE));
		$code = new ESPCMS_VerificationCode();
		$code->code = $seccode;
		$code->type = 0;
		$code->width = 85;
		$code->height = 38;
		$code->background = 30;
		$code->adulterate = $espcms_command['SAFETY_VERIFICATION_SIDEWORD'];
		$code->ttf = 0;
		$code->angle = 0;
		$code->color = 0;
		$code->size = 1;
		$code->shadow = 0;
		$code->animator = 0;
		$code->bgcolor = $espcms_command['SAFETY_VERIFICATION_BACKGROUND_COLOR'];
		$code->fontcolor = $espcms_command['SAFETY_VERIFICATION_FONT_COLOR'];
		$code->datapath = ESPCMS_FILE_ROOT . 'espcms_includes/verfont/';
		$code->includepath = '';
		$code->display();
	}
}
