<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_AdminAuthority;
use admin_application\ArticleModelDB;
use admin_application\AdminPublicDB;
use admin_application\link\ArticleLink;

class RecommendTags {

	private static $document_label_list_cache_key;

	public function __construct() {
		$exclude_method = array('saveRecommendTags');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$document_label_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'document_label_';
	}

	public static function listRecommendTags() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "document_label";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		$lng = AdminPublicDB::get_lancode();
		$db_where = " AND lng='$lng'";
		if ($out_type == 'list') {

			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;

			$mid = $_REQUEST['mid'];
			if (espcms_ismatches($mid) && $mid) {
				$db_where .= " AND mid=$mid";
			}

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('dlid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "dlid";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = ArticleLink::RecommendTags_link_array('edit', $fetch_row);
				$fetch_row['modelname'] = ArticleModelDB::get_mid_view($fetch_row['mid'], 'modelname');
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'article/recommend_tags_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', ArticleLink::RecommendTags_link_array(false, $_REQUEST));
			$templates = 'article/recommend_tags_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addRecommendTags() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', ArticleLink::RecommendTags_link_array());
		$espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/recommend_tags_add');
	}

	public static function editRecommendTags() {
		global $espcms_admin_templates;
		$dlid = $_GET['dlid'];
		if (!$dlid || !espcms_ismatches($dlid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($dlid));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_label";
		$db_where = " WHERE dlid=$dlid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list($read['mid']));
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', ArticleLink::RecommendTags_link_array());
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/recommend_tags_edit');
	}

	public static function saveRecommendTags() {
		global $espcms_db_cache;

		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

		$db_table = ESPCMS_DB_PREFIX . "document_label";
		$talbe_field_array = espcms_field_out($db_table, true);
		if (!espcms_ismatches($_POST['mid']) || empty($_POST['mid']) || empty($_POST['labelname'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addRecommendTags')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();

			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_label_list_cache_key . $_POST['lng'], true);
			espcms_log_install('article_pack-espcms_recommend_tags_button_add', $_POST['labelname']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_recommend_tags_add_save_ok_message', 'true', array($_POST['labelname']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editRecommendTags')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$dlid = $_POST['dlid'];
			if (empty($dlid) || !espcms_ismatches($dlid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($dlid));
			}
			$db_where = "WHERE dlid=$dlid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($dlid));
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$espcms_db_cache->cacheDEL(self::$document_label_list_cache_key . $read['lng'], true);
			espcms_log_install('article_pack-espcms_recommend_tags_button_edit', $_POST['labelname']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_recommend_tags_edit_save_ok_message', 'true', array($_POST['labelname']));
		}
	}

	public static function delRecommendTags() {
		global $espcms_db_cache;
		$lng = AdminPublicDB::get_lancode();
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delRecommendTagsDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$document_label_list_cache_key . $lng, true);
		espcms_log_install('article_pack-espcms_recommend_tags_button_del', $espcms_del_id);

		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_recommend_tags_del_message', 'true', array(), 'json', $return);
	}

	public static function delRecommendTagsDB($dlid = 0) {
		if (!$dlid || !espcms_ismatches($dlid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $dlid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_label";
		$del_query = espcms_db_del($db_table, 'dlid', $dlid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $dlid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $dlid);
			return $return_array;
		}
	}

}
