<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/




use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_FileTool;
use admin_application\AdminPublicDB;
use admin_application\link\TemplatesLink;

class TemplateFile {

	public function __construct() {
		$exclude_method = array('saveTemplateFile', 'verifyTemplateFile');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listTemplateFile() {
		global $espcms_admin_templates;
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {

			$template_type = $_REQUEST['template_type'] == 'wap' ? 'wap' : 'web';

			$template_dir_name = ESPCMS_Core::get_skin($template_type, 'skin_code');

			$templates_dir = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/';

			$dirname = $_REQUEST['dirname'];

			$back_dirname = $_REQUEST['up_dirname'];

			$open_dirname = $_REQUEST['up_dirname'] ? $_REQUEST['up_dirname'] . '/' . $dirname : $dirname;

			$open_dir = $dirname ? $templates_dir . $open_dirname : $templates_dir;
			if (!is_dir($open_dir)) {
				espcms_message_err('public_pack-espcms_input_parameter_fail', array($open_dir));
			}
			if ($open_dirname && $back_dirname) {
				$up_dir_array = explode('/', $back_dirname);
				$dir_array_num = count($up_dir_array);
				$open_gobackdir = $dir_array_num > 1 ? end($up_dir_array) : $back_dirname;

				unset($up_dir_array[$dir_array_num - 1]);

				$open_gobackpath = count($up_dir_array) > 0 && is_array($up_dir_array) ? implode('/', $up_dir_array) : '';

				$espcms_admin_templates->into('open_gobackdir', $open_gobackdir);

				$espcms_admin_templates->into('open_gobackpath', $open_gobackpath);
			}
			$espcms_admin_templates->into('open_dirname', $open_dirname);

			$file_array = array();
			$file_key = 0;

			$dir_list = ESPCMS_FileTool::list_dir($open_dir, false, 'dir', false);
			if (is_array($dir_list)) {
				foreach ($dir_list as $value) {
					$dirinfo = pathinfo($value);
					$file_array[$file_key]['filepath'] = $value;
					$file_array[$file_key]['dirname'] = $dirinfo['dirname'];
					$file_array[$file_key]['up_dirname'] = $open_dirname;
					$file_array[$file_key]['filename'] = $dirinfo['filename'];
					$file_array[$file_key]['extension'] = 'dir';
					$file_array[$file_key]['addtime'] = fileatime($value);
					$file_array[$file_key]['updatetime'] = filemtime($value);
					$file_key++;
				}
			}
			$file_list = ESPCMS_FileTool::list_dir($open_dir, array('html', 'css'), 'file', false);
			if (is_array($file_list)) {
				foreach ($file_list as $value) {
					$file_array[$file_key]['filepath'] = $value['filepath'];
					$file_array[$file_key]['dirname'] = $value['dirname'];
					$file_array[$file_key]['up_dirname'] = $open_dirname;
					$file_array[$file_key]['filename'] = $value['basename'];
					$file_array[$file_key]['extension'] = $value['extension'];
					$file_array[$file_key]['name'] = $value['filename'];
					$file_array[$file_key]['addtime'] = fileatime($value['filepath']);
					$file_array[$file_key]['updatetime'] = filemtime($value['filepath']);
					$value['open_path'] = $open_dirname;
					$value['template_type'] = $template_type;
					$file_array[$file_key]['edit'] = TemplatesLink::TemplateFile_link_array('edit', $value);
					$value['type'] = 'copy';
					$file_array[$file_key]['copy'] = TemplatesLink::TemplateFile_link_array('edit', $value);
					$file_key++;
				}
			}
			$espcms_admin_templates->into('array', $file_array);
			$espcms_admin_templates->into('template_type', $template_type);
			$espcms_admin_templates->into('link', TemplatesLink::TemplateFile_link_array(false, $_REQUEST));
			$templates = 'templates/templates_list';
		} else {
			$espcms_admin_templates->into('link', TemplatesLink::TemplateFile_link_array(false, $_REQUEST));
			$templates = 'templates/templates_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function selectTemplates() {
		global $espcms_admin_templates;

		$template_type = $_GET['template_type'];
		if (!$template_type || !preg_match('/^[\w]+$/', $template_type)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($template_type));
		}
		$lng = AdminPublicDB::get_lancode();

		$template_dir = $_GET['template_dir'];
		if (!$template_dir || !preg_match('/^[\w]+$/', $template_dir)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($template_dir));
		}
		$template_dir_name = ESPCMS_Core::get_skin($template_type, 'skin_code');
		$templates_path = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/' . $lng . '/' . $template_dir;
		if (!is_dir($templates_path)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($template_dir_name . '/' . $lng . '/' . $template_dir));
		}
		$file_list = ESPCMS_FileTool::list_dir($templates_path, array('html'), 'file', false);
		$espcms_admin_templates->into('inputname', $_GET['inputname']);
		$espcms_admin_templates->into('iframes_name', $_GET['iframeName']);
		$espcms_admin_templates->into('file_list', $file_list);
		$espcms_admin_templates->output('templates/templates_select');
	}

	public static function editTemplateFile() {
		global $espcms_admin_templates;
		$open_path = $_GET['open_path'];
		$open_file = $_GET['open_file'];
		if (!$open_path) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($open_path));
		}
		if (!$open_file) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($open_file));
		}

		$open_type = $_GET['open_type'] == 'wap' ? 'wap' : 'web';

		$template_dir_name = ESPCMS_Core::get_skin($open_type, 'skin_code');

		$templates_dir = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/';

		$edit_file = $templates_dir . $open_path . '/' . $open_file;

		$file_inof = ESPCMS_FileTool::mime($edit_file);
		if ($file_inof != 'html' && $file_inof != 'css') {
			espcms_message_err('templates_pack-espcms_templates_file_ext_err', array($open_file));
		}
		if (!is_file($edit_file)) {
			espcms_message_err('templates_pack-espcms_templates_file_read_err', array($open_path . '/' . $open_file));
		}
		$file_content = file_get_contents($edit_file);
		if (!$file_content) {
			espcms_message_err('templates_pack-espcms_templates_file_read_err', array($open_file));
		}
		$read['open_type'] = $open_type;
		$read['open_path'] = $open_path;
		$read['open_name'] = $open_path . '/' . $open_file;
		$read['open_file'] = $open_file;
		$read['content'] = htmlspecialchars($file_content);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', TemplatesLink::TemplateFile_link_array());
		$espcms_admin_templates->into('token', token());
		$type = $_GET['type'] ? 'copy' : 'edit';
		$espcms_admin_templates->into('type', $type);
		$espcms_admin_templates->output('templates/templates_edit');
	}

	public static function saveTemplateFile() {
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		if (!ESPCMS_AdminAuthority::authorityVerify('editTemplateFile')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'copy';
		$open_type = $_POST['open_type'] == 'wap' ? 'wap' : 'web';
		if (empty($open_type)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($open_type));
		}
		$open_path = $_POST['open_path'];
		if (empty($open_path)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($open_path));
		}
		$open_file = $_POST['open_file'];
		if (empty($open_file)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($open_file));
		}
		$content = $_POST['content'];
		if (empty($content)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
		}

		$template_dir_name = ESPCMS_Core::get_skin($open_type, 'skin_code');

		$templates_dir = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/';

		$edit_file = $templates_dir . $open_path . '/' . $open_file;

		$edit_path = $templates_dir . $open_path . '/';

		$file_inof = ESPCMS_FileTool::mime($edit_file);
		if ($file_inof != 'html' && $file_inof != 'css') {
			espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_ext_err', 'false', array($open_file));
		}
		if (!is_file($edit_file)) {
			espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_read_err', 'false', array($open_file));
		}

		if ($saveType == 'copy') {
			if (!is_dir($edit_path)) {
				espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_add_save_ok_message_err2', 'false', array($edit_path));
			}
			$filename = $_POST['filename'];
			if (!preg_match('/^[\w]{2,50}$/i', $filename)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
			}
			if (self::verifyTemplateFileDB($filename, $open_type, $open_path, $open_file)) {
				espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_filename_warning_msg', 'false', array($filename));
			}

			$copy_file = $edit_path . $filename . '.' . $file_inof;

			$content = stripslashes($content);
			$install_id = ESPCMS_FileTool::writeFile($copy_file, $content);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_add_save_ok_message_err', 'false');
			}
			espcms_log_install('templates_pack-espcms_templates_file_button_copy', $filename . '.' . $file_inof);
			espcms_public_dialog('espcms_info_save_ok', 'templates_pack-espcms_templates_file_add_save_ok_message', 'true', array($filename . '.' . $file_inof));
		} elseif ($saveType == 'edit') {
			$content = stripslashes($content);
			$update_id = ESPCMS_FileTool::writeFile($edit_file, $content);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_edit_save_ok_message_err', 'false');
			}
			espcms_log_install('templates_pack-espcms_templates_file_button_edit', $open_path . '/' . $open_file);
			espcms_public_dialog('espcms_info_save_ok', 'templates_pack-espcms_templates_file_edit_save_ok_message', 'true', array($open_file));
		}
	}

	public static function delTemplateFile() {
		$open_path = $_POST['open_path'];
		$open_file = $_POST['open_file'];
		$open_type = $_POST['open_type'] == 'wap' ? 'wap' : 'web';
		if (empty($open_path)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($open_path));
		}
		if (empty($open_file) || !preg_match('/^[\w\.]{2,50}$/i', $open_file)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($open_file));
		}

		$template_dir_name = ESPCMS_Core::get_skin($open_type, 'skin_code');

		$templates_dir = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/';
		$del_file = $templates_dir . $open_path . '/' . $open_file;
		$del_id = ESPCMS_FileTool::delFile($del_file);
		if (!$del_id) {
			espcms_public_dialog('espcms_public_dialog', 'templates_pack-espcms_templates_file_del_message_err', 'false');
		}
		espcms_log_install('templates_pack-espcms_templates_file_button_del', $open_path . '/' . $open_file);
		espcms_public_dialog('espcms_info_save_ok', 'templates_pack-espcms_templates_file_del_message', 'true', array($open_file));
	}

	public static function verifyTemplateFile() {

		$verifyValue = $_REQUEST['verify_value'];
		$open_type = $_GET['open_type'];
		$open_path = $_REQUEST['open_path'];
		$open_file = $_REQUEST['open_file'];
		$db_num = self::verifyTemplateFileDB($verifyValue, $open_type, $open_path, $open_file) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyTemplateFileDB($verifyValue, $open_type, $open_path, $open_file) {
		if (!$open_path || !$open_type || !$open_file || !$verifyValue) {
			return true;
		}

		$open_type = $open_type == 'wap' ? 'wap' : 'web';

		$template_dir_name = ESPCMS_Core::get_skin($open_type, 'skin_code');

		$templates_dir = ESPCMS_FILE_ROOT . 'templates/' . $template_dir_name . '/';

		$old_file = $templates_dir . $open_path . '/' . $open_file;
		$file_inof = ESPCMS_FileTool::mime($old_file);
		if ($file_inof != 'html' && $file_inof != 'css') {
			return true;
		}
		if (!preg_match('/^[\w]{2,50}$/i', $verifyValue)) {
			return true;
		}

		$ver_file = $templates_dir . $open_path . '/' . $verifyValue . '.' . $file_inof;
		if (is_file($ver_file)) {
			return true;
		}
		$db_num = is_file($ver_file) ? 1 : 0;
		return $db_num > 0 ? true : false;
	}

}
