<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



namespace admin_application;

use application\ESPCMS_PhotoDownLoad;
use modul_application\KeywordsOptimizationDB;
use admin_application\FileDB;
use inc_application\link\ArticleLink;

class ArticleTool {

	public static function tsn_creat($code_style, $protectval = false) {
		if (!$code_style) {
			return false;
		}
		$code_array['s'] = rand(1000, 9999);
		$code_array['datetime'] = date("YmdHis");
		$code_array['data'] = date("Ymd");
		$code_array['y'] = date("Y");
		$code_array['m'] = date("m");
		$code_array['d'] = date("d");
		if ($protectval != 'dirname') {
			$code_style = str_replace('{dirname}', $code_array['dirname'], $code_style);
		}
		if ($protectval != 'tid') {
			$code_style = str_replace('{tid}', $code_array['tid'], $code_style);
		}
		if ($protectval != 'sid') {
			$code_style = str_replace('{sid}', $code_array['sid'], $code_style);
		}
		if ($protectval != 'did') {
			$code_style = str_replace('{did}', $code_array['did'], $code_style);
		}
		if ($protectval != 'pageid') {
			$code_style = str_replace('{pageid}', $code_array['pageid'], $code_style);
		}
		if ($protectval != 'datetime') {
			$code_style = str_replace('{datetime}', $code_array['datetime'], $code_style);
		}
		if ($protectval != 'data') {
			$code_style = str_replace('{data}', $code_array['data'], $code_style);
		}
		if ($protectval != 'y') {
			$code_style = str_replace('{y}', $code_array['y'], $code_style);
		}
		if ($protectval != 'm') {
			$code_style = str_replace('{m}', $code_array['m'], $code_style);
		}
		if ($protectval != 'd') {
			$code_style = str_replace('{d}', $code_array['d'], $code_style);
		}
		if ($protectval != 's') {
			$code_style = str_replace('{s}', $code_array['s'], $code_style);
		}
		return $code_style;
	}

	public static function article_link_clear($content = false, $http = false) {
		if (!$content) {
			return false;
		}
		$body = stripslashes($content);
		$basehost = !$http ? $_SERVER['HTTP_HOST'] : $http;
		preg_match_all('/<a[\s\S]*?href=["|\']?([^>"\' ]+)["|\']?\s*[^>]*>(.+?)<\/a>/si', $body, $att);
		if (count($att[1]) > 0) {
			foreach ($att[1] as $key => $value) {
				$leftstr = substr($value, 0, 1);
				$leftlent = stripos('#' . $value, $basehost);
				if ($leftlent < 1 && $leftstr != '/' && $leftstr != '.') {
					$body = str_replace($att[0][$key], $att[2][$key], $body);
				}
			}
		}
		return addslashes($body);
	}

	public static function article_key_replace($content = false, $keywords = false, $ceratkeylink_type = 1) {
		if (!$content || !$keywords) {
			return false;
		}
		$keywords_array = explode(',', $keywords);
		if (!is_array($keywords_array) || count($keywords_array) < 1) {
			return false;
		}
		$tagArray = array_unique($keywords_array);
		if (!is_array($tagArray) || count($tagArray) < 1) {
			return false;
		}
		usort($tagArray, "espcms_sort_terms");
		$newTagArray = array();
		foreach ($tagArray as $key => $value) {
			$newTagArray[$key]['title'] = $value;
			$newTagArray[$key]['keywordname'] = $value;
			$newTagArray[$key]['rekey'] = md5($value);
			$key_view = KeywordsOptimizationDB::get_keywords_optimization_view(false, $value);
			$newTagArray[$key]['link'] = $key_view['islink'] == 1 ? $key_view['linkurl'] : ArticleLink::tags_link($newTagArray[$key]);
		}
		$content = stripslashes($content);
		$content = preg_replace('/<a[\s]*class="taglink"[\s]*title="[^"]*"[\s]*href=["|\']?([^>"\' ]+)["|\']?\s*[^>]*>(.+?)<\/a>/si', "$2", $content);
		$title_matches = array();
		preg_match_all('/title=["|\'][^"\']*["|\']/si', $content, $title_matches);
		$alt_matches = array();
		preg_match_all('/alt=["|\'][^"\']*["|\']/si', $content, $alt_matches);
		if (is_array($title_matches[0]) && count($title_matches[0]) > 0) {
			$titleArray = array();
			foreach ($title_matches[0] as $key => $value) {
				$titleArray[$key]['name'] = $value;
				$titleArray[$key]['namekey'] = chunk_split(md5($value), 1, "-");
				$content = str_replace($titleArray[$key]['name'], $titleArray[$key]['namekey'], $content);
			}
		}
		if (is_array($alt_matches[0]) && count($alt_matches[0]) > 0) {
			$altArray = array();
			foreach ($alt_matches[0] as $key => $value) {
				$altArray[$key]['name'] = $value;
				$altArray[$key]['namekey'] = chunk_split(md5($value), 1, "-");
				$content = str_replace($altArray[$key]['name'], $altArray[$key]['namekey'], $content);
			}
		}
		foreach ($newTagArray as $key => $value) {
			if (!$value['title'] || strpos(espcms_host('AP'), $value['title'])) {
				continue;
			}
			$str_temp = '<a class="taglink" title="' . $value['rekey'] . '" href="' . $value['link'] . '" target="_blank">' . $value['rekey'] . '</a>';
			$content = $ceratkeylink_type > 1 ? str_replace($value['title'], $str_temp, $content) : str_replace_limit($value['title'], $str_temp, $content, 1);
		}
		foreach ($newTagArray as $key => $value) {
			$content = str_replace($value['rekey'], $value['title'], $content);
		}
		if (is_array($titleArray) && count($titleArray) > 0) {
			foreach ($titleArray as $key => $value) {
				$content = str_replace($value['namekey'], $value['name'], $content);
			}
		}
		if (is_array($altArray) && count($altArray) > 0) {
			foreach ($altArray as $key => $value) {
				$content = str_replace($value['namekey'], $value['name'], $content);
			}
		}
		return addslashes($content);
	}

	public static function article_downloadpic($content = false) {
		if (!$content) {
			return false;
		}
		$body = stripslashes($content);
		$images = self::imageList($body);
		if (is_array($images) && count($images) > 0 && $images[0]) {
			foreach ($images as $value) {
				if (!preg_match("/^((https|http|ftp|rtsp|mms)?:\/\/)[^\s]+$/i", $value)) {
					continue;
				}
				$picpathinfo = parse_url($value);
				if (!$picpathinfo['host'] || $picpathinfo['host'] == ESPCMS_WWW_URL) {
					continue;
				}
				$photo_info = ESPCMS_PhotoDownLoad::download($value);
				$photo_save_id = FileDB::saveFile($photo_info);
				if ($photo_save_id && is_array($photo_info)) {
					$body = str_replace($value, $photo_info['url'], $body);
				}
			}
		}
		return addslashes($body);
	}

	public static function imageList($content = false) {
		if (!$content) {
			return false;
		}
		$reg = "/<img[^>]*\s+src\s*=\s*(\'|\")*\s*([^\'\"\s]*)\s*(\'|\")*[^>]*>/is";
		$img_array = array();
		preg_match_all($reg, $content, $img_array, PREG_PATTERN_ORDER);
		return array_unique($img_array[2]);
	}

	function gb_check($content = false) {
		if (!$content) {
			return false;
		}
		$len = strlen($content);
		for ($i = 0; $i < $len; $i++) {
			if (ord(substr($content, $i, 1)) >= 0x81) {
				return true;
			}
		}
		return false;
	}

}
