<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/




namespace admin_application;

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Change;

class FileDB {

	public static function get_filedir_listDB($in_filedir_id = 0, $filedir_id = 0, $level = 0) {
		global $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . 'filedir';

		$db_sql = "SELECT c.filedir_id,c.filedir_lastid,c.filedir_pid,c.filedir_name,COUNT(a.filedir_id) AS has_c FROM $db_table AS c LEFT JOIN $db_table AS a ON a.filedir_lastid = c.filedir_id  GROUP BY c.filedir_id ORDER BY c.filedir_lastid,c.filedir_pid,c.filedir_id";
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$array[] = $fetch_row;
		}

		if ($filedir_id > 0) {
			foreach ($array as $key => $value) {

				$array[$key]['selected'] = ($filedir_id == $value['filedir_id']) ? 'selected' : '';
			}
		}

		$out_category_array = ESPCMS_Change::has_category($in_filedir_id, $array, 'filedir_id', 'filedir_lastid');
		if (is_array($out_category_array)) {
			foreach ($out_category_array as $key => $value) {

				$out_category_array[$key]['classname'] = 'opt_three_' . $value['level'];
				$out_category_array[$key]['icon'] = $value['has_c'] > 0 ? 'espcms_icon_fa espcms_icon_fa-chevron-circle-down text-orange' : 'espcms_icon_fa espcms_icon_fa-chevron-circle-right text-danfei';
			}
		}

		if ($level > 0) {
			if ($in_filedir_id == 0) {
				$end_level = $level;
			} else {

				$first_item = reset($out_category_array);
				$end_level = $first_item['level'] + $level;
			}

			foreach ($out_category_array AS $key => $val) {
				if ($val['level'] >= $end_level) {
					unset($out_category_array[$key]);
				}
			}
		}
		return $out_category_array;
	}

	public static function saveFile($saveFile = array(), $filedir_id = 0) {
		if (!is_array($saveFile) || !$saveFile['size']) {
			return false;
		}

		$db_table = ESPCMS_DB_PREFIX . "file";
		$talbe_field_array = espcms_field_out($db_table, true);
		$talbe_value = array();

		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		$talbe_value['admin_member_id'] = $admin_member_id && espcms_ismatches($admin_member_id) ? $admin_member_id : 0;
		$talbe_value['filedir_id'] = espcms_ismatches($filedir_id) ? $filedir_id : 0;
		$talbe_value['file_title'] = $saveFile['filename'];
		$talbe_value['file_filename'] = $saveFile['upLoadFileName_nopath'];
		$talbe_value['file_ext'] = $saveFile['extension'];
		$talbe_value['file_type'] = $saveFile['upfiletype'];
		$talbe_value['file_path'] = $saveFile['path'];
		$talbe_value['file_size'] = $saveFile['size'] && espcms_ismatches($saveFile['size']) ? $saveFile['size'] : 0;
		$talbe_value['file_iswidth'] = $saveFile['iswidth'];
		$talbe_value['file_addtime'] = $saveFile['ctime'] && espcms_ismatches($saveFile['ctime']) ? $saveFile['ctime'] : time();
		$talbe_value['file_isclass'] = 1;

		$postvalue = espcms_post($talbe_value, $talbe_field_array, true);
		if ($postvalue) {

			$install_id = espcms_db_install_save($db_table, $postvalue);
		}
		return $install_id;
	}

	public static function getFileDir($filedir_id = false, $return_key = false) {
		if (!$filedir_id || !espcms_ismatches($filedir_id)) {
			return false;
		}
		$db_where = "WHERE filedir_id=$filedir_id";
		$db_table = ESPCMS_DB_PREFIX . "filedir";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function getSearchFile($file_filename = false, $file_path = false, $return_key = false) {
		if (!$file_filename || !$file_path) {
			return false;
		}
		$db_where = "WHERE file_filename='$file_filename' AND file_path='$file_path'";
		$db_table = ESPCMS_DB_PREFIX . "file";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function getSearchDir($filedir_name = false, $filedir_lastid = 0, $return_key = false) {
		if (!$filedir_name || !espcms_ismatches($filedir_lastid)) {
			return false;
		}
		$db_where = "WHERE filedir_lastid=$filedir_lastid AND filedir_dirname='$filedir_name'";
		$db_table = ESPCMS_DB_PREFIX . "filedir";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

}
