<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace modul_application;

class ESPCMS_OrderDB {

	public static function get_order_payreceipt_list($oid) {
		if (empty($oid) || !espcms_ismatches($oid)) {
			return false;
		}
		$db_where = " AND oid=$oid";
		$db_table = ESPCMS_DB_PREFIX . 'order_payreceipt';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "oprid");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function get_order_shipreceipt_list($oid) {
		if (empty($oid) || !espcms_ismatches($oid)) {
			return false;
		}
		$db_where = " AND oid=$oid";
		$db_table = ESPCMS_DB_PREFIX . 'order_shipreceipt';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "osrid");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function get_order_view($oid = 0, $ordersn = false, $return_key = false) {
		if (!$oid && !espcms_ismatches($oid) && !$ordersn) {
			return false;
		}
		if ($oid && espcms_ismatches($oid)) {
			$db_where = "WHERE oid=$oid";
		}
		if ($ordersn && espcms_isact($ordersn, '/^[\w-]+$/i')) {
			$db_where = "WHERE ordersn='$ordersn'";
		}
		if (!$db_where) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'order';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_order_info_list($oid) {
		if (empty($oid) || !espcms_ismatches($oid)) {
			return false;
		}
		$db_where = " AND oid=$oid";
		$db_table = ESPCMS_DB_PREFIX . 'order_info';
		$talbe_field_array = espcms_field_out($db_table, false);
		$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, "oiid");
		if (!is_array($array) || count($array) < 1) {
			return array();
		}
		return $array;
	}

	public static function get_pay_plug_view($opid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (!$opid || !espcms_ismatches($opid)) {
			return false;
		}
		$db_where = "WHERE opid=$opid";
		$db_table = ESPCMS_DB_PREFIX . 'order_pay';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $opid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_pay_plug_code_view($paycode = 0, $return_key = false) {
		global $espcms_db_cache;
		if (!$paycode) {
			return false;
		}
		$db_where = "WHERE paycode='$paycode'";
		$db_table = ESPCMS_DB_PREFIX . 'order_pay';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $paycode;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_pay_plug_list($opid = 0, $isclass = false, $ismoblie = false) {
		global $espcms_db_cache;
		$db_table = ESPCMS_DB_PREFIX . 'order_pay';
		if (espcms_ismatches($isclass)) {
			$db_where .= " AND isclass=$isclass";
		}
		if (espcms_ismatches($ismoblie)) {
			$db_where .= " AND ismoblie=$ismoblie";
		}
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $isclass . '_' . $ismoblie;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!is_array($array) || !count($array) > 0) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where);
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		foreach ($array as $key => $value) {
			if ($opid == $value['opid']) {
				$array[$key]['selected'] = 'selected';
			}
		}
		return $array;
	}

	public static function get_express_list($osid = 0, $isclass = false) {
		global $espcms_db_cache;
		$db_table = ESPCMS_DB_PREFIX . 'order_shipping';
		if (espcms_ismatches($isclass)) {
			$db_where = " AND isclass=$isclass";
		}
		$cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $isclass;
		$array = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!is_array($array) || !count($array) > 0) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$array = espcms_db_list_array($db_table, $talbe_field_array, $db_where);
			if (!is_array($array) || count($array) < 1) {
				return array();
			}
			$espcms_db_cache->cacheSave($cache_key, $array);
		}
		foreach ($array as $key => $value) {
			if ($osid == $value['osid']) {
				$array[$key]['selected'] = 'selected';
			}
		}
		return $array;
	}

	public static function get_express_view($osid = 0, $return_key = false) {
		global $espcms_db_cache;
		if (!$osid || !espcms_ismatches($osid)) {
			return false;
		}
		$db_where = "WHERE osid=$osid";
		$db_table = ESPCMS_DB_PREFIX . 'order_shipping';
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $osid;
		$read_info = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$read_info) {
			$talbe_field_array = espcms_field_out($db_table, false);
			$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read_info) {
				return false;
			}
			$espcms_db_cache->cacheSave($cache_key, $read_info);
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function order_install_goods($oid, $postdb = array(), $is_update = false) {
		if (!espcms_ismatches($oid) || empty($oid) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "order_info";
		if ($is_update) {
			espcms_db_delall($db_table, "oid=$oid");
		}
		if (!is_array($postdb['products_name']) || count($postdb['products_name']) < 1 || !is_array($postdb['products_id']) || count($postdb['products_id']) < 1 || !is_array($postdb['product_item_total']) || count($postdb['product_item_total']) < 1 || !is_array($postdb['product_item_price']) || count($postdb['product_item_price']) < 1) {
			return false;
		}
		$talbe_field_array = espcms_field_out($db_table, true);
		$album_install_array = array();
		foreach ($postdb['products_id'] as $key => $did) {
			$install_post['oid'] = $oid;
			$install_post['did'] = $did && espcms_ismatches($did) ? $did : 0;
			$install_post['tsn'] = $postdb['products_tsn'][$key] ? $postdb['products_tsn'][$key] : '';
			$install_post['title'] = $postdb['products_name'][$key] ? $postdb['products_name'][$key] : '';
			$install_post['oprice'] = espcms_ismoney($postdb['products_oprice'][$key]) ? $postdb['products_oprice'][$key] : 0;
			$install_post['bprice'] = espcms_ismoney($postdb['product_item_price'][$key]) ? $postdb['product_item_price'][$key] : 0;
			$install_post['countprice'] = espcms_ismoney($postdb['product_item_total'][$key]) ? $postdb['product_item_total'][$key] : 0;
			$install_post['amount'] = $postdb['product_item_qty'][$key] && espcms_ismatches($postdb['product_item_qty'][$key]) ? $postdb['product_item_qty'][$key] : 0;
			$album_install_array[] = espcms_post($install_post, $talbe_field_array, true, true);
		}
		if (is_array($album_install_array)) {
			$install_id = espcms_db_install_array_save($db_table, $album_install_array);
		} else {
			$install_id = false;
		}
		return $install_id;
	}

	public static function order_update_type($oid, $postdb = array()) {
		if (!espcms_ismatches($oid) || empty($oid) || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "order";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($postdb, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			return false;
		}
		$db_where = "WHERE oid=$oid";
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			return false;
		}
		return $update_id;
	}

	public static function order_install_order_payreceipt($oid, $postdb = array(), $payclass = 1, $paytype = 1) {
		if (!espcms_ismatches($oid) || !$oid || !is_array($postdb) || count($postdb) < 1) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "order_payreceipt";
		if (!espcms_ismatches($postdb['opid']) || !$postdb['opid'] || !espcms_ismoney($postdb['payamount'])) {
			return false;
		}
		$talbe_field_array = espcms_field_out($db_table, true);
		$install_post['oid'] = $oid;
		$install_post['userid'] = espcms_ismatches($postdb['userid']) && $postdb['userid'] ? $postdb['userid'] : 0;
		$install_post['paytype'] = espcms_ismatches($paytype) ? $paytype : 1;
		$install_post['payclass'] = espcms_ismatches($payclass) ? $payclass : 1;
		$install_post['addtime'] = time();
		$install_post['paytime'] = time();
		$install_post['opid'] = espcms_ismatches($postdb['opid']) && $postdb['opid'] ? $postdb['opid'] : 0;
		$install_post['payamount'] = espcms_ismoney($postdb['payamount']) && $postdb['payamount'] ? $postdb['payamount'] : 0;
		$install_post['bankaccount'] = $postdb['bankaccount'] ? $postdb['bankaccount'] : '';
		$install_post['bankname'] = $postdb['bankname'] ? $postdb['bankname'] : '';
		$install_post['paysn'] = $postdb['paysn'] ? $postdb['paysn'] : '';
		$install_post['content'] = $postdb['buyer_email'] ? $postdb['buyer_email'] : '';
		$postvalue = espcms_post($install_post, $talbe_field_array, true);
		$install_id = espcms_db_install_save($db_table, $postvalue);
		if (!$install_id) {
			return false;
		}
		return $install_id;
	}

	public static function get_paylink($plugcode = false, $order_read = array(), $pay_argument = array(), $notify_key = array()) {
		if (!$plugcode || !is_array($order_read) || !is_array($pay_argument)) {
			return false;
		}
		$alipay_file = ESPCMS_FILE_ROOT . 'espcms_includes/payment/' . $plugcode . '.php';
		if (!is_file($alipay_file)) {
			return false;
		}
		include_once $alipay_file;
		$payobj = new $plugcode();
		$orderonline = $payobj->get_code($order_read, $pay_argument, $order_read['return_url'], $order_read['notify_url'], $notify_key);
		return $orderonline;
	}

}
