<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace application;

use admin_application\link\UserMainLink;

class ESPCMS_AdminAuthority {

	public static function getUserLoginInfo($key_value = false, $return_type = 'user') {
		if (!in_array($return_type, array('user', 'info'))) {
			return false;
		}
		if ($return_type == 'user') {
			$espcms_user_info = $_COOKIE['espcms_admin_user_info'];
			if ($espcms_user_info) {
				$espcms_user_info_array = espcms_decrypt($espcms_user_info, ESPCMS_ENCRYPT_CODE);
				return $key_value ? $espcms_user_info_array[$key_value] : $espcms_user_info_array;
			} else {
				return false;
			}
		}
		if ($return_type == 'info') {
			$espcms_user_login_info = $_COOKIE['espcms_admin_user_server_info'];
			if ($espcms_user_login_info) {
				$espcms_user_login_info_array = espcms_decrypt($espcms_user_login_info, ESPCMS_ENCRYPT_CODE);
				return $key_value ? $espcms_user_login_info_array[$key_value] : $espcms_user_login_info_array;
			} else {
				return false;
			}
		}
	}

	public static function authorityBaseVerify($isErrorMessage = false) {
		$login_url = UserMainLink::getLink('login');
		$admin_info = self::getUserLoginInfo();
		$login_info = self::getUserLoginInfo(false, 'info');
		if ($admin_info['admin_username'] && espcms_ismatches($admin_info['admin_member_id']) && espcms_ismatches($admin_info['power_groups_id'])) {
			return true;
		} else {
			if ($isErrorMessage) {
				espcms_message_window_err('public_pack-espcms_authority_function_fail');
			} else {
				header('location:' . $login_url);
				exit();
			}
		}
	}

	public static function authorityVerify($verify_mothod) {
		global $espcms_db_cache;
		if (!$verify_mothod) {
			return false;
		}
		$admin_info = self::getUserLoginInfo();
		$power_groups_id = $admin_info['power_groups_id'];
		if (!espcms_ismatches($power_groups_id) || empty($power_groups_id)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'power_groups';
		$db_where = "WHERE power_groups_id=$power_groups_id";
		$talbe_field_array = espcms_field_out($db_table);
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $power_groups_id;
		$power_read = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$power_read) {
			$power_read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if ($power_read) {
				$espcms_db_cache->cacheSave($cache_key, $power_read);
			}
		}
		if ($power_read['power_groups_issystem']) {
			return true;
		}
		if (!$power_read['power_groups_function']) {
			return false;
		}
		$power_groups_function_array = explode(',', $power_read['power_groups_function']);
		if (!is_array($power_groups_function_array) && count($power_groups_function_array) <= 1) {
			return false;
		}
		$isAuthority = in_array($verify_mothod, $power_groups_function_array) ? true : false;
		return $isAuthority;
	}

	public static function authorityAdminVerify($exclude_method = array(), $ignore = false) {
		global $module_array, $espcms_db_cache;
		$user_center = UserMainLink::getLink('center');
		$user_login = UserMainLink::getLink('login');
		$db_table = ESPCMS_DB_PREFIX . 'power_groups';
		if (self::authorityBaseVerify()) {
			$admin_info = self::getUserLoginInfo();
			$power_groups_id = $admin_info['power_groups_id'];
			if (!espcms_ismatches($power_groups_id) || !$power_groups_id) {
				espcms_message_page_err('login_pack-espcms_authority_function_admin_err', $user_login, array($admin_info['admin_name']));
			}
			$db_where = "WHERE power_groups_id=$power_groups_id";
			$talbe_field_array = espcms_field_out($db_table);
			$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $power_groups_id;
			$power_read = $espcms_db_cache->cacheCheck($cache_key, false);
			if (!$power_read) {
				$power_read = espcms_db_read($db_table, $db_where, $talbe_field_array);
				if ($power_read && $power_read['power_groups_function']) {
					$espcms_db_cache->cacheSave($cache_key, $power_read);
				}
			}
			if (!$power_read['power_groups_issystem']) {
				if (!$power_read['power_groups_function']) {
					espcms_message_page_err('login_pack-espcms_authority_function_err', $user_center, array($admin_info['admin_name'], $power_read['power_groups_name']), 1, false, false);
				}
				$power_groups_function_array = explode(',', $power_read['power_groups_function']);
				if (!is_array($power_groups_function_array) && count($power_groups_function_array) <= 1) {
					espcms_message_page_err('login_pack-espcms_authority_function_err', $user_center, array($admin_info['admin_name'], $power_read['power_groups_name']), 1, false, false);
				}
				$isAuthority = false;
				if (in_array($module_array['method'], $exclude_method)) {
					$isAuthority = true;
				} else {
					$isAuthority = in_array($module_array['module'], $power_groups_function_array) && in_array($module_array['method'], $power_groups_function_array) ? true : false;
				}
				$isAuthority = !$ignore ? $isAuthority : $ignore;
				if (!$isAuthority) {
					espcms_message_page_err('login_pack-espcms_authority_function_err', $user_center, array($admin_info['admin_name'], $power_read['power_groups_name']), 1, false, false);
				}
				return $isAuthority;
			} else {
				return true;
			}
		} else {
			return false;
		}
	}

	public static function authorityIsAdminVerify() {
		global $espcms_db_cache;
		$admin_info = self::getUserLoginInfo();
		$power_groups_id = $admin_info['power_groups_id'];
		if (!espcms_ismatches($power_groups_id) || !$power_groups_id) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'power_groups';
		$db_where = "WHERE power_groups_id=$power_groups_id";
		$talbe_field_array = espcms_field_out($db_table);
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $power_groups_id;
		$power_read = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$power_read) {
			$power_read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if ($power_read) {
				$espcms_db_cache->cacheSave($cache_key, $power_read);
			}
		}
		if ($power_read['power_groups_issystem']) {
			return true;
		} else {
			return false;
		}
	}

	public static function getAuthorityRank($verify_mothod = false, $rankType = 1) {
		global $espcms_db_cache;
		if (!$verify_mothod) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'authority';
		$admin_info = self::getUserLoginInfo();
		$power_groups_id = $admin_info['power_groups_id'];
		if (!espcms_ismatches($power_groups_id) || empty($power_groups_id)) {
			return false;
		}
		$db_where = "WHERE power_groups_id=$power_groups_id";
		$talbe_field_array = espcms_field_out($db_table);
		$cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $power_groups_id;
		$power_read = $espcms_db_cache->cacheCheck($cache_key, false);
		if (!$power_read) {
			$power_read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if ($power_read && $power_read['power_groups_function']) {
				$espcms_db_cache->cacheSave($cache_key, $power_read);
			}
		}
		switch ($rankType) {
			case 1:
				$authority_rank = $power_read['power_groups_view'];
				break;
			case 2:
				$authority_rank = $power_read['power_groups_edit'];
				break;
			case 3:
				$authority_rank = $power_read['power_groups_del'];
				break;
			default:
				$authority_rank = false;
				break;
		}
		if (!$authority_rank) {
			return false;
		}
		$authority_view = $authority_rank ? unserialize($authority_rank) : array();
		return $authority_view[$verify_mothod];
	}

	public static function setLogingInfo($username, $user_login_err_num = 0, $set_time = false) {
		if (!$username) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'admin_users_login';
		$talbe_field_array = espcms_field_out($db_table, true);
		$_POST['user_login_username'] = $username;
		$_POST['user_login_err_num'] = $user_login_err_num;
		$_POST['user_login_ip'] = real_remote_ip();
		$_POST['user_login_err_time'] = $set_time ? time() : 0;
		$db_where = "WHERE user_login_username='$username'";
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if ($read_info) {
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		} else {
			$update_id = espcms_db_install_save($db_table, $postvalue);
		}
		return $update_id;
	}

	public static function getLogingInfo($username) {
		if (!$username) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'admin_users_login';
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = "WHERE user_login_username='$username'";
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		} else {
			return $read_info;
		}
	}

	public static function delLogingInfo($username) {
		if (!$username) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . 'admin_users_login';
		$del_info = espcms_db_delall($db_table, "user_login_username='$username'");
		if (!$del_info) {
			return false;
		} else {
			return $del_info;
		}
	}

	public static function get_admin_view($admin_member_id = 0, $return_key = false) {
		if (!$admin_member_id || !espcms_ismatches($admin_member_id)) {
			return false;
		}
		$db_where = "WHERE admin_member_id=$admin_member_id";
		$db_table = ESPCMS_DB_PREFIX . 'admin_member';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

}
