<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_FileTool;

class ESPCMS_Cache {
	public $cacheFileDIR = 'dbcache/';
	public $cacheTime = 60;
	public $cacheFileType = 'php';
	public $isCache = true;

	function cacheSave($cacheFileName, $cachecontent, $renewid = true) {
		if (!$this->isCache || !$cacheFileName || !$cachecontent) {
			return false;
		}
		if (is_array($cachecontent) && count($cachecontent) > 0) {
			$content = var_export($cachecontent, TRUE);
		} else {
			$content = "'" . $cachecontent . "'";
		}
		$filename = $this->cacheFileDIR . $cacheFileName . '_' . md5($cacheFileName) . '.' . $this->cacheFileType;
		if ($renewid || !is_file($filename)) {
			$sConfig = "<?php\n";
			$sConfig = $sConfig . "/*\rPHP version 5\rCopyright (c) 2002-2019 ECISP.CN、EarcLink.COM\r警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖\r作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030\r*/\n";
			$sConfig = $sConfig . '/*uptime:' . date('Y-m-d H:i:s', time()) . "*/\n";
			$sConfig = $sConfig . '$' . $cacheFileName . '=' . $content . ";\n";
			if (!ESPCMS_FileTool::writeFile($filename, $sConfig)) {
				return false;
			} else {
				return $cachecontent;
			}
		} else {
			include ($filename);
			$cachecontent = $$cacheFileName;
			return $cachecontent ? $cachecontent : false;
		}
	}

	function cacheCheck($cachekey, $checkid = true) {
		if (!$this->isCache || !$cachekey) {
			return false;
		}
		if (!is_dir($this->cacheFileDIR)) {
			espcms_message_err('public_pack-espcms_cache_dir_err', array($this->cacheFileDIR));
		}
		$cacheFileName = $this->cacheFileDIR . $cachekey . '_' . md5($cachekey) . '.' . $this->cacheFileType;
		if (is_file($cacheFileName)) {
			if ($checkid) {
				$nowtime = time();
				$filetime = filemtime($cacheFileName);
				$endtime = $filetime + $this->cacheTime;
				$exchchefiletime = $nowtime - $endtime;
			} else {
				$exchchefiletime = -1;
			}
			if ($exchchefiletime >= 0) {
				return false;
			} else {
				include ($cacheFileName);
				$db_array = $$cachekey;
				return $db_array ? $db_array : false;
			}
		} else {
			return false;
		}
	}

	function cacheDEL($cachekey = false, $cachekeyseach = false) {
		if ($cachekey) {
			if (!$cachekeyseach) {
				$cacheFileName = $this->cacheFileDIR . $cachekey . '_' . md5($cachekey) . '.' . $this->cacheFileType;
				if (is_file($cacheFileName)) {
					return ESPCMS_FileTool::delFile($cacheFileName);
				} else {
					return false;
				}
			} else {
				$cacheFileName = $this->cacheFileDIR;
				if (file_exists($cacheFileName)) {
					$dirname = opendir($cacheFileName);
					while ($val = readdir($dirname)) {
						if ($val == '.' || $val == '..') {
							continue;
						}
						if (stripos('@#!@@' . $val, $cachekey) == 5) {
							$value = $cacheFileName . $val;
							unlink($value);
						}
					}
					closedir($dirname);
					return true;
				} else {
					return false;
				}
			}
		} else {
			$cacheFileName = $this->cacheFileDIR;
			if (file_exists($cacheFileName)) {
				$dirname = opendir($cacheFileName);
				while ($val = readdir($dirname)) {
					if ($val == '.' || $val == '..') {
						continue;
					}
					$value = $cacheFileName . $val;
					unlink($value);
				}
				closedir($dirname);
				return true;
			} else {
				return false;
			}
		}
	}

}
