<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace application;

use application\ESPCMS_FileTool;

class ESPCMS_Core {

    public static function get_lngpack_view($lng = false) {
        if (!$lng || !preg_match('/^[\w]+$/', $lng)) {
            return false;
        }
        $lanpackfile = ESPCMS_FILE_ROOT . 'espcms_datacache/' . $lng . '_pack.php';
        if (!file_exists($lanpackfile)) {
            $creat_type = self::creat_lanpack($lng);
            if (!$creat_type) {
                return false;
            }
        }
        require($lanpackfile);
        return $LANPACK;
    }

    public static function creat_lanpack($lng = false) {
        global $espcms_link_db;
        if (!$lng || !preg_match('/^[\w]+$/', $lng)) {
            return false;
        }
        $sConfig = "<?php\n";
        $sConfig = $sConfig . "/*\rPHP version 5\rCopyright (c) 2012-2018 ECISP.CN,ESPCMS.CN\r警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖\r作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030\r作用：语言包\r*/\n";
        $sConfig = $sConfig . "\$LANPACK = Array(\n";
        $db_table = ESPCMS_DB_PREFIX . "lngpack";
        $db_sql = "SELECT * FROM $db_table WHERE lng='$lng' ORDER BY lpid";
        $db_query = $espcms_link_db->db_query($db_sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $keycode = addslashes($fetch_row['keycode']);
            $langstr = addslashes($fetch_row['langstr']);
            $sConfig = $sConfig . "\x20\x20\x20\x20 '" . $keycode . '\'=>\'' . $langstr . "',\n";
        }
        $sConfig = $sConfig . ");\n";
        $lanpackfile = ESPCMS_FILE_ROOT . 'espcms_datacache/' . $lng . '_pack.php';

        if (!ESPCMS_FileTool::writeFile($lanpackfile, $sConfig)) {
            return false;
        }
        return true;
    }

    public static function command_creat() {
        global $espcms_link_db;
        $sConfig = "<?php\n";
        $sConfig = $sConfig . "/*\rPHP version 5\rCopyright (c) 2012-2018 ECISP.CN,ESPCMS.CN\r警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖\r作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030\r作用：网站参数变量\r*/\n";
        $sConfig = $sConfig . "\$espcms_command = Array(\n";
        $db_table = ESPCMS_DB_PREFIX . "config";
        $db_sql = "SELECT * FROM $db_table ORDER BY config_category_id,config_id";
        $db_query = $espcms_link_db->db_query($db_sql);
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $valname = addslashes($fetch_row['config_name']);
            $value = addslashes($fetch_row['config_value']);
            $valtype = $fetch_row['config_type'];


            if ($valtype == 'int' || $valtype == 'bool') {
                $value = empty($value) ? 0 : $value;
                $sConfig = $sConfig . "\x20\x20\x20\x20 '" . $valname . '\'=>' . $value . ", \n";
            } else {
                $sConfig = $sConfig . "\x20\x20\x20\x20 '" . $valname . '\'=>\'' . $value . "',\n";
            }
        }
        $sConfig = $sConfig . ");\n";
        $commandfile = ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_command.php';

        if (!ESPCMS_FileTool::writeFile($commandfile, $sConfig)) {
            return false;
        }
        return true;
    }

    public static function get_order_pay_list($opid = 0, $isclass = 1, $ismoblie = false, $isonlinepay = false, $order_type = "ASC") {
        $db_table = ESPCMS_DB_PREFIX . 'order_pay';
        $db_order = "opid $order_type";
        $talbe_field_array = espcms_field_out($db_table);
        $db_where = '';
        if (espcms_ismatches($isclass)) {
            $db_where .= " AND isclass=$isclass";
        }
        if (espcms_ismatches($ismoblie)) {
            $db_where .= " AND ismoblie=$ismoblie";
        }
        if (espcms_ismatches($isonlinepay)) {
            $db_where .= " AND isonlinepay=$isonlinepay";
        }
        $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $db_order);
        if (!is_array($array) || count($array) < 1) {
            return array();
        }
        if (espcms_ismatches($opid) && $opid) {
            foreach ($array as $key => $value) {
                if ($opid == $value['opid']) {
                    $array[$key]['selected'] = 'selected';
                }
            }
        }
        return $array;
    }

    public static function get_skin($template_type = 'web', $return_key = false) {
        global $espcms_db_cache;
        if (empty($template_type)) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . 'skin';
        $db_where = $template_type == 'web' ? " WHERE iswap=0 AND isclass=1" : " WHERE iswap=1 AND isclass=1";
        $talbe_field_array = espcms_field_out($db_table);
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $template_type;
        $read = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read) {
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            $espcms_db_cache->cacheSave($cache_key, $read);
        }
        return !$return_key ? $read : $read[$return_key];
    }

    public static function get_app_config($app_code, $isunser = false, $return_key = false) {
        global $espcms_db_cache;
        if (!$app_code) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . 'apply';
        $db_where = " WHERE applycode = '$app_code'";
        $talbe_field_array = espcms_field_out($db_table);
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $app_code;
        $read = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read) {
            $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
            $espcms_db_cache->cacheSave($cache_key, $read);
        }
        if ($isunser) {

            $read['appconfig'] = unserialize($read['appconfig']);
        }
        return !$return_key ? $read : $read[$return_key];
    }

    public static function get_app_view($appid, $return_key = false) {
        if (empty($appid) || !espcms_ismatches($appid)) {
            return false;
        }
        $db_where = "WHERE appid=$appid";
        $db_table = ESPCMS_DB_PREFIX . 'apply';
        $talbe_field_array = espcms_field_out($db_table, false);
        $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read_info) {
            return false;
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }

    public static function get_widget_list() {
        $db_table = ESPCMS_DB_PREFIX . 'widget';
        $talbe_field_array = espcms_field_out($db_table);
        $db_where = " AND widget_isopen=1";
        $db_order = "widget_pid";
        $info_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $db_order);
        return $info_array;
    }

    public static function get_widget_view($widget_id = 0, $widget_code = false, $return_key = false) {
        if (!$widget_id && !espcms_ismatches($widget_id) && !$widget_code) {
            return false;
        }
        $db_table = ESPCMS_DB_PREFIX . 'widget';
        $talbe_field_array = espcms_field_out($db_table);
        $db_where = ' WHERE 1=1';
        if (!empty($widget_id) && espcms_ismatches($widget_id)) {
            $db_where .= " AND widget_id=$widget_id";
        }
        if (!empty($widget_code)) {
            $db_where .= " AND widget_code='$widget_code'";
        }
        $read = espcms_db_read($db_table, $db_where, $talbe_field_array);
        if (!$read) {
            return false;
        }
        return !$return_key ? $read : $read[$return_key];
    }

    public static function get_plug_list($paydir) {
        if (!is_dir($paydir)) {
            return false;
        }
        $dir_list = ESPCMS_FileTool::list_dir($paydir, array('php'), 'file', false);
        if (!is_array($dir_list) || count($dir_list) <= 0) {
            return false;
        }
        $modulesid = true;
        $modules = array();
        foreach ($dir_list as $key => $value) {
            $file = $value['dirname'] . '/' . $value['basename'];
            if (!is_file($file)) {
                continue;
            }
            require_once $file;
        }
        if (!is_array($modules) || count($modules) <= 0) {
            return false;
        }

        unset($modulesid);
        foreach ($modules as $key => $value) {

            ksort($modules[$key]);
        }
        ksort($modules);
        return $modules;
    }

    public static function get_widget_bt_list() {
        $db_table = ESPCMS_DB_PREFIX . 'widget_bt';
        $talbe_field_array = espcms_field_out($db_table);
        $db_where = " AND widget_bt_isopen=1";
        $db_order = "widget_bt_pid";
        $info_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $db_order);
        return $info_array;
    }

    public static function get_lan_list($lng = false, $iswap = false, $isopen = true) {
        global $espcms_db_cache, $espcms_command;
        $db_table = ESPCMS_DB_PREFIX . 'lng';
        $db_order = "pid,lan_id DESC";
        $cache_key = ESPCMS_CACHE_DBLIST_NAME . $db_table . '_' . $iswap . '_' . $isopen;
        $array = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!is_array($array) || !count($array) > 0) {
            $talbe_field_array = espcms_field_out($db_table);
            if (espcms_ismatches($isopen)) {
                $db_where .= " AND isopen=1";
            }
            if (espcms_ismatches($iswap)) {
                $db_where .= " AND iswap=$iswap";
            }
            $array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $db_order);
            if (!is_array($array) || count($array) < 1) {
                return array();
            }
            $espcms_db_cache->cacheSave($cache_key, $array);
        }
        $lng = $lng ? $lng : $espcms_command['HOME_LNG'];
        if ($lng) {
            foreach ($array as $key => $value) {
                if ($lng == $value['lng']) {
                    $array[$key]['selected'] = 'selected';
                }
            }
        }
        return $array;
    }

    public static function get_lan_view($lng = 0, $return_key = false) {
        global $espcms_db_cache;
        if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
            return false;
        }
        $db_where = "WHERE lng='$lng'";
        $db_table = ESPCMS_DB_PREFIX . 'lng';
        $cache_key = ESPCMS_CACHE_DBREAD_NAME . $db_table . '_' . $lng;
        $read_info = $espcms_db_cache->cacheCheck($cache_key, false);
        if (!$read_info) {
            $talbe_field_array = espcms_field_out($db_table, false);
            $read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
            if (!$read_info) {
                return false;
            }
            $espcms_db_cache->cacheSave($cache_key, $read_info);
        }
        return !$return_key ? $read_info : $read_info[$return_key];
    }

    public static function connect_service($ac_name = array(), $post = array(), $isjson = true) {
        global $espcms_command;
        if (!$ac_name || !preg_match("/^[\w]+$/i", $ac_name)) {
            return false;
        }

        $post['sitename'] = addslashes($espcms_command['SITENAME']);
        $post['siteurl'] = espcms_host('AP');
        $post['vol'] = addslashes($espcms_command['CON_VOL']);
        $post['dbosn'] = addslashes($espcms_command['CON_DBOSN']);
        $post['isdbo'] = addslashes($espcms_command['CON_ISDBO']);
        $post['dbcode'] = addslashes($espcms_command['CON_ENCRYPT_CODE']);
        $post['email'] = addslashes($espcms_command['ADMINE_MAIL']);
        $post['tel'] = addslashes($espcms_command['SMS_MOBLIE_NB']);
        $send_add = espcms_decrypt(ESPCMS_QUERST_ADD_LONG, ESPCMS_ADD_ENCODE);
        $response = espcms_curl_post($send_add . $ac_name, espcms_array_to_xml($post));
        if (!$response) {
            return false;
        }
        if ($isjson) {
            $response_josn = json_decode($response, true);
            if (is_array($response_josn)) {
                return $response_josn;
            } else {
                return false;
            }
        } elseif (!$isjson && $response) {
            return $response;
        } else {
            return false;
        }
    }

    public static function connect_url($ac_name = false, $post = array()) {
        global $espcms_command;
        if (!$ac_name || !preg_match("/^[\w]+$/i", $ac_name)) {
            return false;
        }

        $post['ac'] = 'ESPCMS_API';
        $post['at'] = $ac_name;
        $post['vol'] = urlencode($espcms_command['CON_VOL']);
        $post['dbosn'] = addslashes($espcms_command['CON_DBOSN']);
        $post['isdbo'] = addslashes($espcms_command['CON_ISDBO']);
        $post['dbcode'] = addslashes($espcms_command['CON_ENCRYPT_CODE']);
        $post['sitename'] = urlencode($espcms_command['SITENAME']);
        $post['email'] = urlencode($espcms_command['ADMINE_MAIL']);
        $post['tel'] = urlencode($espcms_command['SMS_MOBLIE_NB']);
        $post['siteurl'] = urlencode(espcms_host('AP'));
        $send_add = espcms_decrypt(ESPCMS_QUERST_ADD, ESPCMS_ADD_ENCODE);
        $response = espcms_combine_url($send_add, $post);
        if (!$response) {
            return false;
        }
        return $response;
    }

    public static function is_command_write() {
        $commandfile = ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_command.php';
        if (!is_file($commandfile)) {
            return false;
        }
        if (!is_writable($commandfile)) {
            return false;
        } else {
            return true;
        }
    }

    public static function update_ver($ver_db = array()) {
        if (!is_array($ver_db) || count($ver_db) < 1) {
            return false;
        }

        $db_table = ESPCMS_DB_PREFIX . "config";
        espcms_db_update_set_save($db_table, "WHERE config_name='CON_DBOSN'", "config_value='$ver_db[uid]'");

        ESPCMS_Core::command_creat();
    }

    public static function update_site_db() {
        $db_table_document = ESPCMS_DB_PREFIX . "document";
        $db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
        $db_table_document_typelist = ESPCMS_DB_PREFIX . "document_typelist";
        espcms_db_delall($db_table_document, "1=1");
        espcms_db_delall($db_table_document_content, "1=1");
        espcms_db_delall($db_table_document_typelist, "1=1");
    }

}
