<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace application;

class ESPCMS_FileUpload {

	public static function intoFile($fileArray = array(), $commandArray = array(), $upFileType = 'image', $isZoom = false, $isWater = false, $base64 = false, $chunk = false, $chunks = 0, $save_filename = false, $save_dirname = false) {

		$error_Array = array();

		$error_Array['fileErrar'] = 0;

		$error_Array['dirCreatErrar'] = 0;

		$error_Array['returnVal'] = 1;

		$upFileSize = espcms_ismatches($commandArray['UPFILE_SIZE']) && $commandArray['UPFILE_SIZE'] ? $commandArray['UPFILE_SIZE'] * 1000 * 1000 : 1000000;

		if ($base64) {

			$fileSize = strlen($fileArray);
			if ($fileSize <= 0 || $fileSize > $upFileSize) {
				$error_Array['fileErrar'] = 4;
				$error_Array['filename'] = null;
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}
		} else {
			if (!is_array($fileArray) || !$fileArray['name'] || !$fileArray['type'] || !$fileArray['tmp_name'] || !$fileArray['size'] || !is_array($commandArray)) {
				$error_Array['fileErrar'] = 4;
				$error_Array['filename'] = $fileArray['name'];
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}
		}

		switch ($upFileType) {
			case 'image':
				$allowFileType = $commandArray['UPFILE_FILE_PIC_TYPE'];
				break;
			case 'mover':
				$allowFileType = $commandArray['UPFILE_FILE_MOVER_TYPE'];
				break;
			case 'file':
				$allowFileType = $commandArray['UPFILE_FILE_OTHER_TYPE'];
				break;
		}

		$savePath = $commandArray['UPFILE_SAVAPATH'] ? ESPCMS_FILE_ROOT . $commandArray['UPFILE_SAVAPATH'] : ESPCMS_FILE_ROOT . 'upfile/';

		$fileTempPath = ESPCMS_FILE_ROOT . 'espcms_datacache/filetemp/';






		if ($save_dirname) {
			$savePath = $savePath . $save_dirname;
		} else {
			switch ($commandArray['UPFILE_SAVEDIR']) {
				case 'y':
					$savePath = $savePath . date("Y") . '/' . date("m") . '/' . date("d") . '/';
					break;
				case 'd':
					$savePath = $savePath . date("Y") . '/' . date("m") . date("d") . '/';
					break;
				case 'm':
					$savePath = $savePath . date("Y") . date("m") . date("d") . '/';
					break;
				case 'm1':
					$savePath = $savePath . date("Y") . date("m") . '/';
					break;
				case 'm2':
					$savePath = $savePath . date("Y") . '/';
					break;
				case 'm3':
					$savePath = $savePath . date("Y") . '/' . date("m") . '/';
					break;
			}
		}

		if (!is_dir($savePath)) {
			if (!@mkdir($savePath, 0777, true)) {

				$error_Array['dirCreatErrar'] = 1;
				$error_Array['dirname'] = $savePath;
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}
		}

		if ($chunks > 1) {
			if (!is_dir($fileTempPath)) {
				if (!@mkdir($fileTempPath, 0777, true)) {

					$error_Array['dirCreatErrar'] = 1;
					$error_Array['dirname'] = $fileTempPath;
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}
			}


			if ($fileArray['error'] > 0) {







				$error_Array['fileErrar'] = $fileArray['error'];
				$error_Array['filename'] = $fileArray['name'];
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}

			if ($fileArray['tmp_name'] && $fileArray['name']) {

				$file_extension = self::extendname($fileArray['name']);

				$file_name = self::extendname($fileArray['name'], 2);

				if (empty($file_extension)) {
					$file_extension = self::fileType($fileArray['tmp_name'], $fileArray['type']);
				}

				if (empty($file_extension)) {
					$error_Array['fileErrar'] = 7;
					$error_Array['filename'] = $fileArray['name'];
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				if (!self::typecheck($allowFileType, $file_extension)) {
					$error_Array['fileErrar'] = 8;
					$error_Array['file_extension'] = $file_extension;
					$error_Array['allowFileType'] = $allowFileType;
					$error_Array['filename'] = $fileArray['name'];
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				$newTempFileName = md5($fileArray['name']);

				$upLoadTempFileName = $fileTempPath . $newTempFileName . '_' . $chunk . '.part';

				$isFileCreat = @move_uploaded_file($fileArray['tmp_name'], $upLoadTempFileName);
				if (!$isFileCreat) {
					$error_Array['fileErrar'] = 11;
					$error_Array['filename'] = $upLoadTempFileName;
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				$isFinish = ($chunk + 1) == $chunks ? true : false;
				$isCheck = false;
				if ($isFinish) {

					if (preg_match("/^[\w-]+$/u", $file_name)) {

						switch ($commandArray['UPFILE_FORMATFILE_TYPE']) {
							case 1 :
								$newFileName = date('YmdHis') . rand(100, 999);
								break;
							case 2:
								$newFileName = md5(uniqid(rand() . microtime()));
								break;
							case 3:
								$newFileName = $file_name;
								break;
							case 4:

								$newFileName = $save_filename ? $save_filename : md5(uniqid(rand() . microtime()));
								break;
						}
					} else {
						$newFileName = md5(uniqid(rand() . microtime()));
					}


					$upLoadFileName = $savePath . $newFileName . '.' . $file_extension;

					if (!$out = @fopen($upLoadFileName, "wb")) {
						$error_Array['fileErrar'] = 9;
						$error_Array['filename'] = $upLoadFileName;
						$error_Array['returnVal'] = 0;
						$error_Array['state'] = 'FAILURE';
						return $error_Array;
					}

					if (flock($out, LOCK_EX)) {
						for ($index = 0; $index < $chunks; $index++) {
							$tempfile = $fileTempPath . $newTempFileName . '_' . $index . '.part';
							if (!$in = @fopen($tempfile, "rb")) {
								break;
							}
							while ($buff = fread($in, 4096)) {
								fwrite($out, $buff);
							}
							@fclose($in);
							@unlink($tempfile);
						}
						flock($out, LOCK_UN);
					}
					@fclose($out);
					$isCheck = true;

					if ($upFileType == 'image') {
						$iswidth = self::iswidth($upLoadFileName);
					} else {
						$iswidth = 3;
					}

					$error_Array['filename'] = $fileArray['name'];
					$error_Array['title'] = $fileArray['name'];
					$error_Array['original'] = $newFileName . '.' . $file_extension;
					$error_Array['url'] = ESPCMS_URL_RT . str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);


					$error_Array['upLoadFileName'] = str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);
					$error_Array['upLoadFileName_nopath'] = $newFileName . '.' . $file_extension;

					$error_Array['size'] = filesize($upLoadFileName);
				}

				$error_Array['upfiletype'] = $upFileType;

				$error_Array['type'] = $fileArray['type'];

				$error_Array['path'] = str_replace(ESPCMS_FILE_ROOT, '', $savePath);

				$error_Array['iswidth'] = $iswidth;

				$error_Array['extension'] = $file_extension;
				$error_Array['returnVal'] = 1;
				$error_Array['state'] = 'SUCCESS';

				$error_Array['file_screen'] = self::file_type_screen($file_extension);
				return $error_Array;
			}
		} elseif ($base64) {


			switch ($commandArray['UPFILE_FORMATFILE_TYPE']) {
				case 1 :
					$newFileName = date('YmdHis') . rand(100, 999);
					break;
				case 2:
					$newFileName = md5(uniqid(rand() . microtime()));
					break;
				case 3:
					$newFileName = md5(uniqid(rand() . microtime()));
					break;
				case 4:

					$newFileName = $save_filename ? $save_filename : md5(uniqid(rand() . microtime()));
					break;
			}

			$upLoadFileName = $savePath . $newFileName . '.png';

			$isFileCreat = file_put_contents($upLoadFileName, $fileArray);

			if (!$isFileCreat) {
				$error_Array['fileErrar'] = 9;
				$error_Array['filename'] = $upLoadFileName;
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}

			if ($upFileType == 'image') {
				$iswidth = self::iswidth($upLoadFileName);
			} else {
				$iswidth = 3;
			}

			$error_Array['filename'] = $newFileName . '.png';
			$error_Array['title'] = $newFileName . '.png';
			$error_Array['original'] = $newFileName . '.png';
			$error_Array['url'] = ESPCMS_URL_RT . str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);


			$error_Array['upLoadFileName'] = str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);
			$error_Array['upLoadFileName_nopath'] = $newFileName . '.png';

			$error_Array['upfiletype'] = $upFileType;

			$error_Array['type'] = 'image/png';

			$error_Array['path'] = str_replace(ESPCMS_FILE_ROOT, '', $savePath);

			$error_Array['iswidth'] = $iswidth;

			$error_Array['extension'] = 'png';

			$error_Array['size'] = $fileSize;
			$error_Array['returnVal'] = 1;
			$error_Array['state'] = 'SUCCESS';

			$error_Array['file_screen'] = self::file_type_screen($error_Array['extension']);
			return $error_Array;
		} else {


			if ($fileArray['error'] > 0) {







				$error_Array['fileErrar'] = $fileArray['error'];
				$error_Array['filename'] = $fileArray['name'];
				$error_Array['returnVal'] = 0;
				$error_Array['state'] = 'FAILURE';
				return $error_Array;
			}

			if ($fileArray['tmp_name'] && $fileArray['name']) {

				$file_extension = self::extendname($fileArray['name']);

				$file_name = self::extendname($fileArray['name'], 2);

				if (empty($file_extension)) {
					$file_extension = self::fileType($fileArray['tmp_name'], $fileArray['type']);
				}

				if (empty($file_extension)) {
					$error_Array['fileErrar'] = 7;
					$error_Array['filename'] = $fileArray['name'];
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				if (!self::typecheck($allowFileType, $file_extension)) {
					$error_Array['fileErrar'] = 8;
					$error_Array['file_extension'] = $file_extension;
					$error_Array['allowFileType'] = $allowFileType;
					$error_Array['filename'] = $fileArray['name'];
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				if (preg_match("/^[\w-]+$/u", $file_name)) {

					switch ($commandArray['UPFILE_FORMATFILE_TYPE']) {
						case 1 :
							$newFileName = date('YmdHis') . rand(100, 999);
							break;
						case 2:
							$newFileName = md5(uniqid(rand() . microtime()));
							break;
						case 3:
							$newFileName = $file_name;
							break;
						case 4:

							$newFileName = $save_filename ? $save_filename : md5(uniqid(rand() . microtime()));
							break;
					}
				} else {
					$newFileName = md5(uniqid(rand() . microtime()));
				}

				$upLoadFileName = $savePath . $newFileName . '.' . $file_extension;

				if ($isWater && $upFileType == 'image' && $commandArray['UPFILE_ISWATERMARK']) {
					$isFileCreat = self::waterImg($fileArray['tmp_name'], $upLoadFileName, $isWater, $commandArray);

					if (!$isFileCreat) {
						$isFileCreat = @move_uploaded_file($fileArray['tmp_name'], $upLoadFileName);
					}
				} else {
					$isFileCreat = @move_uploaded_file($fileArray['tmp_name'], $upLoadFileName);
				}

				if (!$isFileCreat) {
					$error_Array['fileErrar'] = 9;
					$error_Array['filename'] = $upLoadFileName;
					$error_Array['returnVal'] = 0;
					$error_Array['state'] = 'FAILURE';
					return $error_Array;
				}

				if ($upFileType == 'image') {
					$iswidth = self::iswidth($upLoadFileName);
				} else {
					$iswidth = 3;
				}

				if ($isZoom && $upFileType == 'image' && $commandArray['UPFILE_PIC_ISZOOM']) {

					$zoomFileName = $savePath . $newFileName . '_small.' . $file_extension;

					$isZoomCreat = self::zoomImg($upLoadFileName, $zoomFileName, $commandArray);

					if (!$isZoomCreat) {
						$error_Array['fileErrar'] = 10;
						$error_Array['filename'] = $zoomFileName;
						$error_Array['returnVal'] = 0;
						$error_Array['state'] = 'FAILURE';
						return $error_Array;
					} else {
						$zoomFileSize = filesize($zoomFileName);
					}
				}

				$error_Array['filename'] = $fileArray['name'];
				$error_Array['title'] = $fileArray['name'];
				$error_Array['original'] = $newFileName . '.' . $file_extension;
				$error_Array['url'] = ESPCMS_URL_RT . str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);



				$error_Array['upLoadFileName'] = str_replace(ESPCMS_FILE_ROOT, '', $upLoadFileName);


				$error_Array['upLoadFileName_nopath'] = $newFileName . '.' . $file_extension;
				if ($isZoom && $upFileType == 'image' && $commandArray['UPFILE_PIC_ISZOOM']) {

					$error_Array['zoomFileName'] = ESPCMS_URL_RT . str_replace(ESPCMS_FILE_ROOT, '', $zoomFileName);
					$error_Array['zoomFileName_nopath'] = $newFileName . '_small.' . $file_extension;
					$error_Array['zoomFileSize'] = $zoomFileSize;
				}

				$error_Array['upfiletype'] = $upFileType;

				$error_Array['type'] = $fileArray['type'];

				$error_Array['path'] = str_replace(ESPCMS_FILE_ROOT, '', $savePath);

				$error_Array['iswidth'] = $iswidth;

				$error_Array['extension'] = $file_extension;

				$error_Array['size'] = filesize($upLoadFileName);
				$error_Array['returnVal'] = 1;
				$error_Array['state'] = 'SUCCESS';

				$error_Array['file_screen'] = self::file_type_screen($file_extension);
				return $error_Array;
			}
		}
	}

	private static function iswidth($srcFile) {

		$data = @GetImageSize($srcFile, $info);
		if (!$data) {
			return 3;
		}

		$srcW = $data[0];

		$srcH = $data[1];
		if ($srcW > $srcH) {
			return 1;
		} else {
			return 2;
		}
	}

	private static function waterImg($srcFile, $toImagesFile, $isWater, $commandArray) {
		if (!espcms_ismatches($commandArray['UPFILE_WATERMARK_TYPE']) || !$isWater || !$srcFile) {
			return false;
		}

		$imgQuality = intval($commandArray['UPFILE_PIC_CREATE_QUALITY']);
		switch ($commandArray['UPFILE_WATERMARK_TYPE']) {

			case 1:

				$img_wmt_text = $commandArray['UPFILE_WATERMARK_FONT'];

				$img_wmt_size = ceil($commandArray['UPFILE_WATERMARK_FONT_SIZE']);
				$img_wmt_size = empty($img_wmt_size) ? 15 : $img_wmt_size;

				$img_wmt_color = $commandArray['UPFILE_WATERMARK_FONT_COLOR'];

				$img_pos = $commandArray['UPFILE_WATERMARK_POSITION'];

				$img_transparent = $commandArray['UPFILE_WATERMARK_TRANSPARENCY'];

				$img_wmt_font = ESPCMS_FILE_ROOT . '/espcms_public/font/msyh.ttf';
				break;

			case 0:

				$img_wmi_file = ESPCMS_FILE_ROOT . $commandArray['UPFILE_WATERMARK_PIC_FILENAME'];

				$img_pos = $commandArray['UPFILE_WATERMARK_POSITION'];

				$img_transparent = $commandArray['UPFILE_WATERMARK_TRANSPARENCY'];
				break;
		}
		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 0 && !is_file($img_wmi_file)) {
			return false;
		}
		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 0) {

			$watermake_data = GetImageSize($img_wmi_file);
		}

		$data = GetImageSize($srcFile);
		switch ($data[2]) {
			case 1:
				$im = ImageCreateFromGIF($srcFile);
				break;
			case 2:
				$im = ImageCreateFromJPEG($srcFile);
				break;
			case 3:
				$im = ImageCreateFromPNG($srcFile);
				break;
		}
		if (!$im) {
			return false;
		}

		$srcW = $data[0];

		$srcH = $data[1];

		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 0 && file_exists($img_wmi_file)) {
			$water_info = getimagesize($img_wmi_file);

			$water_w = $water_info[0];

			$water_h = $water_info[1];

			switch ($water_info[2]) {
				case 1:
					$water_im = ImageCreateFromGIF($img_wmi_file);
					break;
				case 2:
					$water_im = ImageCreateFromJPEG($img_wmi_file);
					break;
				case 3:
					$water_im = ImageCreateFromPNG($img_wmi_file);
					break;
			}
			if (!$water_im) {
				return false;
			}
			$w = $water_w;
			$h = $water_h;
		}

		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 1 && !empty($img_wmt_text)) {
			$wttemp = imagettfbbox($img_wmt_size, 0, $img_wmt_font, $img_wmt_text);

			$w = max($wttemp[2], $wttemp[4]) - min($wttemp[0], $wttemp[6]);
			$h = max($wttemp[1], $wttemp[3]) - min($wttemp[5], $wttemp[7]);
			$ax = min($wttemp[0], $wttemp[6]) * -1;
			$ay = min($wttemp[5], $wttemp[7]) * -1;
			unset($wttemp);
		}

		if (($srcW < $w) || ($srcH < $h)) {
			return false;
		}
		switch ($img_pos) {
			case 1:

				$posX = 10;
				$posY = 10;
				break;
			case 2:

				$posX = ($srcW - $w) / 2;
				$posY = 10;
				break;
			case 3:

				$posX = $srcW - $w - 10;
				$posY = 10;
				break;
			case 4:

				$posX = 10;
				$posY = ($srcH - $h) / 2;
				break;
			case 5:

				$posX = ($srcW - $w) / 2;
				$posY = ($srcH - $h) / 2;
				break;
			case 6:

				$posX = $srcW - $w - 10;
				$posY = ($srcH - $h) / 2;
				break;
			case 7:

				$posX = 10;
				$posY = $srcH - $h - 10;
				break;
			case 8:

				$posX = ($srcW - $w) / 2;
				$posY = $srcH - $h - 10;
				break;
			case 9:

				$posX = $srcW - $w - 10;
				$posY = $srcH - $h - 10;
				break;
			default :

				$posX = rand(0, ($srcW - $w));
				$posY = rand(0, ($srcH - $h));
				break;
		}

		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 0) {
			imagealphablending($im, true);

			if ($watermake_data[2] == 3) {
				imagecopy($im, $water_im, $posX, $posY, 0, 0, $water_w, $water_h);
			} else {
				imagecopymerge($im, $water_im, $posX, $posY, 0, 0, $water_w, $water_h, $img_transparent);
			}
		}

		if ($commandArray['UPFILE_WATERMARK_TYPE'] == 1) {
			if (!empty($img_wmt_color) && (strlen($img_wmt_color) == 7)) {
				$R = hexdec(substr($img_wmt_color, 1, 2));
				$G = hexdec(substr($img_wmt_color, 3, 2));
				$B = hexdec(substr($img_wmt_color, 5));
			} else {
				$R = 235;
				$G = 15;
				$B = 15;
			}

			imagettftext($im, $img_wmt_size, 0, $posX + $ax, $posY + $ay, imagecolorallocate($im, $R, $G, $B), $img_wmt_font, $img_wmt_text);
		}

		switch ($data[2]) {
			case 1:

				imagegif($im, $toImagesFile);
				break;
			case 2:

				imagejpeg($im, $toImagesFile, $imgQuality);
				break;
			case 3:

				imagepng($im, $toImagesFile);
				break;
		}

		ImageDestroy($im);
		if (isset($water_im)) {
			imagedestroy($water_im);
		}
		return true;
	}

	public static function zoomImg($srcFile, $toImagesFile, $commandArray) {
		if (!is_file($srcFile)) {
			return false;
		}

		$imgQuality = intval($commandArray['UPFILE_PIC_CREATE_QUALITY']);

		$dstW = $commandArray['UPFILE_PIC_ZOOM_WIDTH'];

		$dstH = $commandArray['UPFILE_PIC_ZOOM_HIGHT'];

		$data = GetImageSize($srcFile, $info);
		switch ($data[2]) {
			case 1:
				$im = ImageCreateFromGIF($srcFile);
				break;
			case 2:
				$im = ImageCreateFromJPEG($srcFile);
				break;
			case 3:
				$im = ImageCreateFromPNG($srcFile);
				break;
		}

		if (!$im) {
			return false;
		}

		$srcW = $data[0];

		$srcH = $data[1];


		$dstWH = $dstW / $dstH;

		$srcWH = $srcW / $srcH;

		if ($dstWH <= $srcWH) {
			$ftoW = $dstW;
			$ftoH = $ftoW * ($srcH / $srcW);
		} else {
			$ftoH = $dstH;
			$ftoW = $ftoH * ($srcW / $srcH);
		}

		if ($srcW > $dstW || $srcH > $dstH) {

			if (function_exists('imagecreatetruecolor')) {

				if ($commandArray['UPFILE_PIC_ZOOMTYPE'] == 1) {

					$ni = ImageCreateTrueColor($ftoW, $ftoH);
					if ($ni) {
						ImageCopyResampled($ni, $im, 0, 0, 0, 0, $ftoW, $ftoH, $srcW, $srcH);
					} else {
						$ni = ImageCreate($ftoW, $ftoH);
						ImageCopyResized($ni, $im, 0, 0, 0, 0, $ftoW, $ftoH, $srcW, $srcH);
					}
				} elseif ($commandArray['UPFILE_PIC_ZOOMTYPE'] == 2) {

					$ni = ImageCreateTrueColor($dstW, $dstH);
					if ($dstWH < $srcWH) {
						$cH = $dstH;
						$cW = round($dstH * ($srcW / $srcH), 0);
						$cwX = (($cW / 2) - ($dstW / 2)) * ($srcH / $dstH);
						$chY = 0;
					} else {
						$cW = $dstW;
						$cH = round($dstW * ($srcH / $srcW));
						$cwX = 0;
						$chY = (($cH / 2) - ($dstH / 2)) * ($srcW / $dstW);
					}
					if ($ni) {
						ImageCopyResampled($ni, $im, 0, 0, $cwX, $chY, $cW, $cH, $srcW, $srcH);
					} else {
						$ni = ImageCreate($dstW, $dstH);
						ImageCopyResized($ni, $im, 0, 0, $cwX, $chY, $cW, $cH, $srcW, $srcH);
					}
				} elseif ($commandArray['UPFILE_PIC_ZOOMTYPE'] == 3) {

					$ni = ImageCreateTrueColor($dstW, $dstH);
					if ($dstWH < $srcWH) {
						$cH = $dstH;
						$cW = round($dstH * ($srcW / $srcH), 0);
					} else {
						$cW = $dstW;
						$cH = round($dstW * ($srcH / $srcW));
					}
					if ($ni) {
						ImageCopyResampled($ni, $im, 0, 0, 0, 0, $cW, $cH, $srcW, $srcH);
					} else {
						$ni = ImageCreate($dstW, $dstH);
						ImageCopyResized($ni, $im, 0, 0, 0, 0, $cW, $cH, $srcW, $srcH);
					}
				}
			} else {
				$ni = ImageCreate($ftoW, $ftoH);

				ImageCopyResized($ni, $im, 0, 0, 0, 0, $ftoW, $ftoH, $srcW, $srcH);
			}
			switch ($data[2]) {
				case 1:

					imagegif($ni, $toImagesFile);
					break;
				case 2:

					imagejpeg($ni, $toImagesFile, $imgQuality);
					break;
				case 3:

					imagepng($ni, $toImagesFile);
					break;
			}

			$upresultid = true;
			ImageDestroy($ni);
		} else {

			$upresultid = false;
		}

		ImageDestroy($im);
		return $upresultid;
	}

	private static function extendname($filename, $retype = 1) {
		if (empty($filename)) {
			return false;
		}

		$filename = strtolower(trim($filename));
		$pt = strrpos($filename, '.');
		if ($retype == 1) {
			if ($pt) {
				$retval = strtolower(substr($filename, $pt + 1, strlen($filename) - $pt));
			}
		} elseif ($retype == 2) {
			$retval = strtolower(substr($filename, 0, $pt));
		}
		return $retval;
	}

	private static function fileType($filetmpname, $filetype) {

		$file = fopen($filetmpname, 'rb');

		$bin = fread($file, 2);
		fclose($file);

		$strInfo = @unpack('c2chars', $bin);

		$typeCode = intval($strInfo['chars1'] . $strInfo['chars2']);
		switch ($typeCode) {
			case 7790:
				$filetype = 'exe';
				break;
			case 7784:
				$filetype = 'midi';
				break;
			case 8297:
				$filetype = 'rar';
				break;
			case 8075:
				$filetype = 'zip';
				break;
			case 4838:
				$filetype = 'wma';
				break;
			case 7173:
				$filetype = 'gif';
				break;
			case 3780:
				$filetype = 'pdf';
				break;
			case 58116:
				$filetype = 'bat';
				break;
			case 4951:
				$filetype = 'txt';
				break;
			case 7384:
				$filetype = 'chm';
				break;
			case 6787:
				$filetype = 'swf';
				break;
			default:
		}

		switch ($filetype) {
			case 'image/pjpeg':
				$filetype = 'jpg';
				break;
			case 'image/jpeg':
				$filetype = 'jpg';
				break;
			case 'image/x-png':
				$filetype = 'png';
				break;
			case 'image/png':
				$filetype = 'png';
				break;
			case 'image/gif':
				$filetype = 'gif';
				break;
			case 'image/jpg':
				$filetype = 'jpg';
				break;
			case 'audio/mpeg':
				$filetype = 'mp3';
				break;
			case 'application/vnd.ms-powerpoint':
				$filetype = 'ppt';
				break;
			case 'application/vnd.ms-excel':
				$filetype = 'xls';
				break;
			case 'application/msword':
				$filetype = 'doc';
				break;
			case 'application/octet-stream':
				$filetype = 'doc';
				break;
			case 'text/plain':
				$filetype = 'txt';
				break;
			default:
		}
		return $filetype;
	}

	private static function typecheck($allowFileType, $file_extension) {
		if (empty($allowFileType) || empty($file_extension)) {
			return false;
		}
		$allow_type_array = explode(',', $allowFileType);
		$newallowType = array();
		foreach ($allow_type_array as $key => $value) {
			$allow_type = strtolower($value);
			if ($allow_type == 'php' || !$allow_type) {
				continue;
			}
			$newallowType[$allow_type] = $allow_type;
		}
		if (array_key_exists($file_extension, $newallowType)) {
			return true;
		} else {
			return false;
		}
	}

	private static function file_type_screen($extension = false) {
		if (!$extension) {
			return false;
		}
		$images_type_array = array('jpg', 'png', 'jpeg', 'gif');
		$mover_type_array = array('mp4', 'avi', 'flv', 'mpge', 'mkv');
		if (in_array($extension, $images_type_array)) {
			$type = 'image';
		} elseif (in_array($extension, $mover_type_array)) {
			$type = 'mover';
		} else {
			$type = 'file';
		}
		return $type;
	}

}
