<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_Authority;

function espcms_file_attachment_save($file_attachment_linkid, $file_attachment_type, $file_attachment_content, $file_attachment_title, $file_attachment_filepath, $file_attachment_ext, $file_attachment_size, $isdel = false) {
	global $espcms_link_db;

	$db_table = ESPCMS_DB_PREFIX . "file_attachment";
	if (empty($file_attachment_linkid) || !espcms_ismatches($file_attachment_linkid)) {
		return false;
	}
	if (empty($file_attachment_type) || !espcms_ismatches($file_attachment_type)) {
		return false;
	}

	if ($isdel) {
		$delSQL = "DELETE FROM $db_table WHERE file_attachment_linkid=$file_attachment_linkid AND file_attachment_type=$file_attachment_type";
		$espcms_link_db->db_query($delSQL);
	}

	$user_id = ESPCMS_Authority::getUserLoginInfo('user_id');
	$user_ip = real_remote_ip();

	$save_id = 0;
	if ($file_attachment_filepath && is_array($file_attachment_filepath) && count($file_attachment_filepath) > 0) {
		$field_array = espcms_field_out($db_table, true);

		foreach ($file_attachment_filepath as $key => $value) {
			$file_postvalue = array();
			$file_postvalue['user_id'] = espcms_ismatches($user_id) ? $user_id : 0;
			$file_postvalue['file_attachment_linkid'] = $file_attachment_linkid;
			$file_postvalue['file_attachment_type'] = $file_attachment_type;
			$file_postvalue['file_attachment_ip'] = $user_ip;
			$file_postvalue['file_attachment_addtime'] = time();
			$file_postvalue['file_attachment_content'] = $file_attachment_content[$key];
			$file_postvalue['file_attachment_title'] = $file_attachment_title[$key];
			$file_postvalue['file_attachment_filepath'] = $file_attachment_filepath[$key];
			$file_postvalue['file_attachment_ext'] = $file_attachment_ext[$key];
			$file_postvalue['file_attachment_size'] = espcms_ismatches($file_attachment_size[$key]) ? $file_attachment_size[$key] : 0;
			$postvalue = espcms_post($file_postvalue, $field_array, true);
			if ($postvalue) {
				espcms_db_install_save($db_table, $postvalue);
				$save_id++;
			}
		}
	}
	return $save_id;
}
