<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


namespace application\phpmailer;

class SMTP {

	var $SMTP_PORT = 25;
	var $CRLF = "\r\n";
	var $do_debug;       # the level of debug to perform
	var $do_verp = false;
	var $smtp_conn;      # the socket to the server
	var $error;   # error if any on the last call
	var $helo_rply;      # the reply the server sent to us for HELO

	function SMTP() {
		$this->smtp_conn = 0;
		$this->error = null;
		$this->helo_rply = null;
		$this->do_debug = 0;
	}

	function Connect($host, $port = 0, $tval = 30) {
		# set the error val to null so there is no confusion
		$this->error = null;
		# make sure we are __not__ connected
		if ($this->connected()) {
			# ok we are connected! what should we do?
			# for now we will just give an error saying we
			# are already connected
			$this->error = array("error" => "Already connected to a server");
			return false;
		}
		if (empty($port)) {
			$port = $this->SMTP_PORT;
		}
		if (function_exists('fsockopen')) {
			#connect to the smtp server
			$this->smtp_conn = fsockopen($host, # the host of the server
				$port, # the port to use
				$errno, # error number if any
				$errstr, # error message if any
				$tval);   # give up after ? secs
		} elseif (function_exists('pfsockopen')) {
			#connect to the smtp server
			$this->smtp_conn = pfsockopen($host, # the host of the server
				$port, # the port to use
				$errno, # error number if any
				$errstr, # error message if any
				$tval);   # give up after ? secs
		} elseif (function_exists('stream_socket_client')) {
			#connect to the smtp server
			$this->smtp_conn = stream_socket_client($host . ':' . $port, $errno, $errstr, $tval);
		}
		# verify we connected properly
		if (empty($this->smtp_conn)) {
			$this->error = array("error" => "Failed to connect to server",
			    "errno" => $errno,
			    "errstr" => $errstr);
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": $errstr ($errno)" . $this->CRLF;
			}
			return false;
		}
		# sometimes the SMTP server takes a little longer to respond
		# so we will give it a longer timeout for the first read
		if (substr(PHP_OS, 0, 3) != "WIN")
			socket_set_timeout($this->smtp_conn, $tval, 0);
		# get any announcement stuff
		$announce = $this->get_lines();
		# set the timeout  of any socket functions at 1/10 of a second
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $announce;
		}
		return true;
	}

	function Authenticate($username, $password) {
		fputs($this->smtp_conn, "AUTH LOGIN" . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($code != 334) {
			$this->error = array("error" => "AUTH not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		fputs($this->smtp_conn, base64_encode($username) . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($code != 334) {
			$this->error = array("error" => "Username not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		fputs($this->smtp_conn, base64_encode($password) . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($code != 235) {
			$this->error = array("error" => "Password not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Connected() {
		if (!empty($this->smtp_conn)) {
			$sock_status = socket_get_status($this->smtp_conn);
			if ($sock_status["eof"]) {
				# hmm this is an odd situation... the socket is
				# valid but we are not connected anymore
				if ($this->do_debug >= 1) {
					echo "SMTP -> NOTICE:" . $this->CRLF .
					"EOF caught while checking if connected";
				}
				$this->Close();
				return false;
			}
			return true; # everything looks good
		}
		return false;
	}

	function Close() {
		$this->error = null; # so there is no confusion
		$this->helo_rply = null;
		if (!empty($this->smtp_conn)) {
			# close the connection and cleanup
			fclose($this->smtp_conn);
			$this->smtp_conn = 0;
		}
	}

	function Data($msg_data) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Data() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "DATA" . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 354) {
			$this->error = array("error" => "DATA command not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		# the server is ready to accept data!
		# according to rfc 821 we should not send more than 1000
		# including the CRLF
		# characters on a single line so we will break the data up
		# into lines by \r and/or \n then if needed we will break
		# each of those into smaller lines to fit within the limit.
		# in addition we will be looking for lines that start with
		# a period '.' and append and additional period '.' to that
		# line. NOTE: this does not count towards are limit.
		# normalize the line breaks so we know the explode works
		$msg_data = str_replace("\r\n", "\n", $msg_data);
		$msg_data = str_replace("\r", "\n", $msg_data);
		$lines = explode("\n", $msg_data);
		# we need to find a good way to determine is headers are
		# in the msg_data or if it is a straight msg body
		# currently I am assuming rfc 822 definitions of msg headers
		# and if the first field of the first line (':' sperated)
		# does not contain a space then it _should_ be a header
		# and we can process all lines before a blank "" line as
		# headers.
		$field = substr($lines[0], 0, strpos($lines[0], ":"));
		$in_headers = false;
		if (!empty($field) && !strstr($field, " ")) {
			$in_headers = true;
		}
		$max_line_length = 998; # used below; set here for ease in change
		while (list(, $line) = @each($lines)) {
			$lines_out = null;
			if ($line == "" && $in_headers) {
				$in_headers = false;
			}
			# ok we need to break this line up into several
			# smaller lines
			while (strlen($line) > $max_line_length) {
				$pos = strrpos(substr($line, 0, $max_line_length), " ");
				# Patch to fix DOS attack
				if (!$pos) {
					$pos = $max_line_length - 1;
				}
				$lines_out[] = substr($line, 0, $pos);
				$line = substr($line, $pos + 1);
				# if we are processing headers we need to
				# add a LWSP-char to the front of the new line
				# rfc 822 on long msg headers
				if ($in_headers) {
					$line = "\t" . $line;
				}
			}
			$lines_out[] = $line;
			# now send the lines to the server
			while (list(, $line_out) = @each($lines_out)) {
				if (strlen($line_out) > 0) {
					if (substr($line_out, 0, 1) == ".") {
						$line_out = "." . $line_out;
					}
				}
				fputs($this->smtp_conn, $line_out . $this->CRLF);
			}
		}
		# ok all the message data has been sent so lets get this
		# over with aleady
		fputs($this->smtp_conn, $this->CRLF . "." . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "DATA not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Expand($name) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Expand() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "EXPN " . $name . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "EXPN not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		# parse the reply and place in our array to return to user
		$entries = explode($this->CRLF, $rply);
		while (list(, $l) = @each($entries)) {
			$list[] = substr($l, 4);
		}
		return $list;
	}

	function Hello($host = "") {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Hello() without being connected");
			return false;
		}
		# if a hostname for the HELO was not specified determine
		# a suitable one to send
		if (empty($host)) {
			# we need to determine some sort of appopiate default
			# to send to the server
			$host = "localhost";
		}
		if (!$this->SendHello("EHLO", $host)) {
			if (!$this->SendHello("HELO", $host))
				return false;
		}
		return true;
	}

	function SendHello($hello, $host) {
		fputs($this->smtp_conn, $hello . " " . $host . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER: " . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => $hello . " not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		$this->helo_rply = $rply;
		return true;
	}

	function Help($keyword = "") {
		$this->error = null; # to avoid confusion
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Help() without being connected");
			return false;
		}
		$extra = "";
		if (!empty($keyword)) {
			$extra = " " . $keyword;
		}
		fputs($this->smtp_conn, "HELP" . $extra . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 211 && $code != 214) {
			$this->error = array("error" => "HELP not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return $rply;
	}

	function Mail($from) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Mail() without being connected");
			return false;
		}
		$useVerp = ($this->do_verp ? "XVERP" : "");
		fputs($this->smtp_conn, "MAIL FROM:<" . $from . ">" . $useVerp . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "MAIL not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Noop() {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Noop() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "NOOP" . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "NOOP not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Quit($close_on_error = true) {
		$this->error = null; # so there is no confusion
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Quit() without being connected");
			return false;
		}
		# send the quit command to the server
		fputs($this->smtp_conn, "quit" . $this->CRLF);
		# get any good-bye messages
		$byemsg = $this->get_lines();
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $byemsg;
		}
		$rval = true;
		$e = null;
		$code = substr($byemsg, 0, 3);
		if ($code != 221) {
			# use e as a tmp var cause Close will overwrite $this->error
			$e = array("error" => "SMTP server rejected quit command",
			    "smtp_code" => $code,
			    "smtp_rply" => substr($byemsg, 4));
			$rval = false;
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $e["error"] . ": " .
				$byemsg . $this->CRLF;
			}
		}
		if (empty($e) || $close_on_error) {
			$this->Close();
		}
		return $rval;
	}

	function Recipient($to) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Recipient() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "RCPT TO:<" . $to . ">" . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250 && $code != 251) {
			$this->error = array("error" => "RCPT not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Reset() {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Reset() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "RSET" . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "RSET failed",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Send($from) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called Send() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "SEND FROM:" . $from . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "SEND not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function SendAndMail($from) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called SendAndMail() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "SAML FROM:" . $from . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "SAML not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function SendOrMail($from) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array(
			    "error" => "Called SendOrMail() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "SOML FROM:" . $from . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250) {
			$this->error = array("error" => "SOML not accepted from server",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return true;
	}

	function Turn() {
		$this->error = array("error" => "This method, TURN, of the SMTP " .
		    "is not implemented");
		if ($this->do_debug >= 1) {
			echo "SMTP -> NOTICE: " . $this->error["error"] . $this->CRLF;
		}
		return false;
	}

	function Verify($name) {
		$this->error = null; # so no confusion is caused
		if (!$this->connected()) {
			$this->error = array("error" => "Called Verify() without being connected");
			return false;
		}
		fputs($this->smtp_conn, "VRFY " . $name . $this->CRLF);
		$rply = $this->get_lines();
		$code = substr($rply, 0, 3);
		if ($this->do_debug >= 2) {
			echo "SMTP -> FROM SERVER:" . $this->CRLF . $rply;
		}
		if ($code != 250 && $code != 251) {
			$this->error = array("error" => "VRFY failed on name '$name'",
			    "smtp_code" => $code,
			    "smtp_msg" => substr($rply, 4));
			if ($this->do_debug >= 1) {
				echo "SMTP -> ERROR: " . $this->error["error"] .
				": " . $rply . $this->CRLF;
			}
			return false;
		}
		return $rply;
	}

	function get_lines() {
		$data = "";
		while ($str = @fgets($this->smtp_conn, 515)) {
			if ($this->do_debug >= 4) {
				echo "SMTP -> get_lines(): \$data was \"$data\"" .
				$this->CRLF;
				echo "SMTP -> get_lines(): \$str is \"$str\"" .
				$this->CRLF;
			}
			$data .= $str;
			if ($this->do_debug >= 4) {
				echo "SMTP -> get_lines(): \$data is \"$data\"" . $this->CRLF;
			}
			# if the 4th character is a space then we are done reading
			# so just break the loop
			if (substr($str, 3, 1) == " ") {
				break;
			}
		}
		return $data;
	}

}
