<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ArticleModelDB;
use modul_application\KeywordsOptimizationDB;
use modul_application\ESPCMS_MemberAuthority;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;
use inc_application\link\MemberLink;

class Article {

    public static function in_List() {
        global $espcms_web_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'document';
        $tid = $_GET['tid'];
        if (!$tid || !espcms_ismatches($tid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }

        $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $type_read['link'] = ArticleLink::type_link($type_read);
        $type_read['purview_link'] = ArticleLink::doc_js_link('typepuv', $type_read);
        if ($type_read['styleid'] == 3) {

            if ($type_read['isline'] && espcms_isurl($type_read['typeurl'])) {
                $link = $type_read['typeurl'];
            }
            if (!$type_read['isline'] && espcms_ismatches($type_read['gotoline']) && $type_read['gotoline']) {
                $doc_read = ESPCMS_ArticleDB::get_article_read($type_read['gotoline']);
                $link = ArticleLink::doc_link($doc_read);
            }
            header("location:$link");
            exit();
        }

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($type_read['purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($type_read['purview']);
        }

        if (!$type_read['mid'] || !espcms_ismatches($type_read['mid'])) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $model_read = ESPCMS_ArticleModelDB::get_mid_view($type_read['mid']);

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;

        if ($type_read['pagemax'] && espcms_ismatches($type_read['pagemax'])) {
            $per_page_num = $type_read['pagemax'];
        } elseif ($model_read['pagemax'] && espcms_ismatches($model_read['pagemax'])) {
            $per_page_num = $model_read['pagemax'];
        } else {
            $per_page_num = 20;
        }

        $template_index = $type_read['indextemplates'] ? $type_read['indextemplates'] : $model_read['index_templates'];
        if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
            $template_list = $type_read['waptempalte'] ? $type_read['waptempalte'] : $model_read['list_templates'];
            $template_read = $type_read['wapreadtemplate'] ? $type_read['wapreadtemplate'] : $model_read['read_templates'];

            $type_read['styleid'] = $type_read['styleid'] == 1 ? 2 : $type_read['styleid'];
        } else {
            $template_list = $type_read['template'] ? $type_read['template'] : $model_read['list_templates'];
            $template_read = $type_read['readtemplate'] ? $type_read['readtemplate'] : $model_read['read_templates'];
        }

        $lanpack = $espcms_web_templates->geto('lngpack');
        if ($type_read['styleid'] != 4) {
            $str_replace_keyArray = array('{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
            $lanpack['sitename'] = $type_read['headtitle'] ? $type_read['headtitle'] : format_array_replace_string($model_read['listtitlestyle'], $str_replace_keyArray);
            if ($type_read['keywords']) {
                $lanpack['keyword'] = $type_read['keywords'];
            }
            if ($type_read['description']) {
                $lanpack['description'] = $type_read['description'];
            }
        }
        $current = !$type_read['upid'] ? $type_read['tid'] : $type_read['topid'];
        $espcms_web_templates->into('current', $current);
        $espcms_web_templates->into('hover_id', $type_read['tid']);
        $espcms_web_templates->into('type', $type_read);
        $espcms_web_templates->into('path', 'type');

        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
        if ($type_read['styleid'] == 1) {
            $espcms_web_templates->into('lngpack', $lanpack);

            $espcms_web_templates->output('article/' . $template_index, 'article_index', false, false);
        } elseif ($type_read['styleid'] == 2) {
            $lng = espcms_lancode();

            $db_where = " AND isclass=1 AND isbase=0";
            if ($type_read['ispart']) {
                $tid_array = ESPCMS_ArticleTypeDB::get_article_type_listDB($tid, $lng);
                $tid_list = implode(',', array_keys($tid_array));
                $db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
            } else {
                $db_where .= " AND tid=$tid";
            }
            $db_where .= " OR FIND_IN_SET('$tid',extid)";

            $db_num = espcms_db_num($db_table, $db_where);

            $order_rank = $type_read['isorderby'] ? 'DESC' : 'ASC';

            $order_key = $type_read['ordertype'] == 2 ? 'pid,addtime' : 'pid,did';

            $db_sql = espcms_db_list_out($db_table, $db_where);

            $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $model_read['pagesylte'], $lanpack['pagebotton'], 'inc_application\link\ArticleLink', 'type_link', $type_read);

            $sql = $espcms_page_button->sql_creat($order_key, $order_rank);
            $db_query = $espcms_link_db->db_query($sql);
            $array = array();
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $fetch_row['ctitle'] = empty($fetch_row['color']) ? $fetch_row['title'] : "<font color='" . $fetch_row['color'] . "'>" . $fetch_row['title'] . "</font>";
                $fetch_row['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
                $fetch_row['typename'] = $type_read['typename'];
                $fetch_row['typelink'] = ArticleLink::type_link($type_read);
                $fetch_row['link'] = ArticleLink::doc_link($fetch_row);
                if ($order_app_config['isetup'] && $order_app_config['isopen']) {
                    $fetch_row['buylink'] = OrderLink::get_order_link('buy', $fetch_row);
                }
                if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
                    $fetch_row['enqlink'] = EnquiryLink::get_enquiry_link('into', $fetch_row);
                }
                $attr_read = ESPCMS_ArticleDB::get_article_attr_read($fetch_row['did']);
                $array[] = is_array($attr_read) ? array_merge($fetch_row, $attr_read) : $fetch_row;
            }
            $espcms_web_templates->into('lngpack', $lanpack);
            $espcms_web_templates->into('array', $array);
            $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
            $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
            $espcms_web_templates->output('article/' . $template_list, 'article_list', false, false);
        } elseif ($type_read['styleid'] == 4) {

            if ($type_read['gotoid'] && espcms_ismatches($type_read['gotoid'])) {

                $gotype_read = ESPCMS_ArticleTypeDB::get_article_type_view($type_read['gotoid']);
                if (!$gotype_read || !$gotype_read['isclass']) {
                    ESPCMS_Dialog::Message_Page('type_read_err');
                }
                $linkid = $gotype_read['linkid'];
            } else {
                $linkid = $type_read['linkid'];
            }
            if (!$linkid || !espcms_ismatches($linkid)) {
                ESPCMS_Dialog::Message_Page('db_err');
            }
            $doc_read = ESPCMS_ArticleDB::get_article_read($linkid);
            if (!$doc_read) {
                ESPCMS_Dialog::Message_Page('doc_read_err');
            }
            $doc_read['click_link'] = ArticleLink::doc_js_link('click', $doc_read);
            $doc_read['purview_link'] = ArticleLink::doc_js_link('readpuv', $doc_read);

            if (!empty($doc_read['linkdid'])) {
                $doc_read['linkdid'] = str_replace(',', '/', $doc_read['linkdid']);
            }
            if ($order_app_config['isetup'] && $order_app_config['isopen']) {
                $doc_read['buylink'] = OrderLink::get_order_link('buy', $doc_read);
            }
            if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
                $doc_read['enqlink'] = EnquiryLink::get_enquiry_link('into', $doc_read);
            }
            $doc_read['ctitle'] = empty($doc_read['color']) ? $doc_read['title'] : "<font color='" . $doc_read['color'] . "'>" . $doc_read['title'] . "</font>";
            $doc_read['link'] = ArticleLink::doc_link($doc_read);

            $doc_content = ESPCMS_ArticleDB::get_article_content_read($linkid, 'content');

            $page = $_GET['page'] && espcms_ismatches($_GET['page']) ? $_GET['page'] : 1;
            if ($doc_content) {
                $doc_read['content'] = htmlspecialchars_decode($doc_content);
                $exCotnet = explode('<hr class="espcms_pagebreak"/>', $doc_read['content']);
                $filepage = count($exCotnet);
                $page = $page > $filepage ? 1 : $page;

                $pageArray = array();
                if ($filepage > 1) {

                    $nkey = $page + 1;

                    $pkey = $page > 1 ? $page - 1 : 1;

                    $doc_read['page_key'] = $nkey;
                    $doc_read['nlink'] = $nkey <= $filepage ? ArticleLink::doc_link($doc_read) : null;

                    $doc_read['page_key'] = $pkey;
                    $doc_read['plink'] = $page > 1 ? ArticleLink::doc_link($doc_read) : null;

                    for ($index = 0; $index < $filepage; $index++) {
                        $num = $index + 1;
                        $pageArray[$index]['num'] = $num;
                        $pageArray[$index]['n'] = $num == $page ? 1 : 0;
                        $doc_read['page_key'] = $num;
                        $pageArray[$index]['link'] = ArticleLink::doc_link($doc_read);
                    }
                    $outkey = $page - 1;
                    $doc_read['content'] = $exCotnet[$outkey];
                }
                $espcms_web_templates->into('page', $pageArray);
            }

            $attr_read = ESPCMS_ArticleDB::get_article_attr_read($linkid);
            $read = is_array($attr_read) ? array_merge($doc_read, $attr_read) : $doc_read;
            $str_replace_keyArray = array('{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
            $lanpack['sitename'] = $doc_read['headtitle'] ? $doc_read['headtitle'] : format_array_replace_string($model_read['listtitlestyle'], $str_replace_keyArray);
            if ($doc_read['keywords']) {
                $lanpack['keyword'] = $doc_read['keywords'];
            }
            if ($doc_read['description']) {
                $lanpack['description'] = $doc_read['description'];
            }
            $espcms_web_templates->into('lngpack', $lanpack);
            $espcms_web_templates->into('read', $read);

            $tag = KeywordsOptimizationDB::get_key_link($doc_read['keywords']);
            $espcms_web_templates->into('tag', $tag);

            $photo_read = ESPCMS_ArticleDB::get_document_album_list($linkid);
            $espcms_web_templates->into('photo', $photo_read);

            ESPCMS_ArticleDB::update_article_click($linkid);
            if ($doc_read['template'] && $doc_read['istemplates']) {
                $template_read = $doc_read['template'];
            }
            $espcms_web_templates->output('article/' . $template_read, 'article_read', false, false);
        }
    }

    public static function in_SubList() {
        global $espcms_web_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'document';
        $sid = $_GET['sid'];
        if (!$sid || !espcms_ismatches($sid)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }

        $sub_read = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($sid);
        if (!$sub_read || !$sub_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $sub_read['purview_link'] = ArticleLink::doc_js_link('subpuv', $sub_read);
        $sub_read['link'] = ArticleLink::subtype_link($sub_read);

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if ($sub_read['purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($sub_read['purview']);
        }

        if (!$sub_read['mid'] || !espcms_ismatches($sub_read['mid'])) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $model_read = ESPCMS_ArticleModelDB::get_mid_view($sub_read['mid']);

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;

        if ($sub_read['pagemax'] && espcms_ismatches($sub_read['pagemax'])) {
            $per_page_num = $sub_read['pagemax'];
        } elseif ($model_read['pagemax'] && espcms_ismatches($model_read['pagemax'])) {
            $per_page_num = $model_read['pagemax'];
        } else {
            $per_page_num = 20;
        }

        if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
            $template_list = $sub_read['waptempalte'] ? $sub_read['waptempalte'] : $model_read['list_templates'];
        } else {
            $template_list = $sub_read['template'] ? $sub_read['template'] : $model_read['list_templates'];
        }

        $lanpack = $espcms_web_templates->geto('lngpack');
        if ($sub_read['styleid'] != 4) {
            $str_replace_keyArray = array('{typename}' => $sub_read['subjectname'], '{sitename}' => $lanpack['sitename']);
            $lanpack['sitename'] = $sub_read['headtitle'] ? $sub_read['headtitle'] : format_array_replace_string($model_read['listtitlestyle'], $str_replace_keyArray);
            if ($sub_read['keywords']) {
                $lanpack['keyword'] = $sub_read['keywords'];
            }
            if ($sub_read['description']) {
                $lanpack['description'] = $sub_read['description'];
            }
        }
        $espcms_web_templates->into('sub', $sub_read);
        $espcms_web_templates->into('path', 'sub');
        $espcms_web_templates->into('current', $sid);
        $espcms_web_templates->into('hover_id', $sub_read['sid']);

        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);

        $db_where = " AND isclass=1 AND isbase=0 AND sid=$sid";

        $db_num = espcms_db_num($db_table, $db_where);

        $db_sql = espcms_db_list_out($db_table, $db_where);

        $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $model_read['pagesylte'], $lanpack['pagebotton'], 'inc_application\link\ArticleLink', 'subtype_link', $sub_read);

        $sql = $espcms_page_button->sql_creat('pid,did', 'DESC');
        $db_query = $espcms_link_db->db_query($sql);
        $array = array();
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['ctitle'] = empty($fetch_row['color']) ? $fetch_row['title'] : "<font color='" . $fetch_row['color'] . "'>" . $fetch_row['title'] . "</font>";
            $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid']);
            $fetch_row['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
            $fetch_row['typename'] = $type_read['typename'];
            $fetch_row['typelink'] = ArticleLink::type_link($type_read);
            $fetch_row['link'] = ArticleLink::doc_link($fetch_row);
            if ($order_app_config['isetup'] && $order_app_config['isopen']) {
                $fetch_row['buylink'] = OrderLink::get_order_link('buy', $fetch_row);
            }
            if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
                $fetch_row['enqlink'] = EnquiryLink::get_enquiry_link('into', $fetch_row);
            }
            $attr_read = ESPCMS_ArticleDB::get_article_attr_read($fetch_row['did']);
            $array[] = is_array($attr_read) ? array_merge($fetch_row, $attr_read) : $fetch_row;
        }
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
        $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
        $espcms_web_templates->output('article/' . $template_list, 'sub_list', false, false);
    }

    public static function in_Tags() {
        global $espcms_web_templates, $espcms_link_db;
        $db_table = ESPCMS_DB_PREFIX . 'document';
        $key = check_str($_GET['key']);
        if (!$key) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $lng = espcms_lancode();

        $pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;

        $per_page_num = 20;

        $lanpack = $espcms_web_templates->geto('lngpack');
        $lanpack['sitename'] = $key . '-' . $lanpack['sitename'];
        $espcms_web_templates->into('path', 'article');

        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);

        $db_where = " AND isclass=1 AND isbase=0 AND lng='$lng' AND FIND_IN_SET('$key',keywords)";

        $db_num = espcms_db_num($db_table, $db_where);

        $db_sql = espcms_db_list_out($db_table, $db_where);
        $urk_read['keywordname'] = $key;

        $espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, 1, $lanpack['pagebotton'], 'inc_application\link\ArticleLink', 'tags_link', $urk_read);

        $sql = $espcms_page_button->sql_creat('did', 'DESC');
        $db_query = $espcms_link_db->db_query($sql);
        $array = array();
        while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
            $fetch_row['ctitle'] = empty($fetch_row['color']) ? $fetch_row['title'] : "<font color='" . $fetch_row['color'] . "'>" . $fetch_row['title'] . "</font>";
            $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($fetch_row['tid']);
            $fetch_row['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $fetch_row['ishtml'];
            $fetch_row['typename'] = $type_read['typename'];
            $fetch_row['typelink'] = ArticleLink::type_link($type_read);
            $fetch_row['link'] = ArticleLink::doc_link($fetch_row);
            if ($order_app_config['isetup'] && $order_app_config['isopen']) {
                $fetch_row['buylink'] = OrderLink::get_order_link('buy', $fetch_row);
            }
            if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
                $fetch_row['enqlink'] = EnquiryLink::get_enquiry_link('into', $fetch_row);
            }
            $attr_read = ESPCMS_ArticleDB::get_article_attr_read($fetch_row['did']);
            $array[] = is_array($attr_read) ? array_merge($fetch_row, $attr_read) : $fetch_row;
        }
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('array', $array);
        $espcms_web_templates->into('key', $key);
        $espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
        $espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
        $espcms_web_templates->output('article/article_tag', 'article_tag', false, false);
    }

    public static function in_Read() {
        global $espcms_web_templates;
        $did = $_GET['did'];
        if (empty($did) || !espcms_ismatches($did)) {
            ESPCMS_Dialog::Message_Page('db_err');
        }
        $doc_read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$doc_read || !$doc_read['isclass']) {
            ESPCMS_Dialog::Message_Page('doc_read_err');
        }

        if ($doc_read['linkdid']) {
            $doc_read['linkdid'] = str_replace(',', '/', $doc_read['linkdid']);
        }

        if ($doc_read['votelink']) {
            $doc_read['votelink'] = str_replace(',', '/', $doc_read['votelink']);
        }
        $doc_read['click_link'] = ArticleLink::doc_js_link('click', $doc_read);
        $doc_read['link'] = ArticleLink::doc_link($doc_read);

        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);

        if ($doc_read['purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($doc_read['purview']);
        }

        $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($doc_read['tid']);
        if (!$type_read || !$type_read['isclass']) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $type_read['link'] = ArticleLink::type_link($type_read);
        $type_read['purview_link'] = ArticleLink::doc_js_link('readpuv', $doc_read);
        if ($type_read['purview'] && $member_app_config['isetup'] && $member_app_config['isopen']) {
            ESPCMS_MemberAuthority::authorityRandVerify($type_read['purview']);
        }

        if (!$type_read['mid'] || !espcms_ismatches($type_read['mid'])) {
            ESPCMS_Dialog::Message_Page('type_read_err');
        }
        $model_read = ESPCMS_ArticleModelDB::get_mid_view($type_read['mid']);
        if ($order_app_config['isetup'] && $order_app_config['isopen']) {
            $doc_read['buylink'] = OrderLink::get_order_link('buy', $doc_read);
        }
        if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
            $doc_read['enqlink'] = EnquiryLink::get_enquiry_link('into', $doc_read);
        }
        $doc_read['ctitle'] = !$doc_read['color'] ? $doc_read['title'] : "<font color='" . $doc_read['color'] . "'>" . $doc_read['title'] . "</font>";


        $doc_content = ESPCMS_ArticleDB::get_article_content_read($did, 'content');

        $page = $_GET['page'] && espcms_ismatches($_GET['page']) ? $_GET['page'] : 1;
        if ($doc_content) {
            $doc_read['content'] = htmlspecialchars_decode($doc_content);
            $exCotnet = explode('<hr class="espcms_pagebreak"/>', $doc_read['content']);
            $filepage = count($exCotnet);
            $page = $page > $filepage ? 1 : $page;

            $pageArray = array();
            if ($filepage > 1) {

                $nkey = $page + 1;

                $pkey = $page > 1 ? $page - 1 : 1;

                $doc_read['page_key'] = $nkey;
                $doc_read['nlink'] = $nkey <= $filepage ? ArticleLink::doc_link($doc_read) : null;

                $doc_read['page_key'] = $pkey;
                $doc_read['plink'] = $page > 1 ? ArticleLink::doc_link($doc_read) : null;

                for ($index = 0; $index < $filepage; $index++) {
                    $num = $index + 1;
                    $pageArray[$index]['num'] = $num;
                    $pageArray[$index]['n'] = $num == $page ? 1 : 0;
                    $doc_read['page_key'] = $num;
                    $pageArray[$index]['link'] = ArticleLink::doc_link($doc_read);
                }
                $outkey = $page - 1;
                $doc_read['content'] = $exCotnet[$outkey];
            }
            $espcms_web_templates->into('page', $pageArray);
        }

        $attr_read = ESPCMS_ArticleDB::get_article_attr_read($did);
        $read = is_array($attr_read) ? array_merge($doc_read, $attr_read) : $doc_read;
        $lanpack = $espcms_web_templates->geto('lngpack');
        $str_replace_keyArray = array('{title}' => $doc_read['title'], '{typename}' => $type_read['typename'], '{sitename}' => $lanpack['sitename']);
        $lanpack['sitename'] = $doc_read['headtitle'] ? $doc_read['headtitle'] : format_array_replace_string($model_read['readtitlestyle'], $str_replace_keyArray);
        if ($doc_read['keywords']) {
            $lanpack['keyword'] = $doc_read['keywords'];
        }
        if ($doc_read['description']) {
            $lanpack['description'] = $doc_read['description'];
        }
        $espcms_web_templates->into('lngpack', $lanpack);
        $espcms_web_templates->into('read', $read);

        $tag = KeywordsOptimizationDB::get_key_link($doc_read['keywords']);
        $espcms_web_templates->into('tag', $tag);

        $photo_read = ESPCMS_ArticleDB::get_document_album_list($did);
        $espcms_web_templates->into('photo', $photo_read);

        ESPCMS_ArticleDB::update_article_click($did);
        if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
            $template_read = $type_read['wapreadtemplate'] ? $type_read['wapreadtemplate'] : $model_read['read_templates'];
        } else {
            $template_read = $type_read['readtemplate'] ? $type_read['readtemplate'] : $model_read['read_templates'];
        }
        if ($doc_read['template'] && $doc_read['istemplates']) {
            $template_read = $doc_read['template'];
        }
        $current = !$type_read['upid'] ? $type_read['tid'] : $type_read['topid'];
        $espcms_web_templates->into('current', $current);
        $espcms_web_templates->into('hover_id', $type_read['tid']);
        $espcms_web_templates->into('doc_id', $read['did']);
        $espcms_web_templates->into('type', $type_read);
        $espcms_web_templates->into('path', 'article');
        $espcms_web_templates->output('article/' . $template_read, 'article_read', false, false);
    }

    public static function in_GetClick() {
        $did = $_GET['did'];
        if (!$did || !espcms_ismatches($did)) {
            return false;
        }
        $doc_read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$doc_read || !$doc_read['isclass'] || $doc_read['islink']) {
            return false;
        }
        exit('document.write("' . $doc_read['click'] . '")');
    }

    public static function in_Readpuv() {
        global $espcms_command;
        $did = $_GET['did'];
        if (empty($did) || !espcms_ismatches($did)) {
            return false;
        }

        if ($espcms_command['IS_HTML']) {
            return false;
        }
        $doc_read = ESPCMS_ArticleDB::get_article_read($did);
        if (!$doc_read || !$doc_read['isclass'] || $doc_read['islink']) {
            return false;
        }

        if ($doc_read['ishtml'] < 2 && !$espcms_command['IS_HTML']) {
            ESPCMS_ArticleDB::update_article_click($did);
        }
        if ($doc_read['ishtml'] == 2) {
            return false;
        }
        $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($doc_read['tid']);
        if (!$type_read || !$type_read['isclass'] || $type_read['pageclass'] == 2) {
            return false;
        }
        if (!$doc_read['purview'] && !$type_read['purview']) {
            return false;
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
            return false;
        }
        if (!ESPCMS_MemberAuthority::authorityRandVerify($doc_read['purview'], true) && $doc_read['purview']) {
            exit("javascript:location.href='" . MemberLink::get_link('login') . "';");
        }
        if (!ESPCMS_MemberAuthority::authorityRandVerify($type_read['purview'], true) && $type_read['purview']) {
            exit("javascript:location.href='" . MemberLink::get_link('login') . "';");
        }
    }

    public static function in_Typepuv() {
        global $espcms_command;
        $tid = $_GET['tid'];
        if (empty($tid) || !espcms_ismatches($tid)) {
            return false;
        }

        if ($espcms_command['IS_HTML']) {
            return false;
        }
        $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
        if (!$type_read || !$type_read['isclass'] || $type_read['pageclass'] == 2) {
            return false;
        }
        if (!$type_read['purview']) {
            return false;
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
            return false;
        }
        if (!ESPCMS_MemberAuthority::authorityRandVerify($type_read['purview'], true) && $type_read['purview']) {
            exit("javascript:location.href='" . MemberLink::get_link('login') . "';");
        }
    }

    public static function in_Subpuv() {
        global $espcms_command;
        $sid = $_GET['sid'];
        if (empty($sid) || !espcms_ismatches($sid)) {
            return false;
        }

        if ($espcms_command['IS_HTML']) {
            return false;
        }
        $sub_read = ESPCMS_ArticleTypeDB::get_article_subjectlist_view($sid);
        if (!$sub_read || !$sub_read['isclass'] || $sub_read['pageclass'] == 2) {
            return false;
        }
        if (!$sub_read['purview']) {
            return false;
        }
        $member_app_config = ESPCMS_Core::get_app_config('member', false);
        if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
            return false;
        }
        if (!ESPCMS_MemberAuthority::authorityRandVerify($sub_read['purview'], true) && $sub_read['purview']) {
            exit("javascript:location.href='" . MemberLink::get_link('login') . "';");
        }
    }

    public static function in_JsList() {
        global $espcms_web_templates;
        $espcms_web_templates->libfile = true;
        $db_table = ESPCMS_DB_PREFIX . 'document';
        $limit = espcms_ismatches($_GET['max']) && $_GET['max'] ? $_GET['max'] : 20;
        $lng = espcms_lancode();
        $db_where = " AND isclass=1";
        if (espcms_ismatches($_GET['tid']) && $_GET['tid']) {
            $istid = true;
            $tid_array = ESPCMS_ArticleTypeDB::get_article_type_listDB($_GET['tid'], $lng);
            $tid_list = implode(',', array_keys($tid_array));
            $db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
        } elseif (espcms_islongfig($_GET['tid'], '/^[\d]+(-[\d]+)*$/i') && !espcms_ismatches($_GET['tid'])) {

            $istid = true;
            $long_tid = str_replace('-', ',', $_GET['tid']);
            $db_where .= " AND tid IN ($long_tid)";
        }
        if (espcms_ismatches($_GET['mid']) && $_GET['mid']) {
            $db_where .= " AND mid=" . $_GET['mid'];
        }
        if (espcms_ismatches($_GET['sid']) && $_GET['sid']) {
            $issid = true;
            $db_where .= " AND sid=" . $_GET['sid'];
        }
        if (espcms_ismatches($_GET['dlid']) && $_GET['dlid']) {
            $db_where .= " AND FIND_IN_SET('$_GET[dlid]',recommend)";
        }
        if (!$istid && !$issid) {
            $db_where .= " AND lng='$lng'";
        }
        $rank = $_GET['rank'] == 1 ? 'ASC' : 'DESC';
        switch ($_GET['sort']) {
            case 2:
                $order_type = 'pid ' . $rank;
                break;
            case 3:
                $order_type = 'pid ' . $rank . ',did ' . $rank;
                break;
            case 4:
                $order_type = 'click ' . $rank;
                break;
            case 5:
                $order_type = 'addtime ' . $rank;
                break;
            default:
                $order_type = 'did ' . $rank;
                break;
        }

        $order_app_config = ESPCMS_Core::get_app_config('order', false);
        $enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
        $talbe_field_array = espcms_field_out($db_table);
        $list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $order_type, '0,' . $limit);
        $doc_array = array();
        if (!is_array($list_array)) {
            return false;
        }
        foreach ($list_array as $key => $value) {
            $value['ctitle'] = !$value['color'] ? $value['title'] : "<font color='" . $value['color'] . "'>" . $value['title'] . "</font>";
            $type_read = ESPCMS_ArticleTypeDB::get_article_type_view($value['tid']);
            $value['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $value['ishtml'];
            $value['typename'] = $type_read['typename'];
            $value['typelink'] = ArticleLink::type_link($type_read);
            $value['link'] = ArticleLink::doc_link($value);
            if ($order_app_config['isetup'] && $order_app_config['isopen']) {
                $value['buylink'] = OrderLink::get_order_link('buy', $value);
            }
            if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
                $value['enqlink'] = EnquiryLink::get_enquiry_link('into', $value);
            }
            $attr_read = ESPCMS_ArticleDB::get_article_attr_read($value['did']);
            $doc_array[] = is_array($attr_read) ? array_merge($value, $attr_read) : $value;
        }
        $espcms_web_templates->into('array', $doc_array);
        $filename = $_GET['file'] && preg_match("/^[\w-]+$/i", $_GET['file']) ? $_GET['file'] : 'list';
        $output = $espcms_web_templates->fetch('lib/' . $filename);
        $outHTML = addslashes($output);
        $textArray = preg_split('/[\r\n]/i', $outHTML);
        if (is_array($textArray)) {
            $outHTML = null;
            foreach ($textArray as $key => $value) {
                $outHTML .= 'document.write("' . $value . '");';
            }
            exit($outHTML);
        } else {
            exit('document.writeln("' . $outHTML . '")');
        }
    }

}
