<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


use modul_application\ESPCM_InstallDB;
use application\ESPCMS_FileTool;
use inc_application\link\SetupLink;

class Setup {

    public function __construct() {
        $installlock = ESPCMS_FILE_ROOT . 'espcms_datacache/install.lock';
        if (file_exists($installlock) && $_GET['at'] != 'SetupOk') {
            espcms_message_err('setup_pack-espcms_lable_install_repetition');
        }
    }

    public static function in_SetupIndex() {
        global $espcms_web_templates, $espcms_license;
        $espcms_web_templates->into('espcms_license', $espcms_license);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'index');
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_RunTime() {
        global $espcms_web_templates, $espcms_license, $loading_php_version, $loading_mysql_version;
        $is_setup = 1;

        $ser_inc = array();
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_servername'), 'key' => php_uname('s') . '-' . php_uname('v'), 'sug' => 'Windows NT/Linux');
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_serverweb'), 'key' => $_SERVER['SERVER_SOFTWARE'], 'sug' => 'Apache/Nginx');
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_phpver'), 'key' => PHP_VERSION, 'sug' => $loading_php_version . '以上');
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_mysql'), 'key' => '/', 'sug' => $loading_mysql_version . '以上');
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_installpath'), 'key' => ESPCMS_FILE_ROOT, 'sug' => '/');
        $ser_inc[] = array('title' => espcms_lan_pack('setup_pack-espcms_lable_setup_runtime_phpupload'), 'key' => ini_get('upload_max_filesize'), 'sug' => '2M以上');

        $php_inc = array();
        $php_inc[] = array('title' => 'PDO', 'key' => extension_loaded('pdo') && extension_loaded('pdo_mysql') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'Fsockopen', 'key' => ini_get('allow_url_fopen') && function_exists('fsockopen') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'CURL', 'key' => extension_loaded('curl') && function_exists('curl_init') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'openSSL', 'key' => extension_loaded('openssl') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'GD2', 'key' => extension_loaded('gd') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'ZIP', 'key' => function_exists('zip_open') && function_exists('zip_read') ? 1 : 0, 'sug' => 1);
        $php_inc[] = array('title' => 'Mcrypt', 'key' => function_exists('mcrypt_encrypt') && extension_loaded('Mcrypt') ? 1 : 0, 'sug' => 1);
        foreach ($php_inc as $value) {
            if (!$value['key']) {
                $is_setup = 0;
                break;
            }
        }

        $dir_array = ESPCM_InstallDB::get_write_file();
        if (is_array($dir_array)) {
            $dir_inc = array();
            foreach ($dir_array as $key => $value) {
                $dir_path = ESPCMS_FILE_ROOT . $value['name'];
                $dir_status = is_dir($dir_path) && ESPCMS_FileTool::is_dir_writeable($dir_path) ? 1 : 0;
                $dir_inc[] = array('title' => $value['name'], 'key' => $dir_status, 'sug' => 1);
                if (!$dir_status && $is_setup) {
                    $is_setup = 0;
                }
            }
        }
        $espcms_web_templates->into('espcms_license', $espcms_license);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'runtime');
        $espcms_web_templates->into('is_setup', $is_setup);
        $espcms_web_templates->into('ser_inc', $ser_inc);
        $espcms_web_templates->into('php_inc', $php_inc);
        $espcms_web_templates->into('dir_inc', $dir_inc);
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_RegYun() {
        global $espcms_web_templates, $espcms_license;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : '';
        if ($espcms_setup_user_info && is_array($espcms_setup_user_info)) {
            $espcms_web_templates->into('userinfo', $espcms_setup_user_info);
        }
        $espcms_web_templates->into('espcms_license', $espcms_license);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'reg');
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_RegYunDB() {

        if (!espcms_isact($_POST['login_user'], "/^.{2,100}$/i") && !espcms_ismoblie($_POST['login_user']) && !espcms_isemail($_POST['login_user'])) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_login_user_validation_msg', 'false');
        }
        $login_user = $_POST['login_user'];
        $password_len = strlen($_POST['password']);
        if ($password_len < 6 || $password_len > 30) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_login_password_validation_msg', 'false');
        }
        $password = $_POST['password'];
        $user_view = ESPCM_InstallDB::connect_service('Memberlogindb', array('login_user' => $login_user, 'password' => $password));
        if (!$user_view || !is_array($user_view) || !$user_view['uid'] || !espcms_ismatches($user_view['uid'])) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_login_err', 'false');
        }
        $user_login_info_ser = serialize($user_view);
        espcms_set_cookie('espcms_setup_user_info', $user_login_info_ser, 86400);
        espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_login_ok', 'true', array(), 'json', $user_view);
    }

    public static function in_Setting() {
        global $espcms_web_templates;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();



        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if ($espcms_setup_db && is_array($espcms_setup_db)) {
            $espcms_web_templates->into('setup_db', $espcms_setup_db);
        }
        $espcms_web_templates->into('userinfo', $espcms_setup_user_info);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'setting');
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_SettingDB() {
        if (!$_POST['db_host'] || !espcms_isact($_POST['db_name'], "/^[a-zA-Z]{1}[\w\-]*$/i") || !espcms_isact($_POST['db_user'], "/^[\w]+$/i") || !espcms_isact($_POST['db_prefix'], "/^[\w]+$/i") || !espcms_isact($_POST['db_password'], "/^.{2,50}$/i")) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_input_err', 'false');
        }
        if (!espcms_isemail($_POST['admin_email']) || !espcms_isact($_POST['admin_username'], "/^[\w]{2,50}$/i") || !espcms_isact($_POST['admin_password'], "/^.{6,30}$/i") || !espcms_isact($_POST['webname'], "/^.{2,200}$/i")) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_input_err', 'false');
        }
        if (!espcms_ismatches($_POST['db_setuptype']) || !espcms_ismatches($_POST['db_linktype']) || !espcms_ismatches($_POST['module_dbdemo']) || !espcms_ismatches($_POST['module_app'])) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_input_err', 'false');
        }
        $link = self::SqlLink($_POST['db_host'], $_POST['db_name'], $_POST['db_user'], $_POST['db_password']);
        if (!$link) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_no', 'false');
        }

        if (self::is_querydb($_POST) && !$_POST['db_setuptype']) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_db_exist', 'false');
        }
        $espcms_setup_db = serialize($_POST);
        espcms_set_cookie('espcms_setup_db', $espcms_setup_db, 86400);
        espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_ok', 'true');
    }

    protected static function is_querydb($espcms_setup_db = array()) {
        if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php')) {
            require_once(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php');
        }
        $espcms_link_db = new ESPCMS_Mysql($espcms_setup_db['db_host'], $espcms_setup_db['db_name'], $espcms_setup_db['db_user'], $espcms_setup_db['db_password'], 'utf8', false);
        if (!$espcms_link_db) {
            return false;
        }
        $db_sql = "SHOW TABLE STATUS LIKE '" . $espcms_setup_db['db_prefix'] . "%'";
        $db_query = $espcms_link_db->db_query($db_sql, 'qu', true);
        if (!$db_query) {
            return false;
        }
        return true;
    }

    public static function in_DownLoadDB() {
        global $espcms_web_templates;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if (!$espcms_setup_db || !is_array($espcms_setup_db)) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_input_err');
        }
        if ($_COOKIE['espcms_setup_db_file']) {
            espcms_set_cookie('espcms_setup_db_file', false);
        }
        $espcms_web_templates->into('userinfo', $espcms_setup_user_info);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'download');
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_DownloadFile() {
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if (!$espcms_setup_db || !is_array($espcms_setup_db)) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_input_err', 'false');
        }
        $espcms_setup_user_info['install_pack_istype'] = $espcms_setup_db['module_app'];
        $espcms_setup_user_info['install_get'] = 1;
        $download_list = ESPCM_InstallDB::connect_service('InstallPack', $espcms_setup_user_info, false);
        if (!$download_list) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_download_err', 'false');
        }
        exit($download_list);
    }

    public static function in_DownloadView() {
        $uid = $_POST['uid'];
        if (!$uid || !espcms_ismatches($uid)) {
            espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($uid));
        }
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        $espcms_setup_user_info['install_pack_id'] = $uid;
        $espcms_setup_user_info['install_get'] = 1;
        $install_pack_view = ESPCM_InstallDB::connect_service('InstallPackView', $espcms_setup_user_info);
        if (!$install_pack_view || !is_array($install_pack_view)) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_download_err3', 'false', array($uid));
        }
        if (!function_exists('zip_open')) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_download_err4', 'false');
        }
        $save_status = self::saveFile($install_pack_view);
        if ($save_status) {
            if ($install_pack_view['install_pack_isdb'] == 1) {

                $db_name = md5($install_pack_view['install_pack_filename']);
                $espcms_setup_db_file = $_COOKIE['espcms_setup_db_file'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db_file'])) : array();
                $espcms_setup_db_file[] = $db_name;
                $espcms_setup_db_file_ser = serialize($espcms_setup_db_file);
                espcms_set_cookie('espcms_setup_db_file', $espcms_setup_db_file_ser, 86400);
            }
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_download_ok', 'true', array($install_pack_view['install_pack_title']), 'json', $install_pack_view);
        } else {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_download_err3', 'false', array($uid), 'json', $install_pack_view);
        }
    }

    private static function saveFile($pack_read = array()) {
        if (!$pack_read || !is_array($pack_read) || !$pack_read['install_pack_filename'] || !$pack_read['upfile']) {
            return false;
        }
        $filename = md5($pack_read['install_pack_filename']);
        $download_file = ESPCMS_FILE_ROOT . 'espcms_datacache/cache_pack/' . $filename . '.zip';
        if (!is_file($download_file)) {

            if (!ESPCMS_FileTool::downloadFile($pack_read['upfile'], $download_file)) {
                return false;
            }
        }
        $zip_path = $pack_read['install_pack_isdb'] == 2 ? ESPCMS_FILE_ROOT : ESPCMS_FILE_ROOT . 'espcms_install/db/' . $filename . '/';
        if ($pack_read['install_pack_isdb'] == 1 && !is_dir($zip_path)) {
            if (!mkdir($zip_path)) {
                return false;
            }
        }

        $zip = zip_open($download_file);
        if (is_resource($zip)) {

            while (($zip_entry = zip_read($zip)) !== false) {

                $filename = zip_entry_name($zip_entry);

                $foldername = $zip_path . $filename;
                if (strpos(zip_entry_name($zip_entry), '/') !== false) {
                    $last = strrpos(zip_entry_name($zip_entry), '/');
                    $dir = $zip_path . substr(zip_entry_name($zip_entry), 0, $last);
                    $file = substr(zip_entry_name($zip_entry), strrpos(zip_entry_name($zip_entry), '/') + 1);
                    if (!is_dir($dir)) {
                        mkdir($dir, 0755, true);
                    }
                    if (strlen(trim($file)) > 0) {
                        $return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
                        if (!$return) {
                            return false;
                        }
                    }
                } else {
                    $return = file_put_contents($foldername, zip_entry_read($zip_entry, zip_entry_filesize($zip_entry)));
                    if (!$return) {
                        return false;
                    }
                }
            }

            zip_close($zip);

            ESPCMS_FileTool::delFile($download_file);
        } else {
            return false;
        }
        return true;
    }

    public static function in_LinkDemo() {
        $db_host = $_POST['db_host'] ? $_POST['db_host'] : '';
        $db_name = $_POST['db_name'] && espcms_isact($_POST['db_name'], "/^[\w\-]+$/i") ? $_POST['db_name'] : '';
        $db_user = $_POST['db_user'] && espcms_isact($_POST['db_user'], "/^[\w\-]+$/i") ? $_POST['db_user'] : '';
        $db_password = $_POST['db_password'] && espcms_isact($_POST['db_password'], "/^.{2,50}$/i") ? $_POST['db_password'] : '';
        $db_prefix = $_POST['db_prefix'] && espcms_isact($_POST['db_prefix'], "/^[\w]+_$/i") ? $_POST['db_prefix'] : '';

        if (!$db_host || !$db_name || !$db_user || !$db_password || !$db_prefix) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_link_demo_err', 'false');
        }
        $link = self::SqlLink($db_host, $db_name, $db_user, $db_password);
        if ($link) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_link_ok', 'true');
        } else {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_link_no', 'false');
        }
    }

    private static function SqlLink($db_host = false, $db_name = false, $db_user = false, $db_password = false) {
        if (!$db_host || !$db_name || !$db_user || !$db_password) {
            return false;
        }
        if (function_exists('mysql_connect')) {
            $link = @mysql_connect($db_host, $db_user, $db_password);
        } elseif (function_exists('mysqli_connect')) {
            $link = mysqli_connect($db_host, $db_user, $db_password);
        } else {
            return false;
        }
        if (!$link) {
            $link_type = false;
        } else {
            $link_type = true;
            if (function_exists('mysql_close')) {
                mysql_close($link);
            } else {
                mysqli_close($link);
            }
        }
        return $link_type;
    }

    public static function in_InstallDB() {
        global $espcms_web_templates;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        if (!$espcms_setup_user_info || !is_array($espcms_setup_user_info) || !$espcms_setup_user_info['uid'] || !espcms_ismatches($espcms_setup_user_info['uid'])) {
            $espcms_setup_user_info['uid'] = 0;
        }
        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if (!$espcms_setup_db || !is_array($espcms_setup_db)) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_input_err');
        }
        $espcms_setup_db_file = $_COOKIE['espcms_setup_db_file'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db_file'])) : '';
        if (!$espcms_setup_db_file || !is_array($espcms_setup_db_file)) {
            espcms_message_err('setup_pack-espcms_lable_setup_download_err5');
        }
        $db_array[] = array('db_file' => 'espcms_p8_1.sql', 'db_istype' => 1, 'db_name' => espcms_lan_pack('setup_pack-espcms_lable_install_db1'));
        $db_array[] = array('db_file' => 'espcms_p8_2.sql', 'db_istype' => 1, 'db_name' => espcms_lan_pack('setup_pack-espcms_lable_install_db1'));
        if ($espcms_setup_db['module_dbdemo']) {

            $db_array[] = array('db_file' => 'espcms_p8_3.sql', 'db_istype' => 1, 'db_name' => espcms_lan_pack('setup_pack-espcms_lable_install_db2'));
        }
        if (is_array($espcms_setup_db_file)) {

            foreach ($espcms_setup_db_file as $value) {
                $db_array[] = array('db_file' => $value, 'db_istype' => 2, 'db_name' => espcms_lan_pack('setup_pack-espcms_lable_install_db3'));
            }
        }

        if (!$espcms_setup_db['db_host'] || !espcms_isact($espcms_setup_db['db_name'], "/^[\w\-]+$/i") || !espcms_isact($espcms_setup_db['db_user'], "/^[\w\-]+$/i") || !espcms_isact($espcms_setup_db['db_password'], "/^.{2,50}$/i") || !espcms_isact($espcms_setup_db['db_prefix'], "/^[\w]+_$/i")) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_input_err2');
        }

        if (function_exists('mysql_connect')) {
            $link = @mysql_connect($espcms_setup_db['db_host'], $espcms_setup_db['db_user'], $espcms_setup_db['db_password']);
        } elseif (function_exists('mysqli_connect')) {
            $link = mysqli_connect($espcms_setup_db['db_host'], $espcms_setup_db['db_user'], $espcms_setup_db['db_password']);
        }
        if (!$link) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_link_no');
        }

        $dbname = $espcms_setup_db['db_name'];
        if (function_exists('mysql_query')) {
            $sql = mysql_query("CREATE DATABASE IF NOT EXISTS $dbname DEFAULT CHARACTER SET utf8");
        } elseif (function_exists('mysqli_query')) {
            $sql = mysqli_query($link, "CREATE DATABASE IF NOT EXISTS $dbname DEFAULT CHARACTER SET utf8");
        }
        if (!$sql) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_input_err3');
        }
        $setup_db_file = json_encode($db_array);
        $espcms_web_templates->into('setup_db_file', $setup_db_file);
        $espcms_web_templates->into('userinfo', $espcms_setup_user_info);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'installdb');
        $espcms_web_templates->output('index', 'index', false, false);
    }

    public static function in_SaveDB() {
        global $espcms_db_version, $espcms_version;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        if (!$espcms_setup_user_info || !is_array($espcms_setup_user_info) || !$espcms_setup_user_info['uid'] || !espcms_ismatches($espcms_setup_user_info['uid'])) {
            $espcms_setup_user_info['uid'] = 0;
        }
        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if (!$espcms_setup_db || !is_array($espcms_setup_db)) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_setup_setting_db_input_err', 'false');
        }

        $db_path = ESPCMS_FILE_ROOT . 'espcms_install/db/';
        if (!$_POST['db_istype'] || !espcms_ismatches($_POST['db_istype'])) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_install_read_err', 'false');
        }

        $db_file = $_POST['db_istype'] == 2 ? $db_path . $_POST['db_file'] . '/install.sql' : $db_path . $_POST['db_file'];
        if (!is_file($db_file)) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_install_read_err', 'false');
        }
        if (!$_POST['limit_num'] || !espcms_ismatches($_POST['limit_num']) || !$_POST['pack_num'] || !espcms_ismatches($_POST['pack_num'])) {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_install_err', 'false');
        }

        if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php')) {
            require_once(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php');
        }
        $db_prefix = $espcms_setup_db['db_prefix'];

        $espcms_link_db = new ESPCMS_Mysql($espcms_setup_db['db_host'], $espcms_setup_db['db_name'], $espcms_setup_db['db_user'], $espcms_setup_db['db_password'], 'utf8');

        if ($_POST['limit_num'] == 1 && $espcms_setup_db['db_setuptype'] == 1) {
            $db_sql = "SHOW TABLE STATUS LIKE '" . $db_prefix . "%'";
            $db_query = $espcms_link_db->db_query($db_sql);
            while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
                $db_table = $fetch_row['Name'];
                $drop_sql = "DROP TABLE IF EXISTS $db_table";
                $espcms_link_db->db_query($drop_sql, 'qe', true);
            }
        }

        $updatesql = file_get_contents($db_file);
        if ($_POST['db_istype'] == 2) {

            $db_demo_file = $db_path . $_POST['db_file'] . '/db.sql';
            if (is_file($db_demo_file)) {
                $updatesql .= file_get_contents($db_demo_file);
            }
        }
        if ($updatesql) {
            $updatesql = str_replace("\r\n", "\n", $updatesql);
            $ret = array();
            $num = 0;

            foreach (explode(";\n", trim($updatesql)) as $query) {
                $ret[$num] = '';
                $queries = explode("\n", trim($query));
                foreach ($queries as $query) {
                    $ret[$num] .= (isset($query[0]) && $query[0] == '#') || (isset($query[1]) && isset($query[1]) && $query[0] . $query[1] == '--') ? '' : $query;
                }
                $num++;
            }
            unset($updatesql);

            foreach ($ret as $query) {
                $query = trim($query);
                if ($query) {
                    $query = str_replace('esp_', $db_prefix, $query);
                    $espcms_link_db->db_query($query, 'qe', true);
                }
            }

            if ($_POST['db_istype'] == 2) {
                ESPCMS_FileTool::delFile($db_file);
            }
        } else {
            espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_install_err2', 'false');
        }

        if ($_POST['limit_num'] == $_POST['pack_num']) {
            $admin_username = $espcms_setup_db['admin_username'] ? $espcms_setup_db['admin_username'] : 'admin';
            $admin_password = $espcms_setup_db['admin_password'] ? md5($espcms_setup_db['admin_password']) : 'ad3357f54594b13cfc92d1948cdf510a';
            $admin_email = $espcms_setup_db['admin_email'] ? $espcms_setup_db['admin_email'] : '';
            $admin_name = $espcms_setup_user_info['username'] ? $espcms_setup_user_info['username'] : '';
            $admin_intotime = time();

            $install_db = "INSERT INTO " . $db_prefix . "admin_member (power_groups_id,admin_username,admin_password,admin_email,admin_name,admin_intotime,admin_isclass,admin_isremote) VALUES (1,'$admin_username','$admin_password','$admin_email','$admin_name',$admin_intotime,1,0)";
            $espcms_link_db->db_query($install_db);
            $ENCRYPT_CODE = md5(md5($espcms_setup_db['admin_password']) . random(12));

            $table_config = $db_prefix . "config";
            $db_update_sql = "UPDATE $table_config SET config_value='" . $espcms_setup_db['webname'] . "' WHERE config_name='SITENAME'";
            $espcms_link_db->db_query($db_update_sql);
            $db_update_sql = "UPDATE $table_config SET config_value='" . $admin_email . "' WHERE config_name='ADMINE_MAIL'";
            $espcms_link_db->db_query($db_update_sql);
            $db_update_sql = "UPDATE $table_config SET config_value='" . $ENCRYPT_CODE . "' WHERE config_name='CON_ENCRYPT_CODE'";
            $espcms_link_db->db_query($db_update_sql);
            $db_update_sql = "UPDATE $table_config SET config_value='" . $espcms_setup_user_info['uid'] . "' WHERE config_name='CON_DBOSN'";
            $espcms_link_db->db_query($db_update_sql);
            $db_update_sql = "UPDATE $table_config SET config_value='" . $espcms_db_version . "' WHERE config_name='CON_VOL'";
            $espcms_link_db->db_query($db_update_sql);
            $db_update_sql = "UPDATE $table_config SET config_value='" . $espcms_version . "' WHERE config_name='CON_VOLSTR'";
            $espcms_link_db->db_query($db_update_sql);

            $config_path = ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php';
            $config_content = "<?php
define('ESPCMS_DB_HOST', '" . $espcms_setup_db['db_host'] . "');
define('ESPCMS_DB_USER', '" . $espcms_setup_db['db_user'] . "');
define('ESPCMS_DB_PASSWORD', '" . $espcms_setup_db['db_password'] . "');
define('ESPCMS_DB_NAME', '" . $espcms_setup_db['db_name'] . "');
define('ESPCMS_DB_CHARSET', 'utf8');
define('ESPCMS_DB_PREFIX', '" . $espcms_setup_db['db_prefix'] . "');
define('ESPCMS_DB_ERR', 0);
define('ESPCMS_DB_SQL', 0);
define('ESPCMS_DB_LINKTYPE', 1);
define('ESPCMS_ENCRYPT_CODE', '$ENCRYPT_CODE');";
            ESPCMS_FileTool::writeFile($config_path, $config_content);
            $installlock = ESPCMS_FILE_ROOT . 'espcms_datacache/install.lock';
            if (!file_exists($installlock)) {
                touch($installlock);
            }
        }
        espcms_public_dialog('espcms_public_dialog', 'setup_pack-espcms_lable_install_ok', 'true', array(), 'json', $espcms_setup_db);
    }

    public static function in_SetupOk() {
        global $espcms_web_templates;
        $espcms_setup_user_info = $_COOKIE['espcms_setup_user_info'] ? unserialize(stripslashes($_COOKIE['espcms_setup_user_info'])) : array();
        $espcms_setup_db = $_COOKIE['espcms_setup_db'] ? unserialize(stripslashes($_COOKIE['espcms_setup_db'])) : '';
        if (!$espcms_setup_db || !is_array($espcms_setup_db)) {
            espcms_message_err('setup_pack-espcms_lable_setup_setting_db_input_err');
        }
        if ($_COOKIE['espcms_setup_db_file']) {
            espcms_set_cookie('espcms_setup_db_file', false);
        }
        if (file_exists(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php')) {
            require_once(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php');
        } else {
            exit('错误：数据库文件错误');
        }
        if (file_exists(ESPCMS_FILE_ROOT . 'espcms_includes/espcms_version.php')) {
            require_once(ESPCMS_FILE_ROOT . 'espcms_includes/espcms_version.php');
        } else {
            exit('错误：版本配置文件不存在');
        }
        require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_variable.php');
        require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_constant.php');
        require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_function.php');
        espcms_bug_mode();
        espcms_load_constant();
        espcms_cache_constant();
        $_SERVER = espcms_server_vars();
        global $espcms_version, $espcms_db_version, $espcms_tinymce_version, $loading_php_version, $loading_mysql_version;
        espcms_loadcheck_php_versions();
        require_espcms_link_db();
        espcms_command();
        $espcms_web_templates->into('userinfo', $espcms_setup_user_info);
        $espcms_web_templates->into('link', SetupLink::get_link());
        $espcms_web_templates->into('path', 'setupok');
        $espcms_web_templates->output('index', 'index', false, false);
    }

}
