<?php

/*
  PHP version 5
  Copyright (c) 2002-2019ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/


if (!file_exists(ESPCMS_FILE_ROOT . 'espcms_datacache/install.lock') && !file_exists(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php')) {
    header('Content-type: text/html; charset=utf-8');
    header('location:espcms_install/');
    exit;
}

if (file_exists(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php')) {

    require_once(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_config.php');
} else {
    exit('错误：数据库文件错误');
}

if (file_exists(ESPCMS_FILE_ROOT . 'espcms_includes/espcms_version.php')) {
    require_once(ESPCMS_FILE_ROOT . 'espcms_includes/espcms_version.php');
} else {
    exit('错误：版本配置文件不存在');
}

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_constant.php');

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_function.php');

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_variable.php');

espcms_bug_mode();

espcms_load_constant();

espcms_cache_constant();

$_SERVER = espcms_server_vars();

global $espcms_version, $espcms_db_version, $espcms_tinymce_version, $loading_php_version, $loading_mysql_version, $loading_mysql_version_hig;

espcms_loadcheck_php_versions();

espcms_command();

$timeoffset = preg_match("/^[0-9.\-]+$/i", $espcms_command['BASIC_TIMEZONE']) ? $espcms_command['BASIC_TIMEZONE'] * -1 : 8 * -1;
date_default_timezone_set("Etc/GMT$timeoffset");
if (ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE')) {
    if (preg_match('/^[\w]{2,50}$/u', $_GET['lng'])) {
        setcookie('ESPCMS_WAP_LNG_COOKIE', $_GET['lng']);
        $ESPCMS_WEB_LAN = $_GET['lng'];
    } else {
        $ESPCMS_WEB_LAN = $_COOKIE['ESPCMS_WAP_LNG_COOKIE'] && preg_match('/^[\w]{2,50}$/u', $_COOKIE['ESPCMS_WAP_LNG_COOKIE']) ? $_COOKIE['ESPCMS_WAP_LNG_COOKIE'] : $espcms_command['HOME_LNG'];
    }
    define("ESPCMS_WEB_LAN", $ESPCMS_WEB_LAN);
} else {

    if (!defined('ESPCMS_WEB_LAN')) {
        define("ESPCMS_WEB_LAN", $espcms_command['HOME_LNG']);
    }
}

if ($espcms_command['IS_CLOSE']) {
    exit($espcms_command['CLOSE_CONTENT']);
}

$espcms_link_db = require_espcms_link_db();

espcms_loadcheck_mysql_versions();

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_tool.php');

espcms_magic_quotes();

define('ESPCMS_URL', preg_replace('/' . str_replace('/', '\/', $espcms_command['FILE_HTMLDIR']) . '(.*)/i', '', espcms_host('AP')));

define('ESPCMS_WWW_URL', espcms_host('WWW_RT'));

define('ESPCMS_URL_RT', espcms_host('RT'));

$ac_name = espcms_get_ac() ? espcms_get_ac() : ESPCMS_WEB_RUN_AC;
$at_name = espcms_get_at() ? espcms_get_at() : ESPCMS_WEB_RUN_AT;

$espcms_db_cache = espcms_start_cache();

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_db.php');

require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_dbsave.php');

$espcms_web_templates = espcms_web_template();

$module_filename = ESPCMS_FILE_ROOT . 'espcms_web/' . $ac_name . '.php';
if (!is_file($module_filename)) {
    espcms_message_err('public_pack-espcms_module_file_err', array($ac_name));
}
include $module_filename;
$espcms_fun_name = ESPCMS_FUN_PREFIX . $at_name;
if (method_exists($ac_name, $espcms_fun_name)) {
    $control = new $ac_name;
    $control->$espcms_fun_name();
} else {
    espcms_message_err('public_pack-espcms_method_name_err', array($ac_name . '/' . $at_name));
}

function __autoload($class) {
    if (!$class) {
        espcms_message_err('public_pack-espcms_method_class_err', array($class));
    }
    $class_array = explode('\\', $class);
    if (!$class_array[0]) {
        espcms_message_err('public_pack-espcms_method_class_err', array($class));
    }

    $isObject = false;

    switch ($class_array[0]) {
        case 'application':
            $class_array[0] = 'espcms_public';
            $classFile = implode('/', $class_array);
            $isObject = true;
            break;
        case 'modul_application':
            $class_array[0] = 'espcms_interface';
            $classFile = implode('/', $class_array);
            $isObject = true;
            break;
        case 'inc_application':
            $class_array[0] = 'espcms_includes';
            $classFile = implode('/', $class_array);
            $isObject = true;
            break;
        case 'web_application':
            $class_array[0] = 'espcms_web';
            $classFile = implode('/', $class_array);
            $isObject = true;
            break;
        default:
            break;
    }
    if ($isObject) {
        $file = ESPCMS_FILE_ROOT . $classFile . '.php';
        if (!is_file($file)) {
            espcms_message_err('public_pack-espcms_module_file_err', array($class));
        } else {
            include_once($file);
        }
    }
}
