<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use application\ESPCMS_PY;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_ArticleTypeDB;
use modul_application\ESPCMS_ArticleDB;
use admin_application\NevigateDB;
use admin_application\ArticleMainDB;
use admin_application\ArticleModelDB;
use admin_application\ArticleTypeDB;
use admin_application\AdminPublicDB;
use application\ESPCMS_PublicDB;
use admin_application\link\ArticleLink;
use admin_application\link\SettingLink;
use admin_application\link\TemplatesLink;

class ArticleType {

	private static $document_typelist_list_cache_key;
	private static $document_typelist_read_cache_key;

	public function __construct() {
		$exclude_method = array('saveArticleType', 'ajaxArticleType', 'batsetArticleType', 'setArticleType', 'sortArticleType', 'batdelArticleType', 'verifyArticleType');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
		self::$document_typelist_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'document_typelist_';
		self::$document_typelist_read_cache_key = ESPCMS_CACHE_DBREAD_NAME . ESPCMS_DB_PREFIX . 'document_typelist_';
	}

	public static function listArticleType() {
		global $espcms_admin_templates;
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {
			$mid = $_REQUEST['mid'];
			if (espcms_ismatches($mid) && $mid) {
				$db_where .= " AND mid=$mid";
			}
			$isclass = $_REQUEST['isclass'];
			if (espcms_ismatches($isclass)) {
				$db_where .= " AND isclass=$isclass";
			}
			$array = ArticleTypeDB::get_article_type_listDB(0, $lng);
			if (is_array($array)) {
				foreach ($array as $key => $value) {
					$array[$key]['view'] = ArticleLink::Article_Main_link_array('index', $value);
					$array[$key]['edit'] = ArticleLink::ArticleType_link_array('edit', $value);
					$array[$key]['shift'] = ArticleLink::ArticleType_link_array('shift', $value);
					$array[$key]['syn'] = ArticleLink::ArticleType_link_array('syn', $value);
					$array[$key]['add'] = ArticleLink::ArticleType_link_array('add', $value);
					$array[$key]['addbase'] = ArticleLink::ArticleType_link_array('addbase', $value);
					$array[$key]['addlink'] = ArticleLink::ArticleType_link_array('addlink', $value);
					$array[$key]['modelname'] = ArticleModelDB::get_mid_view($value['mid'], 'modelname');
				}
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'article/article_type_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', ArticleLink::ArticleType_link_array(false, $_REQUEST));
			$templates = 'article/article_type_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addArticleType() {
		global $espcms_admin_templates, $espcms_command;
		$add_type = $_GET['type'] ? $_GET['type'] : 'type';
		$tid = $_GET['tid'];
		if ($tid && espcms_ismatches($tid)) {
			$article_type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
			if (!$article_type_read || $article_type_read['styleid'] == 3) {
				espcms_message_err('db_pack-espcms_db_read_fail', array($tid));
			}
			$espcms_admin_templates->into('article_type_read', $article_type_read);
		}
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if ($member_app_config['isetup']) {
			$member_class_list = ESPCMS_MemberDB::get_member_class_list();
			$espcms_admin_templates->into('member_class_list', $member_class_list);
		}
		$espcms_admin_templates->into('is_html', $espcms_command['IS_HTML'] ? 1 : 0);
		$espcms_admin_templates->into('member_app_config', $member_app_config);
		$espcms_admin_templates->into('link', ArticleLink::ArticleType_link_array());
		$espcms_admin_templates->into('read_mid', ArticleLink::ArticleModel_link_array('read'));
		$mid_isbase = $add_type == 'base' ? 1 : 0;
		$espcms_admin_templates->into('model_list', ArticleModelDB::get_model_list($article_type_read['mid'], false, $mid_isbase));
		$espcms_admin_templates->into('page_style', ESPCMS_PublicDB::get_typelist_style($article_type_read['filenamestyle']));
		$espcms_admin_templates->into('read_style', ESPCMS_PublicDB::get_read_style($article_type_read['readnamestyle']));
		$espcms_admin_templates->into('add_type', $add_type);
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
		$espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));
		$espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
		$espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
		$espcms_admin_templates->into('token', token());
		$template = $add_type == 'link' ? 'article/article_type_add_link' : 'article/article_type_add';
		$espcms_admin_templates->output($template);
	}

	public static function editArticleType() {
		global $espcms_admin_templates;
		$lng = AdminPublicDB::get_lancode();
		$tid = $_GET['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($tid));
		}
		$read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($tid));
		}
		$read['content'] = $read['content'] ? espcms_h2t($read['content']) : '';
		$article_type_array = $read['upid'] > 0 ? ArticleTypeDB::get_article_type_list($read['upid'], 0, 0, false, $lng, true) : array();
		$espcms_admin_templates->into('article_type_array', $article_type_array);
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if ($member_app_config['isetup']) {
			$member_class_list = ESPCMS_MemberDB::get_member_class_list($read['purview']);
			$espcms_admin_templates->into('member_class_list', $member_class_list);
		}
		$add_type = $read['styleid'] <= 2 ? 'type' : ($read['styleid'] == 3 ? 'link' : 'base');
		if ($read['styleid'] == 3 && !$read['isline'] && $read['gotoline'] && espcms_ismatches($read['gotoline'])) {
			$doc_list = ArticleMainDB::get_article_list($read['gotoline']);
			$title_array = is_array($doc_list) ? espcms_array_onedim($doc_list, 'title') : array();
			$title_list = is_array($title_array) && count($title_array) > 0 ? implode(',', $title_array) : array();
			$espcms_admin_templates->into('doc_list', $doc_list);
			$espcms_admin_templates->into('title_list', $title_list);
		}
		if ($read['styleid'] == 4) {
			$base_type = ArticleTypeDB::get_article_type_list($read['gotoid'], $tid, 0, false, $lng);
			$espcms_admin_templates->into('base_type', $base_type);
		}
		$espcms_admin_templates->into('purview_array', $read['purview'] && preg_match("/^[\d]+[\d,]*$/i", $read['purview']) ? explode(',', $read['purview']) : array());
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('add_type', $add_type);
		$espcms_admin_templates->into('member_app_config', $member_app_config);
		$espcms_admin_templates->into('link', ArticleLink::ArticleType_link_array());
		$espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($read['mid']));
		$espcms_admin_templates->into('read_mid', ArticleLink::ArticleModel_link_array('read'));
		$espcms_admin_templates->into('page_style', ESPCMS_PublicDB::get_typelist_style($read['filenamestyle']));
		$espcms_admin_templates->into('read_style', ESPCMS_PublicDB::get_read_style($read['readnamestyle']));
		$espcms_admin_templates->into('fileDialog', SettingLink::FileManage_link_array('dialog', $_GET));
		$espcms_admin_templates->into('key_select_link', ArticleLink::KeywordsOptimization_link_array('select'));
		$espcms_admin_templates->into('keygroups_select_link', ArticleLink::KeywordsGroups_link_array('select'));
		$espcms_admin_templates->into('templates_select', TemplatesLink::TemplateFile_link_array('select'));
		$espcms_admin_templates->into('article_select_link', ArticleLink::Article_Main_link_array('select'));
		$espcms_admin_templates->into('token', token());
		$template = $read['styleid'] == 3 ? 'article/article_type_edit_link' : 'article/article_type_edit';
		$espcms_admin_templates->output($template);
	}

	public static function shiftArticleType() {
		global $espcms_admin_templates;
		$lng = AdminPublicDB::get_lancode();
		$tid = $_GET['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($tid));
		}
		$read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($tid));
		}
		$article_type_array = ArticleTypeDB::get_article_type_list(0, 0, $read['mid'], false, $lng, true);
		$espcms_admin_templates->into('article_type_array', $article_type_array);
		$espcms_admin_templates->into('link', ArticleLink::ArticleType_link_array());
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($read['mid']));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/article_type_shift');
	}

	public static function synArticleType() {
		global $espcms_admin_templates;
		$tid = $_GET['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($tid));
		}
		$read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($tid));
		}
		$lan_array = AdminPublicDB::get_lan_list(false, false, false, true);
		$espcms_admin_templates->into('lan_array', $lan_array);
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', ArticleLink::ArticleType_link_array());
		$espcms_admin_templates->into('model_read', ArticleModelDB::get_mid_view($read['mid']));
		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('article/article_type_syn');
	}

	public static function ajaxArticleType() {
		if (!$_GET['mid'] || !espcms_ismatches($_GET['mid'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_GET['mid']));
		}
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($_GET['lng']));
		}
		$mid = $_GET['mid'];
		$lng = $_GET['lng'];
		$tid = $_GET['tid'];
		$selectName = $_GET['selectName'] ? $_GET['selectName'] : 'upid';
		$article_type_array = ArticleTypeDB::get_article_type_list(0, 0, $mid, false, $lng);
		$title = espcms_lan_pack('article_pack-espcms_article_list_upid_title');
		$data_validation_msg = espcms_lan_pack('article_pack-espcms_article_list_upid_validation_msg');
		if (is_array($article_type_array)) {
			$option_str = '<select class="selectpicker form-control" name="' . $selectName . '" id="' . $selectName . '" data-size="8" title="' . $title . '" data-validation="^[1-9]{1}[0-9]*$" data-validation-msg="' . $data_validation_msg . '">';
			foreach ($article_type_array as $key => $value) {
				$option_str .= $value['tid'] == $tid ? '<option value="' . $value['tid'] . '" class="' . $value['classname'] . '" data-icon="' . $value['icon'] . '" disabled>' . $value['typename'] . '</option>' :
					'<option value="' . $value['tid'] . '" class="' . $value['classname'] . '" data-icon="' . $value['icon'] . '">' . $value['typename'] . '</option>';
			}
			$option_str .= '</select>';
		}
		exit($option_str);
	}

	public static function saveArticleType() {
		global $espcms_db_cache, $espcms_link_db;
		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';
		$infotype = $_POST['infotype'] ? $_POST['infotype'] : 'type';
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$db_table_document = ESPCMS_DB_PREFIX . "document";
		$db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
		$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
		$db_table_document_album = ESPCMS_DB_PREFIX . "document_album";
		$talbe_field_array = espcms_field_out($db_table, true);
		$_POST['content'] = $_POST['content'] ? htmlspecialchars($_POST['content']) : '';
		if ($saveType == 'add' || $saveType == 'edit') {
			if ($infotype != 'link') {
				if (!espcms_ismatches($_POST['isdir']) || !espcms_ismatches($_POST['iswap']) || !espcms_ismatches($_POST['pageclass']) || !$_POST['typename']) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
			} else {
				if (!$_POST['typename']) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
			}
			if ($infotype == 'type') {
				if (!espcms_ismatches($_POST['pagemax']) || !espcms_ismatches($_POST['styleid']) || !espcms_ismatches($_POST['ispart']) || !espcms_ismatches($_POST['ordertype']) || !espcms_ismatches($_POST['isorderby'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
			}
			if ($infotype == 'base') {
				$_POST['styleid'] = 4;
			}
			if ($infotype == 'link') {
				$_POST['styleid'] = 3;
			}
			$_POST['upid'] = !espcms_ismatches($_POST['upid']) ? 0 : $_POST['upid'];
			$_POST['purview'] = !espcms_array_ismatches($_POST['purview']) ? 0 : implode(',', $_POST['purview']);
		}
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addArticleType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$_POST['lng'] = AdminPublicDB::get_lancode();
			if ($_POST['upid'] && espcms_ismatches($_POST['upid'])) {
				$_POST['topid'] = ESPCMS_ArticleTypeDB::get_article_type_view($_POST['upid'], 'topid');
			}
			$_POST['pageclass'] = !espcms_ismatches($_POST['pageclass']) ? 0 : $_POST['pageclass'];
			$_POST['ismenu'] = !espcms_ismatches($_POST['ismenu']) ? 0 : $_POST['ismenu'];
			$_POST['isaccessory'] = !espcms_ismatches($_POST['isaccessory']) ? 0 : $_POST['isaccessory'];
			$_POST['isclass'] = !espcms_ismatches($_POST['isclass']) ? 1 : $_POST['isclass'];
			$_POST['pagemax'] = !espcms_ismatches($_POST['pagemax']) ? 0 : $_POST['pagemax'];
			$_POST['ispart'] = !espcms_ismatches($_POST['ispart']) ? 1 : $_POST['ispart'];
			$_POST['ordertype'] = !espcms_ismatches($_POST['ordertype']) ? 1 : $_POST['ordertype'];
			$_POST['isorderby'] = !espcms_ismatches($_POST['isorderby']) ? 1 : $_POST['isorderby'];
			$_POST['gotoid'] = !espcms_ismatches($_POST['gotoid']) ? 0 : $_POST['gotoid'];
			$_POST['content'] = $_POST['content'] ? espcms_t2h($_POST['content']) : '';
			$_POST['gotoid'] = !espcms_ismatches($_POST['gotoid']) ? 0 : $_POST['gotoid'];
			$_POST['isline'] = $infotype == 'link' && espcms_ismatches($_POST['isline']) ? $_POST['isline'] : 0;
			if ($infotype != 'link') {
				if (!espcms_ismatches($_POST['mid']) || empty($_POST['mid'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				}
				if (espcms_ismatches($_POST['isdir']) && $_POST['isdir']) {
					$dirname = ESPCMS_PY::getFullSpell($_POST['typename'], '_');
					$_POST['dirname'] = !self::verifyArticleTypeDB('dirname', $dirname) ? $dirname : $dirname . '_' . time();
				} elseif (!$_POST['isdir'] && !preg_match("/^[\w]+/", $_POST['dirname'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				} elseif (!$_POST['isdir'] && preg_match("/^[\w]+/", $_POST['dirname']) && self::verifyArticleTypeDB('dirname', $_POST['dirname'])) {
					espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_dirname_warning_msg', 'false');
				}
			} else {
				$_POST['gotoline'] = espcms_ismatches($_POST['gotoline']) && !$_POST['isline'] ? $_POST['gotoline'] : 0;
				$_POST['typeurl'] = $_POST['typeurl'] && $_POST['isline'] ? $_POST['typeurl'] : '';
				$_POST['mid'] = 0;
			}
			$pid = ArticleTypeDB::lastPidArticleType($_POST['lng'], 'pid');
			$_POST['pid'] = $pid ? $pid + 1 : 1;
			$_POST['addtime'] = time();
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$install_id = espcms_db_install_save($db_table, $postvalue);
			if (!$install_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if (!$_POST['upid'] && espcms_ismatches($_POST['upid'])) {
				espcms_db_update_set_save($db_table, "WHERE tid=$install_id", "topid=$install_id");
			}
			if ($infotype == 'base' && $install_id) {
				$article_id = ArticleMainDB::article_base_save($install_id, $_POST);
				if ($article_id) {
					espcms_db_update_set_save($db_table, "WHERE tid=$install_id", "linkid=$article_id");
				}
			}
			$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $_POST['lng'], true);
			espcms_log_install('article_pack-espcms_article_type_button_add_type', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_add_save_ok_message', 'true', array($_POST['typename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editArticleType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$tid = $_POST['tid'];
			if (empty($tid) || !espcms_ismatches($tid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			$lng = AdminPublicDB::get_lancode();
			$db_where = "WHERE tid=$tid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			if ($read['upid'] != $_POST['upid'] && $read['upid']) {
				$uptype_read = ESPCMS_ArticleTypeDB::get_article_type_view($_POST['upid']);
				$_POST['topid'] = $uptype_read['topid'] ? $uptype_read['topid'] : $_POST['upid'];
			}
			unset($_POST['mid']);
			unset($_POST['pid']);
			unset($_POST['ismenu']);
			unset($_POST['isaccessory']);
			unset($_POST['isclass']);
			$_POST['pageclass'] = !espcms_ismatches($_POST['pageclass']) ? $read['ispart'] : $_POST['pageclass'];
			$_POST['pagemax'] = !espcms_ismatches($_POST['pagemax']) ? $read['ispart'] : $_POST['pagemax'];
			$_POST['ispart'] = !espcms_ismatches($_POST['ispart']) ? $read['ispart'] : $_POST['ispart'];
			$_POST['ordertype'] = !espcms_ismatches($_POST['ordertype']) ? $read['ordertype'] : $_POST['ordertype'];
			$_POST['isorderby'] = !espcms_ismatches($_POST['isorderby']) ? $read['isorderby'] : $_POST['isorderby'];
			$_POST['gotoid'] = !espcms_ismatches($_POST['gotoid']) ? 0 : $_POST['gotoid'];
			$_POST['content'] = $_POST['content'] ? espcms_t2h($_POST['content']) : '';
			$_POST['isline'] = $infotype == 'link' && espcms_ismatches($_POST['isline']) ? $_POST['isline'] : 0;
			if ($read['styleid'] != 3) {
				if (!$_POST['isdir'] && !preg_match("/^[\w]+/", $_POST['dirname'])) {
					espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false');
				} elseif ($read['dirname'] != $_POST['dirname'] && !$_POST['isdir'] && preg_match("/^[\w]+/", $_POST['dirname']) && self::verifyArticleTypeDB('dirname', $_POST['dirname'], $tid)) {
					espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_dirname_warning_msg', 'false');
				} elseif ((espcms_ismatches($_POST['isdir']) && $_POST['isdir'] && $read['typename'] != $_POST['typename']) || (!$read['isdir'] && $_POST['isdir'])) {
					$dirname = ESPCMS_PY::getFullSpell($_POST['typename'], '_');
					$_POST['dirname'] = !self::verifyArticleTypeDB('dirname', $dirname, $tid) ? $dirname : $dirname . '_' . time();
				}
			} else {
				$_POST['gotoline'] = espcms_ismatches($_POST['gotoline']) && !$_POST['isline'] ? $_POST['gotoline'] : 0;
				$_POST['typeurl'] = $_POST['typeurl'] && $_POST['isline'] ? $_POST['typeurl'] : '';
			}
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if (!$postvalue || !is_array($postvalue)) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
			if (!$update_id) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			if ($read['upid'] != $_POST['upid'] && $read['upid']) {
				$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
				if (is_array($tid_array) && count($tid_array) > 0) {
					$tid_list = implode(',', array_keys($tid_array));
					$last_db_where = count($tid_array) > 1 ? " WHERE tid IN($tid_list)" : " WHERE tid=$tid_list";
					$last_update = espcms_db_update_set_save($db_table, $last_db_where, 'topid=' . $_POST['topid']);
					if ($last_update) {
						foreach ($tid_array as $key => $value) {
							$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $key);
						}
					}
				}
			}
			if (is_array($_POST['type_bat_edit']) && count($_POST['type_bat_edit']) > 0) {
				$loast_update_post = array();
				foreach ($_POST['type_bat_edit'] as $key => $value) {
					$loast_update_post[$value] = $_POST[$value];
				}
				$tid_array = is_array($tid_array) ? $tid_array : ArticleTypeDB::get_article_type_listDB($tid, $lng);
				if (is_array($tid_array) && count($tid_array) > 0 && is_array($loast_update_post)) {
					$tid_list = implode(',', array_keys($tid_array));
					$last_update_postvalue = espcms_post($loast_update_post, $talbe_field_array, true);
					$last_db_where = count($tid_array) > 1 ? " WHERE tid IN($tid_list)" : " WHERE tid=$tid_list";
					$last_update = espcms_db_update_save($db_table, $last_db_where, $last_update_postvalue);
					if ($last_update) {
						foreach ($tid_array as $key => $value) {
							$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $key);
						}
					}
				}
			}
			$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $tid);
			$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $read['lng'], true);
			espcms_log_install('article_pack-espcms_article_type_button_edit', $_POST['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_edit_save_ok_message', 'true', array($_POST['typename']));
		} elseif ($saveType == 'shift') {
			if (!ESPCMS_AdminAuthority::authorityVerify('shiftArticleType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$tid = $_POST['tid'];
			$shift_tid = $_POST['shift_tid'];
			if (empty($tid) || !espcms_ismatches($tid) || empty($shift_tid) || !espcms_ismatches($shift_tid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			$lng = AdminPublicDB::get_lancode();
			$db_where = "WHERE tid=$tid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			$db_where_shift = "WHERE tid=$shift_tid";
			$read_shift = espcms_db_read($db_table, $db_where_shift, $talbe_field_array);
			if (!$read_shift) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($shift_tid));
			}
			if ($read['mid'] != $read_shift['mid'] || $read['lng'] != $read_shift['lng'] || $tid == $shift_tid) {
				espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_type_shift_err1', 'false', array($shift_tid));
			}
			$update_key = espcms_db_update_set_save($db_table_document, $db_where, "tid=$shift_tid");
			if (!$update_key) {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('article_pack-espcms_article_type_button_shift', $read['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_shift_ok', 'true', array($read_shift['typename']));
		} elseif ($saveType == 'synchronization') {
			if (!ESPCMS_AdminAuthority::authorityVerify('synArticleType')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
			$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
			$db_table_document_album = ESPCMS_DB_PREFIX . "document_album";
			$tid = $_POST['tid'];
			$syn_tid = $_POST['syn_tid'];
			if (empty($tid) || !espcms_ismatches($tid) || empty($syn_tid) || !espcms_ismatches($syn_tid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			$lng = $_POST['lng'];
			$db_where = "WHERE tid=$tid";
			$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
			if (!$read) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
			}
			$db_where_syn = "WHERE tid=$syn_tid";
			$read_syn = espcms_db_read($db_table, $db_where_syn, $talbe_field_array);
			if (!$read_syn) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($syn_tid));
			}
			if ($read['mid'] != $read_syn['mid'] || $tid == $syn_tid) {
				espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_type_syn_err', 'false', array($syn_tid));
			}
			$install_key = 0;
			$talbe_field_document = espcms_field_out($db_table_document, false, true);
			$talbe_field_document_install = espcms_field_out($db_table_document, true);
			$talbe_field_document_content_install = espcms_field_out($db_table_document_content, true);
			$talbe_field_document_attr_install = espcms_field_out($db_table_document_attr, true);
			$talbe_field_document_album_install = espcms_field_out($db_table_document_album, true);
			$db_sql = "SELECT $talbe_field_document FROM $db_table_document WHERE tid=$tid ORDER BY did ASC";
			$db_query = $espcms_link_db->db_query($db_sql);
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$did = $fetch_row['did'];
				$fetch_row['lng'] = $lng;
				$fetch_row['tid'] = $syn_tid;
				$fetch_row['extid'] = '';
				$fetch_row['sid'] = 0;
				$fetch_row['fgid'] = 0;
				$fetch_row['linkdid'] = '';
				$fetch_row['filename'] = '';
				$fetch_row['addtime'] = time();
				$fetch_row['uptime'] = 0;
				$postvalue_document = espcms_post($fetch_row, $talbe_field_document_install, true, true);
				if (!$postvalue_document || !is_array($postvalue_document)) {
					continue;
				}
				$install_id = espcms_db_install_save($db_table_document, $postvalue_document);
				if (!$install_id) {
					continue;
				}
				$content = ESPCMS_ArticleDB::get_article_content_read($did, 'content');
				$install_str = array();
				if ($content) {
					$install_str['did'] = $install_id;
					$install_str['content'] = $content;
					$postvalue_document_content = espcms_post($install_str, $talbe_field_document_content_install, true, true);
					if (is_array($postvalue_document_content)) {
						espcms_db_install_save($db_table_document_content, $postvalue_document_content);
					}
				}
				$attr_list_read = ESPCMS_ArticleDB::get_article_attr_read($did);
				if (is_array($attr_list_read)) {
					$attr_list_read['did'] = $install_id;
					$postvalue_document_attr = espcms_post($attr_list_read, $talbe_field_document_attr_install, true, true);
					if (is_array($postvalue_document_attr)) {
						espcms_db_install_save($db_table_document_attr, $postvalue_document_attr);
					}
				}
				$album_list = ESPCMS_ArticleDB::get_document_album_list($did);
				if (is_array($album_list) && count($album_list) > 0) {
					$album_install_array = array();
					foreach ($album_list as $key => $value) {
						$value['did'] = $install_id;
						$album_install_array[] = espcms_post($value, $talbe_field_document_album_install, true, true);
					}
					if (is_array($album_install_array)) {
						espcms_db_install_array_save($db_table_document_album, $album_install_array);
					}
				}
				$install_key++;
			}
			espcms_log_install('article_pack-espcms_article_type_button_synchronization', $read['typename']);
			espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_syn_ok', 'true', array($read_syn['typename']));
		}
	}

	public static function sortArticleType() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleType')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$lng = AdminPublicDB::get_lancode();
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$talbe_field_array = espcms_field_out($db_table, true);
		$tid = $_POST['tid'];
		if (empty($tid) || !espcms_ismatches($tid)) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
		}
		$db_where = "WHERE tid=$tid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
		}
		unset($_POST['lng']);
		unset($_POST['mid']);
		unset($_POST['tid']);
		unset($_POST['topid']);
		unset($_POST['upid']);
		unset($_POST['linkid']);
		unset($_POST['gotoid']);
		unset($_POST['styleid']);
		unset($_POST['ispart']);
		unset($_POST['isclass']);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
		}
		$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $lng, true);
		$read['typename'] = espcms_cutstr($read['typename'], 10);
		espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_sort_message', 'true', array($read['typename']));
	}

	public static function batsetArticleType() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleType')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$lng = AdminPublicDB::get_lancode();
		$select_id = $_POST['select_id'];
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_count = 0;
		foreach ($select_id as $key => $value) {
			if (!espcms_ismatches($value)) {
				continue;
			}
			$update_key = espcms_db_update_set_save($db_table, "WHERE tid=$value", "$field='$field_value'");
			if ($update_key) {
				$update_count++;
				$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $value);
			}
			if ($field == 'ismenu' && $value) {
				$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($value);
				NevigateDB::nevigat_install($type_read, $lng, 'type');
			}
		}
		$set_info_id = implode(', ', $select_id);
		$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $lng, true);
		espcms_log_install('article_pack-espcms_article_type_button_set', "$field=$field_value" . " tid=" . $set_info_id);
		espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_type_set_message', 'true', array($field));
	}

	public static function setArticleType() {
		global $espcms_db_cache;
		$lng = AdminPublicDB::get_lancode();
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticleType')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$tid = $_POST['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
		}
		$field = $_POST['field'];
		$field_value = $_POST['field_value'];
		if (!$field || !espcms_ismatches($field_value)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($field));
		}
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$talbe_field_array = espcms_field_out($db_table, true);
		$isavlue = false;
		foreach ($talbe_field_array as $key => $value) {
			if ($value['Field'] == $field) {
				$isavlue = true;
			}
		}
		if (!$isavlue) {
			espcms_public_dialog('info_set_err', 'db_pack-espcms_db_field_fail', 'false', array($field));
		}
		$update_key = espcms_db_update_set_save($db_table, "WHERE tid=$tid", "$field='$field_value'");
		if ($update_key) {
			$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $tid);
			$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $lng, true);
		}
		if ($field == 'ismenu' && $value) {
			$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($tid);
			NevigateDB::nevigat_install($type_read, $lng, 'type');
		}
		espcms_log_install('article_pack-espcms_article_type_button_set', "$field=$field_value" . " tid=" . $tid);
		espcms_public_dialog('info_set_ok', 'article_pack-espcms_article_type_set_message', 'true', array($field));
	}

	public static function delArticleType() {
		global $espcms_db_cache;
		$lng = AdminPublicDB::get_lancode();
		$tid = $_POST['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_input_parameter_fail', 'false', array($tid));
		}
		$espcms_del_return = self::delArticleTypeDB($tid);
		if ($espcms_del_return) {
			$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $tid);
			$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $lng, true);
		}
		espcms_log_install('article_pack-espcms_article_type_button_del', $espcms_del_return['key']);
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_type_del_message', 'true', array(), 'json', $espcms_del_return['key']);
	}

	public static function batdelArticleType() {
		global $espcms_db_cache;
		if (!ESPCMS_AdminAuthority::authorityVerify('delArticleType')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$lng = AdminPublicDB::get_lancode();
		$select_id = $_POST['select_id'];
		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}
		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delArticleTypeDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_db_cache->cacheDEL(self::$document_typelist_list_cache_key . $lng, true);
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('article_pack-espcms_article_type_button_del', $espcms_del_id);
		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_type_del_message', 'true', array(), 'json', $return);
	}

	private static function delArticleTypeDB($tid = 0) {
		global $espcms_db_cache;
		if (!$tid || !espcms_ismatches($tid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $tid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$db_table_document = ESPCMS_DB_PREFIX . "document";
		$db_table_document_album = ESPCMS_DB_PREFIX . "document_album";
		$db_table_document_attr = ESPCMS_DB_PREFIX . "document_attr";
		$db_table_document_content = ESPCMS_DB_PREFIX . "document_content";
		$lng = AdminPublicDB::get_lancode();
		$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
		$tid_list = implode(',', array_keys($tid_array));
		$db_where = is_array($tid_array) && count($tid_array) > 1 ? " tid IN ($tid_list)" : " tid=$tid_list";
		espcms_db_delall($db_table_document_content, "did IN (SELECT did FROM $db_table_document WHERE $db_where)");
		espcms_db_delall($db_table_document_attr, "did IN (SELECT did FROM $db_table_document WHERE $db_where)");
		espcms_db_delall($db_table_document_album, "did IN (SELECT did FROM $db_table_document WHERE $db_where)");
		espcms_db_delall($db_table_document, $db_where);
		if (espcms_db_delall($db_table, $db_where)) {
			foreach ($tid_array as $value) {
				$espcms_db_cache->cacheDEL(self::$document_typelist_read_cache_key . $value['tid']);
			}
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $tid_list);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $tid_list);
			return $return_array;
		}
	}

	public static function resortArticleType() {
		if (!ESPCMS_AdminAuthority::authorityVerify('editArticle')) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
		}
		$tid = $_POST['tid'];
		if (!$tid || !espcms_ismatches($tid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $tid);
			return $return_array;
		}
		$lng = AdminPublicDB::get_lancode();
		$tid_array = ArticleTypeDB::get_article_type_listDB($tid, $lng);
		if (!is_array($tid_array) || count($tid_array) < 1) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $tid);
			return $return_array;
		}
		$tid_list = implode(',', array_keys($tid_array));
		$db_where = is_array($tid_array) && count($tid_array) > 1 ? "WHERE tid IN ($tid_list)" : "WHERE tid=$tid_list";
		$db_table = ESPCMS_DB_PREFIX . "document";
		$update_key = espcms_db_update_set_save($db_table, $db_where, "pid=50");
		if (!$update_key) {
			espcms_public_dialog('espcms_public_dialog', 'article_pack-espcms_article_type_resort_no', 'false');
		}
		espcms_log_install('article_pack-espcms_article_type_resort', $tid);
		espcms_public_dialog('espcms_info_save_ok', 'article_pack-espcms_article_type_resort_ok', 'true', array($tid));
	}

	public static function verifyArticleType() {
		$verifyKey = $_REQUEST['verify_key'];
		$verifyValue = $_REQUEST['verify_value'];
		$verifyType = $_REQUEST['verifyType'];
		$tid = $_REQUEST['tid'];
		$db_num = self::verifyArticleTypeDB($verifyKey, $verifyValue, $tid, $verifyType) ? '1' : '0';
		exit($db_num);
	}

	private static function verifyArticleTypeDB($verifyKey, $verifyValue, $tid = 0, $verifyType = false) {
		$field_array = array('dirname');
		if (!isset($verifyKey) && !in_array($verifyKey, $field_array)) {
			return true;
		}
		$lng = AdminPublicDB::get_lancode();
		$db_table = ESPCMS_DB_PREFIX . "document_typelist";
		$db_table_document_subjectlist = ESPCMS_DB_PREFIX . "document_subjectlist";
		$db_where = " AND lng='$lng'";
		$type_db_num = espcms_db_num($db_table_document_subjectlist, " AND lng='$lng' AND dirname='$verifyValue'");
		if ($type_db_num > 0) {
			return true;
		}
		if (empty($tid) || !espcms_ismatches($tid)) {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue'" : " AND $verifyKey='$verifyValue'";
		} else {
			$db_where .= $verifyType ? " AND $verifyKey!='$verifyValue' AND tid!=$tid" : " AND $verifyKey='$verifyValue' AND tid!=$tid";
		}
		$db_num = espcms_db_num($db_table, $db_where);
		return $db_num > 0 ? true : false;
	}

}
