<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\AdminPublicDB;
use admin_application\link\MenuLink;
use admin_application\link\ArticleLink;
use inc_application\link\ArticleLink AS ArticleLinkWeb;

class ArticleWidget {

	private static $mothodName;

	public function __construct() {
		ESPCMS_AdminAuthority::authorityBaseVerify(true);
		self::$mothodName = 'ArticleMain';
	}

	public static function widgetOutput() {
		$espcms_widget_templates = espcms_admin_template();
		$espcms_widget_templates->libfile = true;
		$widget_read = ESPCMS_Core::get_widget_view(0, self::$mothodName);
		$widget_read['link'] = MenuLink::getLink('link', $widget_read);
		$widget_read['ajaxlink'] = MenuLink::getLink('ajaxlink', $widget_read);
		$espcms_widget_templates->into('widget_read', $widget_read);
		$output = $espcms_widget_templates->fetch('article/article_widget');
		return $output;
	}

	public static function widgetList() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "document";
		$lng = AdminPublicDB::get_lancode();

		define("ESPCMS_CREAT", $lng);
		$db_where = " AND isbase=0 AND lng='$lng'";
		$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, 'did', 'DESC', 0, 5));
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$fetch_row['titlecode'] = urlencode($fetch_row['title']);
			$fetch_row['view'] = ArticleLinkWeb::doc_link($fetch_row, true, false,$fetch_row['lng']);
			$fetch_row['edit'] = ArticleLink::Article_Main_link_array('edit', $fetch_row);
			$array[] = $fetch_row;
		}
		$espcms_admin_templates->into('array', $array);
		$espcms_admin_templates->output('article/article_widget_list');
	}

}
