<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use admin_application\ArticleModelDB;
use admin_application\AdminPublicDB;
use admin_application\link\CreateMainLink;

class CreateHtmlWeb {

	public function __construct() {
		$exclude_method = array('saveCreateHtmlSpecial', 'loadCreateWindow');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function indexBase() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$lng = AdminPublicDB::get_lancode();
		$lng_array = ESPCMS_Core::get_lan_list($lng, false);
		$espcms_admin_templates->into('lng_array', $lng_array);
		$espcms_admin_templates->into('link', CreateMainLink::CreateBatch_link_array());
		$espcms_admin_templates->output('create/create_batch');
	}

	public static function loadCreateWindow() {
		global $espcms_admin_templates;
		if (!$_GET['lng'] || !preg_match("/^[a-z0-9]{2,50}$/i", $_GET['lng'])) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($_GET['lng']));
		}
		$espcms_admin_templates->into('lng', $_GET['lng']);
		$model_list = ArticleModelDB::get_model_list();
		if (is_array($model_list)) {
			$mid_list = implode('_', espcms_array_findkey($model_list, 'mid'));
		}
		$createtimetype = espcms_ismatches($_GET['createtimetype']) ? $_GET['createtimetype'] : 0;
		$espcms_admin_templates->into('mid_list', $mid_list);
		$espcms_admin_templates->into('createtimetype', $createtimetype);
		$espcms_admin_templates->into('createtime', espcms_isdata($_GET['createtime']) && $createtimetype ? strtotime($_GET['createtime']) : 0);
		$espcms_admin_templates->into('createrang', espcms_ismatches($_GET['createrang']) ? $_GET['createrang'] : 0);
		$espcms_admin_templates->into('home_link', CreateMainLink::CreateIndex_link_array());
		$espcms_admin_templates->into('doc_link', CreateMainLink::CreateArticle_link_array());
		$espcms_admin_templates->into('type_link', CreateMainLink::CreateType_link_array());
		$espcms_admin_templates->into('sub_link', CreateMainLink::CreateSpecial_link_array());
		$espcms_admin_templates->output('create/create_batch_load');
	}

}
