<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/



use application\ESPCMS_AdminAuthority;
use admin_application\link\SettingLink;

class SiteGroup {

	public function __construct() {
		$exclude_method = array('saveSiteGroup');
		ESPCMS_AdminAuthority::authorityAdminVerify($exclude_method);
	}

	public static function listSiteGroup() {
		global $espcms_admin_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . "site";
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$out_type = $_REQUEST['out_type'];
		if ($out_type == 'list') {

			$limit = $_REQUEST['limit'] && espcms_ismatches($_REQUEST['limit']) ? $_REQUEST['limit'] : 0;

			$per_page_num = $_REQUEST['per_page_num'] && espcms_ismatches($_REQUEST['per_page_num']) ? $_REQUEST['per_page_num'] : 10;

			$searchlist = $_GET['searchlist'];
			if ($searchlist == 'true') {
				exit(espcms_page_db($db_table, $db_where, true));
			}

			$sort_key = $_REQUEST['sort_key'];
			$sort_key_array = array('slid');
			if (isset($sort_key) && in_array($sort_key, $sort_key_array)) {
				$order_key = $sort_key;
			} else {
				$order_key = "slid";
			}

			$sort_rank = $_REQUEST['sort_rank'];
			$sort_rank_array = array('ASC', 'DESC');
			if (isset($sort_rank) && in_array($sort_rank, $sort_rank_array)) {
				$order_rank = $sort_rank;
			} else {
				$order_rank = "DESC";
			}
			$db_query = $espcms_link_db->db_query(espcms_db_list_out($db_table, $db_where, $order_key, $order_rank, $limit, $per_page_num));
			while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
				$fetch_row['edit'] = SettingLink::SiteGroup_link_array('edit', $fetch_row);
				$array[] = $fetch_row;
			}
			$espcms_admin_templates->into('array', $array);
			$templates = 'admin/site_group_list';
		} else {
			$espcms_admin_templates->into('page_db', espcms_page_db($db_table, $db_where));
			$espcms_admin_templates->into('link', SettingLink::SiteGroup_link_array(false, $_REQUEST));
			$templates = 'admin/site_group_index';
		}
		$espcms_admin_templates->output($templates);
	}

	public static function addSiteGroup() {
		global $espcms_admin_templates;
		$admin_member_id = ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id');
		if (empty($admin_member_id) || !espcms_ismatches($admin_member_id)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($admin_member_id));
		}
		$espcms_admin_templates->into('link', SettingLink::SiteGroup_link_array());

		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/site_group_add');
	}

	public static function editSiteGroup() {
		global $espcms_admin_templates;
		$slid = $_GET['slid'];
		if (!$slid || !espcms_ismatches($slid)) {
			espcms_message_err('public_pack-espcms_input_parameter_fail', array($slid));
		}
		$db_table = ESPCMS_DB_PREFIX . "site";
		$db_where = " WHERE slid=$slid";
		$talbe_field_array = espcms_field_out($db_table, false);
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			espcms_message_err('db_pack-espcms_db_read_fail', array($db_where));
		}
		$espcms_admin_templates->into('read', $read);
		$espcms_admin_templates->into('link', SettingLink::SiteGroup_link_array());

		$espcms_admin_templates->into('token', token());
		$espcms_admin_templates->output('admin/site_group_edit');
	}

	public static function saveSiteGroup() {

		if (!is_token($_POST['token_name'], $_POST['token_key'])) {
			espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_repeat_fail', 'false', array($_POST['token_name']));
		}
		$saveType = $_POST['savetype'] ? $_POST['savetype'] : 'add';

		$db_table = ESPCMS_DB_PREFIX . "site";
		$talbe_field_array = espcms_field_out($db_table, true);
		if ($saveType == 'add') {
			if (!ESPCMS_AdminAuthority::authorityVerify('addSiteGroup')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}

			$_POST['addtime'] = time();

			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue) {
				$install_id = espcms_db_install_save($db_table, $postvalue);
				if (!$install_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {
				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('setting_pack-espcms_site_group_button_add', $_POST['sitename']);
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_site_group_add_save_ok_message', 'true', array($_POST['sitename']));
		} elseif ($saveType == 'edit') {
			if (!ESPCMS_AdminAuthority::authorityVerify('editSiteGroup')) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_authority_function_fail', 'false');
			}
			$slid = $_POST['slid'];
			if (empty($slid) || !espcms_ismatches($slid)) {
				espcms_public_dialog('espcms_public_dialog', 'public_pack-espcms_input_parameter_fail', 'false', array($slid));
			}
			$db_where = "WHERE slid=$slid";
			$postvalue = espcms_post($_POST, $talbe_field_array, true);
			if ($postvalue && is_array($postvalue)) {
				$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);

				if (!$update_id) {
					espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
				}
			} else {

				espcms_public_dialog('espcms_public_dialog', 'db_pack-espcms_db_install_fail', 'false');
			}
			espcms_log_install('setting_pack-espcms_site_group_button_edit', $_POST['sitename']);

			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_site_group_edit_save_ok_message', 'true', array($_POST['sitename']));
		}
	}

	public static function delSiteGroup() {
		$select_id = $_POST['select_id'];

		if (!is_array($select_id) || count($select_id) <= 0) {
			espcms_public_dialog('info_set_err', 'public_pack-espcms_select_err', 'false', array($select_id));
		}

		$delcount = 0;
		foreach ($select_id as $value) {
			$operate_result = self::delSiteGroupDB($value);
			if ($operate_result['code'] == 'true') {
				$delcount++;
			}
		}
		$espcms_del_id = implode(', ', $select_id);
		espcms_log_install('setting_pack-espcms_site_group_button_del', $espcms_del_id);

		$return['count'] = $delcount;
		espcms_public_dialog('espcms_public_dialog', 'setting_pack-espcms_site_group_del_message', 'true', array(), 'json', $return);
	}

	public static function delSiteGroupDB($slid = 0) {
		if (!$slid || !espcms_ismatches($slid)) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $slid);
			return $return_array;
		}
		$db_table = ESPCMS_DB_PREFIX . "site";
		$talbe_field_array = espcms_field_out($db_table, true);
		$db_where = " WHERE slid=$slid";
		$read = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read) {
			$return_array = array('lan' => 'public_pack-espcms_input_parameter_fail', 'code' => 'false', 'key' => $slid);
			return $return_array;
		}
		$del_query = espcms_db_del($db_table, 'slid', $slid);
		if ($del_query) {
			$return_array = array('lan' => 'public_pack-espcms_del_ok', 'code' => 'true', 'key' => $slid);
			return $return_array;
		} else {
			$return_array = array('lan' => 'public_pack-espcms_del_err', 'code' => 'false', 'key' => $slid);
			return $return_array;
		}
	}

}
