<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
 */

namespace admin_application;

class NevigateDB {

	public static function lastPidNevigate($lng = false, $return_key = false) {
		$db_where = "WHERE lng='$lng' ORDER BY nevigate_pid DESC LIMIT 0,1";
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function nevigat_type_install($nevigate_id, $nev_read, $type_read, $lng) {
		if (!espcms_ismatches($nevigate_id) || !$nevigate_id || !is_array($nev_read) || !is_array($type_read)) {
			return false;
		}
		if (!espcms_ismatches($type_read['tid']) || !$type_read['tid']) {
			return false;
		}
		if ($type_read['styleid'] == 3 && !$type_read['isline'] && !espcms_isurl($type_read['typeurl'])) {
			return false;
		}
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "nevigate";
		$talbe_field_array = espcms_field_out($db_table, true);

		$db_where = "WHERE nevigate_uid=$nevigate_id AND nevigate_linkid=" . $type_read['tid'];
		$read_info = espcms_db_read($db_table, $db_where, 'nevigate_id,nevigate_name', true);
		if ($read_info) {
			return false;
		}

		$nevigate_pid = self::lastPidNevigate($lng, 'nevigate_pid');
		$install_post = array();
		$install_post['nevigate_pid'] = espcms_ismatches($nevigate_pid) ? $nevigate_pid + 1 : 0;
		$install_post['nevigate_topid'] = $nev_read['nevigate_topid'] && espcms_ismatches($nev_read['nevigate_topid']) ? $nev_read['nevigate_topid'] : $nevigate_id;
		$install_post['nevigate_uid'] = $nevigate_id;
		$install_post['lng'] = $lng;
		$install_post['nevigate_name'] = addslashes($type_read['typename']);
		$install_post['nevigate_linkid'] = $type_read['tid'];
		$install_post['nevigate_modul'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? 'link' : 'type';
		$install_post['nevigate_url'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? $type_read['typeurl'] : '';
		$install_post['nevigate_linktype'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? 2 : 1;
		$install_post['nevigate_target'] = 0;
		$install_post['nevigate_ismenu'] = 1;
		$install_post['nevigate_iswap'] = 1;
		$install_post['nevigate_isaccessory'] = 0;

		$install_array[] = espcms_post($install_post, $talbe_field_array, true, true);
		if (is_array($install_array)) {
			$install_id = espcms_db_install_array_save($db_table, $install_array);
		} else {
			$install_id = false;
		}
		return $install_id;
	}

	public static function nevigat_install($type_read, $lng, $nevigate_modul = 'type') {
		global $espcms_db_cache;
		if (!is_array($type_read) || !$type_read['typename']) {
			return false;
		}
		if (!espcms_ismatches($type_read['tid']) || !$type_read['tid']) {
			return false;
		}
		if ($type_read['styleid'] == 3 && !$type_read['isline'] && !espcms_isurl($type_read['typeurl'])) {
			return false;
		}
		if (!$lng || !preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
			return false;
		}
		if (!$nevigate_modul || !preg_match("/^[\w]{2,50}$/i", $nevigate_modul)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "nevigate";

		$db_where = "WHERE nevigate_uid=0 AND nevigate_linkid=" . $type_read['tid'] . " AND nevigate_modul='$nevigate_modul'";
		$nevigate_read = espcms_db_read($db_table, $db_where, 'nevigate_id,nevigate_name', true);
		if ($nevigate_read) {
			return false;
		}
		$nevigate_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'nevigate_';
		$talbe_field_array = espcms_field_out($db_table, true);

		if (!$nevigate_read['nevigate_id']) {

			$nevigate_pid = self::lastPidNevigate($lng, 'nevigate_pid');
			$install_post = array();
			$install_post['nevigate_pid'] = espcms_ismatches($nevigate_pid) ? $nevigate_pid + 1 : 0;
			$install_post['nevigate_topid'] = 0;
			$install_post['nevigate_uid'] = 0;
			$install_post['lng'] = $lng;
			$install_post['nevigate_name'] = addslashes($type_read['typename']);
			$install_post['nevigate_linkid'] = $type_read['tid'];
			$install_post['nevigate_modul'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? 'link' : 'type';
			$install_post['nevigate_url'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? $type_read['typeurl'] : '';
			$install_post['nevigate_linktype'] = $type_read['styleid'] == 3 && $type_read['isline'] && espcms_isurl($type_read['typeurl']) ? 2 : 1;
			$install_post['nevigate_target'] = 0;
			$install_post['nevigate_ismenu'] = 1;
			$install_post['nevigate_iswap'] = 1;
			$install_post['nevigate_isaccessory'] = 0;

			$install_array[] = espcms_post($install_post, $talbe_field_array, true, true);
			if (is_array($install_array)) {
				$install_id = espcms_db_install_array_save($db_table, $install_array);
				$espcms_db_cache->cacheDEL($nevigate_list_cache_key, true);
			} else {
				$install_id = false;
			}
		}
		return $install_id;
	}

	public static function nevigat_del($nevigate_linkid, $nevigate_modul = 'article') {
		global $espcms_db_cache;
		if (!espcms_ismatches($nevigate_linkid) || !$nevigate_linkid) {
			return false;
		}
		if (!$nevigate_modul || !preg_match("/^[\w]{2,50}$/i", $nevigate_modul)) {
			return false;
		}
		$db_table = ESPCMS_DB_PREFIX . "nevigate";
		$nevigate_list_cache_key = ESPCMS_CACHE_DBLIST_NAME . ESPCMS_DB_PREFIX . 'nevigate_';
		$db_where = "nevigate_linkid=$nevigate_linkid AND nevigate_modul='$nevigate_modul'";
		$read = self::get_nevigat_view($nevigate_linkid, $nevigate_modul);
		if (!$read) {
			return false;
		}
		$delid = espcms_db_delall($db_table, $db_where);

		$espcms_db_cache->cacheDEL($nevigate_list_cache_key . $read['lng'], true);
		return $delid;
	}

	public static function get_nevigat_view($nevigate_linkid = 0, $nevigate_modul = 'article', $return_key = false) {
		if (!espcms_ismatches($nevigate_linkid) || !preg_match("/^[\w]{2,50}$/i", $nevigate_modul)) {
			return false;
		}
		$db_where = "WHERE nevigate_linkid=$nevigate_linkid AND nevigate_modul='$nevigate_modul'";
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_nevigat_lng_view($lng = false, $nevigate_modul = 'article', $return_key = false) {
		if (!$lng || !preg_match("/^[\w]{2,50}$/i", $nevigate_modul)) {
			return false;
		}
		$db_where = "WHERE lng='$lng' AND nevigate_modul='$nevigate_modul'";
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

	public static function get_nevigate_id_view($nevigate_id = 0, $return_key = false) {
		if (!espcms_ismatches($nevigate_id) || !$nevigate_id) {
			return false;
		}
		$db_where = "WHERE nevigate_id=$nevigate_id";
		$db_table = ESPCMS_DB_PREFIX . 'nevigate';
		$talbe_field_array = espcms_field_out($db_table, false);
		$read_info = espcms_db_read($db_table, $db_where, $talbe_field_array);
		if (!$read_info) {
			return false;
		}
		return !$return_key ? $read_info : $read_info[$return_key];
	}

}
