<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

namespace application;

class ESPCMS_PhotoDownLoad {

	public static function download($donwfile = false, $method = 'curl', $savapath = false, $save_dirname = false, $isfilename = false) {
		global $espcms_command;
		if (!$donwfile || !preg_match("/^((https|http|ftp|rtsp|mms)?:\/\/)[^\s]+$/i", $donwfile)) {
			return false;
		}
		$info = getimagesize($donwfile);
		if (!$info) {
			return false;
		}
		$mime = $info['mime'];
		$photo_type = $info[2];
		if (!espcms_ismatches($photo_type) || $photo_type > 3) {
			return false;
		}
		if ($savapath) {
			$saveDIR = $savapath;
		} else {
			$saveDIR = $espcms_command['UPFILE_SAVAPATH'] ? $espcms_command['UPFILE_SAVAPATH'] : 'upfile/';
		}
		if ($save_dirname) {
			$saveDIR = $saveDIR . $save_dirname . '/';
		} else {
			switch ($espcms_command['UPFILE_SAVEDIR']) {
				case 'y':
					$saveDIR = $saveDIR . date("Y") . '/' . date("m") . '/' . date("d") . '/';
					break;
				case 'd':
					$saveDIR = $saveDIR . date("Y") . '/' . date("m") . date("d") . '/';
					break;
				case 'm':
					$saveDIR = $saveDIR . date("Y") . date("m") . date("d") . '/';
					break;
				case 'm1':
					$saveDIR = $saveDIR . date("Y") . date("m") . '/';
					break;
				case 'm2':
					$saveDIR = $saveDIR . date("Y") . '/';
					break;
				case 'm3':
					$saveDIR = $saveDIR . date("Y") . '/' . date("m") . '/';
					break;
			}
		}
		$savePath = ESPCMS_FILE_ROOT . $saveDIR;
		if (!is_dir($savePath)) {
			if (!@mkdir($savePath, 0777, true)) {
				return false;
			}
		}
		switch ($photo_type) {
			case 1:
				$image_create_func = 'ImageCreateFromGIF';
				$image_save_func = 'ImageGIF';
				$file_extension = 'gif';
				break;
			case 2:
				$image_create_func = 'ImageCreateFromJPEG';
				$image_save_func = 'ImageJPEG';
				$file_extension = 'jpg';
				$quality = 80;
				break;
			case 3:
				$image_create_func = 'ImageCreateFromPNG';
				$image_save_func = 'ImagePNG';
				$file_extension = 'png';
				$quality = 80;
				break;
		}
		switch ($espcms_command['UPFILE_FORMATFILE_TYPE']) {
			case 1 :
				$newFileName = date('YmdHis') . rand(100, 999);
				break;
			case 2:
				$newFileName = md5(uniqid(rand() . microtime()));
				break;
			default:
				$newFileName = md5(uniqid(rand() . microtime()));
				break;
		}
		if ($isfilename) {
			$newFileName = md5(basename($donwfile));
		}
		$saveFileName = $savePath . $newFileName . '.' . $file_extension;
		$img_info['filename'] = basename($donwfile);
		$img_info['extension'] = $file_extension;
		$img_info['upfiletype'] = 'image';
		$img_info['upLoadFileName_nopath'] = $newFileName . '.' . $file_extension;
		$img_info['path'] = $saveDIR;
		$img_info['mime'] = $mime;
		$img_info['iswidth'] = $info[0] > $info[1] ? 1 : 2;
		$img_info['filepathALL'] = $saveDIR . $newFileName . '.' . $file_extension;
		$img_info['error'] = 0;
		if ($method == 'curl') {
			$save_image = self::LoadImageCURL($donwfile, $saveFileName);
		} elseif ($method == 'gd') {
			$img = $image_create_func($donwfile);
			if (isSet($quality)) {
				$save_image = $image_save_func($img, $saveFileName, $quality);
			} else {
				$save_image = $image_save_func($img, $saveFileName);
			}
		}
		$img_info['url'] = ESPCMS_URL_RT . str_replace(ESPCMS_FILE_ROOT, '', $saveFileName);
		$img_info['size'] = filesize($saveFileName);
		return $img_info;
	}

	private static function LoadImageCURL($download, $saveFileName) {
		$ch = curl_init($download);
		$fp = fopen($saveFileName, "wb");
		$options = array(CURLOPT_FILE => $fp,
		    CURLOPT_HEADER => 0,
		    CURLOPT_FOLLOWLOCATION => 1,
		    CURLOPT_TIMEOUT => 60);
		curl_setopt_array($ch, $options);
		curl_exec($ch);
		curl_close($ch);
		fclose($fp);
	}

}
