<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;

function espcms_load_constant() {
	if (!defined('ESPCMS_ADMIN_RUN_MODULE')) {
		define('ESPCMS_ADMIN_RUN_MODULE', 'Portal/login');
	}
	if (!defined('ESPCMS_WEB_RUN_AC')) {
		define('ESPCMS_WEB_RUN_AC', 'MainLoad');
	}
	if (!defined('ESPCMS_WEB_RUN_AT')) {
		define('ESPCMS_WEB_RUN_AT', 'Portal');
	}
	if (!defined('ESPCMS_SETUP_RUN_AC')) {
		define('ESPCMS_SETUP_RUN_AC', 'Setup');
	}
	if (!defined('ESPCMS_SETUP_RUN_AT')) {
		define('ESPCMS_SETUP_RUN_AT', 'SetupIndex');
	}
	if (!defined('ESPCMS_FUN_PREFIX')) {
		define('ESPCMS_FUN_PREFIX', 'in_');
	}
	if (!defined('ESPCMS_DEBUG')) {
		define('ESPCMS_DEBUG', false);
	}
	if (!defined('ESPCMS_LANG')) {
		define("ESPCMS_LANG", 'zh_CN');
	}
	define('ACTAPPCODE', true);
	if (!defined('ESPCMS_DISPLAY_EER')) {
		define('ESPCMS_DISPLAY_EER', true);
	}
	if (!defined('ESPCMS_DEBUG_LOG')) {
		define('ESPCMS_DEBUG_LOG', false);
	}
	if (!defined('ESPCMS_ISCACHE')) {
		define('ESPCMS_ISCACHE', false);
	}
	if (!defined('ESPCMS_QUERST_ADD')) {
		define('ESPCMS_QUERST_ADD', 'DregA4tGMzwHGhvl4OQDSW++dH1mNe/whkRMb01+9byquZMkff8jD2kaPbexzocK');
	}
	define('ESPCMS_QUERST_ADD_LONG', '25+iCO+h7QQOXLp2OoRlLpcOgqik9w2BKV0Fm2iEykLXBFvIpTZPEblkJYwTHpj22tyEOwm7IGIrn44seVwZeA==');
	define('MINUTE_IN_SECONDS', 60);
	define('HOUR_IN_SECONDS', 60 * MINUTE_IN_SECONDS);
	define('DAY_IN_SECONDS', 24 * HOUR_IN_SECONDS);
	define('WEEK_IN_SECONDS', 7 * DAY_IN_SECONDS);
	define('YEAR_IN_SECONDS', 365 * DAY_IN_SECONDS);
	define('ESPCMS_ADD_ENCODE', '7c9d84a1829cb876fd7bfbd9613b259f');
}

function espcms_server_vars() {
	global $PHP_SELF;
	$default_server_values = array(
	    'SERVER_SOFTWARE' => '',
	    'REQUEST_URI' => '',
	);
	$_SERVER = array_merge($default_server_values, $_SERVER);
	if (empty($_SERVER['REQUEST_URI']) || ( php_sapi_name() != 'cgi-fcgi' && preg_match('/^Microsoft-IIS\//', $_SERVER['SERVER_SOFTWARE']) )) {
		if (isset($_SERVER['HTTP_X_ORIGINAL_URL'])) {
			$_SERVER['REQUEST_URI'] = $_SERVER['HTTP_X_ORIGINAL_URL'];
		} else if (isset($_SERVER['HTTP_X_REWRITE_URL'])) {
			$_SERVER['REQUEST_URI'] = $_SERVER['HTTP_X_REWRITE_URL'];
		} else {
			if (!isset($_SERVER['PATH_INFO']) && isset($_SERVER['ORIG_PATH_INFO'])) {
				$_SERVER['PATH_INFO'] = $_SERVER['ORIG_PATH_INFO'];
			}
			if (isset($_SERVER['PATH_INFO'])) {
				if ($_SERVER['PATH_INFO'] == $_SERVER['SCRIPT_NAME']) {
					$_SERVER['REQUEST_URI'] = $_SERVER['PATH_INFO'];
				} else {
					$_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'] . $_SERVER['PATH_INFO'];
				}
			}
			if (!empty($_SERVER['QUERY_STRING'])) {
				$_SERVER['REQUEST_URI'] .= '?' . $_SERVER['QUERY_STRING'];
			}
		}
	}
	if (isset($_SERVER['SCRIPT_FILENAME']) && ( strpos($_SERVER['SCRIPT_FILENAME'], 'php.cgi') == strlen($_SERVER['SCRIPT_FILENAME']) - 7 )) {
		$_SERVER['SCRIPT_FILENAME'] = $_SERVER['PATH_TRANSLATED'];
	}
	if (strpos($_SERVER['SCRIPT_NAME'], 'php.cgi') !== false) {
		unset($_SERVER['PATH_INFO']);
	}
	$PHP_SELF = $_SERVER['PHP_SELF'];
	if (empty($PHP_SELF)) {
		$_SERVER['PHP_SELF'] = $PHP_SELF = preg_replace('/(\?.*)?$/', '', $_SERVER["REQUEST_URI"]);
	}
	return $_SERVER;
}

function espcms_bug_mode() {
	if (ESPCMS_DEBUG) {
		error_reporting(E_ALL & ~E_NOTICE);
		if (ESPCMS_DISPLAY_EER) {
			ini_set('display_errors', 1);
		} elseif (!ESPCMS_DISPLAY_EER) {
			ini_set('display_errors', 0);
		}
		if (ESPCMS_DEBUG_LOG) {
			ini_set('log_errors', 1);
			ini_set('error_log', ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_debug.log');
		}
	} else {
		error_reporting(E_CORE_ERROR | E_CORE_WARNING | E_COMPILE_ERROR | E_ERROR | E_WARNING | E_PARSE | E_USER_ERROR | E_USER_WARNING | E_RECOVERABLE_ERROR);
	}
	if (defined('XMLRPC_REQUEST')) {
		ini_set('display_errors', 0);
	}
}

function espcms_command() {
	global $espcms_command;
	if (!file_exists(ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_command.php')) {
		if (!ESPCMS_Core::command_creat()) {
			espcms_public_dialog('espcms_info_save_ok', 'setting_pack-espcms_setting_creat_err', 'false', array('/espcms_datacache/espcms_command.php'));
		}
	}
	require_once( ESPCMS_FILE_ROOT . 'espcms_datacache/espcms_command.php' );
}

function espcms_cache_constant() {
	if (!defined('ESPCMS_ISCACHE')) {
		define('ESPCMS_ISCACHE', true);
	}
	if (!defined('ESPCMS_CACHE_TIME')) {
		define('ESPCMS_CACHE_TIME', 60);
	}
	if (!defined('ESPCMS_LANG')) {
		define("ESPCMS_LANG", 'zh_CN');
	}
	if (!defined('ESPCMS_CACHE_FIELD_NAME')) {
		define('ESPCMS_CACHE_FIELD_NAME', 'espcms_field_');
	}
	if (!defined('ESPCMS_CACHE_DBREAD_NAME')) {
		define('ESPCMS_CACHE_DBREAD_NAME', 'espcms_read_');
	}
	if (!defined('ESPCMS_CACHE_DBLIST_NAME')) {
		define('ESPCMS_CACHE_DBLIST_NAME', 'espcms_list_');
	}
}
