<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

function espcms_field_out($tableName, $clear_auto_increment = false, $out_field = false, $ex_field = false) {
	global $espcms_link_db, $espcms_db_cache;
	if (!$tableName) {
		return false;
	}
	$db_sql = "SHOW COLUMNS FROM $tableName";
	$cache_file = $clear_auto_increment ? ESPCMS_CACHE_FIELD_NAME . $tableName . '_1' : ESPCMS_CACHE_FIELD_NAME . $tableName . '_0';
	$cache_db_array = $espcms_db_cache->cacheCheck($cache_file, false);
	if (!$cache_db_array) {
		$db_query = $espcms_link_db->db_query($db_sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			if ($clear_auto_increment && $fetch_row['Extra'] == 'auto_increment') {
				continue;
			}
			$array[] = $fetch_row;
		}
		$cache_db = $espcms_db_cache->cacheSave($cache_file, $array);
		$cache_db_array = $cache_db ? $cache_db : $array;
	}
	if ($ex_field && is_array($cache_db_array)) {
		foreach ($cache_db_array as $key => $value) {
			if ($ex_field && $value['Field'] == $ex_field) {
				unset($cache_db_array[$key]);
			}
		}
	}
	if ($out_field && is_array($cache_db_array)) {
		$field_array = array();
		foreach ($cache_db_array as $value) {
			$field_array[] = $value['Field'];
		}
		$cache_db_array = is_array($field_array) ? implode(',', $field_array) : '';
	}
	return $cache_db_array;
}

function espcms_post($postdb_array = array(), $field_array = array(), $is_empty_value = false, $is_addslashes = false, $update_key_array = false) {
	if (!is_array($postdb_array) || count($postdb_array) <= 0) {
		return false;
	}
	if (!is_array($field_array) || count($field_array) <= 0) {
		return false;
	}
	$field_showdb_array = array();
	foreach ($field_array as $key => $value) {
		if (array_key_exists($value['Field'], $postdb_array) && (!$update_key_array || (is_array($update_key_array) && in_array($value['Field'], $update_key_array)))) {
			$postdb = $is_addslashes ? addslashes($postdb_array[$value['Field']]) : $postdb_array[$value['Field']];
			$field_array[$key]['value'] = $postdb === '' ? $value['Default'] : $postdb;
			$field_showdb_array[] = $field_array[$key];
		}
	}
	return $is_empty_value ? $field_showdb_array : $field_array;
}

function espcms_post_array($postdb_array = array(), $field_array = array(), $is_empty_value = false) {
	if (!is_array($postdb_array) || count($postdb_array) <= 0) {
		return false;
	}
	if (!is_array($field_array) || count($field_array) <= 0) {
		return false;
	}
	$field_showdb_array = array();
	$field_db_array = array();
	foreach ($postdb_array as $postdb_key => $postdb_value) {
		$install_value = array();
		foreach ($field_array as $key => $value) {
			if (array_key_exists($value['Field'], $postdb_value)) {
				$save_value = $postdb_value[$value['Field']];
				$field_array[$key]['value'] = $save_value === '' ? $value['Default'] : $save_value;
				$install_value[] = $field_array[$key];
			}
		}
		$field_showdb_array[] = $install_value;
		$field_db_array[] = $field_array;
	}
	return $is_empty_value ? $field_showdb_array : $field_db_array;
}

function espcms_db_install_save($tableName, $postdb_array = array()) {
	global $espcms_link_db;
	if (!$tableName) {
		return false;
	}
	if (!is_array($postdb_array) || count($postdb_array) <= 0) {
		return false;
	}
	$db_field_array = array();
	$db_install_values_array = array();
	foreach ($postdb_array as $value) {
		$db_field_array[] = $value['Field'];
		$db_install_values_array[] = "'" . $value['value'] . "'";
	}
	$db_field = implode(',', $db_field_array);
	$db_install_value = implode(',', $db_install_values_array);
	$db_sql = 'INSERT INTO ' . $tableName . ' (' . $db_field . ') VALUES (' . $db_install_value . ')';
	$espcms_link_db->db_query($db_sql);
	$db_install_id = $espcms_link_db->db_insert_id();
	return $db_install_id;
}

function espcms_db_install_array_save($tableName, $postdb_array = array()) {
	global $espcms_link_db;
	if (!$tableName) {
		return false;
	}
	if (!is_array($postdb_array) || count($postdb_array) <= 0) {
		return false;
	}
	$db_install_value = array();
	foreach ($postdb_array as $install_value) {
		$db_field_array = array();
		$db_install_values_array = array();
		foreach ($install_value as $value) {
			$db_field_array[] = $value['Field'];
			$db_install_values_array[] = "'" . $value['value'] . "'";
		}
		$db_field = implode(',', $db_field_array);
		$db_install_value[] = '(' . implode(',', $db_install_values_array) . ')';
	}
	$install_value = is_array($db_install_value) ? implode(',', $db_install_value) : '';
	$db_sql = 'INSERT INTO ' . $tableName . ' (' . $db_field . ') VALUES ' . $install_value;
	$espcms_link_db->db_query($db_sql);
	$db_install_id = $espcms_link_db->db_insert_id();
	return $db_install_id;
}

function espcms_db_update_save($tableName, $db_where, $postdb_array = array(), $out_field = false) {
	global $espcms_link_db;
	if (!$tableName || !$db_where) {
		return false;
	}
	if (!is_array($postdb_array) || count($postdb_array) <= 0) {
		return false;
	}
	$db_field_array = array();
	foreach ($postdb_array as $value) {
		if ($out_field && is_array($out_field) && in_array($value['Field'], $out_field)) {
			continue;
		}
		$db_field_array[] = $value['Field'] . "='" . $value['value'] . "'";
	}
	$db_field = implode(',', $db_field_array);
	$db_sql = "UPDATE $tableName SET $db_field $db_where";
	return $espcms_link_db->db_query($db_sql);
}

function espcms_db_update_set_save($tableName, $db_where, $save_field) {
	global $espcms_link_db;
	if (!$tableName || !$db_where) {
		return false;
	}
	if (empty($save_field)) {
		return false;
	}
	$db_sql = "UPDATE $tableName SET $save_field $db_where";
	return $espcms_link_db->db_query($db_sql);
}

function espcms_db_lastid($tableName, $id_field, $return_field = null, $order_type = 'DESC', $db_where = '') {
	global $espcms_link_db;
	if (!$tableName || !$id_field) {
		return false;
	}
	$return_field = empty($return_field) ? '*' : $return_field;
	$lastSQL = "SELECT $return_field FROM $tableName $db_where ORDER BY $id_field $order_type LIMIT 0,1";
	$read = $espcms_link_db->db_array_read($lastSQL);
	if ($read[$id_field]) {
		return $read;
	} else {
		$return_field_array = array();
		if (!empty($return_field)) {
			$return_array = explode(',', $return_field);
			foreach ($return_array as $key => $value) {
				$return_field_array[$value] = 0;
			}
		} else {
			$return_field_array = 0;
		}
		return $return_field_array;
	}
}

function espcms_db_del($tableName, $fieldName, $value) {
	global $espcms_link_db;
	if (!$tableName || !$fieldName || !$value) {
		return false;
	}
	$delSQL = "DELETE FROM $tableName WHERE $fieldName=$value";
	$del_query = $espcms_link_db->db_query($delSQL);
	if ($del_query) {
		return true;
	} else {
		return false;
	}
}

function espcms_db_delall($tableName, $where) {
	global $espcms_link_db;
	if (!$tableName || !$where) {
		return false;
	}
	$delSQL = "DELETE FROM $tableName WHERE $where";
	$del_query = $espcms_link_db->db_query($delSQL);
	if ($del_query) {
		return true;
	} else {
		return false;
	}
}

function espcms_db_num($tableName, $db_where = null, $num_str = '*') {
	global $espcms_link_db;
	if (!$tableName) {
		return false;
	}
	$sql_where = " WHERE 1=1" . $db_where;
	$db_sql = "SELECT COUNT($num_str) AS num FROM $tableName $sql_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	return $db_read['num'];
}

function espcms_db_sum($tableName, $talbe_field = false, $db_where = false) {
	global $espcms_link_db;
	if (!$tableName || !$db_where || !$talbe_field) {
		return false;
	}
	$db_sql = "SELECT SUM($talbe_field) AS sum FROM $tableName $db_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	return $db_read['sum'];
}

function espcms_db_read($tableName, $db_where, $talbe_field_array = array(), $is_field_str = false) {
	global $espcms_link_db;
	if (!$tableName || !$db_where) {
		return false;
	}
	$db_field_array = array();
	if (is_array($talbe_field_array) && count($talbe_field_array) > 0 && !$is_field_str) {
		foreach ($talbe_field_array as $key => $value) {
			$db_field_array[] = $value['Field'];
		}
		$db_field = implode(',', $db_field_array);
	} elseif ($is_field_str) {
		$db_field = $talbe_field_array;
	}
	$db_field = $db_field ? $db_field : '*';
	$db_sql = "SELECT $db_field FROM $tableName $db_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	if ($db_read && is_array($db_read)) {
		return $db_read;
	} else {
		return false;
	}
}

function espcms_db_left_join_read($tableName_a, $tableName_b, $db_where, $talbe_field_array_a = array(), $talbe_field_array_b = array(), $on_where = false) {
	global $espcms_link_db;
	if (!$tableName_a || !$tableName_b || !$talbe_field_array_a || !$talbe_field_array_b || !is_array($talbe_field_array_a) || !is_array($talbe_field_array_b) || !$db_where || !$on_where) {
		return false;
	}
	$talbe_field = array();
	foreach ($talbe_field_array_a as $value) {
		$talbe_field[] = $tableName_a . '.' . $value['Field'];
	}
	foreach ($talbe_field_array_b as $value) {
		$talbe_field[] = $tableName_b . '.' . $value['Field'];
	}
	$db_field = is_array($talbe_field) > 0 ? implode(',', $talbe_field) : '';
	$db_sql = "SELECT $db_field FROM $tableName_a LEFT JOIN $tableName_b ON $tableName_a.$on_where=$tableName_b.$on_where $db_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	if ($db_read && is_array($db_read)) {
		return $db_read;
	} else {
		return false;
	}
}

function espcms_db_read_field($tableName, $db_where, $db_field) {
	global $espcms_link_db;
	if (!$tableName || !$db_where || !$db_field) {
		return false;
	}
	$db_field = is_array($db_field) && count($db_field) > 0 ? implode(',', $db_field) : $db_field;
	$db_sql = "SELECT $db_field FROM $tableName $db_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	if ($db_read && is_array($db_read)) {
		$return_db = count($db_read) > 1 ? $db_read : $db_read[$db_field];
		return $return_db;
	} else {
		return false;
	}
}

function espcms_db_read_field_array($tableName, $db_where, $db_field_array = array()) {
	global $espcms_link_db;
	if (!$tableName || !$db_where || !$db_field_array) {
		return false;
	}
	$db_field = is_array($db_field_array) && count($db_field_array) > 0 ? implode(',', $db_field_array) : '*';
	$db_sql = "SELECT $db_field FROM $tableName $db_where";
	$db_read = $espcms_link_db->db_array_read($db_sql);
	if ($db_read && is_array($db_read)) {
		return $db_read;
	} else {
		return false;
	}
}

function espcms_db_list_array($tableName, $talbe_field_array = array(), $db_where = false, $db_order = false, $limit = false) {
	global $espcms_link_db;
	if (!$tableName || !$talbe_field_array) {
		return false;
	}
	if (is_array($talbe_field_array) && count($talbe_field_array) > 0) {
		foreach ($talbe_field_array as $value) {
			if ($value['Extra'] == 'auto_increment') {
				$order_field = $value['Field'];
			}
			$db_field_array[] = $value['Field'];
		}
		$db_field = implode(',', $db_field_array);
	} elseif (preg_match("/^[\w]+[\,\w]*$/i", $talbe_field_array)) {
		$db_field = $talbe_field_array;
	}
	$db_field = $db_field ? $db_field : '*';
	$db_order_by = $db_order ? $db_order : $order_field;
	$db_limit = $limit && preg_match("/^[\d]+,[\d]+$/i", $limit) ? 'LIMIT ' . $limit : '';
	$db_sql = "SELECT $db_field FROM $tableName WHERE 1=1 $db_where ORDER BY $db_order_by $db_limit";
	$db_query = $espcms_link_db->db_query($db_sql);
	while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
		$array[] = $fetch_row;
	}
	return $array;
}

function espcms_db_format_where($array = array(), $where_field = false, $where_link = " AND ") {
	if (!is_array($array) || count($array) <= 0 || empty($where_field) || !espcms_array_ismatches($array)) {
		return false;
	}
	$where_value = implode(',', $array);
	return count($array) == 1 ? $where_link . "$where_field=$where_value" : $where_link . "$where_field IN ($where_value)";
}

function espcms_db_list_out($db_table, $db_where = false, $order_key = false, $order_rank = 'DESC', $limit = false, $per_page_num = false, $field_key = false) {
	if (!$db_table) {
		return false;
	}
	$talbe_field = $field_key ? $field_key : espcms_field_out($db_table, false, true);
	$db_sql = "SELECT $talbe_field FROM $db_table WHERE 1=1 $db_where";
	if ($order_key) {
		$db_sql .= " ORDER BY $order_key $order_rank";
	}
	if (espcms_ismatches($limit) && espcms_ismatches($per_page_num)) {
		$db_sql .= " LIMIT $limit,$per_page_num";
	}
	return $db_sql;
}

function espcms_db_truncate($tableName) {
	global $espcms_link_db;
	if (!$tableName || !preg_match("/^[\w]+$/i", $tableName)) {
		return false;
	}
	$db_sql = "TRUNCATE $tableName";
	return $espcms_link_db->db_query($db_sql);
}

function espcms_db_drop_table($tableName) {
	global $espcms_link_db;
	if (!$tableName || !preg_match("/^[\w]+$/i", $tableName)) {
		return false;
	}
	$db_sql = "DROP TABLE IF EXISTS $tableName";
	return $espcms_link_db->db_query($db_sql);
}

function espcms_db_ver() {
	global $espcms_link_db;
	return $espcms_link_db->db_version();
}
