<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
 */

use application\ESPCMS_AdminAuthority;
use application\ESPCMS_Core;
use inc_application\link\PublicLink;

function require_espcms_link_db() {

	global $espcms_link_db;

	if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php')) {
		require_once( ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Mysql.php' );
	}
	if (isset($espcms_link_db)) {
		return;
	}

	$espcms_link_db = new ESPCMS_Mysql(ESPCMS_DB_HOST, ESPCMS_DB_NAME, ESPCMS_DB_USER, ESPCMS_DB_PASSWORD, ESPCMS_DB_CHARSET);
}

function espcms_loadcheck_php_versions() {

	global $loading_php_version, $espcms_version, $loading_php_version_hig;

	$php_current_version = phpversion();
	if (version_compare($loading_php_version, $php_current_version, '>') || !$loading_php_version || !$espcms_version) {
		espcms_message_err('public_pack-espcms_php_version_low', array($php_current_version, $espcms_version, $loading_php_version));
	}
	if (version_compare($loading_php_version_hig, $php_current_version, '<')) {
		espcms_message_err('public_pack-espcms_php_version_hig', array($php_current_version, $espcms_version, $loading_php_version_hig));
	}
}

function espcms_loadcheck_php_curl() {
	if (!extension_loaded('curl') || !function_exists('curl_init')) {
		espcms_message_err('public_pack-espcms_php_function_err', array('CURL'));
	}
}

function espcms_loadcheck_mysql_versions() {

	global $loading_mysql_version, $espcms_version, $espcms_link_db;

	$mysql_current_version = $espcms_link_db->db_version();
	if (version_compare($loading_mysql_version, $mysql_current_version, '>')) {
		espcms_message_err('db_pack-espcms_sql_version_low', array($mysql_current_version, $espcms_version, $loading_mysql_version));
	}
}

function espcms_lan_pack($language_pack_code, $format_code = array()) {
	if (!isset($language_pack_code) || empty($language_pack_code)) {
		return false;
	}

	list($link_filename, $variable) = explode('-', $language_pack_code);
	$link_file = ESPCMS_FILE_ROOT . 'espcms_includes/lanpack/' . ESPCMS_LANG . '/' . $link_filename . '.php';
	if (file_exists($link_file)) {
		require($link_file);
	}
	if (isset($$variable) && is_array($format_code) && count($format_code) > 0) {
		$message = vsprintf($$variable, $format_code);
		return $message;
	} else {
		return $$variable;
	}
}

function espcms_web_lan_pack($lng, $language_code, $format_code = array()) {
	if (!$lng || !preg_match('/^[\w]+$/', $lng)) {
		return false;
	}
	if (!isset($language_code) || !$language_code) {
		return false;
	}
	$link_file = ESPCMS_FILE_ROOT . 'espcms_datacache/' . $lng . '_pack.php';
	if (file_exists($link_file)) {
		require($link_file);
	}
	if (isset($LANPACK[$language_code]) && is_array($format_code) && count($format_code) > 0) {
		$message = vsprintf($LANPACK[$language_code], $format_code);
		return $message;
	} else {
		return $LANPACK[$language_code];
	}
}

function espcms_message_err($message_code, $format_code = array()) {

	$title = espcms_lan_pack('public_pack-espcms_soft_title_err');

	$message_lan = espcms_lan_pack($message_code);
	if (isset($message_lan) && !empty($message_lan) && is_array($format_code) && count($format_code) > 0) {

		$message = vsprintf($message_lan, $format_code);
	} else {
		$message = $message_lan;
	}

	$message_html_code = '<!DOCTYPE html>
	<html xmlns="http://www.w3.org/1999/xhtml" dir=\'ltr\'>
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title>' . $title . '</title>
		<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/jquery.min.js"></script>
		<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/iframeResizer.contentWindow.min.js"></script>
		<style type="text/css">
			html {
				background: #eee;
			}
			body {
				background: #fff;
				color: #333;
				font-family: "Open Sans", sans-serif;
				margin: 2em auto;
				padding: 20px;
				max-width: 92%;
				-webkit-box-shadow: 0 1px 3px rgba(0,0,0,0.13);
				box-shadow: 0 1px 3px rgba(0,0,0,0.13);
			}
			h1 {
				border-bottom: 1px solid #dadada;
				clear: both;
				color: #666;
				font: 24px "Open Sans", sans-serif;
				margin: 30px 0 0 0;
				padding: 0;
				padding-bottom: 7px;
			}
			#error-page {
				margin-top:40px;
			}
			#error-page p {
				font-size: 14px;
				line-height: 1.5;
				margin: 25px 0 20px;
			}
			#error-page code {
				font-family: Consolas, Monaco, monospace;
			}
			ul li {
				margin-bottom: 10px;
				font-size: 14px ;
			}
			a {
				color: #333;
				text-decoration: underline;
			}
			a:hover {
				color: #fa0000;
				text-decoration: underline;
			}
			.button {
				background: #f7f7f7;
				border: 1px solid #cccccc;
				color: #555;
				display: inline-block;
				text-decoration: none;
				font-size: 13px;
				line-height: 26px;
				height: 28px;
				margin: 0;
				padding: 0 10px 1px;
				cursor: pointer;
				-webkit-border-radius: 3px;
				-webkit-appearance: none;
				border-radius: 3px;
				white-space: nowrap;
				-webkit-box-sizing: border-box;
				-moz-box-sizing:    border-box;
				box-sizing:         border-box;
				-webkit-box-shadow: inset 0 1px 0 #fff, 0 1px 0 rgba(0,0,0,.08);
				box-shadow: inset 0 1px 0 #fff, 0 1px 0 rgba(0,0,0,.08);
				vertical-align: top;
			}
			.button.button-large {
				height: 29px;
				line-height: 28px;
				padding: 0 12px;
			}
			.button:hover,
			.button:focus {
				background: #fafafa;
				border-color: #999;
				color: #222;
			}
			.button:focus  {
				-webkit-box-shadow: 1px 1px 1px rgba(0,0,0,.2);
				box-shadow: 1px 1px 1px rgba(0,0,0,.2);
			}
			.button:active {
				background: #eee;
				border-color: #999;
				color: #333;
				-webkit-box-shadow: inset 0 2px 5px -3px rgba( 0, 0, 0, 0.5 );
				box-shadow: inset 0 2px 5px -3px rgba( 0, 0, 0, 0.5 );
			}
			code {
				font-size:14px;padding:0px 5px;color:#eb3609;
			}
		</style>
	</head>
	<body id="error-page">' . $message . '</body></html>';
	exit($message_html_code);
}

function espcms_public_dialog($domid_name = 'espcms_public_dialog', $message_code = null, $err_code = '', $format_code = array(), $return_type = 'json', $return_array = array(), $istoken = false, $width = 720) {

	$title = espcms_lan_pack('public_pack-espcms_soft_title_err');

	$message_lan = espcms_lan_pack($message_code);
	if (isset($message_lan) && !empty($message_lan) && is_array($format_code) && count($format_code) > 0) {

		$message = vsprintf($message_lan, $format_code);
	} else {
		$message = $message_lan;
	}
	if ($istoken) {
		$tokenkey = token();
		$message_html_code['token_name'] = $tokenkey['token_name'];
		$message_html_code['token_key'] = $tokenkey['token_key'];
	}

	$message_html_code['domid_name'] = $domid_name;
	$message_html_code['data'] = '<div id="' . $domid_name . '" title="' . $title . '" class="displaynone">' . $message . '</div>';
	$message_html_code['message'] = $message;
	$message_html_code['code'] = $err_code;
	$message_html_code['width'] = $width ? $width : 720;
	if ($return_array && is_array($return_array) && count($return_array) > 0) {
		$message_html_code = array_merge($message_html_code, $return_array);
	}
	$message_out_json = json_encode($message_html_code);

	exit($return_type == 'data' ? $message_html_code['data'] : $message_out_json);
}

function espcms_message_page_err($message_code, $goback_url = '', $format_code = array(), $facetype = 1, $isbutton = true, $isgoback = true) {

	$title = espcms_lan_pack('public_pack-espcms_soft_title_err');

	$message_lan = espcms_lan_pack($message_code);
	if (isset($message_lan) && !empty($message_lan) && is_array($format_code) && count($format_code) > 0) {

		$message = vsprintf($message_lan, $format_code);
	} else {
		$message = $message_lan;
	}

	switch ($facetype) {
		case 1:
			$face_cssname = 'espcms_message_icon_err';
			break;
		case 2:
			$face_cssname = 'espcms_message_icon_err_gt';
			break;
		case 3:
			$face_cssname = 'espcms_message_icon_err_wh';
			break;
		case 4:
			$face_cssname = 'espcms_message_icon_err_ok';
			break;
		default:
			$face_cssname = 'espcms_message_icon_err';
			break;
	}
	$goback_message = $isgoback ? '<p class="pt5">' . espcms_lan_pack('public_pack-espcms_message_page_gobackurl') . '</p>' : '';
	$botton_title = $isbutton ? '<a href="' . $goback_url . '" class="btn btn-orange btn-lg">' . espcms_lan_pack('botton_pack-espcms_botton_goback_url') . '</a>' : '';
	$js_str = $isgoback ? '$(window).load(function () {
						$("#spanSeconds").html(seconds);
						window.setInterval(espcms_redirection, 1000);
					});' : '';

	$message_html_code = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>' . $title . '</title>
				<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style_font_icon.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style_public.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_all.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_framework.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_select.css" rel="stylesheet" type="text/css" />
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/jquery.min.js"></script>
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/bootstrap.js"></script>
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/espcms_function.js"></script>
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/espcms_form.js"></script>
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/espcms_formvalidation.js"></script>
				<script type="text/javascript" src="' . ESPCMS_ADMIN_URL . 'js/iframeResizer.contentWindow.min.js"></script>
				<script type="text/javascript">
					var seconds = 15;
					var defaultUrl = "' . $goback_url . '";
					' . $js_str . '
				</script>
			</head>
			<body class="espcms_message">
				<div class="espcms_message_warning"></div>
				<div class="espcms_message_strwindow">
					<div class="espcms_message_d1 ' . $face_cssname . '">
						<p class="text-orange">' . $message . '</p>
						' . $goback_message . '
					</div>
					<div class="espcms_message_d2">
						' . $botton_title . '
					</div>
				</div>
			</body>
		</html>';
	exit($message_html_code);
}

function espcms_message_window_err($message_code, $format_code = array()) {

	$title = espcms_lan_pack('public_pack-espcms_soft_title_err');

	$message_lan = espcms_lan_pack($message_code);
	if (isset($message_lan) && !empty($message_lan) && is_array($format_code) && count($format_code) > 0) {

		$message = vsprintf($message_lan, $format_code);
	} else {
		$message = $message_lan;
	}
	$botton_title = espcms_lan_pack('botton_pack-espcms_botton_close_window');

	$message_html_code = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>' . $title . '</title>
				<meta content="text/html; charset=utf-8" http-equiv="Content-Type" />
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style_font_icon.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style_public.css" rel="stylesheet" type="text/css" />
				<link href="' . ESPCMS_TEMPLATES_PATH . 'css/espcms_style_frames.css" rel="stylesheet" type="text/css" />
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/jquery.min.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/bootstrap.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_function.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_form.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_formvalidation.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_dialog.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_select.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_checkbox.js"></script>
				<script type="text/javascript" src="' . ESPCMS_URL . 'js/espcms_select_checkbox.js"></script>
				<script type="text/javascript">
					$(document).ready(function () {
						var height = $(window).height();
						var dialog_list_height = height - 190;
						$(\'.dialog_list\').css(\'height\', dialog_list_height);
						banpageKey();
						$(\'.espcms_close_dialog\').click(function () {
							closedialogbox();
						});
					});
					function closedialogbox() {
						parent.closeifram();
					}
				</script>
			</head>
			<body class="dialog_body">
				<div class="espcms_message_strwindow">
					<div class="espcms_message_d1 espcms_message_icon_err" style="width:100%">
						<p class="text-orange">' . $message . '</p>
					</div>
				</div>
				<div class="dialogbotton">
					<div class="dialog_buttonset">
						<button type="button" class="btn btn-lightgray espcms_close_dialog">' . $botton_title . '</button>
					</div>
				</div>
			</body>
		</html>';
	exit($message_html_code);
}

function espcms_admin_template() {

	global $espcms_admin_templates, $module_array, $espcms_command;

	if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php')) {
		require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php' );
	} else {
		espcms_message_err('public_pack-espcms_templates_err');
	}
	$espcms_admin_templates = new ESPCMS_Templates();

	$espcms_admin_templates->html_compile_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/admin_templates/';

	$espcms_admin_templates->templatescache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/admin_templates_cache/';

	$espcms_admin_templates->dbcache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';

	$espcms_admin_templates->photo_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbpic/';

	$espcms_admin_templates->templates_path_dir = ESPCMS_FILE_ROOT . ESPCMS_ADMIN_DIRNAME . '/';

	$espcms_admin_templates->templates_themss_dirname = ESPCMS_ADMIN_THEMES_NAME . '/';

	$espcms_admin_templates->templatesfileex = '.html';

	$espcms_admin_templates->libdir = ESPCMS_ADMIN_DIRNAME . '/control/';

	$espcms_admin_templates->left_delimiter = '[%';

	$espcms_admin_templates->right_delimiter = '%]';
	$espcms_admin_templates->iscaching = false;

	$espcms_admin_templates->into('ESPCMS_URL', ESPCMS_URL);
	$espcms_admin_templates->into('ESPCMS_URL_NOLINE', espcms_host('URL'));
	$espcms_admin_templates->into('ESPCMS_WWW_URL', ESPCMS_WWW_URL);
	$espcms_admin_templates->into('ESPCMS_ADMIN_URL', ESPCMS_ADMIN_URL);

	$espcms_admin_templates->into('ESPCMS_ADMIN_TEMPLATES_URL', ESPCMS_ADMIN_URL . ESPCMS_ADMIN_THEMES_NAME . '/');

	$espcms_admin_templates->into('module_array', $module_array);

	$espcms_admin_templates->into('ESPCMS_TEMPLATES_PATH', ESPCMS_TEMPLATES_PATH);

	$espcms_admin_templates->into('ESPCMS_SOFT_TITLE', $espcms_command['SITENAME'] ? $espcms_command['SITENAME'] : '易思ESPCMS-P8企业建站管理系统');

	$espcms_admin_templates->into('iframes_name', $_REQUEST['iframes_name']);
	$espcms_admin_templates->into('par_iframes_name', $_REQUEST['par_iframes_name']);
	return $espcms_admin_templates;
}

function espcms_web_template($lng = false) {

	global $espcms_web_templates, $espcms_command;

	if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php')) {
		require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php' );
	} else {
		espcms_message_err('public_pack-espcms_templates_err');
	}

	if ($lng && preg_match("/^[a-z0-9]{2,50}$/i", $lng)) {
		$lancode = $lng == 'cn' || $lng == 'big5' ? 'cn' : $lng;
		$templates_lng = $lng;
	} elseif (ESPCMS_CREAT && defined('ESPCMS_CREAT')) {
		$lancode = ESPCMS_CREAT == 'cn' || ESPCMS_CREAT == 'big5' ? 'cn' : ESPCMS_CREAT;
		$templates_lng = ESPCMS_CREAT;
	} else {
		$lancode = espcms_lancode();
		$templates_lng = ESPCMS_WEB_LAN;
	}

	$web_templates = ESPCMS_WEB_TYPE == 'WAP' ? ESPCMS_Core::get_skin('wap', 'skin_code') : ESPCMS_Core::get_skin('web', 'skin_code');
	$espcms_web_templates = new ESPCMS_Templates();

	$espcms_web_templates->lng = $templates_lng;

	$espcms_web_templates->html_compile_dir = ESPCMS_WEB_TYPE == 'WAP' ? ESPCMS_FILE_ROOT . 'espcms_datacache/wap_templates/' : ESPCMS_FILE_ROOT . 'espcms_datacache/web_templates/';

	$espcms_web_templates->templatescache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/cache_templates/';

	$espcms_web_templates->dbcache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';

	$espcms_web_templates->photo_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbpic/';

	$espcms_web_templates->templates_path_dir = ESPCMS_FILE_ROOT . 'templates/';

	$espcms_web_templates->templates_themss_dirname = $web_templates . '/' . $lancode . '/';

	$espcms_web_templates->templatesfileex = '.html';

	$espcms_web_templates->libdir = 'espcms_web/';

	$espcms_web_templates->left_delimiter = '{%';

	$espcms_web_templates->right_delimiter = '%}';

	$espcms_web_templates->iscaching = false;

	$espcms_web_templates->into('url', ESPCMS_URL);

	$espcms_web_templates->into('homelink', PublicLink::get_link($templates_lng, 'home'));

	$espcms_web_templates->into('espcms_url', espcms_url());

	$espcms_web_templates->into('rootdir', espcms_url());

	$espcms_web_templates->into('rootpath', espcms_url() . 'templates/' . $web_templates . '/');

	$espcms_web_templates->into('icon_16', espcms_url() . $espcms_command['WEB_ICON_16']);

	$espcms_web_templates->into('icon_32', espcms_url() . $espcms_command['WEB_ICON_32']);

	$espcms_web_templates->into('icon_64', espcms_url() . $espcms_command['WEB_ICON_64']);

	$lanpack = ESPCMS_Core::get_lngpack_view($lancode);
	$espcms_web_templates->into('lngpack', $lanpack);
	$espcms_web_templates->into('lng', $templates_lng);
	$espcms_web_templates->into('icp', $espcms_command['WEB_ICP']);
	return $espcms_web_templates;
}

function espcms_setup_template() {

	global $espcms_web_templates;

	if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php')) {
		require_once(ESPCMS_FILE_ROOT . 'espcms_public/espcms_templates/ESPCMS_Templates.php' );
	} else {
		espcms_message_err('public_pack-espcms_templates_err');
	}
	$espcms_web_templates = new ESPCMS_Templates();

	$espcms_web_templates->html_compile_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/setup_templates/';

	$espcms_web_templates->templatescache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/cache_templates/';

	$espcms_web_templates->dbcache_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';

	$espcms_web_templates->photo_dir = ESPCMS_FILE_ROOT . 'espcms_datacache/dbpic/';

	$espcms_web_templates->templates_path_dir = ESPCMS_FILE_ROOT . 'espcms_install/templates/';

	$espcms_web_templates->templatesfileex = '.html';

	$espcms_web_templates->libdir = 'espcms_web/';

	$espcms_web_templates->left_delimiter = '{%';

	$espcms_web_templates->right_delimiter = '%}';

	$espcms_web_templates->iscaching = false;

	$espcms_web_templates->into('url', ESPCMS_URL);

	$espcms_web_templates->into('espcms_url', espcms_url());

	$espcms_web_templates->into('rootdir', ESPCMS_URL);

	$espcms_web_templates->into('setup_url', ESPCMS_URL . 'espcms_install/');

	$espcms_web_templates->into('rootpath', ESPCMS_URL_RT . 'templates/');
	return $espcms_web_templates;
}

function espcms_log_install($message_code, $extras_message = null, $admin_member_id = 0) {
	if (empty($message_code)) {
		return false;
	}
	$admin_member_id = !$admin_member_id ? ESPCMS_AdminAuthority::getUserLoginInfo('admin_member_id') : $admin_member_id;
	if (!espcms_ismatches($admin_member_id)) {
		$admin_member_id = 0;
	}

	$message_lan = espcms_lan_pack($message_code);
	if (empty($message_lan)) {
		return false;
	}
	$extras_message_title = espcms_lan_pack('public_pack-espcms_soft_extras_message');

	$remoteip = real_remote_ip();

	$onlineip = ip_shift($remoteip);
	$onlineip = empty($onlineip) ? 0 : $onlineip;
	$addtime = time();

	$db_table = ESPCMS_DB_PREFIX . "logs";
	$talbe_field_array = espcms_field_out($db_table, true);

	$install_value_array = array();

	$install_value_array['admin_member_id'] = $admin_member_id;
	$install_value_array['user_log_action'] = $extras_message ? $message_lan . '，' . $extras_message_title . $extras_message : $message_lan;
	$install_value_array['user_log_time'] = $addtime;
	$install_value_array['user_log_ip'] = $onlineip;

	$install_value = espcms_post($install_value_array, $talbe_field_array, true);

	if (!espcms_db_install_save($db_table, $install_value)) {
		espcms_message_err('db_pack-espcms_db_log_install_fail', array($extras_message));
	} else {
		return true;
	}
}

function espcms_start_cache() {
	global $espcms_db_cache, $espcms_command;
	if (file_exists(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Cache.php')) {
		require_once(ESPCMS_FILE_ROOT . 'espcms_public/ESPCMS_Cache.php' );
	} else {
		espcms_message_err('public_pack-espcms_cache_err');
	}

	$espcms_db_cache = new ESPCMS_Cache();

	$espcms_db_cache->cacheFileDIR = ESPCMS_FILE_ROOT . 'espcms_datacache/dbcache/';

	$espcms_db_cache->cacheTime = ESPCMS_CACHE_TIME ? ESPCMS_CACHE_TIME : 60 * 60 * 24;

	if ($espcms_command['IS_CACHING']) {
		$espcms_db_cache->isCache = ESPCMS_ISCACHE ? ESPCMS_ISCACHE : true;
	} else {
		$espcms_db_cache->isCache = false;
	}
	return $espcms_db_cache;
}

function espcms_page_db($db_table = '', $db_where = '', $is_json = false, $db_num = '*', $page_num = false) {
	global $espcms_command;

	$page_db = array();

	$page_db['per_page_num'] = $page_num ? $page_num : ($espcms_command['PER_PAGE_NUM'] ? ceil($espcms_command['PER_PAGE_NUM']) : 20);

	$page_db['sum_db'] = 0;

	$page_db['sum_page'] = 1;

	$page_db['now_page'] = 0;
	$page_db['sum_db'] = espcms_db_num($db_table, $db_where, $db_num);
	if ($page_db['sum_db'] > 0) {

		$page_db['sum_page'] = ceil($page_db['sum_db'] / $page_db['per_page_num']);
	}
	return !$is_json ? $page_db : json_encode($page_db);
}

function espcms_get_act($isget = 'get') {
	$act_array = array(
	    'FileManage/uploadFileConfig',
	    'MainCenter/SiteState',
	    'MainCenter/ViewService',
	    'Portal/Join',
	    'MainCenter/PusMessage'
	);

	if (ACTAPPCODE && !in_array($_GET['act'], $act_array)) {
		if ($isget == 'get') {
			$act = $_GET['act'] ? espcms_decrypt($_GET['act'], ESPCMS_ENCRYPT_CODE) : false;
		} elseif ($isget == 'post') {
			$act = $_POST['act'] ? espcms_decrypt($_POST['act'], ESPCMS_ENCRYPT_CODE) : false;
		} elseif ($isget == 'requetst') {
			$act = $_REQUEST['act'] ? espcms_decrypt($_REQUEST['act'], ESPCMS_ENCRYPT_CODE) : false;
		} else {
			$act = $_GET['act'] ? espcms_decrypt($_GET['act'], ESPCMS_ENCRYPT_CODE) : false;
		}
	} else {
		if ($isget == 'get') {
			$act = $_GET['act'];
		} elseif ($isget == 'post') {
			$act = $_POST['act'];
		} elseif ($isget == 'requetst') {
			$act = $_REQUEST['act'];
		} else {
			$act = $_GET['act'];
		}
	}
	return $act;
}

function espcms_get_app($isget = 'get') {
	if (ACTAPPCODE) {
		if ($isget == 'get') {
			$act = $_GET['app'] ? espcms_decrypt($_GET['app'], ESPCMS_ENCRYPT_CODE) : false;
		} elseif ($isget == 'post') {
			$act = $_POST['app'] ? espcms_decrypt($_POST['app'], ESPCMS_ENCRYPT_CODE) : false;
		} elseif ($isget == 'requetst') {
			$act = $_REQUEST['app'] ? espcms_decrypt($_REQUEST['app'], ESPCMS_ENCRYPT_CODE) : false;
		} else {
			$act = $_GET['app'] ? espcms_decrypt($_GET['app'], ESPCMS_ENCRYPT_CODE) : false;
		}
	} else {
		if ($isget == 'get') {
			$act = $_GET['app'];
		} elseif ($isget == 'post') {
			$act = $_POST['app'];
		} elseif ($isget == 'requetst') {
			$act = $_REQUEST['app'];
		} else {
			$act = $_GET['app'];
		}
	}
	return $act;
}

function espcms_get_ac($isget = 'get') {
	if ($isget == 'get') {
		$ac = $_GET['ac'];
	} elseif ($isget == 'post') {
		$ac = $_POST['ac'];
	} elseif ($isget == 'requetst') {
		$ac = $_REQUEST['ac'];
	} else {
		$ac = $_GET['ac'];
	}
	return $ac;
}

function espcms_get_at($isget = 'get') {
	if ($isget == 'get') {
		$at = $_GET['at'];
	} elseif ($isget == 'post') {
		$at = $_POST['at'];
	} elseif ($isget == 'requetst') {
		$at = $_REQUEST['at'];
	} else {
		$at = $_GET['at'];
	}
	return $at;
}
