<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use application\ESPCMS_PageButton;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_SendMessage;
use modul_application\ESPCMS_OrderDB;
use inc_application\link\MemberLink;
use inc_application\link\OrderLink;
use inc_application\link\ArticleLink;

class OrderMain {

	private static $member_cookie_read;
	private static $member_con;
	private static $order_con;

	public function __construct() {
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$member_app_config['isetup'] || !$member_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		ESPCMS_MemberAuthority::authorityWebVerify(false, $member_app_config['appconfig']);
		static::$member_con = unserialize($member_app_config['appconfig']);
		$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
		static::$member_cookie_read = ESPCMS_MemberDB::get_member_view($member_cookie_info['userid']);
		if (!static::$member_cookie_read) {
			ESPCMS_Dialog::Message_Page('member_read_err', MemberLink::get_link('quit'));
		}
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup'] || !$order_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close');
		}
		static::$order_con = unserialize($order_app_config['appconfig']);
	}

	public static function in_List() {
		global $espcms_web_templates, $espcms_link_db;
		$db_table = ESPCMS_DB_PREFIX . 'order';
		$pageid = $_GET['pageid'] && espcms_ismatches($_GET['pageid']) ? $_GET['pageid'] : 1;
		$per_page_num = 20;
		$userid = static::$member_cookie_read['userid'];
		if (!espcms_ismatches($userid) || !$userid) {
			ESPCMS_Dialog::Message_Page('db_err', MemberLink::get_link('center'));
		}
		$db_where = " AND userid=$userid";
		$db_num = espcms_db_num($db_table, $db_where);
		$db_sql = espcms_db_list_out($db_table, $db_where);
		$lanpack = $espcms_web_templates->geto('lngpack');
		$page_style = ESPCMS_WEB_TYPE == 'WAP' && defined('ESPCMS_WEB_TYPE') ? 2 : 1;
		$espcms_page_button = new ESPCMS_PageButton($db_sql, $db_num, $per_page_num, $pageid, $page_style, $lanpack['pagebotton'], 'inc_application\link\OrderLink', 'order_member_link', array());
		$sql = $espcms_page_button->sql_creat('oid', 'DESC');
		$db_query = $espcms_link_db->db_query($sql);
		while ($fetch_row = $espcms_link_db->db_array_list($db_query)) {
			$fetch_row['edit'] = OrderLink::get_order_link('edit', $fetch_row);
			$fetch_row['view'] = OrderLink::get_order_link('view', $fetch_row);
			$fetch_row['paylink'] = OrderLink::get_order_link('pay_ok', $fetch_row);
			$fetch_row['cancel'] = OrderLink::get_order_link('cancel', $fetch_row);
			$array[] = $fetch_row;
		}
		$lanpack['sitename'] = $lanpack['title_member_name'] . '-' . $lanpack['sitename'];
		$espcms_web_templates->into('lngpack', $lanpack);
		$espcms_web_templates->into('array', $array);
		$espcms_web_templates->into('path', 'member');
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('page_read', $espcms_page_button->page_argument_out());
		$espcms_web_templates->into('pagebotton', $espcms_page_button->page_botton_creat());
		$espcms_web_templates->output('member/member_order_list', 'member_order_list', false, false);
	}

	public static function in_View() {
		global $espcms_web_templates;
		$oid = $_GET['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			ESPCMS_Dialog::Message_Page('db_err', OrderLink::order_member_link());
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read || $read['userid'] != static::$member_cookie_read['userid']) {
			ESPCMS_Dialog::Message_Page('order_read_err', OrderLink::order_member_link());
		}
		if (($_GET['type'] == 'edit' && $read['islock']) || ($_GET['type'] == 'edit' && $read['ispay']) || ($_GET['type'] == 'edit' && !$read['ordertype'])) {
			ESPCMS_Dialog::Message_Page('order_lock_edit_err', OrderLink::order_member_link());
		}
		$product_array = ESPCMS_OrderDB::get_order_info_list($oid);
		if ($product_array && is_array($product_array)) {
			foreach ($product_array as $key => $value) {
				$product_array[$key]['link'] = ArticleLink::doc_link($value);
			}
		}
		if ($read['ispay'] == 1 && espcms_ismatches($read['opid'])) {
			$read['payname'] = ESPCMS_OrderDB::get_pay_plug_view($read['opid'], 'payname');
		}
		$shipreceipt_list = ESPCMS_OrderDB::get_order_shipreceipt_list($oid);
		if (is_array($shipreceipt_list)) {
			foreach ($shipreceipt_list as $key => $value) {
				$shipreceipt_list[$key]['shippingname'] = ESPCMS_OrderDB::get_express_view($value['osid'], 'shippingname');
			}
		}
		$espcms_web_templates->into('shipreceipt_list', $shipreceipt_list);
		$espcms_web_templates->into('order_link', OrderLink::get_order_link(false, $read));
		$espcms_web_templates->into('product_array', $product_array);
		$espcms_web_templates->into('read', $read);
		$espcms_web_templates->into('member_con', static::$member_con);
		$espcms_web_templates->into('tokenkey', token('order_edit'));
		$espcms_web_templates->into('path', 'member');
		$filename = $_GET['type'] == 'edit' ? 'member_order_edit' : 'member_order_view';
		$espcms_web_templates->output('member/' . $filename, $filename, false, false);
	}

	public static function in_EditSave() {
		if (!is_token($_POST['tokenname'], $_POST['tokenkey'])) {
			ESPCMS_Dialog::Message_Page('repeat_inut', MemberLink::get_link('center'));
		}
		$oid = $_POST['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			ESPCMS_Dialog::Message_Page('db_err');
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read || $read['userid'] != static::$member_cookie_read['userid']) {
			ESPCMS_Dialog::Message_Page('order_read_err');
		}
		if ($read['islock'] || $read['ispay'] || !$read['ordertype']) {
			ESPCMS_Dialog::Message_Page('order_lock_edit_err');
		}
		$_POST['consignee'] = $_POST['consignee'] ? htmlspecialchars($_POST['consignee']) : '';
		$_POST['country'] = $_POST['country'] ? htmlspecialchars($_POST['country']) : '';
		$_POST['province'] = $_POST['province'] ? htmlspecialchars($_POST['province']) : '';
		$_POST['city'] = $_POST['city'] ? htmlspecialchars($_POST['city']) : '';
		$_POST['address'] = $_POST['address'] ? htmlspecialchars($_POST['address']) : '';
		$_POST['zipcode'] = $_POST['zipcode'] ? htmlspecialchars($_POST['zipcode']) : '';
		$_POST['tel'] = $_POST['tel'] ? htmlspecialchars($_POST['tel']) : '';
		$_POST['content'] = $_POST['content'] ? htmlspecialchars($_POST['content']) : '';
		$_POST['invcontent'] = $_POST['invcontent'] ? htmlspecialchars($_POST['invcontent']) : '';
		$_POST['companysn'] = $_POST['companysn'] ? htmlspecialchars($_POST['companysn']) : '';
		$_POST['invpayee'] = $_POST['invpayee'] ? htmlspecialchars($_POST['invpayee']) : '';
		unset($_POST['oid'], $_POST['ordersn'], $_POST['userid'], $_POST['order_source'], $_POST['ordertype'], $_POST['islock'], $_POST['ispay'], $_POST['isshipping'], $_POST['osid'], $_POST['opid'], $_POST['paytype'], $_POST['shiptype']);
		unset($_POST['paysn'], $_POST['treatnote'], $_POST['paytime'], $_POST['shippingtime'], $_POST['paymoney'], $_POST['invoicefeemoney'], $_POST['orderamount'], $_POST['discount'], $_POST['integral'], $_POST['addtime']);
		$_POST['updatetime'] = time();
		$db_where = "WHERE oid=$oid AND userid=" . static::$member_cookie_read['userid'];
		$db_table = ESPCMS_DB_PREFIX . "order";
		$talbe_field_array = espcms_field_out($db_table, true);
		$postvalue = espcms_post($_POST, $talbe_field_array, true);
		if (!$postvalue || !is_array($postvalue)) {
			ESPCMS_Dialog::Message_Page('dba_read_err', MemberLink::get_link('edit_info'));
		}
		$update_id = espcms_db_update_save($db_table, $db_where, $postvalue);
		if (!$update_id) {
			ESPCMS_Dialog::Message_Page('save_err', OrderLink::order_member_link());
		}
		ESPCMS_Dialog::Message_Page('order_edit_ok', OrderLink::order_member_link());
	}

	public static function in_Cancel() {
		global $espcms_command;
		$oid = $_GET['oid'];
		if (!$oid || !espcms_ismatches($oid)) {
			ESPCMS_Dialog::Message_Page('db_err', OrderLink::order_member_link());
		}
		$read = ESPCMS_OrderDB::get_order_view($oid);
		if (!$read || $read['userid'] != static::$member_cookie_read['userid']) {
			ESPCMS_Dialog::Message_Page('order_read_err');
		}
		if ($read['islock'] || $read['ispay'] || !$read['ordertype']) {
			ESPCMS_Dialog::Message_Page('order_lock_edit_err');
		}
		$db_where = "WHERE oid=$oid AND userid=" . static::$member_cookie_read['userid'];
		$db_table = ESPCMS_DB_PREFIX . "order";
		$update_key = espcms_db_update_set_save($db_table, $db_where, "ordertype=0");
		if (!$update_key) {
			ESPCMS_Dialog::Message_Page('save_err', OrderLink::order_member_link());
		}
		if ($espcms_command['EMAIL_ISOPEN'] && static::$order_con['ORDER_ISEMAIL']) {
			$read['addtime'] = espcms_timeformat($read['addtime'], 3);
			if (static::$member_cookie_read['isemail'] && espcms_isemail(static::$member_cookie_read['email'])) {
				ESPCMS_SendMessage::send_email_key_message('order_cancel', static::$member_cookie_read['email'], $read);
			}
		}
		if ($espcms_command['SMS_ISOPEN'] && static::$order_con['ORDER_ISMOBLIE']) {
			$read['addtime'] = espcms_timeformat($read['addtime'], 3);
			if (static::$member_cookie_read['ismoblie'] && espcms_ismoblie(static::$member_cookie_read['mobile'])) {
				ESPCMS_SendMessage::send_moblie_sms_message('order_cancel', static::$member_cookie_read['mobile'], $read);
			}
		}
		ESPCMS_Dialog::Message_Page('order_cancel_ok', OrderLink::order_member_link());
	}

}
