<?php
/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030 / 13797552220
*/
use application\ESPCMS_Core;
use modul_application\ESPCMS_Dialog;
use modul_application\ESPCMS_MemberDB;
use modul_application\ESPCMS_OrderDB;
use modul_application\ESPCMS_MemberAuthority;
use modul_application\ESPCMS_SendMessage;
use inc_application\link\OrderLink;
use inc_application\link\MemberLink;
class OrderReturn {
	public static function in_SyncUpdate() {
		global $espcms_web_templates, $espcms_command;
		$espcms_web_templates->into('path', 'order');
		$paycode = $_GET['paycode'];
		if (!$paycode || !espcms_isact($paycode, "/^[\w]+$/i")) {
			ESPCMS_Dialog::Message_Page('order_paycode_err', OrderLink::get_order_link('list'));
		}
		$requery_code = $_GET;
		if (!is_array($requery_code)) {
			ESPCMS_Dialog::Message_Page('order_paycode_err', OrderLink::get_order_link('list'));
		}
		$pay_file = ESPCMS_FILE_ROOT . 'espcms_includes/payment/' . $paycode . '.php';
		if (!is_file($pay_file)) {
			ESPCMS_Dialog::Message_Page('order_paplug_err', OrderLink::get_order_link('list'));
		}
		$pay_plug_read = ESPCMS_OrderDB::get_pay_plug_code_view($paycode);
		$pay_argument = $pay_plug_read['pluglist'] ? unserialize($pay_plug_read['pluglist']) : false;
		if (!$pay_argument || !is_array($pay_argument)) {
			ESPCMS_Dialog::Message_Page('order_paycode_err', OrderLink::get_order_link('list'));
		}
		include_once $pay_file;
		$payobj = new $paycode();
		$order_read = $payobj->respond($requery_code, $pay_argument);
		if (!$order_read['paysn'] || !espcms_ismatches($order_read['paysn']) || !$order_read['opid'] || !espcms_ismatches($order_read['opid'])) {
			ESPCMS_Dialog::Message_Page('order_pay_err', OrderLink::get_order_link('list'));
		}
		$order_read_db = ESPCMS_OrderDB::get_order_view(false, $order_read['ordersn']);
		if (!$order_read_db || !is_array($order_read_db)) {
			ESPCMS_Dialog::Message_Page('order_read_err', OrderLink::get_order_link('list'));
		}
		$order_read['userid'] = $order_read_db['userid'];
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		if (!$order_app_config['isetup'] || !$order_app_config['isopen']) {
			ESPCMS_Dialog::Message_Page('app_close', OrderLink::get_order_link('list'));
		}
		$order_con = unserialize($order_app_config['appconfig']);
		if ($order_read_db['orderamount'] != $order_read['payamount']) {
			ESPCMS_Dialog::Message_Page('order_update_err', OrderLink::get_order_link('list'));
		}
		$member_app_config = ESPCMS_Core::get_app_config('member', false);
		if (!$order_read_db['ispay']) {
			$oprid = ESPCMS_OrderDB::order_install_order_payreceipt($order_read_db['oid'], $order_read);
			if (!$oprid) {
				ESPCMS_Dialog::Message_Page('order_payreceipt_save_err', OrderLink::get_order_link('list'));
			}
			$order_update_type['opid'] = espcms_ismatches($order_read['opid']) && $order_read['opid'] ? $order_read['opid'] : 0;
			$order_update_type['ordertype'] = 2;
			$order_update_type['islock'] = 1;
			$order_update_type['ispay'] = 1;
			$order_update_type['paysn'] = $order_read['paysn'];
			$order_update_type['opid'] = espcms_ismatches($order_read['opid']) && $order_read['opid'] ? $order_read['opid'] : 0;
			$order_update_type['paytime'] = time();
			$oid = ESPCMS_OrderDB::order_update_type($order_read_db['oid'], $order_update_type);
			if (!$oid) {
				ESPCMS_Dialog::Message_Page('order_type_update_err', OrderLink::get_order_link('list'));
			}
			if ($member_app_config['isetup'] && $member_app_config['isopen'] && $order_read_db['userid'] && espcms_ismatches($order_read_db['userid'])) {
				ESPCMS_MemberDB::member_integral_DB($order_read_db['userid'], $order_read_db['integral']);
				ESPCMS_MemberDB::install_member_integral($order_read_db['userid'], $order_read_db['integral'], 1, $order_read_db['ordersn']);
				$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
				$espcms_web_templates->into('member', $member_cookie_info);
			}
			if ($espcms_command['EMAIL_ISOPEN'] && $order_con['ORDER_ISEMAIL']) {
				$order_read_db['addtime'] = espcms_timeformat($order_read_db['addtime'], 3);
				if ($member_cookie_info['isemail'] && espcms_isemail($member_cookie_info['email'])) {
					ESPCMS_SendMessage::send_email_key_message('order_pay_ok', $member_cookie_info['email'], $order_read_db);
				}
				ESPCMS_SendMessage::send_email_key_message('order_system_pay_ok', $espcms_command['ADMINE_MAIL'], $order_read_db);
			}
			if ($espcms_command['SMS_ISOPEN'] && $order_con['ORDER_ISMOBLIE']) {
				$order_read_db['addtime'] = espcms_timeformat($order_read_db['addtime'], 3);
				if ($member_cookie_info['ismoblie'] && espcms_ismoblie($member_cookie_info['mobile'])) {
					ESPCMS_SendMessage::send_moblie_sms_message('order_pay_ok', $member_cookie_info['mobile'], $order_read_db);
				}
				ESPCMS_SendMessage::send_moblie_sms_message('order_system_pay_ok', $espcms_command['SMS_MOBLIE_NB'], $order_read_db);
			}
		} else {
			if ($member_app_config['isetup'] && $member_app_config['isopen'] && $order_read_db['userid'] && espcms_ismatches($order_read_db['userid'])) {
				$member_cookie_info = ESPCMS_MemberAuthority::getMemberInfo();
				$espcms_web_templates->into('member', $member_cookie_info);
			}
		}
		$espcms_web_templates->into('mlink', MemberLink::get_link());
		$espcms_web_templates->into('member_app', $member_app_config);
		$espcms_web_templates->into('member_order_link', OrderLink::order_member_link());
		$espcms_web_templates->into('order_link', OrderLink::get_order_link());
		$espcms_web_templates->into('read', $order_read_db);
		$espcms_web_templates->into('out', 'pay_ok');
		$espcms_web_templates->into('order_con', $order_con);
		$espcms_web_templates->output('member/order', 'order', false, false);
	}
}
