<?php

/*
  PHP version 5
  Copyright (c) 2002-2018 ECISP.CN、EarcLink.COM
  警告：这不是一个免费的软件，请在许可范围内使用，请尊重知识产权，侵权必究，举报有奖
  作者：黄祥云 E-mail:6326420@qq.com  QQ:6326420 TEL:18665655030
  ESPCMS官网介绍：http://www.ecisp.cn	企业建站：http://www.earclink.cn
 */

use application\ESPCMS_Core;
use modul_application\ESPCMS_ArticleDB;
use modul_application\ESPCMS_ArticleTypeDB;
use inc_application\link\ArticleLink;
use inc_application\link\OrderLink;
use inc_application\link\EnquiryLink;

class lib_list {

	public static function call_list($parameter, $filename = 'list', $outHTML = null) {
		$espcms_lib_template = espcms_web_template();
		$espcms_lib_template->libfile = true;
		$para = espcms_array_getvalue($parameter);
		$limit = espcms_ismatches($para['max']) && $para['max'] ? $para['max'] : 20;
		$lng = espcms_lancode();
		$db_where = " AND isclass=1";
		if (espcms_ismatches($para['tid']) && $para['tid']) {
			$istid = true;
			$tid_array = ESPCMS_ArticleTypeDB::get_article_type_listDB($para['tid'], $lng);
			if (is_array($tid_array)) {
				$tid_list = implode(',', array_keys($tid_array));
				if ($tid_list) {
					$db_where .= is_array($tid_array) && count($tid_array) > 1 ? " AND tid IN ($tid_list)" : " AND tid=$tid_list";
				}
			}
		} elseif (espcms_islongfig($para['tid'], '/^[\d]+(-[\d]+)*$/i') && !espcms_ismatches($para['tid'])) {
			$istid = true;
			$long_tid = str_replace('-', ',', $para['tid']);
			$db_where .= " AND tid IN ($long_tid)";
		}
		if (espcms_ismatches($para['mid']) && $para['mid']) {
			$db_where .= " AND mid=" . $para['mid'];
		}
		if (espcms_ismatches($para['sid']) && $para['sid']) {
			$issid = true;
			$db_where .= " AND sid=" . $para['sid'];
		}
		if (espcms_ismatches($para['dlid']) && $para['dlid']) {
			$db_where .= " AND FIND_IN_SET('$para[dlid]',recommend)";
		}
		if (espcms_islongfig($para['linkdid'], '/^[\d]+(\/[\d]+)*$/i')) {
			$linkdid = espcms_long_array($para['linkdid']);
			if ($linkdid && espcms_islongfig($linkdid)) {
				$islinkdid = true;
				$db_where .= " AND did IN ($linkdid)";
			}
		}
		if (!$istid && !$issid && !$islinkdid) {
			$db_where .= " AND lng='$lng'";
		}
		$rank = $para['rank'] == 1 ? 'ASC' : 'DESC';
		switch ($para['sort']) {
			case 1:
				$order_type = 'did ' . $rank;
				break;
			case 2:
				$order_type = 'pid ' . $rank;
				break;
			case 3:
				$order_type = 'pid ' . $rank . ',did ' . $rank;
				break;
			case 4:
				$order_type = 'click ' . $rank;
				break;
			case 5:
				$order_type = 'addtime ' . $rank;
				break;
			default:
				$order_type = 'pid,did ' . $rank;
				break;
		}
		$order_app_config = ESPCMS_Core::get_app_config('order', false);
		$enquiry_app_config = ESPCMS_Core::get_app_config('enquiry', false);
		$db_table = ESPCMS_DB_PREFIX . 'document';
		$talbe_field_array = espcms_field_out($db_table);
		$list_array = espcms_db_list_array($db_table, $talbe_field_array, $db_where, $order_type, '0,' . $limit);
		$doc_array = array();
		if (is_array($list_array)) {
			foreach ($list_array as $key => $value) {
				$value['ctitle'] = empty($value['color']) ? $value['title'] : "<font color='" . $value['color'] . "'>" . $value['title'] . "</font>";
				$type_read = ESPCMS_ArticleTypeDB::get_article_type_view($value['tid']);
				$value['ishtml'] = $type_read['pageclass'] == 2 ? 2 : $value['ishtml'];
				$value['typename'] = $type_read['typename'];
				$value['pageclass'] = $type_read['pageclass'];
				$value['typelink'] = ArticleLink::type_link($type_read);
				$value['dirname'] = $type_read['dirname'];
				$value['readnamestyle'] = $type_read['readnamestyle'];
				$value['link'] = ArticleLink::doc_link($value);
				if ($order_app_config['isetup'] && $order_app_config['isopen']) {
					$value['buylink'] = OrderLink::get_order_link('buy', $value);
				}
				if ($enquiry_app_config['isetup'] && $enquiry_app_config['isopen']) {
					$value['enqlink'] = EnquiryLink::get_enquiry_link('into', $value);
				}
				$attr_read = ESPCMS_ArticleDB::get_article_attr_read($value['did']);
				$doc_array[] = is_array($attr_read) ? array_merge($value, $attr_read) : $value;
			}
		}
		$espcms_lib_template->into('array', $doc_array);
		$espcms_lib_template->into('para', $para);
		if (!empty($outHTML)) {
			$output = $espcms_lib_template->fetch(null, null, $outHTML);
		} else {
			$output = $espcms_lib_template->fetch('lib/' . $filename);
		}
		return $output;
	}

}
