function espcms_isInteger(val) {
	return (/(^[1-9]\d*$)/.test(val));
}
function espcms_round(num, v) {
	var vv = Math.pow(10, v);
	return Math.round(num * vv) / vv;
}
function number_format(number, decimals, dec_point, thousands_sep) {
	number = (number + '').replace(/[^0-9+-Ee.]/g, '');
	number = espcms_round(number, decimals);
	var n = !isFinite(+number) ? 0 : +number,
		prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
		sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
		dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
		s = '',
		toFixedFix = function (n, prec) {
			var k = Math.pow(10, prec);
			return '' + Math.floor(n * k) / k;
		};
	s = (prec ? toFixedFix(n, prec) : '' + Math.floor(n)).split('.');
	var re = /(-?\d+)(\d{3})/;
	while (re.test(s[0])) {
		s[0] = s[0].replace(re, "$1" + sep + "$2");
	}
	if ((s[1] || '').length < prec) {
		s[1] = s[1] || '';
		s[1] += new Array(prec - s[1].length + 1).join('');
		s[1] = s[1] ? s[1] : '00';
	}
	var money_str = '￥' + s.join(dec);
	return money_str;
}
function order_amount() {
	$('.amount').unbind('change').bind('change', function () {
		var amount = $(this).val();
		var bprice = $(this).attr('data-p');
		var did = $(this).attr('data-id');
		var countprice_str = $('#countprice_str_' + did);
		var countprice_did = $('#countprice' + did);
		if (!espcms_isInteger(amount) || !bprice.match(/^(0|[1-9][0-9]{0,9})(\.[0-9]{1,3})?$/ig)) {
			return false;
		}
		amount = !amount ? 0 : parseInt(amount);
		bprice = !bprice ? 0 : bprice;
		var countprice = amount * bprice;
		countprice_did.val(countprice);
		var fmoney = number_format(countprice, 3, ".", ",");
		countprice_str.empty().append(fmoney);
		update_product_total();
	});
}
function order_del() {
	$('.delete_item').on('click', function () {
		var did = $(this).attr('data-id');
		var order_del_url = $('#order_del_url').val();
		$.ajax({
			type: "post",
			url: order_del_url,
			data: {'did': did, 'deltype': 'd'},
			success: function (data) {
				if (data == 'true') {
					window.location.reload();
				}
			}
		});
	});
	$('.delete_all_item').on('click', function () {
		var order_del_url = $('#order_del_url').val();
		$.ajax({
			type: "post",
			url: order_del_url,
			data: {'deltype': 'a'},
			success: function (data) {
				if (data == 'true') {
					window.location.reload();
				}
			}
		});
	});
}
function update_product_total() {
	var product_total = $('#product_total');
	var product_total_str = $('#product_total_str');
	var product_paymoney = 0;
	$('.countprice').each(function () {
		var item_total_now = $(this).val();
		product_paymoney = product_paymoney + parseFloat(item_total_now);
	});
	product_total.val(product_paymoney);
	var product_total = number_format(product_paymoney, 3, ".", ",");
	product_total_str.empty().append(product_total);
}
function ondisplayother(div, style, div2, style2) {
	$('#' + div).removeClass().addClass(style);
	$('#' + div2).removeClass().addClass(style2);
}
function espcms_match(str, reg) {
	if (!str || !reg) {
		return false;
	}
	if (reg) {
		var re = new RegExp(reg, "ig");
	} else {
		return false;
	}
	if (!str.match(re)) {
		return false;
	} else {
		return true;
	}
}
function load_tabclick(inputname) {
	$(inputname).on('click', function () {
		var open_list = $(this).attr('open_list');
		var close_list = $(this).attr('close_list');
		var link_type = $(this).attr('link_type');
		var link_vlaue = $(this).attr('link_vlaue');
		if (link_type != 'undefined' && link_type && link_vlaue) {
			var checked_vlaue = $('input[type=radio][name=' + link_type + ']:checked').val();
			if (link_vlaue != checked_vlaue) {
				return false;
			}
		}
		$(open_list).show();
		$(close_list).hide();
	});
}
function espcms_url_array(str) {
	var newArray = new Array();
	var urlarrayStr = str.split("&");
	var valname = null;
	for (var i = 0; i < urlarrayStr.length; i++) {
		valname = urlarrayStr[i].split("=");
		newArray[valname[0]] = decodeURIComponent(valname[1]);
	}
	return newArray;
}
function espcms_url_long_array(url) {
	if (url === '') {
		return false;
	}
	var num = url.indexOf("?");
	url = url.substr(num + 1);
	var arr = url.split("&");
	var theRequest = new Object();
	var urlArray;
	for (var i = 0; i < arr.length; i++) {
		urlArray = arr[i].split("=");
		if (urlArray.length > 0) {
			theRequest[urlArray[0]] = (urlArray[1]);
		}
	}
	return theRequest;
}
function espcms_combine_url(queryString, url) {
	if (queryString === '' || url === '') {
		return false;
	}
	var urlArray = url.split('?');
	var urlQueryArray = espcms_url_long_array(url);
	var queryStringArray = espcms_url_long_array(queryString);
	var newArray = new Array();
	var i = 0;
	for (var key in urlQueryArray) {
		if (queryStringArray[key] || queryStringArray[key] === '') {
			delete urlQueryArray[key];
		} else {
			newArray[i] = key + '=' + urlQueryArray[key];
			i++;
		}
	}
	for (var key in queryStringArray) {
		if (queryStringArray[key] && queryStringArray[key] !== 'undefined' && queryStringArray[key] !== 'false') {
			newArray[i] = key + '=' + encodeURI(queryStringArray[key]);
			i++;
		}
	}
	var combined = urlArray[0] + "?";
	var keyStr = newArray.join('&');
	combined += keyStr;
	return combined;
}
function into_input_value(val, inputElementID, isappend) {
	var elementName = '#' + inputElementID;
	if (isappend) {
		var append_val = $(elementName).val();
		var news_str = append_val ? append_val + ',' + val : val;
		$(elementName).val(news_str);
	} else {
		$(elementName).val(val);
	}
}
(function ($) {
	$.fn.espcms_token_js = function (opt) {
		if (!opt.url) {
			return false;
		}
		var token_name = !opt.token_name ? 'tokenname' : !opt.token_name;
		var token_key = !opt.token_key ? 'tokenkey' : !opt.token_key;
		$.ajax({
			type: "get",
			url: opt.url,
			dataType: 'json',
			success: function (data) {
				$("#" + token_name).val(data.token_name);
				$("#" + token_key).val(data.token_key);
			}
		});
	};
})(jQuery);
function conpon_check() {
	$('#ocdsn').unbind('change').bind('change', function () {
		var ocdsn = $(this).val();
		if (!ocdsn) {
			return false;
		}
		var didArray = new Array();
		var tidArray = new Array();
		$('.products_id').each(function () {
			var did = $(this).val();
			var tid = $(this).attr('data-tid');
			didArray.push(did);
			tidArray.push(tid);
		});
		if (didArray.length < 1 || tidArray.length < 1) {
			return false;
		}
		var did = didArray.join('_');
		var tid = tidArray.join('_');
		var url = $('#check_coupon_link').val();
		var product_money = $('#productmoney').val();
		if (!url) {
			return false;
		}
		$.ajax({
			type: "post",
			url: url,
			dataType: 'json',
			data: {'did': did, 'tid': tid, 'ocdsn': ocdsn, 'product_money': product_money},
			success: function (data) {
				if (data.code == true) {
					$('#discount').val(data.discount);
					var discount_str = '-' + data.discount_str + '=' + data.pro_discount_str;
					$('.discount_div').empty().append(discount_str).show();
				} else {
					$('#discount').val(0);
					$('.discount_div').empty().hide();
				}
			}
		});
	});
}
