<?php
/***********************************************************
	Filename: {phpok}/admin/site_control.php
	Note	: 站点管理器
	Version : 4.0
	Web		: www.phpok.com
	Author  : qinggan <qinggan@188.com>
	Update  : 2013年10月8日
***********************************************************/
if(!defined("PHPOK_SET")){exit("<h1>Access Denied</h1>");}
class site_control extends phpok_control
{
	public function __construct()
	{
		parent::control();
	}

	public function index_f()
	{
		$rslist = $this->model('site')->get_all_site();
		$this->assign("rslist",$rslist);
		$this->view("site_list");
	}

	/**
	 * 添加新站点
	**/
	public function add_f()
	{
		$this->view("site_add");
	}


	public function addok_f()
	{
		$title = $this->get("title");
		if(!$title){
			$this->error(P_Lang('网站标题不能为空'));
		}
		$domain = $this->get("domain");
		if(!$domain){
			$this->error("域名不能为空");
		}
		$domain = strtolower($domain);
		if(strpos($domain,'/') !== false){
			$this->error(P_Lang('域名填写不规范，不能带有http://或https://或/'));
		}
		$domain_rs = $this->model("site")->domain_check($domain);
		if($domain_rs){
			$this->error(P_Lang('域名已被使用，请更换'));
		}
		$array = array();
		$array["title"] = $title;
		$array["dir"] = '/';
		$array["status"] = 0;
		$array["content"] = '';
		$array["tpl_id"] = 0;
		$array["url_type"] = 'default';
		$array["domain_id"] = "";
		$array["logo"] = '';
		$array["meta"] = '';
		$site_id = $this->model('site')->save($array);
		if(!$site_id){
			$this->error(P_Lang('网站创建失败'));
		}
		$domain_id = $this->model('site')->domain_add($domain,$site_id);
		if($domain_id){
			$tmp = array('domain_id'=>$domain_id);
			$this->model("site")->save($tmp,$site_id);
		}
		$this->success();
	}

	public function delete_f()
	{
		$id = $this->get("id","int");
		if(!$id) $this->json(P_Lang('未指定ID'));
		$rs = $this->model('site')->get_one($id);
		if(!$rs) $this->json(P_Lang('站点信息不存在'));
		if($rs['is_default']){
			$this->json(P_Lang('默认站点不支持删除操作'));
		}
		//删除网站内容
		$this->model("site")->site_delete($id);
		if($id == $_SESSION['admin_site_id']){
			$d_rs = $this->model('site')->get_one_default();
			$_SESSION['admin_site_id'] = $d_rs['id'];
		}
		$this->json(P_Lang('网站删除成功'),true);
	}

	public function default_f()
	{
		$id = $this->get("id","int");
		if(!$id) $this->json(P_Lang('未指定站点信息'));
		$rs = $this->model('site')->get_one($id);
		if(!$rs) $this->json(P_Lang('站点信息不存在'));
		if($rs['is_default']) $this->json(P_Lang('默认站点不支持此操作'));
		$this->model('site')->set_default($id);
		$this->json(P_Lang('默认站点设置成功'),true);
	}
	public function alias_f()
	{
		$id = $this->get('id','int');
		if(!$id){
			$this->json(P_Lang('未指定站点ID'));
		}
		$alias = $this->get('alias');
		if(!$alias){
			$this->json(P_Lang('未指定别名'));
		}
		$this->model('site')->alias_save($alias,$id);
		$this->json(true);
	}
}