﻿if (!this.JSON2) {

    this.JSON2 = {};

}



(function () {



    function f(n) {

        return n < 10 ? '0' + n : n;

    }



    if (typeof Date.prototype.toJSON2 !== 'function') {



        Date.prototype.toJSON2 = function (key) {



            return isFinite(this.valueOf()) ?

                   this.getUTCFullYear()   + '-' +

                 f(this.getUTCMonth() + 1) + '-' +

                 f(this.getUTCDate())      + 'T' +

                 f(this.getUTCHours())     + ':' +

                 f(this.getUTCMinutes())   + ':' +

                 f(this.getUTCSeconds())   + 'Z' : null;

        };



        String.prototype.toJSON2 =

        Number.prototype.toJSON2 =

        Boolean.prototype.toJSON2 = function (key) {

            return this.valueOf();

        };

    }



    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,

        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,

        gap,

        indent,

        meta = {    // table of character substitutions

            '\b': '\\b',

            '\t': '\\t',

            '\n': '\\n',

            '\f': '\\f',

            '\r': '\\r',

            '"' : '\\"',

            '\\': '\\\\'

        },

        rep;





    function quote(string) {



        escapable.lastIndex = 0;

        return escapable.test(string) ?

            '"' + string.replace(escapable, function (a) {

                var c = meta[a];

                return typeof c === 'string' ? c :

                    '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);

            }) + '"' :

            '"' + string + '"';

    }





    function str(key, holder) {



// Produce a string from holder[key].



        var i,          // The loop counter.

            k,          // The member key.

            v,          // The member value.

            length,

            mind = gap,

            partial,

            value = holder[key];





        if (value && typeof value === 'object' &&

                typeof value.toJSON2 === 'function') {

            value = value.toJSON2(key);

        }



        if (typeof rep === 'function') {

            value = rep.call(holder, key, value);

        }





        switch (typeof value) {

        case 'string':

            return quote(value);



        case 'number':



            return isFinite(value) ? String(value) : 'null';



        case 'boolean':

        case 'null':





            return String(value);





        case 'object':





            if (!value) {

                return 'null';

            }





            gap += indent;

            partial = [];





            if (Object.prototype.toString.apply(value) === '[object Array]') {



                length = value.length;

                for (i = 0; i < length; i += 1) {

                    partial[i] = str(i, value) || 'null';

                }





                v = partial.length === 0 ? '[]' :

                    gap ? '[\n' + gap +

                            partial.join(',\n' + gap) + '\n' +

                                mind + ']' :

                          '[' + partial.join(',') + ']';

                gap = mind;

                return v;

            }



            if (rep && typeof rep === 'object') {

                length = rep.length;

                for (i = 0; i < length; i += 1) {

                    k = rep[i];

                    if (typeof k === 'string') {

                        v = str(k, value);

                        if (v) {

                            partial.push(quote(k) + (gap ? ': ' : ':') + v);

                        }

                    }

                }

            } else {





                for (k in value) {

                    if (Object.hasOwnProperty.call(value, k)) {

                        v = str(k, value);

                        if (v) {

                            partial.push(quote(k) + (gap ? ': ' : ':') + v);

                        }

                    }

                }

            }



            v = partial.length === 0 ? '{}' :

                gap ? '{\n' + gap + partial.join(',\n' + gap) + '\n' +

                        mind + '}' : '{' + partial.join(',') + '}';

            gap = mind;

            return v;

        }

    }





    if (typeof JSON2.stringify !== 'function') {

        JSON2.stringify = function (value, replacer, space) {



            var i;

            gap = '';

            indent = '';



            if (typeof space === 'number') {

                for (i = 0; i < space; i += 1) {

                    indent += ' ';

                }



// If the space parameter is a string, it will be used as the indent string.



            } else if (typeof space === 'string') {

                indent = space;

            }



// If there is a replacer, it must be a function or an array.

// Otherwise, throw an error.



            rep = replacer;

            if (replacer && typeof replacer !== 'function' &&

                    (typeof replacer !== 'object' ||

                     typeof replacer.length !== 'number')) {

                throw new Error('JSON2.stringify');

            }



// Make a fake root object containing our value under the key of ''.

// Return the result of stringifying the value.



            return str('', {'': value});

        };

    }





// If the JSON2 object does not yet have a parse method, give it one.



    if (typeof JSON2.parse !== 'function') {

        JSON2.parse = function (text, reviver) {



// The parse method takes a text and an optional reviver function, and returns

// a JavaScript value if the text is a valid JSON2 text.



            var j;



            function walk(holder, key) {



// The walk method is used to recursively walk the resulting structure so

// that modifications can be made.



                var k, v, value = holder[key];

                if (value && typeof value === 'object') {

                    for (k in value) {

                        if (Object.hasOwnProperty.call(value, k)) {

                            v = walk(value, k);

                            if (v !== undefined) {

                                value[k] = v;

                            } else {

                                delete value[k];

                            }

                        }

                    }

                }

                return reviver.call(holder, key, value);

            }





// Parsing happens in four stages. In the first stage, we replace certain

// Unicode characters with escape sequences. JavaScript handles many characters

// incorrectly, either silently deleting them, or treating them as line endings.



            text = String(text);

            cx.lastIndex = 0;

            if (cx.test(text)) {

                text = text.replace(cx, function (a) {

                    return '\\u' +

                        ('0000' + a.charCodeAt(0).toString(16)).slice(-4);

                });

            }



            if (/^[\],:{}\s]*$/.

test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@').

replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']').

replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {





                j = eval('(' + text + ')');



                return typeof reviver === 'function' ?

                    walk({'': j}, '') : j;

            }



// If the text is not JSON2 parseable, then a SyntaxError is thrown.



            throw new SyntaxError('JSON2.parse');

        };

    }

}());

//-------------------------------------------------------------------------------------------------------------------------------

//选择产品时处理

function ProductChange(_curObject,_curVal)

{

    eval("var curList="+$("#ProIDList").val());//原有产品列表

	//alert($("#ProIDList").val());

    eval("var curPro="+_curVal);//当前产品

//	alert(_curVal);

    if(curList.length>1)

    {

        $(_curObject).toggleClass('checked');//多个产品时改变当前产品选择状态

        if($(_curObject).hasClass('checked'))

        {

            curList.unshift(curPro);//添加当前产品

        }

        else

        {

	        for(i=0;i<curList.length;i++)

	        {

    		    if(curList[i].ID==curPro.ID)

    		    {

    		        curList.splice(i,1);//移除当前产品

    		        break;

    		    }

	        }

	    }	    

	}

	else if(!$(_curObject).hasClass('checked'))

	{

	    $(_curObject).toggleClass('checked');

	    curList.unshift(curPro);//当只有一个产品时只能添加	    

	}

	var _proTotal=0.00;

	for(i=0;i<curList.length;i++)

    {

        _proTotal+=parseFloat(curList[i].Price);	    

    }

    $("#spanProTotal").html("&yen;"+changeTwoDecimal_f(_proTotal));//总价

	$("#ProIDList").val(JSON2.stringify(curList));//保存当前选择的全部产品列表	

}

//保留二位小数

function changeTwoDecimal_f(x)

{

    var f_x = parseFloat(x);

    if (isNaN(f_x))

    {

        return false;//出错返回

    }

    var f_x = Math.round(x*100)/100;

    var s_x = f_x.toString();

    var pos_decimal = s_x.indexOf('.');

    if (pos_decimal < 0)

    {

        pos_decimal = s_x.length;

        s_x += '.';

    }

    while (s_x.length <= pos_decimal + 2)

    {

        s_x += '0';

    }

    return s_x;

}

//加载相关推荐

function Mobile_Load_Relation(_ProductID)

{

    $.ajax({

                type:"GET",

                url:"/Ajax/Mobile_Load_Relation.ashx",

                cache:false,

                async:false,

                dataType:"html",

                data:"ID="+_ProductID,

                success:function(html){$("#ulRelation").html(html);},

                error:function(){$("#ulRelation").html("相关推荐加载失败");}

             })

}