define(function(require, exports, module) {
/**
 * Simpletooltip is a JQuery plugin, thought to insert short tooltips to any element of your website more easily
 * v1.3.0
 *
 * 2014 Carlos Sanz Garcia
 * Distributed under GPL-3.0 license
 *
 * http://not-only-code.github.com/Simpletooltip
 */

!function(a){"use strict";var b,c=null;b=function(a){return void 0!==a&&"object"==typeof a&&(this.$el=a.$el||null,this.$tooltip=null,this.$arrow=null,this.margins={border:6,top:15,right:15,bottom:15,left:15},this.settings={},this.themes={},this.isJqueryObject(this.$el)&&!this.$el.data().hasOwnProperty("simpletooltipInstanced")&&(this.title=this.$el.attr("title"),void 0!==this.title&&this.title.length))?(this.$el.attr("title",""),this.setOptions(a.settings),this.setTooltip(),this.initialize(),this.$el.data("simpletooltip-instanced","1"),this):void 0},b.defaults={position:"top",color:"#DDDDDD",background_color:"#222222",border_width:0,arrow_width:6,padding:{width:8,height:6},max_width:200,fade:!0},b.themes={dark:{color:"#CCCCCC",background_color:"#222222",border_color:"#111111",border_width:4},gray:{color:"#434343",background_color:"#DCDCDC",border_color:"#BABABA",border_width:4},white:{color:"#6D7988",background_color:"#CCDEF2",border_color:"#FFFFFF",border_width:4},blue:{color:"#FFFFFF",background_color:"#0088BE",border_color:"#00669C",border_width:4}},b.templates={tooltip:'<div class="simple-tooltip"></div>',arrow:'<span class="arrow">&nbsp;</span>'},b.prototype.isJqueryObject=function(a){return null!==a&&void 0!==a&&"object"==typeof a&&void 0!==a.jquery},b.prototype.setTooltip=function(){return this.isJqueryObject(this.$tooltip)&&this.isJqueryObject(this.$arrow)?void 0:(this.$tooltip=a(b.templates.tooltip),this.$tooltip.html(this.title),this.$tooltip.addClass(this.getAttribute("position")),this.$arrow=a(b.templates.arrow),this.$tooltip.append(this.$arrow),this.$tooltip)},b.prototype.setOptions=function(c){void 0!==c&&"object"==typeof c&&(this.settings=a.extend(b.defaults,c),void 0!==this.settings.themes&&"object"==typeof this.settings.themes&&(this.themes=a.extend(b.themes,this.settings.themes),delete this.settings.themes),void 0!==this.themes[this.settings.theme]&&(this.settings=a.extend(this.settings,this.themes[this.settings.theme])))},b.prototype.initialize=function(){this.$el.on("mouseenter",{that:this},this.mouseOver),this.$el.on("mouseleave",{that:this},this.mouseOut),this.$el.attr("title","")},b.prototype.getAttribute=function(a){var b,c="simpletooltip-"+a.replace("_","-");return void 0!==this.$el.data(c)?this.$el.data(c):void 0!==(b=this.$el.data("simpletooltip-theme"))&&void 0!==this.themes[b]&&void 0!==this.themes[b][a]?this.themes[b][a]:void 0!==this.settings[a]?this.settings[a]:!1},b.prototype.mouseOver=function(a){var b=a.data.that;return b.$tooltip.parent().length?a:(c.append(b.$tooltip),b.$tooltip.hide(),b.styleTooltip(),b.getAttribute("fade")?b.$tooltip.delay(180).fadeIn(200):b.$tooltip.show(),a)},b.prototype.mouseOut=function(a){var b=a.data.that;return b.$tooltip.parent().length?b.$tooltip.css("opacity")?(b.getAttribute("fade")?b.$tooltip.clearQueue().stop().fadeOut(100,function(){b.$tooltip.remove()}):b.$tooltip.remove(),a):(b.$tooltip.remove(),a):a},b.prototype.styleTooltip=function(){if(this.isJqueryObject(this.$el)&&this.isJqueryObject(this.$tooltip)){var b=this.$el.offset(),c=this.getAttribute("background_color"),d=this.getAttribute("border_color");this.isJqueryObject(this.$arrow)||(this.$arrow=this.$tooltip.find(" > .arrow"));var e=this.getAttribute("border_width");e=d&&"boolean"!=typeof e&&"none"!==e?Number(e):0;var f=e&&d?d:c,g=Math.round(3*this.settings.arrow_width/4),h=-parseInt(2*this.settings.arrow_width+e,10),i=-parseInt(2*g+e,10),j={maxWidth:this.getAttribute("max_width"),backgroundColor:c,color:this.getAttribute("color"),borderColor:d,borderWidth:e};switch(this.getAttribute("position")){case"top-right":b.top-=parseInt(this.$tooltip.outerHeight()+this.margins.bottom,10),b.left+=parseInt(this.$el.outerWidth()-this.margins.right-this.margins.border,10),this.$arrow.css({left:this.settings.padding.width-e,borderWidth:g,bottom:i,borderTopColor:f,borderLeftColor:f});break;case"right-top":b.top-=parseInt(this.$tooltip.outerHeight()-this.margins.bottom,10),b.left+=parseInt(this.$el.outerWidth()+this.margins.right,10),this.$arrow.css({bottom:this.settings.padding.height-e,borderWidth:g,left:i,borderRightColor:f,borderBottomColor:f});break;case"right":b.top+=parseInt((this.$el.outerHeight()-this.$tooltip.outerHeight())/2,10),b.left+=parseInt(this.$el.outerWidth()+this.margins.right,10),this.$arrow.css({left:h,borderRightColor:f,marginTop:-this.settings.arrow_width});break;case"right-bottom":b.top+=parseInt(this.$el.outerHeight()-this.margins.bottom,10),b.left+=parseInt(this.$el.outerWidth()+this.margins.right,10),this.$arrow.css({top:this.settings.padding.height-e,borderWidth:g,left:i,borderRightColor:f,borderTopColor:f});break;case"bottom-right":b.top+=parseInt(this.$el.outerHeight()+this.margins.bottom,10),b.left+=parseInt(this.$el.outerWidth()-this.margins.right-this.margins.border,10),this.$arrow.css({left:this.settings.padding.width-e,borderWidth:g,top:i,borderBottomColor:f,borderLeftColor:f});break;case"bottom":b.top+=parseInt(this.$el.outerHeight()+this.margins.bottom,10),b.left+=parseInt((this.$el.outerWidth()-this.$tooltip.outerWidth())/2,10),this.$arrow.css({top:h,marginLeft:-this.settings.arrow_width,borderBottomColor:f});break;case"bottom-left":b.top+=parseInt(this.$el.outerHeight()+this.margins.bottom,10),b.left-=parseInt(this.$tooltip.outerWidth()-this.margins.left-this.margins.border,10),this.$arrow.css({right:this.settings.padding.width-e,borderWidth:g,top:i,borderBottomColor:f,borderRightColor:f});break;case"left-bottom":b.top+=parseInt(this.$el.outerHeight()-this.margins.bottom,10),b.left-=parseInt(this.$tooltip.outerWidth()+this.margins.left,10),this.$arrow.css({top:this.settings.padding.height-e,borderWidth:g,right:i,borderLeftColor:f,borderTopColor:f});break;case"left":b.top+=parseInt((this.$el.outerHeight()-this.$tooltip.outerHeight())/2,10),b.left-=parseInt(this.$tooltip.outerWidth()+this.margins.left,10),this.$arrow.css({right:h,borderLeftColor:f,marginTop:-this.settings.arrow_width});break;case"left-top":b.top-=parseInt(this.$tooltip.outerHeight()-this.margins.bottom,10),b.left-=parseInt(this.$tooltip.outerWidth()+this.margins.left,10),this.$arrow.css({bottom:this.settings.padding.height-e,borderWidth:g,right:i,borderLeftColor:f,borderBottomColor:f});break;case"top-left":b.top-=parseInt(this.$tooltip.outerHeight()+this.margins.bottom,10),b.left-=parseInt(this.$tooltip.outerWidth()-this.margins.left,10),this.$arrow.css({right:this.settings.padding.width-e,borderWidth:g,bottom:i,borderTopColor:f,borderRightColor:f});break;default:b.top-=parseInt(this.$tooltip.outerHeight()+this.margins.top,10),b.left+=parseInt((this.$el.outerWidth()-this.$tooltip.outerWidth())/2,10),this.$arrow.css({bottom:h,borderTopColor:f,marginLeft:-this.settings.arrow_width})}this.$tooltip.css(a.extend(j,{top:b.top,left:b.left}))}},a.fn.simpletooltip=function(c){return this.each(function(){var d=a(this);if(!d.data().hasOwnProperty("simpletooltipInstanced")){var e={$el:d};void 0!==c&&"object"==typeof c&&(e.settings=c),new b(e)}})},a(window).on("load",function(){c=a("body"),a('[data-simpletooltip="init"]').each(function(){a(this).simpletooltip()})})}(jQuery);

});