<?php
	//转为实体函数
	function un_escape($str){
 		$ret = '';
 		$len = strlen($str);
 		for ($i = 0; $i < $len; $i++){
 			if ($str[$i] == '%' && $str[$i+1] == 'u'){
 				$val = hexdec(substr($str, $i+2, 4));
				if ($val < 0x7f) 
					$ret .= chr($val);
				else if($val < 0x800) 
					$ret .= chr(0xc0|($val>>6)).chr(0x80|($val&0x3f));
				else 
					$ret .= chr(0xe0|($val>>12)).chr(0x80|(($val>>6)&0x3f)).chr(0x80|($val&0x3f));
				$i += 5;
			}
			else if ($str[$i] == '%'){
				$ret .= urldecode(substr($str, $i, 3));
				$i += 2;
			}
			else $ret .= $str[$i];
		}
		return $ret;
	}
	
	function htmlencode($fstring){
		if (!empty($fstring)){
		   $string1=str_replace(chr(32),"&nbsp;",$fstring);
		   $string=str_replace(chr(13),"<br />",$string1);
		}
		return $string;
	}
	
	//删除目录下所有文件和子目录
	function deldir($directory){
		if(is_dir($directory)) {      
			if($dir_handle=@opendir($directory)) {	
				while(false!==($filename=readdir($dir_handle))) {  
					$file=$directory."/".$filename;
					if($filename!="." && $filename!="..") {   
						if(is_dir($file)) {
							deldir($file);
						} else {
							unlink($file);
						}           
					}
				}
				closedir($dir_handle);                      
				                     
			}
			rmdir($directory);     
		}
	}
	
	//中文字符编码转换
	function checkstr($word){
		if (!mb_check_encoding($word, 'utf-8')){  
			$word = iconv('gb2312', 'utf-8', $word);  
		}else{
			$word=$word;
		}
		return $word;
	}
	//统计目录大小
	function dirsize($dir_path)
	{
		$size = 0;
		if (is_file($dir_path)) {
			$size = filesize($dir_path);
		} else {
			$dir_arr = glob(trim($dir_path).'/*');
			if (is_array($dir_arr)) {
				foreach ($dir_arr as $k => $v) {
					$size += dirsize($v);
				}
			}
		}
		return $size;
	}