<?php
	class Common extends Action {
		function init(){
		if(!file_exists("./runtime/install.lock")){
			header("Location:".B_ROOT."/install/index.php");
		}
		//常量信息
		$this->assign("appname", APP_NAME);
		$this->assign("keywords", KEYWORD);
		$this->assign("description", DESCRIPTION);
		$this->assign("icp",ICP);
		$this->assign("copy",COPY);
		$this->assign("tel",TEL);
		
		//页面导航
		$cache = new FileCache();
		$globallink = $cache->get("globallink");
		if(!$globallink){
			$menu = D('menu');
			$globallink = $menu->field('id,title,url,target,type')->order('ord asc')->where(array('pid'=>0,'display'=>1))->r_select(array("menu",'id,title,url,target,type','pid',array('men','ord asc','',"display=1")));
			$cache->set("globallink",$globallink);		
		}
		$this->assign('globallink',$globallink);

		//焦点图
		$ban = $cache->get("banner");
		if(!$ban){
			$banner = D('banner');
			$ban = $banner->where(array('display'=>1,'ord'=>array(0,1,2,3,4,5)))->order('ord asc')->select();
			$cache->set("banner",$ban);
		}
		$this->assign('ban',$ban);
		
		//公告
		$notice = $cache->get("notice");
		if(!$notice){
			$time=strtotime(date("Y-m-d"))+60*60*24;
			$notice=D("notice")->field('id,title,color,starttime')->where('display="1" and "'.$time.'" > starttime and ("'.$time.'" < endtime or endtime="0")')->order("ord asc")->select();
			$cache->set("notice",$notice);
		}
		$this->assign("notice", $notice);
		
		//联系方式
		$contact = $cache->get("contact");
		if(!$contact){
			$contact = D("fun")->where(array("id"=>1,"audit"=>1))->find();
			$contact["content"]=str_replace(array("&quot;", "&#039;"),array("\"", "'"), $contact["content"]);
			$cache->set("contact",$contact);
		}
		$this->assign("contact",$contact);
		
		//分配插件
		$activex = $cache->get("activex");
		if(!$activex){
			$activex = D('activex')->where(array('audit'=>1))->order('id asc')->select();
			$cache->set("activex",$activex);
		}
		$this->assign('activex',$activex);
		
		//友情链接
		$links = $cache->get("links");
		if(!$links){
			$links = D("flink")->field('id, webname,url,logo,list')->where(array("audit"=>1))->order("ord asc")->select();
			$cache->set("links",$links);	
		}
		$this->assign("links",$links);
		
		}		
	}