-- --------------------------------------------------
-- 文件名: yixun.sql 
-- YiXunCMS数据库安装文件
-- 作者： 易迅软件
-- --------------------------------------------------

# --------------------------------------------------------
# 表的结构 yx_menu,该表用于导航
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_menu;
CREATE TABLE yx_menu (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(10) NOT NULL,
  `pid` smallint(5) NOT NULL,
  `path` varchar(100) NOT NULL,
  `target` varchar(10) NOT NULL,
  `url` varchar(100) NOT NULL,
  `display` tinyint(1) NOT NULL DEFAULT '1',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `menu_pid` (`pid`),
  KEY `menu_path` (`path`),
  KEY `menu_display` (`display`),
  KEY `menu_type` (`type`),
  KEY `menu_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_notice,该表用于站内公告
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_notice;
CREATE TABLE yx_notice (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL DEFAULT '',
  `color` char(6) NOT NULL DEFAULT '000000',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `display` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `notice_starttime` (`starttime`),
  KEY `notice_endtime` (`endtime`),
  KEY `notice_display` (`display`),
  KEY `notice_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_acolumn,该表用于单页分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_acolumn;
CREATE TABLE yx_acolumn (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `picid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `acolumn_pid` (`pid`),
  KEY `acolumn_picid` (`picid`),
  KEY `acolumn_path` (`path`),
  KEY `acolumn_display` (`display`),
  KEY `acolumn_ord` (`ord`),
  KEY `acolumn_type` (`type`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;


# --------------------------------------------------------
# 表的结构 yx_about,该表用于单页
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_about;
CREATE TABLE yx_about (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(3) unsigned NOT NULL DEFAULT '0',
  `pic` char(24) DEFAULT 'no_image.gif',
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `about_pid` (`pid`),
  KEY `about_audit` (`audit`),
  KEY `about_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_about,该表用于单页分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_acolumn;
CREATE TABLE yx_acolumn (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `picid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `acolumn_pid` (`pid`),
  KEY `acolumn_picid` (`picid`),
  KEY `acolumn_path` (`path`),
  KEY `acolumn_display` (`display`),
  KEY `acolumn_ord` (`ord`),
  KEY `acolumn_type` (`type`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_advert,该表用于网站广告
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_advert;
CREATE TABLE yx_advert (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `wz` smallint(1) unsigned NOT NULL DEFAULT '0',
  `pic` char(24) NOT NULL,
  `links` varchar(100) NOT NULL,
  `display` smallint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `advert_wz` (`wz`),
  KEY `advert_display` (`display`),
  KEY `advert_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_album,该表用于相册
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_album;
CREATE TABLE yx_album (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `display` smallint(3) NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `album_pid` (`pid`),
  KEY `album_path` (`path`),
  KEY `album_display` (`display`),
  KEY `album_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_image,该表用于相片
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_image;
CREATE TABLE yx_image (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `name` char(24) NOT NULL DEFAULT '',
  `title` varchar(80) NOT NULL,
  `thumb` tinyint(1) NOT NULL DEFAULT '0',
  `water` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `image_pid` (`pid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_column,该表用于文章分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_column;
CREATE TABLE yx_column (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `picid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `callid` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `column_pid` (`pid`),
  KEY `column_picid` (`picid`),
  KEY `column_path` (`path`),
  KEY `column_audit` (`audit`),
  KEY `column_ord` (`ord`),
  KEY `column_display` (`display`),
  KEY `column_callid` (`callid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_article,该表用于文章
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_article;
CREATE TABLE yx_article (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `pic` char(24) DEFAULT 'no_image.gif',
  `summary` varchar(300) NOT NULL DEFAULT '',
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `comefrom` varchar(50) NOT NULL DEFAULT '',
  `content` text,
  `keyword` varchar(20) NOT NULL DEFAULT '',
  `fun` varchar(100) NOT NULL DEFAULT '无',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `recommend` smallint(1) unsigned NOT NULL DEFAULT '0',
  `allow` smallint(1) unsigned NOT NULL DEFAULT '1',
  `views` smallint(5) unsigned NOT NULL DEFAULT '0',
  `ord` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `article_title` (`title`),
  KEY `article_uid` (`uid`),
  KEY `article_pid` (`pid`),
  KEY `article_audit` (`audit`),
  KEY `article_recommend` (`recommend`),
  KEY `article_allow` (`allow`),
  KEY `article_keyword` (`keyword`),
  KEY `article_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_phcolumn,该表用于展示分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_phcolumn;
CREATE TABLE yx_phcolumn (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `path` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `callid` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `phcolumn_pid` (`pid`),
  KEY `phcolumn_path` (`path`),
  KEY `phcolumn_audit` (`audit`),
  KEY `phcolumn_ord` (`ord`),
  KEY `phcolumn_display` (`display`),
  KEY `phcolumn_callid` (`callid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_photo,该表用于展示
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_photo;
CREATE TABLE yx_photo (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(50) NOT NULL DEFAULT '',
  `summary` varchar(300) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `recommend` smallint(1) unsigned NOT NULL DEFAULT '0',
  `top` smallint(1) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `content` text,
  `views` smallint(5) NOT NULL DEFAULT '0',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  `posttime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `photo_title` (`title`),
  KEY `photo_pid` (`pid`),
  KEY `photo_uid` (`uid`),
  KEY `photo_recommend` (`recommend`),
  KEY `photo_top` (`top`),
  KEY `photo_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_vcolumn,该表用于视频分类
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_vcolumn;
CREATE TABLE yx_vcolumn (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `pid` smallint(5) unsigned NOT NULL,
  `path` varchar(100) NOT NULL,
  `title` varchar(100) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `vcolumn_audit` (`audit`),
  KEY `vcolumn_ord` (`ord`),
  KEY `vcolumn_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_video,该表用于视频
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_video;
CREATE TABLE yx_video (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `pid` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `ptime` int(10) unsigned NOT NULL DEFAULT '0',
  `recommend` smallint(1) unsigned NOT NULL DEFAULT '0',
  `comefrom` smallint(1) unsigned NOT NULL DEFAULT '0',
  `views` smallint(5) NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `video_pid` (`pid`),
  KEY `video_recommend` (`recommend`),
  KEY `video_comefrom` (`comefrom`),
  KEY `video_audit` (`audit`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_banner,该表用于轮播图
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_banner;
CREATE TABLE yx_banner (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(80) NOT NULL,
  `pic` char(24) NOT NULL,
  `links` varchar(100) NOT NULL,
  `display` smallint(1) NOT NULL DEFAULT '1',
  `ord` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `banner_display` (`display`),
  KEY `banner_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_board,该表用于留言板
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_board;
CREATE TABLE yx_board (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `nickname` varchar(50) NOT NULL DEFAULT '',
  `telephone` varchar(11) NOT NULL DEFAULT '0',
  `email` varchar(50) NOT NULL DEFAULT '',
  `msn` varchar(20) DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_download,该表用于下载
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_download;
CREATE TABLE yx_download (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `picid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL,
  `filename` char(24) NOT NULL DEFAULT '',
  `summary` varchar(300) NOT NULL DEFAULT '',
  `posttime` int(10) unsigned NOT NULL DEFAULT '0',
  `views` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `download_picid` (`picid`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_flink,该表用于友情链接
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_flink;
CREATE TABLE yx_flink (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `webname` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(60) NOT NULL DEFAULT '',
  `logo` varchar(60) NOT NULL DEFAULT '',
  `rname` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `dtime` int(10) unsigned NOT NULL DEFAULT '0',
  `msg` varchar(200) NOT NULL DEFAULT '',
  `list` smallint(1) unsigned NOT NULL DEFAULT '0',
  `audit` smallint(1) unsigned NOT NULL DEFAULT '0',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `flink_list` (`list`),
  KEY `flink_audit` (`audit`),
  KEY `flink_ord` (`ord`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_fun,该表用于扩展
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_fun;
CREATE TABLE yx_fun (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text,
  `audit` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fun_audit` (`audit`),
  KEY `fun_ord` (`ord`)  
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_group,该表用于用户组
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_group;
CREATE TABLE yx_group (
  `id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
  `groupname` varchar(20) NOT NULL DEFAULT '',
  `description` varchar(200) NOT NULL DEFAULT '',
  `baseadmin` tinyint(1) NOT NULL DEFAULT '0',
  `unitadmin` tinyint(1) NOT NULL DEFAULT '0',
  `artadmin` tinyint(1) NOT NULL DEFAULT '0',
  `disadmin` tinyint(1) NOT NULL DEFAULT '0',
  `downadmin` tinyint(1) NOT NULL DEFAULT '0',
  `videoadmin` tinyint(1) NOT NULL DEFAULT '0',
  `funadmin` tinyint(1) NOT NULL DEFAULT '0',
  `imgadmin` tinyint(1) NOT NULL DEFAULT '0',
  `dataadmin` tinyint(1) NOT NULL DEFAULT '0',
  `updateadmin` tinyint(1) NOT NULL DEFAULT '0',
  `useradmin` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_user,该表用于用户
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_user;
CREATE TABLE yx_user (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` smallint(4) unsigned NOT NULL,
  `username` varchar(20) NOT NULL DEFAULT '',
  `userpwd` varchar(40) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  `sex` smallint(3) NOT NULL DEFAULT '0',
  `disable` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `user_gid` (`gid`),
  KEY `user_username` (`username`),
  KEY `user_userpwd` (`userpwd`),
  KEY `user_disable` (`disable`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 表的结构 yx_play,该表用于幻灯片
# --------------------------------------------------------
DROP TABLE IF EXISTS yx_play;
CREATE TABLE yx_play (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL DEFAULT '',
  `pic` char(24) NOT NULL DEFAULT '',
  `starttime` int(10) unsigned NOT NULL DEFAULT '0',
  `endtime` int(10) unsigned NOT NULL DEFAULT '0',
  `display` smallint(1) unsigned NOT NULL DEFAULT '1',
  `ord` smallint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `play_aid` (`aid`),
  KEY `play_starttime` (`starttime`),
  KEY `play_endtime` (`endtime`),
  KEY `play_ord` (`ord`),
  KEY `play_display` (`display`)
) DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci;

# --------------------------------------------------------
# 转存表中的数据 `yx_menu`
# --------------------------------------------------------
INSERT INTO yx_menu (`id`,`title`,`pid`,`path`,`target`,`url`,`display`,`type`,`ord`) VALUES
('1','首页','0','0','_self','/','1','0','0'),
('2','公司简介','0','0','_self','/alone/index/pid/2','1','0','1'),
('3','产品展示','0','0','_self','/pro/index/pid/2','1','0','2'),
('4','成功案例','0','0','_self','/pro/index/pid/4','1','0','3'),
('6','动态资讯','0','0','_self','/article/index/pid/2','1','0','4'),
('7','在线留言','0','0','_self','/board/index/pid/1','1','0','8'),
('8','企业招聘','0','0','_self','/alone/index/pid/7','1','0','7'),
('9','联系我们','0','0','_self','/alone/index/pid/5','1','0','9'),
('10','企业概况','2','0-2','_self','/alone/index/pid/2','1','0','0'),
('11','企业资质','0','0','_self','/alone/index/pid/4','1','0','2'),
('12','资料下载','0','0','_self','/download/index/pid/1','1','0','6'),
('13','宣传视频','0','0','_self','/video/index/pid/2','1','0','5');

# --------------------------------------------------------
# 转存表中的数据 `yx_notice`
# --------------------------------------------------------
INSERT INTO yx_notice (`id`,`title`,`color`,`starttime`,`endtime`,`content`,`display`,`ord`) VALUES
('1','亲爱的用户，您正在使用的是YIXUNCMS2.0.4.9SD版~~','DB0000','1459237156','0','<p>	亲爱的用户，您正在使用的是YIXUNCMS2.0.4.9SD版~~</p>','1','0'),
('2','YIXUNCMS2.0.4.9建站系统用图说明','000000','1459237156','0','<p>	本网站中所使用的部分图片均来源于互联网，仅为网站系统测试使用，图片版权规源网站、单位及个人所有，任何单位或个人不得使用其用于商业宣传或其它用途。</p>','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_acolumn`
# --------------------------------------------------------
INSERT INTO yx_acolumn (`id`,`pid`,`picid`,`path`,`title`,`description`,`display`,`ord`,`type`,`link`) VALUES
('1','0','16','0','企业介绍','ABOUTS','1','0','1','1'),
('2','1','15','0-1','公司概况','Company profile','1','0','1','1'),
('3','1','15','0-1','企业文化','Corporate culture','1','0','1','1'),
('4','1','15','0-1','企业资质','Qualification','1','0','0','1'),
('5','1','15','0-1','联系我们','contact','1','0','1','1'),
('6','0','15','0','人才招聘','Talent recruit','1','0','1','1'),
('7','6','15','0-6','人才政策','Talent policy','1','0','1','1'),
('8','6','15','0-6','招聘职位','Recruitment post','1','0','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_about`
# --------------------------------------------------------
INSERT INTO yx_about (`id`,`pid`,`pic`,`title`,`content`,`audit`,`ord`) VALUES
('1','2','no_image.gif','公司介绍','<p>	易迅软件是一家从事BS架构软件应用及开发的工作团队，专注服务于国内中小型企业单位、各级院校网站平台及WEB应用系统的设计与研发，旨在通过更加简易的搭建过程、更简单的维护特性、更省心地的系统升级为用户寻找一种更为高效、经济的建站方式。 目前易迅软件已广泛应用于国内数千家网站，数百家网络公司使用YIXUNCMS系统进行网站搭建，简洁的界面、简易的操作得到了广大企业的认可，被企业称为国内首选的企业网站建设系统。</p><p>	易迅软件拥有经验丰富的设计和研发团队， 规范的－－软件开发流程。团队秉承简易操作、高效运行的理念注重产品的外观设计、易操作、高效率，易迅软件通过成熟的底层框架技术保证了软件代码的健壮，使得易迅软件无论在稳定性、运行效率、负载能力、安全性等方面都表现出了良好的性能。</p><p>	我们坚持高效、经济建站的原则，真诚希望与您建立良好的合作伙伴关系，努力提升我们的软件与服务水平，为您节约每一分成本、创造价值。易迅将不断进取，努力打造功能强大、简洁实用的软件，为用户提供满意的软件产品。</p>','1','0'),
('3','5','no_image.gif','联系我们','<p>	易迅软件技术工作室</p><p>	全国服务热线：15284330477<br />	企鹅：1652368686<br />	电子信箱：1652368686@qq.com<br />	官方网址：http://www.ys-bs.com<br />	易迅建站超市：http://shop.ys-bs.com</p>','1','2'),
('7','4','20160502235330_519.jpg','资质证书','<p>	请在后台自行修改</p>','1','0'),
('8','4','20160502235324_250.jpg','资质证书','<p>	请在后台自行修改</p>','1','0'),
('9','4','20160502235316_620.jpg','资质证书','<p>	请在后台自行添加</p>','1','0'),
('10','7','no_image.gif','人才政策','<p>	请在后台自行添加</p>','1','0'),
('11','8','no_image.gif','人才招聘','<p>	招聘职位：业务员</p><p>	工作地点：北京</p><p>	招聘人数：5人</p><p>	要求：有工作经验优先考虑</p>','1','0'),
('12','3','no_image.gif','企业文化','<p>	<p>	请在后台自行添加</p></p>','1','0');

# --------------------------------------------------------
# 转存表中的数据 `yx_advert`
# --------------------------------------------------------
INSERT INTO yx_advert (`id`,`wz`,`pic`,`links`,`display`,`ord`) VALUES
('1','2','20151202132405_826.png','http://www.ys-bs.com','1','1'),
('2','1','20160407175605_417.png','http://shop.ys-bs.com','1','0'),
('3','3','20160529203638_778.png','http://www.ys-bs.com/','1','0'),
('4','4','20160529203651_482.png','http://www.ys-bs.com/','1','0'),
('5','5','20160529203703_345.png','http://www.ys-bs.com/','1','0'),
('6','6','20160529203710_123.png','http://www.ys-bs.com/','1','0');

# --------------------------------------------------------
# 转存表中的数据 `yx_album`
# --------------------------------------------------------
INSERT INTO yx_album (`id`,`pid`,`path`,`title`,`description`,`display`,`ord`,`link`) VALUES
('1','0','0','分类用图','分类用图','1','0','1'),
('2','0','0','下载用图','下载用图','1','0','1'),
('4','0','0','其它用图','其它用图','0','0','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_image`
# --------------------------------------------------------
INSERT INTO yx_image (`id`,`pid`,`name`,`title`,`thumb`,`water`) VALUES
('1','4','20160522192001_817.png','公司图册','0','1'),
('2','2','20160407153246_193.png','公司图册','0','0');

# --------------------------------------------------------
# 转存表中的数据 `yx_column`
# --------------------------------------------------------
INSERT INTO yx_column (`id`,`pid`,`picid`,`path`,`title`,`description`,`audit`,`ord`,`display`,`callid`,`link`) VALUES
('1','0','1','0','资讯动态','dynamics','0','0','1','0','1'),
('2','1','1','0-1','公司动态','Company news','0','0','1','1','1'),
('3','5','1','0-5','施工工艺','Site experience','0','0','1','1','1'),
('4','1','1','0-1','行业动态','Industry news','0','0','1','1','1'),
('5','0','1','0','技术文摘','Industry','0','0','1','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_article`
# --------------------------------------------------------
INSERT INTO `yx_article` (`id`,`title`,`pic`,`summary`,`posttime`,`uid`,`comefrom`,`content`,`keyword`,`fun`,`pid`,`audit`,`recommend`,`allow`,`views`,`ord`) VALUES
('1','根据需求定位网站的排名和策略','no_image.gif','网站排名中最重要的部分是哪里?我们多认为是标题、meta标签、内容和外链。这样的理解不能说是错误的，关键在于我们的之后的SEO优化操作上。我们以“网络公司”网站来进行实战分析。 ','1459237156','1','ASP300','<p>请在后台自行修改...</p>','定位,网站','无','3','1','0','0','62','0'),
('2','提高关键词检索量的方法有哪些','no_image.gif','我们在从事网站优化的时候都希望能够全面提高网站关键词的搜索量，那么我们到底应该怎么做呢?下面我们就来分析提高关键词搜索量的方法有哪些，从而让我们更好地做好关键词优化工作。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','3','1','1','1','2','0'),
('3','如何建立自己的网站','no_image.gif','时代在不断的变化，我们也随着它而不断的变化。互联网的时代也越来越强大，所以成千上万的企业都在为自己的企业、品牌创造属于自己的网站，个人也给自己建立网站了。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','3','1','1','1','3','0'),
('4','关键词转移单元对质量度是否有影响','no_image.gif','　　百度竞价推广关键词转移单元对质量度有影响吗?很大一部分做竞价推广账户的人认为关键词转移一定会降低关键词质量度。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','3','1','1','1','1','0'),
('5','如何用竞价软件刷排名获得最好的效果','no_image.gif','做百度竞价推广使用刷价软件的好处是什么?就是关键词出价的优化。关键词人工出价往往会出现出价虚高的情况，这是人工调价所不能避免 的，而且效率很差。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','3','1','1','1','6','0'),
('6','移动网站的营销首先要做好站','no_image.gif','移动搜索其实大部分都是碎片化时间搜索，不像PC端的搜索那样。移动端有很多特质，它不可能像PC端那样首页放很多东西。因为屏幕小，所以我们一定要 找出产品的核心需求点，写那么两点最多三点就行了。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','3','1','1','1','1','0'),
('7','竞价推广中着陆页的选择和设计技巧','no_image.gif','大家可能最关心的是百度的账户维护，被百度竞价的客服牵着鼻子走了，有几个人会记得分析网站的跳 出率，改变下竞价的着陆页面呢?或许降低跳出率，提高患者在网站的停留时间。咨询邀请上来的机会也多一点。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','0','3','0'),
('8','为实现推广预期目标效果该做什么准备','no_image.gif','搜索推广营销的过程，形象地说，就是不断寻找符合企业自身实际情况的最优“漏斗”的过程。让“漏斗”能够更大更直，做为“漏斗”开口的前两层(展现与点击)，更是至关重要，小脑袋竞价软件觉得这也是百度推广阶段的工作目标：增加展现量和点击量。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','1','5','0'),
('9','网络推广重中之重作为自媒体人员你要了解','no_image.gif','好友经常来阅读你的空间日志，也算是粉丝级别的了，那么给这样的粉丝一点回馈也很正常。搞个抢红包活动，派送点红包比较实在，虽然红包里没有多少钱， 但却是一个答谢、沟通的过程。有人说没有干货的自媒体肯定会失败，可干货内容毕竟少之又少，而且也不是每个人都愿意分享的。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','1','4','0'),
('10','站群建站及优化策略需要注意哪些事项','no_image.gif','站群这个名词在10年到12年间曾风靡一时，如同当年的web网页点击器一样，可以迅速的抬高排名，批量关键词注入，收获各种关键词推荐来的订单，流量方面也有很大的保障','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','1','5','0'),
('11','微信公众号推广的那些操作手法','no_image.gif','下面我就说说那位算命小伙伴的运营模式。据我了解这位算命伙伴他有三年的网络算命经验，所以积累了一定量的粉丝，以及拥有了一部分的用户群体，那么我就说说这一个月内他是怎么运营的','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','1','5','0'),
('12','企业网站推广没有那么简单','no_image.gif','网站企业不是一个独立的存在，他需要其他网站的关键词来辅佐，这样才能吸引蜘蛛对你企业品牌关键词的信任，就是在其他网站做网站关键词就行了，这个任 务每天都要做100个品牌关键词，比如在百度贴吧发文章，文章标题有企业品牌关键词就可以了','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','4','1','1','1','3','0'),
('13','YIXUNCMS助力中国企业步入健康发展快车道','20160529211532_770.jpg','易迅BS软件助力中国企业健康发展快车道','1459237156','1','易迅','<p>	　　YIXUNCMS是一款专门为我国中小型企业设计开发的建站系统，完全开源免费；易迅BS软件工作室一直从事企业网站的设计与开发，在7年的时间里我们发现企业建站的方式各式各样，程序员的水平良莠不齐，一个普通的企业站基本的要求就是前端简洁大方、后台管理方便，因为一般的企业网站均没有专业的网站管理人员，他们对各式各样的网站后台使用感到困惑。</p><p>	　　众多的企业站采用DEDECMS、PHPCMS等开源软件做二次开发，我们并不否认这些开源软件先进性与全面性，但对于大部分没有专业知识的企业人员来说使用功能强大的后台无疑感到棘手、力不从心，而如此功能强大的系统也增加了企业站的体积，用另一方面来讲，企业站的基出功能大同小异，有见于此，我们为何不用一个简洁的系统去完成企业站的功能呢？</p><p>	　　YIXUNCMS在开发之初，就将目标定位在了简洁上，使得无论具备专业知识都可以轻松搭建并管理自己的企业站，就像微信的一句广告语：再小的个体也有自己的品牌。我们真诚的希望YIXUNCMS在使用上能给管理者以轻松、一目了然的感觉，使其不拘泥于复杂的管理而纠结。</p><p>	　　易迅BS软件助力中国企业站更加快速、高效、实用。</p>','易迅,网站源码,免费源码,PHP','无','2','1','1','1','5','0'),
('14','究竟哪些建站产品是您信得过的？','20160529211429_790.jpg','究竟哪些建站产品是您信得过的？','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','2','1','1','1','6','0'),
('15','YIXUNCMS共享版与授权版的区别','20160529211352_814.jpg','易迅BS软件工作室致力于为中国企业提供最实用、高效、简洁的网站软件产品。YIXUCNMS累计下载量达万次以上，易迅软件工作室感谢广大站长及源码爱好者的支持。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','2','1','1','1','7','0'),
('16','各类建站软件的优势对比','no_image.gif','2.0.4是一套优化整合版，涵盖了目前YIXUNCMS系列版本的所有功能并在现在功能基础上进行相应扩展，优化了界面设计及用户体验，希望我们的努力能为您的工作带来方便','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','1','1','1','0','1','0'),
('17','企业究竟该如何选择建站软件？','20160529211250_504.jpg','易迅BS软件工作室致力于为中国企业提供最实用、高效、简洁的网站软件产品。继YIXUCNMS1.0版本后，易迅工作室陆续推出了2.0简约版及时尚版，累计下载量达万次以上，易迅软件工作室感谢广大站长及源码爱好者的支持。','1459237156','1','易迅','<p>请在后台自行修改...</p>','易迅,网站源码,免费源码,PHP','无','2','1','1','1','8','0'),
('18','感谢您选择并使用YIXUNCMS建站软件SD版','20160529211013_642.jpg','2.0.4是一套优化整合版，涵盖了目前YIXUNCMS系列版本的所有功能并在现在功能基础上进行相应扩展，优化了界面设计及用户体验，希望我们的努力能为您的工作带来方便','1459237156','1','易迅','<p>	易迅BS软件工作室致力于为中国企业提供最实用、高效、简洁的网站软件产品，累计下载量达万次以上，易迅软件工作室感谢广大站长及源码爱好者的支持。<br />希望我们的努力能为您的工作带来方便，请记住我们的网址：http://www.ys-bs.com。</p>','易迅,网站源码,免费源码,PHP','无','2','1','1','1','28','0');

# --------------------------------------------------------
# 转存表中的数据 `yx_phcolumn`
# --------------------------------------------------------
INSERT INTO yx_phcolumn (`id`,`pid`,`path`,`title`,`description`,`audit`,`ord`,`display`,`callid`,`link`) VALUES
('1','0','0','产品展示','product display','0','0','1','1','1'),
('2','1','0-1','产品类别一','product display','0','0','1','1','1'),
('3','0','0','成功案例','success case','0','0','1','2','1'),
('4','3','0-3','案例展示一','success case','0','0','1','2','1'),
('5','3','0-3','案例展示二','success case','0','0','1','2','1'),
('6','3','0-3','案例展示三','success case','0','0','1','2','1'),
('7','1','0-1','产品类别二','product display','0','0','1','1','1'),
('8','1','0-1','产品展示三','product display','0','0','1','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_photo`
# --------------------------------------------------------
INSERT INTO yx_photo (`id`,`pid`,`uid`,`title`,`summary`,`pic`,`recommend`,`top`,`audit`,`content`,`views`,`ord`,`posttime`) VALUES
('1','4','1','成功案例展示三','无描述','20150422144619_203.jpg','1','0','1','<p>
	请在后台自行修改...</p>
','50','0','1459237156'),
('2','4','1','成功案例展示二','无描述','20150422143552_360.jpg','1','0','1','<p>
	请在后台自行修改...</p>
','12','0','1459237156'),
('3','4','1','成功案例展示一','无描述','20150422144030_129.jpg','1','0','1','<p>
	请在后台自行修改...</p>
','23','0','1459237156'),
('4','2','1','产品展示三','产品展示三','20150422152154_324.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','8','0','1459237156'),
('5','2','1','产品展示二','产品展示一','20150422152233_826.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','14','0','1459237156'),
('6','2','1','产品展示一','产品展示一','20150422154928_963.jpg','1','1','1','<p>
	请在后台自行修改或删除...</p>
','22','0','1459237156'),
('7','2','1','产品展示四','产品展示四','20160407223515_671.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','35','0','1460039715'),
('8','4','1','成功案例展示四','成功案例展示四','20160529194907_317.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522547'),
('9','4','1','成功案例展示五','成功案例展示五','20160529194933_277.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522573'),
('10','4','1','成功案例展示六','成功案例展示六','20160529195007_745.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522607'),
('11','4','1','成功案例展示七','成功案例展示七','20160529195045_556.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522645'),
('12','2','1','产品展示五','产品展示五','20160529195131_575.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522691'),
('13','2','1','产品展示六','产品展示六','20160529195154_548.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522714'),
('14','2','1','产品展示七','产品展示七','20160529195214_495.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','0','0','1464522734'),
('15','2','1','产品展示八','产品展示八','20160529195230_835.jpg','1','0','1','<p>
	请在后台自行修改或删除...</p>
','7','0','1464522750');

# --------------------------------------------------------
# 转存表中的数据 `yx_vcolumn`
# --------------------------------------------------------
INSERT INTO yx_vcolumn (`id`,`pid`,`path`,`title`,`description`,`audit`,`ord`,`display`,`link`) VALUES
('1','0','0','企业视频','Enterprise video','0','0','1','1'),
('2','1','0-1','宣传视频','Promotional video','0','0','1','1'),
('3','1','0-1','活动视频','Active video','0','0','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_video`
# --------------------------------------------------------
INSERT INTO yx_video (`id`,`uid`,`pid`,`title`,`pic`,`url`,`content`,`ptime`,`recommend`,`comefrom`,`views`,`audit`) VALUES
('1','1','2','江南style','20160406215158_586.jpg','http://player.youku.com/player.php/sid/XNDgwNjYyMDk2/v.swf','请在后台自行修改...','1450886680','0','0','4','1'),
('2','1','2','青春修炼手册','20160406213922_279.png','http://www.tudou.com/v/PzwxEgs4K08/&resourceId=0_04_05_99/v.swf','请在后台自行修改...','1450886739','0','0','17','1'),
('3','1','2','萧亚轩《爱的主打歌》','20160406213456_128.jpg','http://player.youku.com/player.php/sid/XNDg5Mzc2MzE2/v.swf','请在后台自行修改...','1450886770','0','0','18','1'),
('4','1','2','小苹果－筷子兄弟','20160406212924_748.png','http://player.youku.com/player.php/sid/XNzE4Njc2Mzc2/v.swf','请在后台自行修改...','1450886828','0','0','36','1'),
('5','1','2','人与自然','20160523164848_779.jpg','/uploads/video/20160523164834250.flv','请在后台自行修改...','1463993328','1','1','30','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_banner`
# --------------------------------------------------------
INSERT INTO yx_banner (`id`,`title`,`pic`,`links`,`display`,`ord`) VALUES
('1','第一张焦点图','1.jpg','#','1','0'),
('2','第二张焦点图','2.jpg','#','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_download`
# --------------------------------------------------------
INSERT INTO yx_download (`id`,`picid`,`title`,`filename`,`summary`,`posttime`,`views`) VALUES
('1','2','YIXUNCMS下载示例二','20160407111248_246.zip','这里是资料下载的简要说明，字数不宜过多~~这里是资料下载的简要说明，字数不宜过多~~这里是资料下载的简要说明，字数不宜过多~~','1459998768','11'),
('2','2','YIXUNCMS下载示例一','20160407144419_146.zip','这里是资料下载的简要说明，字数不宜过多~~这里是资料下载的简要说明，字数不宜过多~~这里是资料下载的简要说明，字数不宜过多~~','1460011459','7'),
('3','2','YIXUNCMS下载示例三','20160524011032989.zip','这里是资料下载的简要说明，字数不宜过多~~这里是资料下载的简要说明','1464023447','2');

# --------------------------------------------------------
# 转存表中的数据 `yx_flink`
# --------------------------------------------------------
INSERT INTO yx_flink (`id`,`webname`,`url`,`logo`,`rname`,`email`,`dtime`,`msg`,`list`,`audit`,`ord`) VALUES
('1','YIXUNCMS','http://www.ys-bs.com','yixun.gif','易迅软件','1652368686@qq.com','1459237156','易迅软件工作室','0','1','0'),
('2','易迅建站超市','http://shop.ys-bs.com','yixun.gif','易迅软件','1652368686@qq.com','1459237156','易迅建站超市','0','1','0');

# --------------------------------------------------------
# 转存表中的数据 `yx_fun`
# --------------------------------------------------------
INSERT INTO yx_fun (`id`,`title`,`content`,`audit`,`ord`) VALUES
('1','联系方式','<p>	官方网址：http://www.ys-bs.com<br />	建站超市：http://shop.ys-bs.com<br>	企鹅：1652368686<br>	信箱：1652368686@qq.com<br>	电话：15284330477</p>','1','0'),
('2','首页公司概况','<p>	易迅软件是一家从事BS架构软件应用及开发的工作团队，专注服务于国内中小型企业单位、各级院校网站平台及WEB应用系统的设计与研发，旨在通过更加简易的搭建过程、更简单的维护特性、更省心的系统升级为用户寻找一种更为高效、经济的建站方式。目前易迅软件已广泛应用于国内数千家网站，数百家网络公司使用YIXUNCMS系统进行网站搭建，简洁的界面、简易的操作得到了广大企业的认可...</p>','1','1');

# --------------------------------------------------------
# 转存表中的数据 `yx_group`
# --------------------------------------------------------
INSERT INTO yx_group (`id`,`groupname`,`description`,`baseadmin`,`unitadmin`,`artadmin`,`disadmin`,`downadmin`,`videoadmin`,`funadmin`,`imgadmin`,`dataadmin`,`updateadmin`,`useradmin`) VALUES
('1','超级管理员','超级管理员用户组，该组的用户具有全部的权限','1','1','1','1','1','1','1','1','1','1','1');
