<?php
defined('PHP168_PATH') or die();

/**
* CMS
**/

$this_controller->check_action($ACTION) or message('no_privilege');

$models = $this_system->get_models();

$model = isset($_GET['model']) && isset($models[$_GET['model']]) ? $_GET['model'] : '';
if($model){
	if(!isset($models[$model])){
		message('no_such_cms_model');
	}else{
		$this_module->set_model($model);
	}
}

$pages = '';
$count = 0;

//ؼ
$keyword = isset($_GET['keyword']) ? p8_stripslashes2(trim($_GET['keyword'])) : '';
if(!strlen($keyword)){
	include template($this_module, 'search');exit;
}

$page_url = $this_url .'?keyword='. urlencode($keyword);
$page_url .= '&page=?page?';


$cid = isset($_GET['cid']) ? intval($_GET['cid']) : 0;

$order = isset($_GET['order']) ? $order : 0;

$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$page = max($page, 1);

$sphinx = empty($this_module->CONFIG['sphinx']['enabled']) ? false : true;

//طģ
$category = &$this_system->load_module('category');
$category->get_cache();

if(is_file($this_system->path .'model/'. $model .'/search.php')){
	//ģԶű,תȥ
	
	$_REQUEST['model'] = $model;
	$this_system->init_model();
	require $this_system->path .'model/'. $model .'/search.php';
	exit;
}

$select = select();

//з
if($cid){
	$cids = array($cid);
	if(isset($category->categories[$cid]['categories'])){
		$cids = $category->get_children_ids($cid) + $cids;
	}
	$select->in('m.cid', $cids);
}

$keyword = html_entities($keyword);

$page_size = 10;


$T = $model ? $this_module->table : $this_module->main_table;

if($sphinx){
	//sphinx
	
	$select->from($T. ' AS i', 'i.*');
	
	//sphinxֶο
	$select->like('i.id', $keyword);
	$select->order('i.timestamp DESC');
	
	//sphinxģ
	$sphinx_indexes = $this_system->sphinx_indexes($model ? array($model => 1) : array());
	
	$sphinx = $this_module->CONFIG['sphinx'];
	$sphinx['index'] = $sphinx_indexes;
	
	//ȡ
	$list = &$core->list_item(
		$select,
		array(
			'page' => &$page,
			'count' => &$count,
			'page_size' => $page_size,
			'sphinx' => $sphinx
		)
	);
	
}else{
	
	$select->from($T. ' AS i', 'i.*');
	
	$select->search('i.title', $keyword);
	$select->where_or();
	$select->search('i.summary', $keyword);
	$select->order('i.timestamp DESC');
	
	//ȡ
	$count = 0;
	$list = $core->list_item(
		$select,
		array(
			'page' => &$page,
			'count' => &$count,
			'page_size' => $page_size
		)
	);
}

//echo $select->build_sql();


$page_count = ceil($count / $page_size);
//ҳ
$pages = list_page(array(
	'count' => $count,
	'page' => $page,
	'page_size' => $page_size,
	'url' => $page_url
));



//URL
foreach($list as $k => $v){
	$v['#category'] = &$category->categories[$v['cid']];
	
	$list[$k]['url'] = p8_url($this_module, $v, 'view');
	$list[$k]['frame'] = attachment_url($v['frame']);
	$list[$k]['summary'] = html_entity_decode($v['summary']);
	$list[$k]['summary'] = preg_replace('/(amp;)+/','', $list[$k]['summary']);
	//
	$list[$k]['category_name'] = $v['#category']['name'];
	//ַ
	$list[$k]['category_url'] = $v['#category']['url'];
}

$usetime = substr(get_timer() - $P8['start_time'], 0, 7);

$LABEL_POSTFIX = array('search');

include template($this_module, 'search');