-- <?php exit;?>
DROP TABLE IF EXISTS `p8_46_`;
CREATE TABLE `p8_46_` (
  `id` mediumint(7) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `expense_type` varchar(20) NOT NULL DEFAULT '',
  `link_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `buyable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `buy_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `credit_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `credit` smallint(5) unsigned NOT NULL DEFAULT '0',
  `width` varchar(10) NOT NULL DEFAULT '',
  `height` varchar(10) NOT NULL DEFAULT '',
  `template` varchar(50) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `show_count` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `verify` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `max_day` tinyint(3) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `buyable` (`buyable`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_46_buy`;
CREATE TABLE `p8_46_buy` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `aid` mediumint(7) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(7) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '0',
  `verified` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `showing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `credit` smallint(5) unsigned NOT NULL DEFAULT '0',
  `day` smallint(5) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `clicks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `postfix` varchar(60) NOT NULL DEFAULT '',
  `comment` varchar(60) NOT NULL DEFAULT '',
  `display_order` tinyint(3) unsigned NOT NULL DEFAULT '255',
  `data` text NOT NULL,
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`,`display_order`,`timestamp`),
  KEY `aid_2` (`aid`,`showing`,`verified`,`postfix`,`expire`),
  KEY `uid` (`uid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_46_click_log`;
CREATE TABLE `p8_46_click_log` (
  `bid` int(10) unsigned NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL,
  `referer` char(120) NOT NULL DEFAULT '',
  KEY `bid` (`bid`,`timestamp`),
  KEY `bid_ip` (`bid`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_acl`;
CREATE TABLE `p8_acl` (
  `system` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(50) NOT NULL DEFAULT '',
  `role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `postfix` varchar(30) NOT NULL,
  `v` text NOT NULL,
  PRIMARY KEY (`system`,`module`,`role_id`,`postfix`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_admin_log`;
CREATE TABLE `p8_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL,
  `username` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(40) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `data` mediumtext NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`timestamp`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_admin_menu`;
CREATE TABLE `p8_admin_menu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT '',
  `module` char(50) NOT NULL DEFAULT '',
  `action` char(50) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` char(30) NOT NULL DEFAULT '',
  `url` char(255) NOT NULL DEFAULT '',
  `target` char(10) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `front` tinyint(1) NOT NULL DEFAULT '0',
  `frequent` tinyint(1) NOT NULL DEFAULT '0',
  `display_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `system` (`system`,`module`)
) ENGINE=MyISAM AUTO_INCREMENT=170 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_area`;
CREATE TABLE `p8_area` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(5) unsigned NOT NULL,
  `name` char(40) NOT NULL,
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_attachment`;
CREATE TABLE `p8_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` char(50) NOT NULL DEFAULT '',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `filename` char(100) NOT NULL DEFAULT '',
  `type` char(50) NOT NULL DEFAULT '',
  `ext` char(5) NOT NULL DEFAULT '',
  `size` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `path` char(60) NOT NULL DEFAULT '',
  `thumb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `remote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`uid`),
  KEY `module` (`module`,`timestamp`),
  KEY `uid` (`uid`,`timestamp`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=104 DEFAULT CHARSET=gbk
/*!50100 PARTITION BY HASH (uid)
PARTITIONS 10 */;

DROP TABLE IF EXISTS `p8_cache`;
CREATE TABLE `p8_cache` (
  `path` varchar(30) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `id` varchar(50) NOT NULL DEFAULT '',
  `v` mediumtext NOT NULL,
  PRIMARY KEY (`path`,`name`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_assist_category_`;
CREATE TABLE `p8_cms_assist_category_` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(5) unsigned NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `item_count` smallint(5) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_assist_category_list`;
CREATE TABLE `p8_cms_assist_category_list` (
  `iid` mediumint(8) unsigned NOT NULL,
  `sid` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`sid`,`iid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_attachment`;
CREATE TABLE `p8_cms_attachment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module` char(50) NOT NULL DEFAULT '',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `filename` char(100) NOT NULL DEFAULT '',
  `type` char(50) NOT NULL DEFAULT '',
  `ext` char(5) NOT NULL DEFAULT '',
  `size` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `path` char(60) NOT NULL DEFAULT '',
  `thumb` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `remote` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`uid`),
  KEY `module` (`module`,`timestamp`),
  KEY `uid` (`uid`,`timestamp`),
  KEY `item_id` (`item_id`)
) ENGINE=MyISAM AUTO_INCREMENT=176 DEFAULT CHARSET=gbk
/*!50100 PARTITION BY HASH (uid)
PARTITIONS 10 */;

DROP TABLE IF EXISTS `p8_cms_category`;
CREATE TABLE `p8_cms_category` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parent` smallint(5) unsigned NOT NULL,
  `name` varchar(60) NOT NULL DEFAULT '',
  `letter` varchar(2) NOT NULL DEFAULT '',
  `model` varchar(20) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `domain` varchar(255) NOT NULL DEFAULT '',
  `frame` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) unsigned NOT NULL,
  `item_count` mediumint(8) unsigned NOT NULL,
  `htmlize` tinyint(1) unsigned NOT NULL,
  `html_list_url_rule` varchar(255) NOT NULL DEFAULT '',
  `html_view_url_rule` varchar(255) NOT NULL DEFAULT '',
  `path` varchar(255) NOT NULL DEFAULT '',
  `page_size` smallint(5) unsigned NOT NULL DEFAULT '20',
  `list_template` varchar(50) NOT NULL DEFAULT '',
  `list_template_mobile` varchar(50) NOT NULL DEFAULT '',
  `view_template` varchar(50) NOT NULL DEFAULT '',
  `view_template_mobile` varchar(50) NOT NULL DEFAULT '',
  `item_template` varchar(50) NOT NULL DEFAULT '',
  `item_template_mobile` varchar(50) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `seo_keywords` text NOT NULL,
  `seo_description` text NOT NULL,
  `label_postfix` varchar(50) NOT NULL DEFAULT '',
  `list_all_model` tinyint(1) NOT NULL DEFAULT '0',
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `model` (`model`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item`;
CREATE TABLE `p8_cms_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `title_color` varchar(7) NOT NULL DEFAULT '',
  `title_bold` tinyint(1) NOT NULL DEFAULT '0',
  `sub_title` varchar(120) NOT NULL DEFAULT '',
  `cid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `frame` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `author` varchar(20) NOT NULL DEFAULT '',
  `editer` varchar(20) NOT NULL DEFAULT '',
  `username` varchar(20) NOT NULL DEFAULT '',
  `attributes` varchar(40) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `pages` smallint(5) unsigned NOT NULL DEFAULT '1',
  `html_view_url_rule` varchar(80) NOT NULL DEFAULT '',
  `views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `list_order` int(10) unsigned NOT NULL DEFAULT '0',
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `verifier` tinyint(1) NOT NULL DEFAULT '0',
  `ever_verified` tinyint(1) NOT NULL DEFAULT '0',
  `allow_comment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `allow_mood` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `credit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `credit_type` smallint(5) unsigned NOT NULL DEFAULT '0',
  `digg` mediumint(8) NOT NULL DEFAULT '0',
  `trample` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`,`list_order`),
  KEY `cid_id` (`cid`,`id`),
  KEY `timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=234 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_article_`;
CREATE TABLE `p8_cms_item_article_` (
  `id` int(10) unsigned NOT NULL,
  `model` varchar(20) NOT NULL DEFAULT '',
  `cid` smallint(5) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `title_color` varchar(7) NOT NULL DEFAULT '',
  `title_bold` tinyint(1) NOT NULL DEFAULT '0',
  `sub_title` varchar(120) NOT NULL DEFAULT '',
  `frame` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `attributes` varchar(40) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `source` varchar(120) NOT NULL DEFAULT '',
  `author` varchar(20) NOT NULL DEFAULT '',
  `editer` varchar(20) NOT NULL DEFAULT '',
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `verified` tinyint(1) unsigned NOT NULL,
  `verifier` tinyint(1) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `list_order` int(10) unsigned NOT NULL,
  `update_time` int(10) unsigned NOT NULL,
  `pages` smallint(5) unsigned NOT NULL DEFAULT '1',
  `html_view_url_rule` varchar(80) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `views` mediumint(8) unsigned NOT NULL,
  `comments` mediumint(8) unsigned NOT NULL,
  `seo_keywords` varchar(100) NOT NULL,
  `seo_description` varchar(200) NOT NULL,
  `label_postfix` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`,`list_order`),
  KEY `cid_id` (`cid`,`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_article_addon`;
CREATE TABLE `p8_cms_item_article_addon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iid` int(10) unsigned NOT NULL,
  `page` smallint(5) unsigned NOT NULL,
  `addon_title` varchar(40) NOT NULL DEFAULT '',
  `addon_frame` varchar(100) NOT NULL DEFAULT '',
  `addon_summary` varchar(180) NOT NULL DEFAULT '',
  `ip` char(15) NOT NULL DEFAULT '',
  `last_update_ip` char(15) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL,
  `content` mediumtext NOT NULL,
  `vote_id` smallint(5) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `iid` (`iid`,`page`)
) ENGINE=MyISAM AUTO_INCREMENT=195 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_attribute`;
CREATE TABLE `p8_cms_item_attribute` (
  `id` int(10) unsigned NOT NULL,
  `aid` tinyint(3) unsigned NOT NULL,
  `cid` mediumint(8) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `last_setter` char(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`,`id`),
  KEY `id` (`id`),
  KEY `aid` (`aid`,`timestamp`),
  KEY `cid` (`aid`,`cid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_comment`;
CREATE TABLE `p8_cms_item_comment` (
  `id` bigint(20) unsigned NOT NULL,
  `iid` int(10) unsigned NOT NULL,
  `mid` smallint(5) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `quote` text NOT NULL,
  `content` text NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `digg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `oppose` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `iid` (`iid`,`timestamp`),
  KEY `digg` (`iid`,`digg`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_comment_id`;
CREATE TABLE `p8_cms_item_comment_id` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_comment_unverified`;
CREATE TABLE `p8_cms_item_comment_unverified` (
  `id` bigint(20) unsigned NOT NULL,
  `iid` int(10) unsigned NOT NULL,
  `mid` smallint(2) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `quote` text NOT NULL,
  `content` text NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `digg` smallint(5) unsigned NOT NULL DEFAULT '0',
  `oppose` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `iid` (`iid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_digg`;
CREATE TABLE `p8_cms_item_digg` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iid` int(10) unsigned NOT NULL,
  `digg` mediumint(8) NOT NULL DEFAULT '0',
  `trample` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aid` (`iid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_member`;
CREATE TABLE `p8_cms_item_member` (
  `iid` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL,
  `model` char(20) NOT NULL DEFAULT '',
  `verified` tinyint(1) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`iid`),
  KEY `uid` (`uid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_member_collection`;
CREATE TABLE `p8_cms_item_member_collection` (
  `iid` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`iid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_mood`;
CREATE TABLE `p8_cms_item_mood` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '',
  `image` char(20) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_mood_data`;
CREATE TABLE `p8_cms_item_mood_data` (
  `iid` int(10) unsigned NOT NULL,
  `m1` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m2` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m3` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m4` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m5` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m6` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m7` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `m8` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`iid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_pay`;
CREATE TABLE `p8_cms_item_pay` (
  `iid` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL,
  `timestamp` int(8) NOT NULL,
  PRIMARY KEY (`iid`,`uid`),
  KEY `uid` (`uid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_product_`;
CREATE TABLE `p8_cms_item_product_` (
  `id` int(10) unsigned NOT NULL,
  `model` varchar(20) NOT NULL DEFAULT '',
  `cid` smallint(5) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `title_color` varchar(7) NOT NULL DEFAULT '',
  `title_bold` tinyint(1) NOT NULL DEFAULT '0',
  `sub_title` varchar(120) NOT NULL DEFAULT '',
  `frame` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `attributes` varchar(40) NOT NULL DEFAULT '',
  `summary` varchar(255) NOT NULL DEFAULT '',
  `source` varchar(120) NOT NULL DEFAULT '',
  `author` varchar(20) NOT NULL DEFAULT '',
  `editer` varchar(20) NOT NULL DEFAULT '',
  `keywords` varchar(100) NOT NULL DEFAULT '',
  `verified` tinyint(1) unsigned NOT NULL,
  `verifier` tinyint(1) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `create_time` int(10) unsigned NOT NULL DEFAULT '0',
  `list_order` int(10) unsigned NOT NULL,
  `update_time` int(10) unsigned NOT NULL,
  `pages` smallint(5) unsigned NOT NULL DEFAULT '1',
  `html_view_url_rule` varchar(80) NOT NULL DEFAULT '',
  `template` varchar(30) NOT NULL DEFAULT '',
  `views` mediumint(8) unsigned NOT NULL,
  `comments` mediumint(8) unsigned NOT NULL,
  `seo_keywords` varchar(100) NOT NULL,
  `seo_description` varchar(200) NOT NULL,
  `label_postfix` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`,`list_order`),
  KEY `cid_id` (`cid`,`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_product_addon`;
CREATE TABLE `p8_cms_item_product_addon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iid` int(10) unsigned NOT NULL,
  `page` smallint(5) unsigned NOT NULL,
  `addon_title` varchar(40) NOT NULL DEFAULT '',
  `addon_frame` varchar(100) NOT NULL DEFAULT '',
  `addon_summary` varchar(180) NOT NULL DEFAULT '',
  `ip` char(15) NOT NULL DEFAULT '',
  `last_update_ip` char(15) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL,
  `aboutinfo` mediumtext NOT NULL,
  `attrbutes` text NOT NULL,
  `content` mediumtext NOT NULL,
  `pics` text NOT NULL,
  `pro_down` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `iid` (`iid`,`page`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_search`;
CREATE TABLE `p8_cms_item_search` (
  `id` int(10) unsigned NOT NULL,
  `search` mediumtext NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk
/*!50100 PARTITION BY RANGE (timestamp)
(PARTITION p0 VALUES LESS THAN (0) ENGINE = MyISAM) */;

DROP TABLE IF EXISTS `p8_cms_item_tag`;
CREATE TABLE `p8_cms_item_tag` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL,
  `item_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `hot` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_tag_item`;
CREATE TABLE `p8_cms_item_tag_item` (
  `tid` smallint(5) unsigned NOT NULL,
  `iid` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`tid`,`iid`),
  KEY `iid` (`iid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_item_unverified`;
CREATE TABLE `p8_cms_item_unverified` (
  `id` int(10) unsigned NOT NULL,
  `model` varchar(20) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `cid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '',
  `attributes` varchar(40) NOT NULL DEFAULT '',
  `pages` smallint(5) unsigned NOT NULL DEFAULT '1',
  `views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `comments` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `ever_verified` tinyint(1) NOT NULL DEFAULT '0',
  `data` longtext NOT NULL,
  `push_back_reason` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`timestamp`),
  KEY `cid` (`cid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_member`;
CREATE TABLE `p8_cms_member` (
  `id` mediumint(8) unsigned NOT NULL,
  `username` char(20) NOT NULL DEFAULT '',
  `role_id` smallint(5) unsigned NOT NULL,
  `item_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `role_id` (`role_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_model`;
CREATE TABLE `p8_cms_model` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_model_field`;
CREATE TABLE `p8_cms_model_field` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `alias` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `list_table` tinyint(1) NOT NULL DEFAULT '0',
  `filterable` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` tinyint(1) NOT NULL DEFAULT '0',
  `not_null` tinyint(1) unsigned NOT NULL,
  `length` varchar(10) NOT NULL DEFAULT '',
  `is_unsigned` tinyint(1) unsigned NOT NULL,
  `editable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `default_value` text NOT NULL,
  `data` text NOT NULL,
  `config` text NOT NULL,
  `widget` varchar(50) NOT NULL DEFAULT '',
  `widget_addon_attr` varchar(255) NOT NULL DEFAULT '',
  `display_order` tinyint(3) unsigned NOT NULL,
  `units` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`model`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_order`;
CREATE TABLE `p8_cms_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `NO` varchar(25) NOT NULL DEFAULT '',
  `interface_NO` varchar(25) NOT NULL DEFAULT '',
  `name` varchar(40) NOT NULL DEFAULT '',
  `subject` varchar(60) NOT NULL DEFAULT '',
  `seller_uid` mediumint(8) unsigned NOT NULL,
  `seller_username` varchar(20) NOT NULL DEFAULT '',
  `buyer_uid` mediumint(8) unsigned NOT NULL,
  `sid` mediumint(8) unsigned NOT NULL,
  `buyer_username` varchar(20) NOT NULL DEFAULT '',
  `phone` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(60) NOT NULL DEFAULT '',
  `address` varchar(100) NOT NULL DEFAULT '',
  `interface` varchar(10) NOT NULL DEFAULT '',
  `amount` decimal(10,2) unsigned NOT NULL,
  `number` smallint(5) unsigned NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `notify` text NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NO` (`NO`),
  KEY `seller_uid` (`seller_uid`,`timestamp`),
  KEY `buyer_uid` (`buyer_uid`,`timestamp`),
  KEY `status` (`status`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_statistic_cluster`;
CREATE TABLE `p8_cms_statistic_cluster` (
  `client_id` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `model` varchar(30) NOT NULL DEFAULT '',
  `year` smallint(4) NOT NULL DEFAULT '0',
  `month` tinyint(1) NOT NULL DEFAULT '0',
  `day` tinyint(1) NOT NULL DEFAULT '0',
  `post` int(11) NOT NULL DEFAULT '0',
  `unverified` int(11) NOT NULL DEFAULT '0',
  `verified` int(11) NOT NULL DEFAULT '0',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `model` (`client_id`,`model`,`year`,`month`,`day`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_statistic_data`;
CREATE TABLE `p8_cms_statistic_data` (
  `cid` int(11) NOT NULL DEFAULT '0',
  `model` varchar(30) NOT NULL DEFAULT '',
  `year` smallint(4) NOT NULL DEFAULT '0',
  `month` tinyint(1) NOT NULL DEFAULT '0',
  `day` tinyint(1) NOT NULL DEFAULT '0',
  `post` int(11) NOT NULL DEFAULT '0',
  `unverified` int(11) NOT NULL DEFAULT '0',
  `comment` int(11) NOT NULL DEFAULT '0',
  `visit` int(11) NOT NULL DEFAULT '0',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `model` (`cid`,`model`,`year`,`month`,`day`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cms_statistic_member`;
CREATE TABLE `p8_cms_statistic_member` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `role_id` int(11) NOT NULL DEFAULT '0',
  `role_gid` int(11) NOT NULL DEFAULT '0',
  `cid` int(11) NOT NULL DEFAULT '0',
  `model` varchar(30) NOT NULL DEFAULT '',
  `year` smallint(4) NOT NULL DEFAULT '0',
  `month` tinyint(2) NOT NULL DEFAULT '0',
  `day` tinyint(2) NOT NULL DEFAULT '0',
  `post` int(11) NOT NULL DEFAULT '0',
  `unverified` int(11) NOT NULL DEFAULT '0',
  `comment` int(11) NOT NULL DEFAULT '0',
  `visit` int(11) NOT NULL DEFAULT '0',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `model` (`uid`,`cid`,`model`,`year`,`month`,`day`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_config`;
CREATE TABLE `p8_config` (
  `system` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'string',
  `k` varchar(50) NOT NULL DEFAULT '',
  `v` mediumtext NOT NULL,
  PRIMARY KEY (`system`,`module`,`k`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_credit`;
CREATE TABLE `p8_credit` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '',
  `unit` char(4) NOT NULL DEFAULT '',
  `icon` char(20) NOT NULL DEFAULT '',
  `is_unsigned` tinyint(1) unsigned NOT NULL,
  `default_value` char(20) NOT NULL DEFAULT '0',
  `float_bit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `float_point` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `roe` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_credit_log`;
CREATE TABLE `p8_credit_log` (
  `uid` mediumint(8) unsigned NOT NULL,
  `credit_id` tinyint(3) unsigned NOT NULL,
  `credit` int(10) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  KEY `uid` (`uid`,`credit_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk
/*!50100 PARTITION BY HASH (uid)
PARTITIONS 10 */;

DROP TABLE IF EXISTS `p8_credit_member`;
CREATE TABLE `p8_credit_member` (
  `id` mediumint(8) unsigned NOT NULL,
  `credit_1` int(11) NOT NULL DEFAULT '100',
  `credit_2` int(11) NOT NULL DEFAULT '50',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_credit_rule`;
CREATE TABLE `p8_credit_rule` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT '',
  `module` char(50) NOT NULL DEFAULT '',
  `action` char(20) NOT NULL DEFAULT '',
  `role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `credit_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `credit` int(10) NOT NULL DEFAULT '0',
  `postfix` char(30) NOT NULL DEFAULT '',
  `times` smallint(5) unsigned NOT NULL DEFAULT '0',
  `interval` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique` (`system`,`module`,`action`,`credit_id`,`role_id`,`postfix`),
  KEY `credit_id` (`credit_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_credit_rule_log`;
CREATE TABLE `p8_credit_rule_log` (
  `uid` mediumint(8) unsigned NOT NULL,
  `rule_id` smallint(5) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  KEY `uid` (`uid`,`rule_id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk
/*!50100 PARTITION BY HASH (rule_id)
PARTITIONS 10 */;

DROP TABLE IF EXISTS `p8_credit_rule_log_cache`;
CREATE TABLE `p8_credit_rule_log_cache` (
  `uid` mediumint(8) unsigned NOT NULL,
  `rule_id` smallint(5) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `times` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`uid`,`rule_id`)
) ENGINE=MEMORY DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_crontab_`;
CREATE TABLE `p8_crontab_` (
  `id` mediumint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `script` varchar(50) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `next_run_time` int(10) unsigned NOT NULL DEFAULT '0',
  `last_run_time` int(10) unsigned NOT NULL DEFAULT '0',
  `day` mediumint(4) unsigned NOT NULL DEFAULT '0',
  `week` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `month` tinyint(2) NOT NULL DEFAULT '0',
  `hour` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `minute` tinyint(2) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `script` (`script`),
  KEY `next_run_time` (`status`,`next_run_time`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cservice_`;
CREATE TABLE `p8_cservice_` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num` bigint(14) NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `mobilephone` int(16) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT '',
  `site` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(60) NOT NULL DEFAULT '',
  `priority` int(1) NOT NULL DEFAULT '0',
  `category` varchar(30) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `solvetime` int(11) NOT NULL DEFAULT '0',
  `adminuid` int(11) NOT NULL DEFAULT '0',
  `adminname` varchar(30) NOT NULL,
  `state` int(1) NOT NULL DEFAULT '0',
  `hits` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_cservice_reply`;
CREATE TABLE `p8_cservice_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `askid` int(11) NOT NULL DEFAULT '0',
  `repid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(60) NOT NULL DEFAULT '',
  `frame` varchar(255) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  `state` int(1) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_filter_word`;
CREATE TABLE `p8_filter_word` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `filter_word` char(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filter_word` (`filter_word`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item`;
CREATE TABLE `p8_forms_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `title_color` varchar(100) NOT NULL DEFAULT '',
  `mid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '',
  `ip` varchar(16) NOT NULL DEFAULT '',
  `views` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0',
  `list_order` int(10) unsigned NOT NULL DEFAULT '0',
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `status` smallint(3) NOT NULL DEFAULT '0',
  `replyer` varchar(20) NOT NULL DEFAULT '',
  `reply_time` int(10) unsigned NOT NULL DEFAULT '0',
  `reply` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `mid` (`mid`,`list_order`),
  KEY `mid_id` (`mid`,`id`),
  KEY `timestamp` (`timestamp`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=1628 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_banshi`;
CREATE TABLE `p8_forms_item_banshi` (
  `id` int(10) unsigned NOT NULL,
  `bianhao` varchar(255) DEFAULT NULL,
  `bslb` varchar(255) NOT NULL,
  `czsm` varchar(255) DEFAULT NULL,
  `fujian` varchar(255) DEFAULT NULL,
  `lianj` varchar(255) DEFAULT NULL,
  `lxr` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `ssbm` varchar(255) NOT NULL,
  `sybumen` varchar(255) NOT NULL,
  `tel` varchar(255) NOT NULL,
  `tupian` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dailishang`;
CREATE TABLE `p8_forms_item_dailishang` (
  `id` int(10) unsigned NOT NULL,
  `channel_ptype` varchar(255) NOT NULL,
  `channel_memo` text NOT NULL,
  `channel_name` varchar(255) NOT NULL,
  `channel_contact` varchar(255) NOT NULL,
  `channel_telephone` varchar(255) NOT NULL,
  `channel_qqmsn` varchar(255) NOT NULL,
  `channel_address` varchar(255) NOT NULL,
  `cpin` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dails`;
CREATE TABLE `p8_forms_item_dails` (
  `id` int(10) unsigned NOT NULL,
  `dlsxm` varchar(255) NOT NULL,
  `leix` varchar(255) NOT NULL,
  `sgcp` varchar(255) NOT NULL,
  `shenggneir` varchar(255) NOT NULL,
  `fujian` varchar(255) DEFAULT NULL,
  `yufen` varchar(255) NOT NULL,
  `nianfen` varchar(255) NOT NULL,
  `jtrq` varchar(255) NOT NULL,
  `lxdh` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dlsdd`;
CREATE TABLE `p8_forms_item_dlsdd` (
  `id` int(10) unsigned NOT NULL,
  `tbqye` varchar(255) NOT NULL,
  `tbnf` varchar(255) NOT NULL,
  `tbyf` varchar(255) NOT NULL,
  `date` varchar(255) NOT NULL,
  `danghao` varchar(255) DEFAULT NULL,
  `kehu` varchar(255) NOT NULL,
  `mingc` varchar(255) NOT NULL,
  `ddxq` varchar(255) DEFAULT NULL,
  `ddje` decimal(10,0) NOT NULL,
  `fuk` varchar(255) NOT NULL,
  `fukbf` varchar(255) NOT NULL,
  `fukbz` varchar(255) DEFAULT NULL,
  `cwqrdz` varchar(255) DEFAULT NULL,
  `caiwubz` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dlsqtsg`;
CREATE TABLE `p8_forms_item_dlsqtsg` (
  `id` int(10) unsigned NOT NULL,
  `dls` varchar(255) NOT NULL,
  `lxdh` varchar(255) NOT NULL,
  `sqlx` varchar(255) NOT NULL,
  `xqnr` varchar(255) NOT NULL,
  `fujian` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dlsyw`;
CREATE TABLE `p8_forms_item_dlsyw` (
  `id` int(10) unsigned NOT NULL,
  `mingc` varchar(255) NOT NULL,
  `lxr` varchar(255) NOT NULL,
  `slx` varchar(255) NOT NULL,
  `beizu` varchar(255) NOT NULL,
  `dianhua` varchar(255) NOT NULL,
  `fjian` varchar(255) DEFAULT NULL,
  `date` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_dlxstc`;
CREATE TABLE `p8_forms_item_dlxstc` (
  `id` int(10) unsigned NOT NULL,
  `qymc` varchar(255) NOT NULL,
  `lxr` varchar(255) NOT NULL,
  `lxdh` varchar(255) DEFAULT NULL,
  `xiaoshou` decimal(10,0) NOT NULL,
  `tcje` decimal(10,0) NOT NULL,
  `tczf` varchar(255) NOT NULL,
  `tcxq` varchar(255) DEFAULT NULL,
  `fjzl` varchar(255) DEFAULT NULL,
  `nianfen` varchar(255) NOT NULL,
  `yuefen` varchar(255) NOT NULL,
  `ticmm` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_fukuan`;
CREATE TABLE `p8_forms_item_fukuan` (
  `id` int(10) unsigned NOT NULL,
  `mingcheng` varchar(255) NOT NULL,
  `lixr` varchar(255) NOT NULL,
  `jine` varchar(255) NOT NULL,
  `beizhu` varchar(255) NOT NULL,
  `dianhua` varchar(255) DEFAULT NULL,
  `fjzl` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_jixiaobiaoyan`;
CREATE TABLE `p8_forms_item_jixiaobiaoyan` (
  `id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `bumeng` varchar(255) NOT NULL,
  `jinger` int(23) DEFAULT NULL,
  `xiangxi` varchar(255) DEFAULT NULL,
  `xmima` varchar(255) NOT NULL,
  `qymc` varchar(255) NOT NULL,
  `dianhua` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_kehu`;
CREATE TABLE `p8_forms_item_kehu` (
  `id` int(10) unsigned NOT NULL,
  `beizhu` varchar(255) DEFAULT NULL,
  `bum` varchar(255) NOT NULL,
  `caigou` varchar(255) NOT NULL,
  `czhm` varchar(255) DEFAULT NULL,
  `date` varchar(255) NOT NULL,
  `date2` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `khbhao` varchar(255) NOT NULL,
  `khjb` varchar(255) NOT NULL,
  `khlb` varchar(255) NOT NULL,
  `khlx` varchar(255) NOT NULL,
  `khmc` varchar(255) NOT NULL,
  `lianxiren` varchar(255) NOT NULL,
  `QQ` varchar(255) DEFAULT NULL,
  `shouji` varchar(255) NOT NULL,
  `wangzhi` varchar(255) DEFAULT NULL,
  `xingmin` varchar(255) NOT NULL,
  `year` varchar(255) NOT NULL,
  `yuefen` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_kehucj`;
CREATE TABLE `p8_forms_item_kehucj` (
  `id` int(10) unsigned NOT NULL,
  `ddlx` varchar(255) NOT NULL,
  `ddnr` varchar(255) DEFAULT NULL,
  `fkcs` varchar(255) NOT NULL,
  `fkqk` varchar(255) NOT NULL,
  `fpqk` varchar(255) DEFAULT NULL,
  `fpxx` varchar(255) DEFAULT NULL,
  `fpzt` varchar(255) DEFAULT NULL,
  `htbh` varchar(255) NOT NULL,
  `kehumc` varchar(255) NOT NULL,
  `khlxdh` varchar(255) DEFAULT NULL,
  `khlxr` varchar(255) NOT NULL,
  `kxqr` varchar(255) DEFAULT NULL,
  `riqi` varchar(255) NOT NULL,
  `sffp` varchar(255) NOT NULL,
  `sjcjjg` varchar(255) DEFAULT NULL,
  `ssbumen` varchar(255) NOT NULL,
  `xingming` varchar(255) NOT NULL,
  `year` varchar(255) NOT NULL,
  `yfje` int(10) DEFAULT NULL,
  `yljiage` varchar(255) DEFAULT NULL,
  `yue` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_khzxyd`;
CREATE TABLE `p8_forms_item_khzxyd` (
  `id` int(10) unsigned NOT NULL,
  `xingm` varchar(255) NOT NULL,
  `qiye` varchar(255) NOT NULL,
  `souji` varchar(255) NOT NULL,
  `sqlx` varchar(255) NOT NULL,
  `xiangqing` varchar(255) DEFAULT NULL,
  `cpin` varchar(255) NOT NULL,
  `qq` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_queren`;
CREATE TABLE `p8_forms_item_queren` (
  `id` int(10) unsigned NOT NULL,
  `qiyem` varchar(255) NOT NULL,
  `lianxiren` varchar(255) NOT NULL,
  `dianhua` varchar(255) NOT NULL,
  `hwsd` varchar(255) NOT NULL,
  `bzsm` varchar(255) DEFAULT NULL,
  `fujian` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_quizhi`;
CREATE TABLE `p8_forms_item_quizhi` (
  `id` int(10) unsigned NOT NULL,
  `birthday` varchar(10) NOT NULL,
  `content` text NOT NULL,
  `education` tinyint(3) NOT NULL,
  `email` varchar(60) NOT NULL,
  `entime` tinyint(3) NOT NULL,
  `experience` tinyint(3) NOT NULL,
  `gender` tinyint(3) NOT NULL,
  `job` varchar(10) NOT NULL,
  `name` varchar(30) NOT NULL,
  `profession` varchar(60) NOT NULL,
  `salary` tinyint(3) NOT NULL,
  `school` varchar(100) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `jlfj` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_recruitment`;
CREATE TABLE `p8_forms_item_recruitment` (
  `id` int(10) unsigned NOT NULL,
  `age` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `count` smallint(5) unsigned NOT NULL,
  `education` tinyint(3) NOT NULL,
  `experience` tinyint(3) NOT NULL,
  `gender` tinyint(3) NOT NULL,
  `jobname` varchar(60) NOT NULL,
  `kind` tinyint(1) NOT NULL,
  `married` tinyint(3) NOT NULL,
  `profession` varchar(60) DEFAULT NULL,
  `salary` tinyint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_tousu`;
CREATE TABLE `p8_forms_item_tousu` (
  `id` int(10) unsigned NOT NULL,
  `advicetype` varchar(255) NOT NULL,
  `mobphone` varchar(255) NOT NULL,
  `truename` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `content` varchar(255) NOT NULL,
  `fujian` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_wuliu`;
CREATE TABLE `p8_forms_item_wuliu` (
  `id` int(10) unsigned NOT NULL,
  `shuor` varchar(255) NOT NULL,
  `fhdh` varchar(255) DEFAULT NULL,
  `fhfs` varchar(255) DEFAULT NULL,
  `ddcsrq` varchar(255) NOT NULL,
  `yjfh` varchar(255) NOT NULL,
  `zsfh` varchar(255) DEFAULT NULL,
  `wlzt` varchar(255) NOT NULL,
  `wulmc` varchar(255) NOT NULL,
  `hwnr` varchar(255) NOT NULL,
  `lxdh` varchar(255) NOT NULL,
  `gongsi` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_item_xinxidian`;
CREATE TABLE `p8_forms_item_xinxidian` (
  `id` int(10) unsigned NOT NULL,
  `dianhua` varchar(255) NOT NULL,
  `ganwei` varchar(255) NOT NULL,
  `jlqk` varchar(255) DEFAULT NULL,
  `khqy` varchar(255) NOT NULL,
  `khxz` varchar(255) NOT NULL,
  `lxr` varchar(255) NOT NULL,
  `szbm` varchar(255) NOT NULL,
  `tbsj` varchar(255) NOT NULL,
  `xinxidian` varchar(255) NOT NULL,
  `xxdbhq` varchar(255) NOT NULL,
  `xxdzt` varchar(255) NOT NULL,
  `year` varchar(255) NOT NULL,
  `yue` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_model`;
CREATE TABLE `p8_forms_model` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `enabled` tinyint(1) NOT NULL DEFAULT '1',
  `verified` varchar(20) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `display_order` int(10) unsigned NOT NULL DEFAULT '0',
  `post_template` varchar(50) NOT NULL DEFAULT '',
  `list_template` varchar(50) NOT NULL DEFAULT '',
  `view_template` varchar(50) NOT NULL DEFAULT '',
  `config` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_forms_model_field`;
CREATE TABLE `p8_forms_model_field` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `model` varchar(30) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `alias` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `part` varchar(20) NOT NULL DEFAULT '',
  `list_table` tinyint(1) NOT NULL DEFAULT '0',
  `filterable` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` tinyint(1) NOT NULL DEFAULT '0',
  `not_null` tinyint(1) unsigned NOT NULL,
  `length` varchar(10) NOT NULL DEFAULT '',
  `is_unsigned` tinyint(1) unsigned NOT NULL,
  `editable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `manager_editable` tinyint(1) DEFAULT '0',
  `default_value` text NOT NULL,
  `data` text NOT NULL,
  `config` text NOT NULL,
  `widget` varchar(50) NOT NULL DEFAULT '',
  `widget_addon_attr` varchar(255) NOT NULL DEFAULT '',
  `display_order` tinyint(3) unsigned NOT NULL,
  `units` varchar(20) NOT NULL,
  `jsreg` varchar(40) NOT NULL DEFAULT '',
  `jsregmsg` varchar(20) NOT NULL DEFAULT '',
  `color` varchar(10) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`model`,`name`)
) ENGINE=MyISAM AUTO_INCREMENT=267 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_friendlink_link`;
CREATE TABLE `p8_friendlink_link` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `fid` int(7) NOT NULL DEFAULT '0',
  `name` varchar(30) NOT NULL DEFAULT '',
  `url` varchar(150) NOT NULL DEFAULT '',
  `logo` varchar(150) NOT NULL DEFAULT '',
  `descrip` varchar(255) NOT NULL DEFAULT '',
  `list` int(10) NOT NULL DEFAULT '0',
  `ifhide` tinyint(1) NOT NULL DEFAULT '0',
  `iswordlink` tinyint(1) DEFAULT NULL,
  `hits` tinyint(7) NOT NULL DEFAULT '0',
  `posttime` int(10) NOT NULL DEFAULT '0',
  `uid` int(7) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `yz` tinyint(1) NOT NULL DEFAULT '1',
  `endtime` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `yz` (`yz`,`endtime`,`ifhide`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_friendlink_sort`;
CREATE TABLE `p8_friendlink_sort` (
  `fid` mediumint(7) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL DEFAULT '',
  `list` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_guestbook_`;
CREATE TABLE `p8_guestbook_` (
  `id` int(7) NOT NULL AUTO_INCREMENT,
  `cid` mediumint(7) NOT NULL DEFAULT '0',
  `uid` int(7) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `email` varchar(50) NOT NULL DEFAULT '',
  `ip` varchar(15) NOT NULL DEFAULT '',
  `ico` tinyint(2) NOT NULL DEFAULT '0',
  `oicq` varchar(11) DEFAULT NULL,
  `weburl` varchar(150) NOT NULL DEFAULT '',
  `blogurl` varchar(150) NOT NULL DEFAULT '',
  `telephone` varchar(15) DEFAULT NULL,
  `title` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `verified` tinyint(1) NOT NULL DEFAULT '0',
  `ifhide` smallint(1) DEFAULT NULL,
  `posttime` int(10) NOT NULL DEFAULT '0',
  `list` int(10) NOT NULL DEFAULT '0',
  `digg` int(5) NOT NULL DEFAULT '0',
  `trample` int(5) NOT NULL DEFAULT '0',
  `reply` text NOT NULL,
  `replytime` varchar(11) DEFAULT NULL,
  `replyer` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_guestbook_category`;
CREATE TABLE `p8_guestbook_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `ifclose` smallint(2) NOT NULL,
  `ifcaptcha` smallint(2) NOT NULL,
  `display_order` smallint(3) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_homepage_block`;
CREATE TABLE `p8_homepage_block` (
  `name` varchar(60) NOT NULL,
  `system` varchar(20) NOT NULL,
  `module` varchar(50) NOT NULL,
  `method` varchar(20) NOT NULL,
  `alias` varchar(20) NOT NULL,
  PRIMARY KEY (`name`),
  KEY `system` (`system`,`module`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_homepage_menu`;
CREATE TABLE `p8_homepage_menu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT '',
  `module` char(50) NOT NULL DEFAULT '',
  `action` char(50) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` char(30) NOT NULL DEFAULT '',
  `url` char(255) NOT NULL DEFAULT '',
  `target` char(10) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `front` tinyint(1) NOT NULL DEFAULT '0',
  `display_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `system` (`system`,`module`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_homepage_view`;
CREATE TABLE `p8_homepage_view` (
  `uid` mediumint(8) unsigned NOT NULL,
  `view_uid` mediumint(8) unsigned NOT NULL,
  `view_username` char(20) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`,`view_uid`),
  KEY `view_uid` (`view_uid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_label`;
CREATE TABLE `p8_label` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `system` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(50) NOT NULL DEFAULT '',
  `source_system` varchar(30) NOT NULL DEFAULT '',
  `source_module` varchar(50) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT '',
  `option` text NOT NULL,
  `content` text NOT NULL,
  `invoke` text NOT NULL,
  `variable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `last_update` int(10) unsigned NOT NULL DEFAULT '0',
  `ttl` mediumint(8) NOT NULL DEFAULT '0',
  `postfix` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `system` (`system`,`module`,`postfix`,`name`),
  KEY `name` (`name`),
  KEY `source` (`source_system`,`source_module`)
) ENGINE=MyISAM AUTO_INCREMENT=593 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_mail_queue`;
CREATE TABLE `p8_mail_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(40) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member`;
CREATE TABLE `p8_member` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `salt` varchar(10) NOT NULL DEFAULT '',
  `number` varchar(20) NOT NULL DEFAULT '',
  `email` varchar(40) NOT NULL DEFAULT '',
  `name` varchar(50) NOT NULL DEFAULT '',
  `phone` varchar(20) NOT NULL DEFAULT '',
  `cell_phone` varchar(11) NOT NULL DEFAULT '',
  `address` varchar(50) NOT NULL DEFAULT '',
  `fax` varchar(20) NOT NULL DEFAULT '',
  `qq` varchar(12) NOT NULL DEFAULT '',
  `msn` varchar(50) NOT NULL DEFAULT '',
  `gender` tinyint(1) NOT NULL DEFAULT '1',
  `birthday` int(11) NOT NULL DEFAULT '0',
  `icon` varchar(150) NOT NULL DEFAULT '',
  `role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `role_gid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `last_role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `is_admin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_founder` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `friend_setting` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `friends` smallint(5) unsigned NOT NULL DEFAULT '0',
  `new_messages` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `register_time` int(10) unsigned NOT NULL DEFAULT '0',
  `register_ip` varchar(15) NOT NULL DEFAULT '',
  `last_login_ip` varchar(15) NOT NULL DEFAULT '',
  `pinyin` varchar(4) NOT NULL DEFAULT '',
  `last_login` int(10) unsigned NOT NULL DEFAULT '0',
  `login_time` smallint(5) unsigned NOT NULL DEFAULT '0',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `memo` text NOT NULL,
  `homepage` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `role_id` (`role_id`),
  KEY `role_gid` (`role_gid`),
  KEY `is_admin` (`is_admin`),
  KEY `is_founder` (`is_founder`),
  KEY `cell_phone` (`cell_phone`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_acl`;
CREATE TABLE `p8_member_acl` (
  `system` varchar(30) NOT NULL DEFAULT '',
  `module` varchar(50) NOT NULL DEFAULT '',
  `user_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `postfix` varchar(30) NOT NULL,
  `v` text NOT NULL,
  PRIMARY KEY (`system`,`module`,`user_id`,`postfix`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_buy_role`;
CREATE TABLE `p8_member_buy_role` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_NO` char(25) NOT NULL DEFAULT '',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL DEFAULT '',
  `role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `amount` mediumint(5) unsigned NOT NULL DEFAULT '0',
  `time` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_NO` (`order_NO`),
  KEY `uid` (`uid`,`timestamp`),
  KEY `status` (`status`,`expire`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_friend`;
CREATE TABLE `p8_member_friend` (
  `uid` mediumint(8) unsigned NOT NULL,
  `fuid` mediumint(8) unsigned NOT NULL,
  `cid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL,
  `description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`,`fuid`),
  KEY `fuid` (`fuid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_friend_category`;
CREATE TABLE `p8_member_friend_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL,
  `name` char(20) NOT NULL DEFAULT '',
  `members` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_friend_unverified`;
CREATE TABLE `p8_member_friend_unverified` (
  `uid` mediumint(8) unsigned NOT NULL,
  `fuid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `cid` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `description` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`,`fuid`),
  KEY `fuid` (`fuid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_getpasswd`;
CREATE TABLE `p8_member_getpasswd` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `email` char(32) NOT NULL,
  `checkcode` char(32) NOT NULL DEFAULT '',
  `createtime` mediumtext NOT NULL,
  `invalidlong` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_menu`;
CREATE TABLE `p8_member_menu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT '',
  `module` char(50) NOT NULL DEFAULT '',
  `action` char(50) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `color` char(7) NOT NULL DEFAULT '',
  `name` char(30) NOT NULL DEFAULT '',
  `url` char(255) NOT NULL DEFAULT '',
  `target` char(10) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `front` tinyint(1) NOT NULL DEFAULT '0',
  `display_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `system` (`system`,`module`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_recharge`;
CREATE TABLE `p8_member_recharge` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_NO` char(25) NOT NULL DEFAULT '',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL DEFAULT '',
  `amount` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_NO` (`order_NO`),
  KEY `uid` (`uid`,`timestamp`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_member_recharge_card`;
CREATE TABLE `p8_member_recharge_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sn` varchar(20) NOT NULL DEFAULT '',
  `credit_type` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `quantity` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL DEFAULT '',
  `occupied` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `used` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `used_timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`),
  KEY `credit_type` (`credit_type`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=1000000 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_message`;
CREATE TABLE `p8_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL DEFAULT '',
  `othername` varchar(20) NOT NULL DEFAULT '',
  `sender_uid` mediumint(8) unsigned NOT NULL,
  `sendee_uid` mediumint(8) unsigned NOT NULL,
  `role_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `type` enum('in','out','rubbish','draft') NOT NULL,
  `title` varchar(100) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `new` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sendee_uid` (`sendee_uid`,`timestamp`),
  KEY `sender_uid` (`sender_uid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_module`;
CREATE TABLE `p8_module` (
  `system` char(30) NOT NULL DEFAULT '',
  `name` char(50) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `class` char(30) NOT NULL DEFAULT '',
  `controller_class` char(50) NOT NULL DEFAULT '',
  `installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`system`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_navigation_menu`;
CREATE TABLE `p8_navigation_menu` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT '',
  `module` char(50) NOT NULL DEFAULT '',
  `color` char(10) NOT NULL DEFAULT '',
  `parent` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` char(30) NOT NULL DEFAULT '',
  `url` char(255) NOT NULL DEFAULT '',
  `target` char(10) NOT NULL DEFAULT '',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `display_order` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `system` (`system`,`module`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_notify_`;
CREATE TABLE `p8_notify_` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `title` varchar(50) NOT NULL DEFAULT '',
  `send_pm` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `send_mail` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `send_sms` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sms_back` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content` mediumtext NOT NULL,
  `data` mediumtext NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `send_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `sign_in_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `expire` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_notify_sign_in`;
CREATE TABLE `p8_notify_sign_in` (
  `nid` int(10) unsigned NOT NULL,
  `uid` mediumint(8) unsigned NOT NULL,
  `hash` char(16) NOT NULL DEFAULT '',
  `comment` char(255) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL,
  `receive` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`nid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_page_`;
CREATE TABLE `p8_page_` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `fid` mediumint(5) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(100) NOT NULL DEFAULT '',
  `timestamp` int(10) NOT NULL DEFAULT '0',
  `uid` mediumint(7) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL DEFAULT '',
  `style` varchar(15) NOT NULL DEFAULT '',
  `type` int(1) NOT NULL DEFAULT '0',
  `tpl_head` varchar(50) NOT NULL DEFAULT '',
  `tpl_main` varchar(50) NOT NULL DEFAULT '',
  `tpl_foot` varchar(50) NOT NULL DEFAULT '',
  `htmlize` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `tpl_mobile` varchar(50) NOT NULL DEFAULT '',
  `html_view_url_rule` varchar(100) NOT NULL DEFAULT '',
  `filepath` varchar(30) NOT NULL DEFAULT '',
  `descrip` text NOT NULL,
  `keywords` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `hits` int(7) NOT NULL DEFAULT '0',
  `ishtml` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk;

CREATE TABLE IF NOT EXISTS `p8_pagecache` (
  `id` char(32) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk
/*!50100 PARTITION BY KEY ()
PARTITIONS 20 */;

DROP TABLE IF EXISTS `p8_pay_interface`;
CREATE TABLE `p8_pay_interface` (
  `name` char(15) NOT NULL,
  `alias` char(20) NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `logo` char(15) NOT NULL DEFAULT '',
  `config` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_pay_log`;
CREATE TABLE `p8_pay_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `order_NO` char(20) NOT NULL,
  `interface` char(15) NOT NULL DEFAULT '',
  `payer_uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `payer_username` char(20) NOT NULL DEFAULT '',
  `amount` decimal(10,2) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_pay_member_interface`;
CREATE TABLE `p8_pay_member_interface` (
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `name` char(15) NOT NULL,
  `config` text NOT NULL,
  PRIMARY KEY (`uid`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_pay_order`;
CREATE TABLE `p8_pay_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `NO` varchar(25) NOT NULL DEFAULT '',
  `interface_NO` varchar(25) NOT NULL DEFAULT '',
  `name` varchar(40) NOT NULL DEFAULT '',
  `seller_uid` mediumint(8) unsigned NOT NULL,
  `seller_username` varchar(20) NOT NULL DEFAULT '',
  `buyer_uid` mediumint(8) unsigned NOT NULL,
  `buyer_username` varchar(20) NOT NULL DEFAULT '',
  `interface` varchar(10) NOT NULL DEFAULT '',
  `amount` decimal(10,2) unsigned NOT NULL,
  `number` smallint(5) unsigned NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL,
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `notify` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NO` (`NO`),
  KEY `seller_uid` (`seller_uid`,`timestamp`),
  KEY `buyer_uid` (`buyer_uid`,`timestamp`),
  KEY `status` (`status`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_pay_order_lock`;
CREATE TABLE `p8_pay_order_lock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `NO` char(20) NOT NULL DEFAULT '',
  `update_status` tinyint(1) unsigned NOT NULL,
  `notify_status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `NO` (`NO`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_plugin`;
CREATE TABLE `p8_plugin` (
  `name` char(50) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `class` char(30) NOT NULL DEFAULT '',
  `installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_plugin_ad_flash_`;
CREATE TABLE `p8_plugin_ad_flash_` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL DEFAULT '',
  `link` varchar(100) NOT NULL DEFAULT '',
  `bigpic` varchar(100) NOT NULL DEFAULT '',
  `smallpic` varchar(100) NOT NULL DEFAULT '',
  `ifshow` int(1) NOT NULL DEFAULT '1',
  `timestamp` varchar(11) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_plugin_qqconnect_`;
CREATE TABLE `p8_plugin_qqconnect_` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `uid` mediumint(5) NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL DEFAULT '',
  `openid` char(32) NOT NULL DEFAULT '0',
  `access_token` varchar(30) NOT NULL DEFAULT '',
  `expires_in` int(11) NOT NULL DEFAULT '0',
  `nickname` varchar(30) NOT NULL DEFAULT '',
  `gender` char(2) NOT NULL DEFAULT '0',
  `vip` tinyint(1) NOT NULL DEFAULT '0',
  `level` tinyint(1) NOT NULL DEFAULT '0',
  `figureurl` varchar(255) NOT NULL DEFAULT '',
  `timestamp` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_plugin_schedul_`;
CREATE TABLE `p8_plugin_schedul_` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL DEFAULT '0000-00-00',
  `date_time` tinyint(1) NOT NULL DEFAULT '0',
  `level` varchar(20) NOT NULL DEFAULT '0',
  `name` varchar(120) NOT NULL DEFAULT '',
  `phone` varchar(50) NOT NULL,
  `event` varchar(255) NOT NULL DEFAULT '',
  `list_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role`;
CREATE TABLE `p8_role` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `system` char(30) NOT NULL DEFAULT 'core',
  `type` enum('system','normal') NOT NULL DEFAULT 'normal',
  `gid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` char(20) NOT NULL DEFAULT '',
  `icon` char(50) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  `credit_1` int(11) NOT NULL DEFAULT '0',
  `credit_2` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group`;
CREATE TABLE `p8_role_group` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '',
  `registrable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `default_role` smallint(5) unsigned NOT NULL DEFAULT '0',
  `description` char(255) NOT NULL DEFAULT '',
  `display_order` smallint(5) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_1_data`;
CREATE TABLE `p8_role_group_1_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_2_data`;
CREATE TABLE `p8_role_group_2_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_3_data`;
CREATE TABLE `p8_role_group_3_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_4_data`;
CREATE TABLE `p8_role_group_4_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_5_data`;
CREATE TABLE `p8_role_group_5_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_6_data`;
CREATE TABLE `p8_role_group_6_data` (
  `id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_role_group_field`;
CREATE TABLE `p8_role_group_field` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `gid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` char(30) NOT NULL DEFAULT '',
  `alias` char(50) NOT NULL DEFAULT '',
  `type` char(20) NOT NULL DEFAULT '',
  `not_null` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `length` char(10) NOT NULL DEFAULT '',
  `is_unsigned` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `default_value` char(100) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `widget` char(20) NOT NULL DEFAULT '',
  `widget_addon_attr` char(255) NOT NULL DEFAULT '',
  `display_order` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`gid`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

CREATE TABLE IF NOT EXISTS `p8_session` (
  `id` char(32) NOT NULL DEFAULT '',
  `uid` mediumint(7) unsigned NOT NULL DEFAULT '0',
  `username` char(30) NOT NULL DEFAULT '',
  `system` char(20) NOT NULL DEFAULT '',
  `module` char(30) NOT NULL DEFAULT '',
  `action` char(25) NOT NULL DEFAULT '',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '',
  `lastview` int(10) unsigned NOT NULL DEFAULT '0',
  `data1` char(255) NOT NULL DEFAULT '',
  `data2` char(255) NOT NULL DEFAULT '',
  `data3` char(255) NOT NULL DEFAULT '',
  `data4` char(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `lastview` (`lastview`),
  KEY `uid` (`uid`)
) ENGINE=MEMORY DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_sphinx`;
CREATE TABLE `p8_sphinx` (
  `id` char(50) NOT NULL,
  `max_id` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_spider_category`;
CREATE TABLE `p8_spider_category` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `display_order` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_spider_item`;
CREATE TABLE `p8_spider_item` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `rid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `title` varchar(80) NOT NULL DEFAULT '',
  `pages` smallint(5) unsigned NOT NULL DEFAULT '1',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` mediumtext NOT NULL,
  `captured_items` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_spider_item_addon`;
CREATE TABLE `p8_spider_item_addon` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iid` mediumint(8) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`iid`,`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_spider_rule`;
CREATE TABLE `p8_spider_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL,
  `cid` smallint(5) unsigned NOT NULL,
  `timestamp` int(10) unsigned NOT NULL,
  `data` mediumtext NOT NULL,
  `captured_items` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_system`;
CREATE TABLE `p8_system` (
  `name` char(30) NOT NULL DEFAULT '',
  `alias` char(30) NOT NULL DEFAULT '',
  `table_prefix` char(20) NOT NULL DEFAULT '',
  `class` char(30) NOT NULL DEFAULT '',
  `controller_class` char(50) NOT NULL DEFAULT '',
  `installed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_vote_`;
CREATE TABLE `p8_vote_` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `frame` varchar(255) NOT NULL DEFAULT '',
  `template` varchar(40) NOT NULL,
  `label_template` varchar(40) NOT NULL,
  `content` text NOT NULL,
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `multi` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `page_size` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `roles` varchar(255) NOT NULL DEFAULT '',
  `viewable` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vote_to_view` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `view_voter` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `vote_interval` smallint(5) unsigned NOT NULL DEFAULT '0',
  `votes` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  `captcha` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_vote_option`;
CREATE TABLE `p8_vote_option` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `vid` int(10) unsigned NOT NULL,
  `name` varchar(40) NOT NULL DEFAULT '',
  `description` varchar(100) NOT NULL DEFAULT '',
  `frame` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `display_order` int(10) unsigned NOT NULL DEFAULT '0',
  `votes` mediumint(8) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `vid` (`vid`,`display_order`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk;

DROP TABLE IF EXISTS `p8_vote_voter`;
CREATE TABLE `p8_vote_voter` (
  `vid` int(10) unsigned NOT NULL,
  `oid` int(10) unsigned NOT NULL,
  `uid` char(15) NOT NULL DEFAULT '',
  `username` char(20) NOT NULL DEFAULT '',
  `timestamp` int(10) unsigned NOT NULL,
  KEY `oid` (`oid`,`timestamp`),
  KEY `vid` (`vid`,`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=gbk
/*!50100 PARTITION BY HASH (vid)
PARTITIONS 10 */;

