<?php
defined('PHP168_PATH') or die();

  //##################/
 //#			#/
//##################/
class P8_Core{

var $name,				//
	$CONFIG,			//
	$_CONFIG,			//
	$CACHE,				//
	$systems,			//еϵͳ
	$_loaded_systems,	//װصϵͳ
	$modules,			//еģ
	$_loaded_modules,	//صģ
	$plugins,			//еĲ
	$_loaded_plugins,	//صĲ
	$credits,			//
	$roles,				//ɫ
	$role_groups,		//ɫ
	$_role_data,		//ɫ
	$path,				//ĵľ·
	$url,				//ĵURL
	$controller,		//ǰ̨
	$admin_controller,	//̨
	$U_controller,		//Ա
	$wap_controller,	//wap
	$DB_master,			//ݿ
	$DB_slave,			//ݿ
	$ROLE,				//ɫ
	$type,				//
	$TABLE_,			//ıǰ׺,P8_TABLE_ͬ,úݿڵǰ׺, php168.p8_,Ϊ̨PHPһݿԤӿ
	$member_table,		//ĻԱ
	$attachment_table,	//
	$attachment_url,	//
	$RESOURCE,
	$clustered,			//ǷȺ
	
	$ismobile,			//Ƿƶ豸
	$MOBILE;			//ƶ豸

function __construct(){
	
	$this->path = PHP168_PATH;
	$this->name = $this->type = 'core';
	
	$this->systems = $this->modules = $this->_loaded_systems = $this->_loaded_modules = array();
	//error_reporting(E_ALL);
	//
	$this->_CONFIG = $this->CONFIG = include CACHE_PATH .'config.php';
	global $CACHE;
	$CACHE = new P8_Cache($this);
	$this->CACHE = &$CACHE;
	
	$_config = $this->CACHE->read('', 'core', '');
	$_config = is_array($_config)?$_config:array();
	
	$this->CONFIG = array_merge($_config, $this->CONFIG);
	unset($_config);
	
	$this->TABLE_ = empty($this->CONFIG['core_table_prefix']) ? $this->CONFIG['table_prefix'] : $this->CONFIG['core_table_prefix'];
	$this->attachment_table = $this->TABLE_ .'attachment';
	$this->member_table = $this->TABLE_ .'member';
	
	//ʵַ
	$this->url = &$this->CONFIG['url'];
	$this->RESOURCE = empty($this->CONFIG['resource_url']) ? $this->url : $this->CONFIG['resource_url'];
	
	//Ƿrewriteindex.php
	$this->controller = $this->url .(empty($this->CONFIG['url_rewrite_enabled']) ? '/index.php' : '');
	
	$this->admin_controller = empty($this->CONFIG['admin_controller']) ? P8_ROOT .'admin.php' : P8_ROOT . $this->CONFIG['admin_controller'];
	
	$this->U_controller = $this->CONFIG['url'] .'/u.php';
	
	$this->systems = &$this->CONFIG['system&module'];
	$this->modules = &$this->CONFIG['modules'];
	$this->plugins = &$this->CONFIG['plugins'];
	$this->credits = &$this->CONFIG['credits'];
	$this->clustered = !empty($this->modules['cluster']['installed']) && !empty($this->modules['cluster']['enabled']);
	$this->attachment_url = $this->url .'/'. $this->CONFIG['attachment']['path'];
	
	//ʼݿ
	$this->DB_connect();
	$this->DB_connect('slave');
	
	//ʼƶ
	$this->int_mobile();
	
}

function P8_Core(){
	$this->__construct();
}


/**
* ϵͳ
* @param string $name ϵͳ
* @return object ϵͳ
**/
function &load_system($name){
	$name = strtolower($name);
	//ÿϵͳֻװһ
	if(isset($this->_loaded_systems[$name])) return $this->_loaded_systems[$name];
	
	if(!isset($this->systems[$name])){
		echo 'Error: The system '. $name .' you load doesn\'t exist<br />';
		foreach(debug_backtrace() as $v){
			echo "$v[file]: $v[line]<br />\r\n";
		}
		exit;
	}
	
	require_once $this->path . $name .'/system.php';
	$this->_loaded_systems[$name] = &new $this->systems[$name]['class']($this, $name);
	return $this->_loaded_systems[$name];
}

/**
* гϵͳ
* @param boolean $refresh Ƿг, Ĭ϶ȡ
* @return array ϵͳ
* л
**/
function list_systems($refresh = false){
	
	if($refresh){
		return include PHP168_PATH .'inc/call/refresh_systems.call.php';
	}else{
		
		return empty($this->systems) ? $this->systems = &$this->CONFIG['system&module'] : $this->systems;
	}
}

/**
* ϵͳģ
* @param string $name ģ
* @return object ģ
**/
function &load_module($name){
	$name = strtolower($name);
	if(isset($this->_loaded_modules[$name])) return $this->_loaded_modules[$name];
	
	if(!isset($this->modules[$name])){
		echo 'Error: The module '. $name .' you load doesn\'t exist<br />';
		foreach(debug_backtrace() as $v){
			echo "$v[file]: $v[line]<br />\r\n";
		}
		exit;
	}
	
	require_once $this->path .'modules/'. $name .'/module.php';
	$this->_loaded_modules[$name] = &new $this->modules[$name]['class']($this, $name);
	return $this->_loaded_modules[$name];
}

/**
* ģб
* @param boolean $refresh Ƿг, Ĭ϶ȡ
* @return array ģ
**/
function list_modules($refresh = false){
	
	if($refresh){
		return include PHP168_PATH .'inc/call/refresh_core_modules.call.php';
	}else{

		return empty($this->modules) ? $this->modules = &$this->CONFIG['modules'] : $this->modules;
	}

}

/**
* ӦÿƲ
* @param object $obj ,ϵͳ,ģ
* @return object Ʋ
**/
function &controller(&$obj){
	switch($obj->type){
	
	case 'system':
		$name = empty($obj->core->systems[$obj->name]['controller_class']) ? '' : $obj->core->systems[$obj->name]['controller_class'];
		require_once $obj->path .'controller.php';
	break;
	
	case 'module':
		$name = empty($obj->system->modules[$obj->name]['controller_class']) ? '' : $obj->system->modules[$obj->name]['controller_class'];
		require_once $obj->path .'controller.php';
	break;
	
	case 'core':
		$name = 'P8_Controller';
	break;
	
	}

	if(empty($name)){
		$ret = false;
		return $ret;
	}

	$controller = &new $name($obj);
	return $controller;
}

function &load_plugin($name){
	$name = strtolower($name);
	if(isset($this->_loaded_plugins[$name])) return $this->_loaded_plugins[$name];
	
	if(!isset($this->plugins[$name])) return null;
	
	require_once PHP168_PATH .'inc/plugin.class.php';
	require_once PHP168_PATH .'plugin/'. $name .'/plugin.php';
	$this->_loaded_plugins[$name] = &new $this->plugins[$name]['class']($this, $name);
	return $this->_loaded_plugins[$name];
}

function list_plugins($refresh = false){
	return include PHP168_PATH .'inc/call/refresh_plugins.call.php';
}

/**
* ԰б
* @param bool $refresh Ƿг
**/
function list_language($refresh = false){
	//if(isset($this->CONFIG['language'])) return $this->CONFIG['language'];
	return include PHP168_PATH .'inc/call/list_language.call.php';
}

/**
* ģб
* @param bool $refresh Ƿг
**/
function list_templates($refresh = false){
	return include PHP168_PATH .'inc/call/list_templates.call.php';
}

/**
* ȡ
* @param string $system ϵͳ
* @param string $module ģ
* @return array 
**/
function get_config($system, $module){
	$query = $this->DB_master->query("SELECT type, k, v FROM {$this->TABLE_}config WHERE system = '$system' AND module = '$module'");
	$config = array();
	while($v = $this->DB_master->fetch_array($query)){
		$config[$v['k']] = $v['type'] == 'serialize' ? mb_unserialize($v['v']) : $v['v'];
	}
	return $config;
}

/**
* д
* ñʽ
* system(ϵͳ)	module(ģ)	type()		key(ֵ)		value(ֵ)
*
* core							string				lang			zh-cn			//
* b				business_sell	serialize			ĳ		л	//ϵͳĳ
* @param array $datas ʽarray('key' => 'value'), Ҫд,ֻдֲ
* @param array $protect_fields ֶ,дݿ
* @param boolean Ƿдɹ
**/
function set_config(
	$datas,
	$protect_fields = array(),
	$ignore_fields = array()
){
	$protect_fields = array_merge(
		$protect_fields,
		array(
			//mysqlѡ
			'mysql_connect_types' => 1,
			//ݿ
			'DB_master' => 1,
			//ѡı뺯
			'encode_conv_functions' => 1,
			//ǰ׺
			'table_prefix' => 1
		)
	);
	
	$ignore_fields = array_merge(
		$ignore_fields,
		array(
			'admin_actions' => 1,
			'actions' => 1
		)
	);
	
	$this->CONFIG = $this->_set_config(
		$this->name,
		'',
		$this->path,
		'',
		'core',
		$datas,
		$protect_fields,
		$ignore_fields
	);
	
	/*
	*/
	
	return true;
}

/**
* ͳһд
* @param string $system ϵͳ
* @param string $module ģ
* @param string $path ϵͳ/ģľ·
* @param string $cache_path ϵͳ/ģĻ·
* @param string $cache_name ϵͳ/ģĻ
* @param mix $datas ϵͳ/ģĻ
* @param array $protect_fields ϵͳ/ģıֶ,дݿ⵫д
* @param array $ignore_fields ϵͳ/ģĲдݿҲᱻ뻺ֶ
**/
function _set_config(
	$system,
	$module,
	$path,
	$cache_path,
	$cache_name,
	$datas,
	$protect_fields = array(),	//ֶ,дݿҲд,ֶ޸
	$ignore_fields = array()	//ֶ,дݿҲд
){
	global $_syn_configs;
	$_syn_configs[$system][$module] = 1;
	//ͬ
	
	$info = include $path .'#.php';
	
	$query = $this->DB_master->query("SELECT type, k, v FROM {$this->TABLE_}config WHERE system = '$system' AND module = '$module'");
	$config = array();
	while($v = $this->DB_master->fetch_array($query)){
		$config[$v['k']] = $v['type'] == 'serialize' ? mb_unserialize($v['v']) : $v['v'];
		unset($info[$v['k']]);		//ݿֵѾ,ɾ#.phpֵ
	}
	
	//ȥħ
	//$datas = p8_stripslashes2($datas);
	//
	$datas = array_merge($info, $datas);	//$datas$infoֵ
	unset($info);
	
	//ڲݿ
	$db_datas = array();
	foreach($datas as $k => $v){
		if(isset($protect_fields[$k])){
			continue;
		}
		if(isset($ignore_fields[$k])){
			unset($datas[$k]);
			continue;
		}
		
		//
		$config[$k] = $v;
		$_k = $this->DB_master->escape_string($k);	//й
		$type = 'string';
		
		$_v = $v;
		if(is_array($v) || is_object($v)){
			$_v = serialize($v);//ͽл
			$type = 'serialize';
		}
		$_v = $this->DB_master->escape_string($_v);	//й
		
		$db_datas[] = array($system, $module, $type, $_k, $_v);
	}
	
	//滻
	$this->DB_master->insert(
		$this->TABLE_ .'config',
		$db_datas,
		array(
			'multiple' => array('system' ,'module' ,'type' ,'k' ,'v'),
			'replace' => true
		)
	);
	
	$datas = array_merge($datas, $config);	//$config  $datasֵ
	unset($config, $db_datas);
	
	//д
	$this->CACHE->write($cache_path, $cache_name, '', $datas);
	
	if($system == 'core' && $module == ''){
		$this->_CONFIG['memcache'] = $datas['memcache'];
		$this->_CONFIG['core_table_prefix'] = $this->CONFIG['core_table_prefix'];
		
		$config = array(
			'DB_master' => $this->CONFIG['DB_master'],
			'table_prefix' => $this->CONFIG['table_prefix'],
		);
		
		$datas = array_merge($datas, $config);
		
		if($this->_CONFIG){
			write_file(CACHE_PATH .'config.php', "<?php\r\nreturn ". var_export($this->_CONFIG, true) .';');
		}
	}
	
	return $datas;
}

/**
* ݿ
* @param string $type ,masterΪݿ,slaveΪݿ,ʵֶд
* @return boolean
**/
function DB_connect($type = 'master'){
	$mysql_connect_type = isset($this->CONFIG['mysql_connect_type'])?$this->CONFIG['mysql_connect_type']: 'mysql';
	require_once PHP168_PATH .'inc/'. $mysql_connect_type .'.class.php';
	
	//Ӷݿ
	if($type == 'slave'){
		//ʼ˳
		if(is_object($this->DB_slave)) return true;
		
		if(!isset($this->CONFIG['DB_slave']) || ($count = count($this->CONFIG['DB_slave'])) == 0){
			$this->DB_connect('master');
			$this->DB_slave = &$this->DB_master;
			return true;
		}
		
		//ֻһ,Ҵӵõ,ѴΪ
		if($count == 1 && $this->CONFIG['DB_slave'][0] == $this->CONFIG['DB_master']){
			$this->DB_slave = &$this->DB_master;
		}else{//ж
			//һ
			$k = array_rand($this->CONFIG['DB_slave']);
			$mysql_connect_type = isset($this->CONFIG['mysql_connect_types'][$mysql_connect_type])?$this->CONFIG['mysql_connect_types'][$mysql_connect_type]:'P8_mysql';
			$this->DB_slave = new $mysql_connect_type(
				$this->CONFIG['DB_slave'][$k]['host'],
				$this->CONFIG['DB_slave'][$k]['user'],
				$this->CONFIG['DB_slave'][$k]['password'],
				$this->CONFIG['DB_slave'][$k]['db'],
				$this->CONFIG['mysql_charset'],
				$this->CONFIG['DB_slave'][$k]['port'],
				$this->CONFIG['DB_slave'][$k]['pconnect']
			);
		}
		
	}else{
		//д
		if(is_object($this->DB_master)) return true;
		
		if(empty($this->CONFIG['DB_master'])) die('ûݿ');
		$mysql_connect_type = isset($this->CONFIG['mysql_connect_types'][$mysql_connect_type])?$this->CONFIG['mysql_connect_types'][$mysql_connect_type]:'P8_mysql';
		$this->DB_master = new $mysql_connect_type(
			$this->CONFIG['DB_master']['host'],
			$this->CONFIG['DB_master']['user'],
			$this->CONFIG['DB_master']['password'],
			$this->CONFIG['DB_master']['db'],
			$this->CONFIG['mysql_charset'],
			$this->CONFIG['DB_master']['port'],
			$this->CONFIG['DB_master']['pconnect']
		);
	}
}

/**
* URL·
**/
function get_router(){
	list($uri, ) = explode('?', $_SERVER['_REQUEST_URI'], 2);
	global $__FILE__;
	$self = basename($__FILE__);
	substr($uri, -1) == '/' && $uri .= $self;
	$uri = substr(preg_replace('|^/.*'. $self .'|', '', $uri), 1);
	
	if(empty($uri)) return array();
	
	//ָֻ1/
	$s = explode('/', $uri, 2);
	
	return $s;
}

/**
* (ҳ)б
* @param object $select select
* @param int $page ҳ
* @param int $page_size ÿҳ
* @param int $count ҵļ¼
* @return array 
**/
function list_item(&$select, $options = array()){
	$options['page'] = empty($options['page']) ? 0 : intval($options['page']);
	$options['count'] = empty($options['count']) ? 0 : intval($options['count']);
	$options['page_size'] = empty($options['page_size']) ? 0 : intval($options['page_size']);
	$options['sphinx'] = empty($options['sphinx']) ? array() : $options['sphinx'];
	$options['ms'] = empty($options['ms']) ? 'slave' : $options['ms'];
	$options['db_obj'] = empty($options['db_obj']) ? null : $options['db_obj'];
	$options['key_for_return'] = empty($options['key_for_return']) ? '' : $options['key_for_return'];
	$options['return'] = empty($options['return']) ? '' : $options['return'];
	
	//ǷҪҳ,page = 0,÷ҳ
	$list_page = $options['page'] && $options['page_size'];
	
	if($options['db_obj']){
		$db = &$options['db_obj'];
	}else if($options['ms'] == 'master'){
		$db = &$this->DB_master;
	}else{
		$db = &$this->DB_slave;
	}
	
	//sphinx
	if(!empty($options['sphinx']['enabled'])){
		if($list_page){
			//Ҫҳ
			$select->limit(($options['page'] -1) * $options['page_size'], $options['page_size']);
		}else if($options['page_size']){
			//ҳ
			$select->limit(0, $options['page_size']);
		}
		
		$result = p8_sphinx_fetch($select, $options['sphinx']);
		
		$datas = $ids = array();
		if(empty($result['matches'])) return $datas;
		
		//ƥ
		foreach($result['matches'] as $v){
			$datas[$v['id']] = array('id' => $v['id']);
			$ids[] = $v['id'];
		}//ȡ
		
		//
		$select->sphinx_clear();
		
		//ֻȡһfromֵID,$select->from('first_from AS i', 'i.*'), i.idᱻʹ
		$alias = array_shift(array_keys($select->_from));
		$select->in($alias .'.id', $ids);
		//дprimary IN ($ids)whereȡ
		$query = $this->select($select, array('ms' => $options['ms'], 'return' => 'query', 'db_obj' => &$options['db_obj']));
		
		//صID˳, 3, 1, 2˳SQLѯ᷵1,2,3
		while($arr = $db->fetch_array($query)){
			$datas[$arr['id']] = $arr;
		}
		
		if($list_page){
			//ܹҵ¼
			$options['count'] = $result['total_found'];
			//ҳ
			$pages = ceil($options['count'] / $options['page_size']);
		}
		
		//±Ϊ0ͷ
		return array_values($datas);
		
	}else{
		//Ĭϵݿѯ
		if($list_page){
			//Ҫҳ
			
			if($options['count'] <= 0){
				$count = $db->fetch_one($select->build_count_sql());
				
				$options['count'] = $count['num'];
			}
			
			//ûֱӷؿ
			if($options['count'] == 0) return array();
			
			$pages = ceil($options['count'] / $options['page_size']);
			$options['page'] = min($pages, $options['page']);
			$select->limit(($options['page'] -1) * $options['page_size'], $options['page_size']);
		}else if($options['page_size']){
			//ҳ
			$select->limit(0, $options['page_size']);
		}

		return $this->select(
			$select, 
			array(
				'ms' => $options['ms'],
				'return' => $options['return'],
				'key_for_return' => $options['key_for_return'],
				'db_obj' => &$options['db_obj']
			)
		);
	}
}

/**
* 
* @param object $select selectSQLĶ
**/
function select(&$select, $option = array()){
	
	$option['single'] = empty($option['single']) ? false : true;
	$option['ms'] = isset($option['single']) && $option['ms'] = 'master' ? 'master' : 'slave';
	//Լֵ
	$option['key_for_return'] = empty($option['key_for_return']) ? '' : $option['key_for_return'];
	//query
	$option['return'] = isset($option['return']) && $option['return'] == 'query' ? 'query' : 'array';
	$option['db_obj'] = empty($option['db_obj']) ? null : $option['db_obj'];
	
	if($option['db_obj']){
		$db = &$option['db_obj'];
	}else if($option['ms'] == 'master'){
		$db = &$this->DB_master;
	}else{
		$db = &$this->DB_slave;
	}
	
	if($option['single']){
		
		return $db->fetch_one($select->build_sql());
		
	}else if($option['key_for_return']){
		
		$query = $db->query($select->build_sql());
		$ret = array();
		while($arr = $db->fetch_array($query)){
			$ret[$option['key_for_return']] = $arr;
		}
		return $ret;
		
	}else{
		return $option['return'] == 'query' ? $db->query($select->build_sql()) : $db->fetch_all($select->build_sql());
	}
	
}

/**
* »ԱĻ
* @param int $uid Աid
* @param array $credits ID => 
* @param bool $add Ƿ+,credit +1,ѻΪcreditsֵ, credit = 1
**/
function update_credit($uid, $credits, $add = true){
	$uid = (array)$uid;
	if(empty($uid) || empty($credits)) return false;
	
	/*
	if(!empty($this->CONFIG['integration']['type'])){
		
	}
	*/
	
	$data = $log = array();
	foreach($credits as $id => $v){
		if($add){
			$data['credit_'. $id] = 'credit_'. $id .'+'. $v;
			foreach($uid as $u){
				$log[] = array(
					'uid' => $u,
					'credit_id' => $id,
					'credit' => $v,
					'timestamp' => P8_TIME
				);
			}
		}else{
			$data['credit_'. $id] = $v;
		}
	}
	
	if($add){
		return $this->DB_master->update(
			$this->TABLE_ .'credit_member',
			$data,
			'id IN ('. implode(',', $uid) .')',
			false
		);
		
		$this->DB_master->insert(
			$this->TABLE_ .'credit_log',
			$log,
			array(
				'multiple' => array('uid', 'credit_id', 'credit', 'timestamp')
			)
		);
	}else{
		return $this->DB_master->update(
			$this->TABLE_ .'credit_member',
			$data,
			'id IN ('. implode(',', $uid) .')'
		);
	}
}

/**
* ûԱĻ
**/
function get_credit($uid){
	$tmp = $this->DB_master->fetch_one("SELECT * FROM {$this->TABLE_}credit_member WHERE id = '$uid'");
	if(empty($tmp)) return array();
	
	unset($tmp['id']);
	$ret = array();
	foreach($tmp as $k => $v){
		$ret[substr($k, 7)] = $v;
	}
	return $ret;
}

/**
* @param int $uid ûID
* @param int $source_id ԴID
* @param int $target_id ĿID
* @param int|float $amount ҪһĿֵ
**/
function exchange_credit($uid, $source_id, $target_id, $amount){
	//ʲֱӷ
	if(empty($this->credits[$source_id]['roe'][$target_id])) return false;
	
	$need = ceil($amount / $this->credits[$source_id]['roe'][$target_id]);
	
	$credits = $this->get_credit($uid);
	//ֲ
	if($credits[$source_id] < $need) return false;
	
	$data = array($target_id => $amount, $source_id => -$need);
	
	return $this->update_credit($uid, $data);
}

/**
* ȡģĻ
**/
function get_cache($type){
	switch($type){
	
	//ɫ
	case 'role':
		if(empty($this->roles)){
			global $CACHE;
			$this->_role_data = $CACHE->read('core/modules', 'role', 'roles', 'serialize');
			
			$this->roles = &$this->_role_data['roles'];
		}
		
		if(func_num_args() > 1){
			$param = func_get_args(); array_shift($param);
			$type = array_shift($param);
			$ref = &$this->_role_data;
			
			switch($type){
				case 'role_group': $ref = $ref['group_roles']; break;
				case 'system': $ref = $ref['system_roles']; break;
				case 'type': $ref = $ref['type_roles']; break;
				case 'all': $ref = $ref['roles']; break;
			}
			if($first = array_shift($param)){
				$ref = $ref[$first];
			}
			
			foreach($param as $v){
				$ref = $ref[$v];
			}
			
			return $ref;
		}
	break;
	
	//ɫ黺
	case 'role_group':
		if(empty($this->role_groups)){
			global $CACHE;
			$this->role_groups = $CACHE->read('core/modules', 'role', 'groups');
		}
	break;
	
	//Ȩ޻
	case 'acl':
		$param = func_get_args();
		
		$role = isset($param[1]) ? 'role_'. $param[1] : 0;
		$system = isset($param[2]) ? $param[2] : '';
		$module = isset($param[3]) ? $param[3] : '';
		$postfix = isset($param[4]) ? $param[4] : '';
		
		$key = $system;
		$key .= $module ? '/modules/'. $module : '';
		$role .= $postfix ? '#'. $postfix : '';
		
		return $this->CACHE->read($key, 'acl', $role .'@'. $this->CONFIG['last_acl_cache']);
		
	break;
	
	}
	
}

/**
* עϵͳģ
**/
function unload($system, $module = ''){
	if($module){
		if($system == 'core'){
			$this->_loaded_modules[$module] = null;
			unset($this->_loaded_modules[$module]);
		}else{
			$this->_loaded_systems[$system]->_loaded_modules[$module] = null;
			unset($this->_loaded_systems[$system]->_loaded_modules[$module]);
		}
	}else{
		foreach($this->_loaded_systems[$system]->_loaded_modules as $mod => $v){
			$this->_loaded_systems[$system]->_loaded_modules[$mod] = null;
			unset($this->_loaded_systems[$system]->_loaded_modules[$mod]);
		}
		$this->_loaded_systems[$system] = null;
		unset($this->_loaded_systems[$system]);
	}
}

/**
* 
**/
function &integrate(){
	static $inte;
	
	if($inte !== null) return $inte;
	
	if(!empty($this->CONFIG['integration']['type'])){
		require PHP168_PATH .'inc/integrate/'. $this->CONFIG['integration']['type'] .'.php';
		
		$class = 'P8_Integrate_'. $this->CONFIG['integration']['type'];
		
		$inte = new $class($this);
		
		return $inte;
	}
	
	$inte = false;
	return $inte;
}

function load_acl($system, $module = '', $role_id = 0, $postfix = ''){
	static $acl;
	
	if(!isset($acl[$system][$module][$role_id][$postfix])){
		$path = $module ? $system .'/modules/'. $module : $system;
		$acl[$system][$module][$role_id][$postfix] = 
			$this->CACHE->read($path, 'acl', 'role_'. $role_id .($postfix ? '#'. $postfix : '') .'@'. $this->CONFIG['last_acl_cache']);
	}
	
	return $acl[$system][$module][$role_id][$postfix];
}

function int_mobile(){
	if(!defined(ISMOBILE)){
		if(isset($this->CONFIG['is_mobile']) && !$this->CONFIG['is_mobile']){
			$this->ismobile = 0;
		}else{
			require PHP168_PATH .'inc/mobile_detect.php';
			$this->MOBILE = new Mobile_Detect();
			$this->ismobile = $this->MOBILE->isMobile();
		}
	}
}

}





































  //##################/
 //#	ϵͳ̳	#/
//##################/
class P8_System{

var $CONFIG,			//
	$_loaded_modules,	//صģ
	$modules,			//ģ
	$path,				//ϵͳľ·
	$name,				//ϵͳ
	$url,				//ϵͳURL
	$controller,		//ϵͳ
	$admin_controller,
	$U_controller,
	$core,				//ú
	$ROLE,
	$table,
	$TABLE_,
	$member_table,		//ϵͳԱ
	$attachment_table,	//
	$type,
	$DB_master,
	$DB_slave;

function __construct($name){
	
	$this->path = PHP168_PATH . $name . '/';
	$this->name = $name;
	$this->type = 'system';
	
	$this->modules = array();
	
	//ȡģб
	$this->list_modules();
	
	//ϵͳ
	$this->CONFIG = $this->core->CACHE->read('', $this->name);
	
	if(!empty($this->CONFIG['domain'])){
		$this->controller = $this->CONFIG['domain'] .(empty($this->core->CONFIG['url_rewrite_enabled']) ? '/index.php' : '');
		$this->U_controller = $this->CONFIG['domain'] .'/u.php';
		$this->url = $this->CONFIG['domain'];
	}else{
		$this->controller = $this->core->controller .'/'. $this->name;
		$this->U_controller = $this->core->U_controller .'/'. $this->name;
		$this->url = $this->core->url .'/'. $this->name;
	}
	
	$this->admin_controller = $this->core->admin_controller .'/'. $this->name;
	
	$this->DB_master = &$this->core->DB_master;
	$this->DB_slave = &$this->core->DB_slave;
	
	$this->TABLE_ = (empty($this->CONFIG['table_prefix']) ? P8_TABLE_ : $this->CONFIG['table_prefix']) . $this->name .'_';
	$this->member_table = $this->TABLE_ .'member';
	$this->attachment_table = $this->TABLE_ .'attachment';
	
	if($this->core->systems[$this->name]['installed'])
		$this->get_role();
}

/**
* 캯
* @param string $name ϵͳ
**/
function P8_System($name){
	$this->__construct($name);
}

/**
* ȡõǰûڵǰϵͳĽɫ
**/
function get_role(){
	
	if($this->ROLE) return true;
	
	global $UID, $USERNAME, $_P8SESSION;
	
	if($UID){
		$name = $this->name;
		if(!empty($_P8SESSION['role@system'][$name])){
			//Ѿù
			$this->ROLE = $_P8SESSION['role@system'][$name];
			return true;
		}
		
		$member = $this->DB_master->fetch_one("SELECT * FROM $this->member_table WHERE id = '$UID'");
		
		if(empty($member)){
			//ϵͳĻԱûм,øĬϵĻԱȨ
			$role_id = empty($this->core->CONFIG['use_core_roles_only']) ? $this->core->CONFIG['member_role'] : $this->core->ROLE;
			$this->DB_master->insert(
				$this->member_table,
				array(
					'id' => $UID,
					'username' => $USERNAME,
					'role_id' => $role_id
				)
			);
			
			$member = $this->DB_master->fetch_one("SELECT * FROM $this->member_table WHERE id = '$UID'");
			
			$this->ROLE = $_P8SESSION['role@system'][$this->name] = $role_id;
		}else{
			//ϵͳĽɫ
			$this->ROLE = $_P8SESSION['role@system'][$this->name] = $member['role_id'];
		}
		
		//unset($member['id'], $member['username'], $member['role_id']);
		
		//$_P8SESSION[$this->name .'_member_info'] = $member;
	}else{
		//ûе¼ع鵽ϵͳοͽɫ
		//if(empty($this->CONFIG['guest_role'])) return false;
		
		$role_id = $this->core->CONFIG['guest_role'];
		$this->ROLE = $role_id;
		$_P8SESSION['role@system'][$this->name] = $role_id;
	}
}

function set_config(
	$datas,
	$protect_fields = array(),
	$ignore_fields = array()
){
	
	/* //ϵͳûװͲҪд˺
	if(empty($this->core->systems[$this->name]['installed']))
		return false; */
	
	$protect_fields = array_merge(
		$protect_fields,
		array(
		)
	);
	
	$ignore_fields = array_merge(
		$ignore_fields,
		array(
			'alias' => 1,
			'class' => 1,
			'controller_class' => 1,
			'admin_actions' => 1,
			'actions' => 1,
			'credit_rule_actions' => 1
		)
	);
	
	$this->CONFIG = $this->core->_set_config(
		$this->name,
		'',
		$this->path,
		'',
		$this->name,
		$datas,
		$protect_fields,
		$ignore_fields
	);
	
	return true;
}

//-------------------ģ麯------------------------
/**
* ϵͳģ
* @param string $name ģ
* @return boolean
**/
function &load_module($name){
	$name = strtolower($name);
	if(isset($this->_loaded_modules[$name])) return $this->_loaded_modules[$name];
	
	if(!isset($this->modules[$name])){
		echo 'Error: The module '. $name .' you load doesn\'t exist<br />';
		foreach(debug_backtrace() as $v){
			echo "$v[file]: $v[line]\r\n<br />";
		}
		exit;
	}
	
	require_once $this->path .'/modules/'. $name .'/module.php';
	$this->_loaded_modules[$name] = &new $this->modules[$name]['class']($this, $name);
	return $this->_loaded_modules[$name];
}

/**
* ϵͳģб
* @param boolean $refresh Ƿг, Ĭ϶ȡ
* @return array ϵͳģ
**/
function list_modules($refresh = false){
	
	if($refresh){
		return include PHP168_PATH .'inc/call/refresh_system_modules.call.php';
	}else{
		
		return empty($this->modules) ? $this->modules = &$this->core->CONFIG['system&module'][$this->name]['modules'] : $this->modules;
	}

}


}































  //##################/
 //#	ģ̳	#/
//##################/
class P8_Module{


var $name;				//ģ
var $path;				//ģľ·
var $CONFIG;			//
var $url;				//URL
var $controller;		//ģ
var $admin_controller;
var $U_controller;
var $system;			//ϵͳ,ֱӵϵͳķ
var $core;				//
var $configurable = true;//Ƿ,̳ʱΪfalse,ʱ
var $TABLE_;			//ǰ׺
var $table;
var $type;				//
var $DB_master;
var $DB_slave;

function __construct($name){
	
	$this->path = $this->system->path .'modules/'. $name .'/';
	$this->name = $name;
	$this->type = 'module';
	
	//,ģ,
	if($this->system->type == 'core'){
		$this->core = &$this->system;
	}else{
		$this->core = &$this->system->core;
	}
	
	if($this->configurable){
		$this->CONFIG = $this->core->CACHE->read($this->system->name .'/modules/', $this->name);
	}
	
	if(!empty($this->CONFIG['domain'])){
		
		$this->controller = $this->CONFIG['domain'] .(empty($this->core->CONFIG['url_rewrite_enabled']) ? '/index.php/' : '/');
		$this->U_controller = $this->CONFIG['domain'] .'/u.php/';
		$this->url = $this->CONFIG['domain'];
		
	}else{
		if($this->system->type == 'core'){
			$this->controller = $this->core->controller .'/'. $name;
			$this->U_controller = $this->core->U_controller .'/'. $name;
		}else{
			$this->controller = $this->system->controller .'/'. $name;
			$this->U_controller = $this->system->U_controller .'/'. $name;
		}
		
		$this->url = $this->system->url .'/modules/'. $this->name;
	}
	$this->admin_controller = $this->system->admin_controller .'/'. $name;
	
	$this->DB_master = &$this->core->DB_master;
	$this->DB_slave = &$this->core->DB_slave;
	
	$this->TABLE_ = $this->system->TABLE_ . $this->name .'_';
}

/**
* 캯
* @param string $name ϵͳģ
**/
function P8_Module($name){
	$this->__construct($name);
}

/**
* 
* @param array $data 
* @return boolean
**/
function set_config(
	$datas,
	$protect_fields = array(),
	$ignore_fields = array()
){
	/* //ϵͳûװͲҪд˺
	if(empty($this->system->modules[$this->name]['installed']))
		return false; */
	
	//ֱ˳
	if(!$this->configurable) return false;
	
	$protect_fields = array_merge(
		$protect_fields,
		array()
	);
	
	$ignore_fields = array_merge(
		$ignore_fields,
		array(
			'alias' => 1,
			'class' => 1,
			'controller_class' => 1,
			'admin_actions' => 1,
			'actions' => 1,
			'credit_rule_actions' => 1
		)
	);
	
	$this->CONFIG = $this->core->_set_config(
		$this->system->name,
		$this->name, $this->path,
		$this->system->name .'/modules/',
		$this->name, $datas,
		$protect_fields,
		$ignore_fields
	);
	
	return true;
}

/**
* ģҹ
* @param string $system ϵͳ
* @param string $module ģ
* @param string $id_field idֶ
**/
function hook($system, $module, $id_field){
	return include PHP168_PATH .'inc/call/hook_module.call.php';
}

/**
* ȡģҹ
* @param string $system ϵͳ
* @param string $module ģ
**/
function unhook($system, $module){
	
	return include PHP168_PATH .'inc/call/unhook_module.call.php';
}

/**
* ɾҹģ,ֻID,൱ɽկԼ
**/
function delete_hook_module_item($ids){
	if(empty($this->system->CONFIG['hook_modules'][$this->name])) return false;
	
	//֪ͨΧ߲ȡж
	foreach($this->system->CONFIG['hook_modules'][$this->name] as $system => $v){
		//ϵͳ
		if($system == 'core'){
			//ģ
			$s = &$this->core;
		}else{
			$s = &$this->core->load_system($system);
		}
		
		foreach($v as $module => $id_field){
			//ģ
			$m = &$s->load_module($module);
			//ùҹɾ
			$m->hook_delete($this, "#module_table#.$id_field IN ($ids)");
		}
	}
	return true;
}

/**
* ģ鹴ɾ,ҪٸݸģĲͬиչ
* @param object $module_obj ģ
* @param string $cond ɾ
* еģɾԴ˸ʽ function delete($data){}
* $data = array(
*	'where' => 'id IN (1,2,3)'		//ɾ
*	'delete_hook' => true|false,	//Ƿɾҹģ
*	'hook' => true|false			//ҹɾ
* )
**/
function hook_delete(&$module_obj, $cond){
	//ñģɾݺ
	return $this->delete(array(
		'where' => str_replace('#module_table#', $this->table, $cond),
		'hook' => true
	));
}

/**
* ɻ,վ֪ͨվҲ»
**/
function cache(){
	
}

}
//ģͲ(M)
































  //##################//
 //#	Ʋ	#//
//##################//
class P8_Controller{

var $model,				//ģͲǺ,ϵͳ,ģ
	$core,				//ú
	$admin_actions,		//̨
	$actions,			//ǰ̨
	$m_actions,			//ǰ̨
	$ACL,				//Ȩ
	$MACL,				//Ȩ
	$ROLE,				//ǰϵͳɫ
	$acl_postfix,		//չȨ
	$acl_path,			//Ȩ޻·
	$no_base_acl,		//޻Ȩ
	$postfix_queue,		//׺
	$last_acl_cache,	//һθȨ޻ʱ׺
	$last_user_acl_cache,	//һθ¸Ȩ޻ʱ׺ 
	$DB_master,
	$DB_slave;

function __construct(&$obj){
	$this->model = &$obj;
	
	$this->init();
}

function P8_Controller(&$obj){
	$this->__construct($obj);
}

function init(){
	global $CACHE,$UID;
	
	switch($this->model->type){
	
	case 'core':
		//
		$this->core = &$this->model;
		
		$this->acl_path = $this->model->name;
		$this->ROLE = $this->model->ROLE;
	break;
	
	case 'system':
		//ϵͳ
		$this->core = &$this->model->core;
		
		$this->acl_path = $this->model->name;
		$this->ROLE = $this->model->ROLE;
	break;
	
	case 'module':
		$this->core = &$this->model->core;
		
		if($this->model->system->name == 'core'){	//ģ
			$this->acl_path = $this->model->system->name .'/modules/'. $this->model->name;
			$this->ROLE = $this->model->core->ROLE;
		}else{	//ϵͳģ
			$this->acl_path = $this->model->system->name .'/modules/'. $this->model->name;
			$this->ROLE = $this->model->system->ROLE;
		}
	break;
	
	}
	
	$this->last_acl_cache = '@'. $this->core->CONFIG['last_acl_cache'];
	$this->last_user_acl_cache = '@'. $this->core->CONFIG['last_user_acl_cache'];
	
	//ûлȨ޿,ֻչȨ򲻶Ȩ
	if(!$this->no_base_acl){
		$ACL = $CACHE->read($this->acl_path, 'acl', 'role_'. $this->ROLE . $this->last_acl_cache);
		//ݽɫʼȨ
		$this->admin_actions = empty($ACL['admin_actions']) ? array() : $ACL['admin_actions'];
		$this->actions = empty($ACL['actions']) ? array() : $ACL['actions'];
		
		unset($ACL['admin_actions'], $ACL['actions']);
		
		//ʼϸȨ
		$this->ACL = $ACL;
		/**---------------Ȩ-----------------**/
		$MACL = $CACHE->read($this->acl_path, 'acl', 'user_'. $UID . $this->last_user_acl_cache);
		//ݽɫʼȨ
		$this->m_actions = empty($MACL['actions']) ? array() : $MACL['actions'];
		
		unset($MACL['admin_actions'], $MACL['actions']);
		
		//ʼϸȨ
		$this->MACL = $MACL;
	}
	
	$this->acl_postfix = array();
	$this->postfix_queue = array();
	
	$this->DB_master = &$this->core->DB_master;
	$this->DB_slave = &$this->core->DB_slave;
	
	$this->_init();
}

/**
* าǵĳʼ
**/
function _init(){}

/**
* ̨Ȩ
* @param string $action 
* @return boolean
**/
function check_admin_action($action, $postfix = ''){
	//Ǵʼֱӷ
	global $IS_FOUNDER;
	if($IS_FOUNDER) return true;
	
	if($postfix && ($pos = array_search($postfix, $this->postfix_queue)) !== false){
		//к׺ҵ׺
		
		//׺Ȩ
		if(!empty($this->acl_postfix[$this->postfix_queue[$pos]])){
			//Ȩ,Ȩ
			return !empty($this->acl_postfix[$this->postfix_queue[$pos]]['admin_actions'][$action]);
		}else if($pos != 0){
			//û÷һ׺Ȩ,һ׺Ȩ޲Ϊ
			if(!empty($this->acl_postfix[$this->postfix_queue[$pos -1]])){
				return !empty($this->acl_postfix[$this->postfix_queue[$pos -1]]['admin_actions'][$action]);
			}
		}
	}
	
	return !empty($this->admin_actions[$action]);
}

/**
* ǰ̨Ȩ
* @param string $action 
* @return boolean
**/
function check_action($action, $postfix = ''){
	//Ǵʼֱӷ
	global $IS_FOUNDER;
	if($IS_FOUNDER) return true;
	
	if($postfix && ($pos = array_search($postfix, $this->postfix_queue)) !== false){
		//к׺ҵ׺
		
		//׺Ȩ
		if(!empty($this->acl_postfix[$this->postfix_queue[$pos]])){
			//Ȩ,Ȩ
			return !empty($this->acl_postfix[$this->postfix_queue[$pos]]['actions'][$action]);
		}else if($pos != 0){
			//û÷һ׺Ȩ,һ׺Ȩ޲Ϊ
			if(!empty($this->acl_postfix[$this->postfix_queue[$pos -1]])){
				return !empty($this->acl_postfix[$this->postfix_queue[$pos -1]]['actions'][$action]);
			}
		}
	}
	//ȲȨ
	if($this->check_m_action($action, $postfix))return true;
	//޺׺ĬϵȨ
	return !empty($this->actions[$action]);
}


/**
* ǰ̨Ȩ
* @param string $action 
* @return boolean
**/
function check_m_action($action, $postfix = ''){
	//Ǵʼֱӷ
	global $IS_FOUNDER;
	if($IS_FOUNDER) return true;
	//޺׺ĬϵȨ
	return !empty($this->m_actions[$action]);
}

/**
* ȡú׺Ȩޱ
* @param string $postfix ׺
**/
function load_acl($postfix){
	$ACL = $this->core->CACHE->read($this->acl_path, 'acl', 'role_'. $this->ROLE .($postfix ? '#'. $postfix : ''). $this->last_acl_cache);
	//׺
	array_push($this->postfix_queue, $postfix);
	if(empty($ACL)) return false;
	
	$this->acl_postfix[$postfix]['admin_actions'] = empty($ACL['admin_actions']) ? array() : $ACL['admin_actions'];
	$this->acl_postfix[$postfix]['actions'] = empty($ACL['actions']) ? array() : $ACL['actions'];
	
	unset($ACL['admin_actions'], $ACL['actions']);
	$this->acl_postfix[$postfix]['ACL'] = $ACL;
}

/**
* ȡadmin_actions, actions Ȩ
* @param string $key ֵ
* @param string $postfix ׺
* @return mix û,null
**/
function get_acl($key, $postfix = ''){
	if($postfix){
		return isset($this->acl_postfix[$postfix]['ACL'][$key]) ? $this->acl_postfix[$postfix]['ACL'][$key] : null;
	}else{
		return isset($this->ACL[$key]) ? $this->ACL[$key] : null;
	}
}

/**
* ȡadmin_actions, actions Ȩ
* @param string $key ֵ
* @param string $postfix ׺
* @return mix û,null
**/
function get_m_acl($key, $postfix = ''){
	if($postfix){
		return isset($this->acl_postfix[$postfix]['ACL'][$key]) ? $this->acl_postfix[$postfix]['ACL'][$key] : null;
	}else{
		return isset($this->MACL[$key]) ? $this->MACL[$key] : null;
	}
}
/**
* ȡadmin_actions, actions ĸȨ
* @param string $key ֵ
* @param string $postfix ׺
* @return mix û,null
**/
function get_member_acl($key, $postfix = ''){
	if($postfix){
		return isset($this->acl_postfix[$postfix]['ACL'][$key]) ? $this->acl_postfix[$postfix]['ACL'][$key] : null;
	}else{
		return isset($this->ACL[$key]) ? $this->ACL[$key] : null;
	}
}

}





























  //##################//
 //#			#//
//##################//
class P8_Cache{

var $memcache,
	$memcache_config,
	$prefix,
	$core;

function __construct(&$core){
	
	$this->core = &$core;
	
	if(!empty($core->CONFIG['memcache']['enabled'])){
		$this->memcache_config = $config = &$core->CONFIG['memcache'];
		
		$this->memcache = new memcache();
		
		foreach($config['server'] as $v){
			$this->memcache->addServer($v['host'], $v['port'], $config['pconnect']);
		}
		
		if($config['compress'])
			$this->memcache->setCompressThreshold(20000, 0.2);
		
		$this->prefix = $config['prefix'];
	}
}

/**
* 
**/
function P8_Cache(&$core){
	$this->__construct($core);
}

/**
* д
* д,Իļıľ·Ϊmemcacheļֵȡ
* @param string $path 汣·,/data/ļµ·,a/b, a/
* @param string $name ģ,Ҫ x/data/нӦļ,role,/data/role
* @param string $id id,id,ʽΪ$module_$id.php,ûidΪ$module.php,ûidһڱģܻ
* @param array $data 
* @param string $type 汣,ĬΪvar_exportʽ,߿serializeлʽ
* @return boolean Ƿ񱣴ɹ
* @example cache_write('a/', 'con', 'a', array());	ݱ浽/data/a/con_a.php
* @example cache_write('a/', 'con', '', array());	ݱ浽/data/a/con.php
**/
function write($path, $name, $id, $data, $type = 'var_export'){
	$_path = real_path(CACHE_PATH . $path);
	if(!$_path) return false;
	
	if($id){//ID,Ϊдļ,ûдܻ
		//CACHE_PATH . $path . $name
		
		if(is_int($id)){
			$tmp = '/'. intval($id / 1000) .'/';	//ÿļд洢ļ1000
			$file = $name . $tmp . $name .'_'. $id .'.php';
			$name = $name . $tmp;
		}else{
			$file = $name .'/'. $name .'_'. $id .'.php';
		}
	}else{
		$file = $name .'/'. $name .'.php';
	}
	//Ŀ¼ڴ
	md($_path . $name, true);
	$path = str_replace(CACHE_PATH, '', $_path);
	if($this->memcache){
		//memcache,ѻŵmemcache
		
		$status = $this->memcache_write($path . $file, $data);
	}
	
	/* $this->DB_master->insert(
		$this->core->TABLE_ .'cache',
		array(
			'path' => $path,
			'name' => $name,
			'id' => $id,
			'v' => $this->DB_master->escape_string(serialize($data))
		),
		array('replace' => true)
	); */
	
	//if($path == '' && $name == 'core' && $id == ''){
		$status = $this->file_write($_path . $file, $data, $type);
	//}
	
	return true;
}

/**
* 
* @param string $path ȡ·,Ĭ϶ȡ/data,ָΪarticle/,ôȡarticle/data/
* @param string $name ģ,Ҫ x/data/нӦļ,role,ȡ/data/role
* @param string $id id,id,ȡʽΪ$module_$id.php,ûidΪ$name.php,ûidһڶȡģܻ
* @param string $type ȡ,ĬΪvar_exportʽ,߿serializeлʽ
* @return array ȡ
**/
function read($path, $name, $id = '', $type = 'var_export'){
	$_path = real_path(CACHE_PATH . $path);
	if(!$_path) return array();
	
	if($id){//ID,Ϊдļ,ûдܻ
		//CACHE_PATH . $path . $name
		
		if(is_int($id)){
			$tmp = '/'. intval($id / 1000) .'/';	//ÿļд洢ļ1000
			$file = $name . $tmp . $name .'_'. $id .'.php';
			$name = $name . $tmp;
		}else{
			$file = $name .'/'. $name .'_'. $id .'.php';
		}
	}else{
		$file = $name .'/'. $name .'.php';
	}
	
	$path = str_replace(CACHE_PATH, '', $_path);
	if($this->memcache){
		//memcache,ֱmemcacheж
		
		$data = $this->memcache_read($path . $file);
		if(empty($data)){
			//memcacheû,¶һļ
			
			//$data = $this->db_read($path, $name, $id);
			$data = $this->file_read($_path . $file, $type);
			$this->memcache_write($path . $file, $data);
			return $data;
		}
		return $data;
	}else{
		//return $this->db_read($path, $name, $id);
		//echo $_path . $file."<br/>\n\r";
		return $this->file_read($_path . $file, $type);
	}
}

/**
* ɾ
* @param string $path ȡ·,Ĭ϶ȡ/data,ָΪarticle/,ôȡarticle/data/
* @param string $name ģ,Ҫ x/data/нӦļ,role,ȡ/data/role
* @param string $id id,id,ȡʽΪ$module_$id.php,ûidΪ$module.php,ûidһڶȡģܻ
* @return boolean
**/
function delete($path, $name, $id = ''){
	$_path = real_path(CACHE_PATH . $path);
	if(!$_path) return false;
	
	if($id){
		if(is_int($id)){
			$tmp = '/'. intval($id / 1000) .'/';	//ÿļд洢ļ1000
			$file = $name . $tmp . $name .'_'. $id .'.php';
		}else{
			$file = $name .'/'. $name .'_'. $id .'.php';
		}
	}else{
		$file = $name .'/'. $name .'.php';
	}
	
	if($this->memcache){
		$path = str_replace(CACHE_PATH, '', $_path);
		$this->memcache_delete($path . $file);
	}
	
	/* $this->DB_master->delete(
		$this->core->TABLE_ .'cache',
		"path = '$path'" .($name == '*' ? '' : " AND name = '$name'"). ($id == '*' ? '' : " AND id = '$id'")
	); */
	
	if($id == '*'){
		rm($_path . $name, true);
		/*
		foreach(glob($_path . $file) as $v){
			@unlink($v);
		}*/
		return true;
	}else{
		return @unlink($_path . $file);
	}
}

function memcache_write($file, &$data){
	//д浽memcache
	$this->memcache->set($this->prefix . $file, $data);
}

function memcache_read($file){
	//memcache
	return $this->memcache->get($this->prefix . $file);
}

function memcache_delete($file){
	//memcacheɾ
	return $this->memcache->delete($this->prefix . $file, 0);
}

function file_write($file, &$data, $type = 'var_export'){
	//д浽ļ
	
	$fp = fopen($file, 'w');
	flock($fp, LOCK_EX);
	$status = fwrite($fp, $type == 'var_export' ?
		"<?php\r\nreturn ". var_export($data, true) .";" :
		'<?php die();?>'. serialize($data)
		//dieֹй¶
	);
	flock($fp, LOCK_UN);
	return $status;
}

/*
function db_read($path, $name, $id = ''){

	$tmp = $this->DB_master->fetch_one("SELECT v FROM {$this->core->TABLE_}cache WHERE path = '$path' AND name = '$name' AND id = '$id'");
	return empty($tmp['v']) ? array() : mb_unserialize($tmp['v']);
}*/

function file_read($file, $type = 'var_export'){
	$data = null;
	//ļ
	if($type == 'var_export'){
		$data = @include $file;
	}else{
		//л
		$fp = @fopen($file, 'r');
		if($fp){
			flock($fp, LOCK_SH);
			//λ< ?php die();? >֮
			fseek($fp, 14);
			$c = '';
			while(!feof($fp)){
				$c .= fgets($fp);
			}
			$data = @mb_unserialize($c);
			unset($c);
			flock($fp, LOCK_UN);
		}
	}
	
	if(empty($data))
		return array();
	return $data;
}

}