<?php

/**
 *      【橙创家校通v4.0】 (C)2010-2012 Tuntron Inc.
 *      
 *    	 http://www.tuntron.com   QQ：1121251729
 *
 *      &用户组基类文件&
 */
 
if (!defined('IS_RUN')) die('Forbidden');

class tj_usergroup extends tj_model {

    var $table = 'dbpre_usergroups';
    var $key = 'groupid';

    function __construct() {
        parent::__construct();
        $this->init_field();
    }

    function tj_usergroup() {
        $this->__construct();
    }

    function init_field() {
        $this->add_field('groupid,grouptype,groupname,point,color,menuid,access');
        $this->add_field_fun('groupname,grouptype,color', '_T');
        $this->add_field_fun('groupid,point', 'intval');
    }
	
	function read_where_groupname($groupname) {
        $this->db->from($this->table);
		$this->db->where('groupname', $groupname);
		$this->db->select('groupid');
        return $this->db->once_fetch_assoc();
    }

    function read($groupid) {
        $result = parent::read($groupid);
	    $result['access'] = $result['access'] ? unserialize($result['access']) : array();
        return $result;
    }

    function read_all($type=null) {
        $this->db->from($this->table);
        if($type) {
            $this->db->where('grouptype', $type);
            if($type=='member') {
                $this->db->order_by('groupid');
            }
        }
        $this->db->select('groupid,grouptype,groupname,point,color,menuid,access');
		
		$allusergroup=$this->db->fetch_all_assoc();
		foreach($allusergroup as $key=>$item){
			$allusergroup[$key]['menutitle'] =$item['menuid']?G_class('menu')->read($item['menuid']):'';
		}
		
		
        return $allusergroup;
    }

	function usergroup_option($groupid,$grouptype=null) {
		
		global $_CO;
        $this->db->from($this->table);
		$this->db->where_more('groupid', $_CO['groupid']);
        $this->db->select('groupid,groupname');
		
		$usergroup=$this->db->fetch_all_assoc();
		
		foreach($usergroup as $key=>$item){
			if($item['groupid']<>5){
			$isselected = intval($groupid)>0&&$groupid==$item['groupid']?'selected="selected"':'';
			$usergroup_html.= '<option value="'.$item['groupid'].'"'.$isselected.'>'.$item['groupname'].'</option>';
			}
		}
		return $usergroup_html;
    }
	
	function get_usergroupid_str($groupid,$c) {

		$this->db->from($this->table);
		if($c=='sch'){
			$this->db->where_more('groupid', $groupid);
			$this->db->where_not_equal('grouptype', 'parent');//学校框架不显示家长
		}else{
			$this->db->where('grouptype', 'parent');
		}
        $this->db->select('groupid');
		
		$usergroup=$this->db->fetch_all_assoc();
		
		foreach($usergroup as $key=>$item){
			$usergroupid_str.= $item['groupid'].'_';
		}
		return $usergroupid_str;
    }
	
	function usergroup_show($groupid,$gid,$c,$bid,$p) {
		
		global $mod;
		$this->db->from($this->table);
		$this->db->where_more('groupid', $groupid);
        $this->db->select('groupid,groupname');
		
		$usergroup=$this->db->fetch_all_assoc();
		
		foreach($usergroup as $key=>$item){

			$usergrouphtml.= $gid ==$item['groupid']?'<li class="on"><a  href="'.SITEURL.'?mod='.$mod.'&do=member&c='.$c.'&bid='.$bid.'&gid='.$item['groupid'].'&p='.$p.'">只显示'.$item['groupname'].'</a></li>':'<li><a  href="'.SITEURL.'?mod='.$mod.'&do=member&c='.$c.'&bid='.$bid.'&gid='.$item['groupid'].'&p='.$p.'">只显示'.$item['groupname'].'</a></li>';
		}
		return $usergrouphtml;
    }
	
    function update(& $post) {
        if(!is_array($post)) return;
        foreach($post as $key => $val) {
            $this->save($val, $key, FALSE);
        }
        $this->write_cache();
    }
	
	
	function del($groupid) {
		
        $this->db->where('groupid', $groupid);  
		
		$this->db->from($this->table);     

        $this->db->delete();
    }

    function save($post,$groupid=null) {
        $edit = $groupid!=null;
        if($edit) {
            if(!is_numeric($groupid) || $groupid < 1) Note('无效groupid');
            if(!$detail=$this->read($groupid)) Note('用户组为空');
			isset($post['access']) && $post['access'] = $post['access'] ? serialize($post['access']) : '';
        }
        $groupid = parent::save($post,$groupid);
		$this->write_cache();
        return $groupid;
    }

    function & point_by_usergroup($point) {
        if(!isset($this->global['usergroup'])) {
            $this->global['usergroup'] = $this->variable('usergroup');

            if(!$this->global['usergroup']) return;
        }
        $groupid = 0;
        foreach($this->global['usergroup'] as $key => $val) {
            if($val['grouptype'] != 'member') continue;
            if($point > $val['point']) $groupid = $key;
        }
        return $groupid;
    }
	
	//获取当前用户的权限值
    function get_access($groupid) {
        $usergroups =fileRead('dat/access.php');
		if(!$usergroups) $this->write_cache();
        $access = unserialize($usergroups['usergroup_'.$groupid]);
        return $access;
    }

 	function write_cache() {
		
		$arrgroups = $this->read_all();
		foreach($arrgroups as $item){
				$arrgroup['usergroup_'.$item['groupid']] = $item['access'];
		}
		writecache('access.php','dat',$arrgroup);
      
    }

    function write_cache_menuid($groupid) {
        if(!$result = $this->read($groupid)) return;
        write_cache($this->cache_name.'_'.$groupid, arrayeval($result), $this->model_flag);
    }

    function check_post(& $post, $edit = FALSE) {
        if($edit && isset($post['groupname']) && !$post['groupname']) Note('组头衔不能为空！');
        if(!$edit && !$post['groupname']) Note('组头衔不能为空！');
        if(!$edit && !in_array($post['grouptype'],array('system','school','home','special'))) Note('还没有选择组类型！');
    }
}
?>