
DROP TABLE IF EXISTS `tj_access`;
CREATE TABLE `tj_access` (
  `name` varchar(16) NOT NULL default '',
  `action` varchar(50) NOT NULL default '',
  `type` varchar(16) NOT NULL default '',
  `cate` varchar(100) NOT NULL default '',
  `des` varchar(255) NOT NULL COMMENT '权限描述'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限分类';
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许编辑管理范围内话题','edit_other_topic','system','讨论组','开启本功能后，本组成员便可以编辑当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许编辑自己发布的话题','edit_self_topic','system','讨论组','开启本功能后，本组成员便可以编辑自己发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许在讨论组发布话题','add_topic','system','讨论组','开启本功能后，本组成员便可以在讨论组板块发布话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许创建讨论组','add_group','system','讨论组','开启本功能后，本组成员便可以在讨论组板块创建讨论组。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许增加讨论区','add_groupcate','system','讨论组','开启本功能后，本组成员便可以在讨论组板块增加讨论区。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许添加、编辑、删除人员','set_member','system','人员管理','开启本功能后，本组成员便可以在人员管理界面添加、编辑、删除人员。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许禁用、启用人员','baned_member','system','人员管理','开启本功能后，本组成员便可以在人员管理界面禁用和启用人员。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送手机短信','send_sms','system','人员管理','开启本功能后，本组成员便可以在人员管理界面发送手机短信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送站内信','send_msg','system','人员管理','开启本功能后，本组成员便可以在人员管理界面发送站内信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许下载人员数据','export_member','system','人员管理','开启本功能后，本组成员便可以下载人员数据。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许新建或修改部门信息','set_branch','system','人员管理','开启本功能后，本组成员便可以新建或修改部门信息。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许设置用户组','system_usergroup','system','系统设置','开启本功能后，本组成员便可以在总后台设置用户组。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行数据库操作','set_mysql','system','系统设置','开启本功能后，本组成员便可以在总后台进行数据库操作。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行短信接口设置','system_setsms','system','系统设置','开启本功能后，本组成员便可以在总后台设置短信接口。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许管理菜单','set_menu','system','系统设置','开启本功能后，本组成员便可以在总后台管理菜单。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行短信分配','system_smsassign','system','系统设置','开启本功能后，本组成员便可以在总后台为其下属用户分配短信数额。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许修改系统信息','system_changeinfo','system','系统设置','开启本功能后，本组成员便可以在总后台编辑系统信息。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许删除自己发布的话题','del_self_topic','system','讨论组','开启本功能后，本组成员便可以删除自己发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许删除管理范围内话题','del_other_topic','system','讨论组','开启本功能后，本组成员便可以删除当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许置顶话题','top_topic','system','讨论组','开启本功能后，本组成员便可以置顶当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许把话题加入精华','posts_topic','system','讨论组','开启本功能后，本组成员便可以把当前用户组的下属用户所发布的话题加入精华。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许评论话题','Cmt_topic','system','讨论组','开启本功能后，本组成员便可以在讨论组评论话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发布系统公告','system_ann','system','其他','开启本功能后，本组成员便可以在总后台发布系统公告。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许管理帮助信息','set_help','system','其他','开启本功能后，本组成员便可以在总后台管理帮助信息。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行科目设置','set_subject','school','校务管理','开启本功能后，本组成员便可以新建或修改部门信息。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行考试设置','set_exam','school','校务管理','开启本功能后，本组成员便可以下载人员数据。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许进行考勤管理','set_attendance','school','校务管理','开启本功能后，本组成员便可以在人员管理界面发送站内信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发布学校公告','school_ann','school','校务管理','开启本功能后，本组成员便可以在人员管理界面发送手机短信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许设置课程表','set_schedule','school','班务管理','开启本功能后，本组成员便可以设置本班课程表。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发布班级公告','class_ann','school','班务管理','开启本功能后，本组成员便可以发布班级公告。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许添加考试','add_exam','school','考试&作业','开启本功能后，本组成员便可以添加考试。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许查看考试成绩','show_result','school','考试&作业','开启本功能后，本组成员便可以查看考试成绩。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许导入、编辑考试成绩','add_result','school','考试&作业','开启本功能后，本组成员便可以导入、编辑考试成绩。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送考试成绩','send_result','school','考试&作业','开启本功能后，本组成员便可以发送考试成绩给学生家长。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许下载考试成绩数据','down_result','school','考试&作业','开启本功能后，本组成员便可以下载考试成绩数据。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许添加新作业','add_work','school','考试&作业','开启本功能后，本组成员便可以添加新作业。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送作业内容','send_work','school','考试&作业','开启本功能后，本组成员便可以发送作业内容到学生家长。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许创建下载文件夹','add_folder','school','文件下载','开启本功能后，本组成员便可以创建下载文件夹。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许上传文件','upload_file','school','文件下载','开启本功能后，本组成员便可以上传文件。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许下载文件','down_file','school','文件下载','开启本功能后，本组成员便可以下载文件。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许新建或修改部门信息','set_branch','school','人员管理','开启本功能后，本组成员便可以新建或修改部门信息。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许下载人员数据','export_member','school','人员管理','开启本功能后，本组成员便可以下载人员数据。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送站内信','send_msg','school','人员管理','开启本功能后，本组成员便可以在人员管理界面发送站内信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许发送手机短信','send_sms','school','人员管理','开启本功能后，本组成员便可以在人员管理界面发送手机短信。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许禁用、启用人员','baned_member','school','人员管理','开启本功能后，本组成员便可以在人员管理界面禁用和启用人员。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许添加、编辑、删除人员','set_member','school','人员管理','开启本功能后，本组成员便可以在人员管理界面添加、编辑、删除人员。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许增加讨论区','add_groupcate','school','讨论组','开启本功能后，本组成员便可以在讨论组板块增加讨论区。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许创建讨论组','add_group','school','讨论组','开启本功能后，本组成员便可以在讨论组板块创建讨论组。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许在讨论组发布话题','add_topic','school','讨论组','开启本功能后，本组成员便可以在讨论组板块发布话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许编辑自己发布的话题','edit_self_topic','school','讨论组','开启本功能后，本组成员便可以编辑自己发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许编辑管理范围内话题','edit_other_topic','school','讨论组','开启本功能后，本组成员便可以编辑当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许删除自己发布的话题','del_self_topic','school','讨论组','开启本功能后，本组成员便可以删除自己发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许删除管理范围内话题','del_other_topic','school','讨论组','开启本功能后，本组成员便可以删除当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许置顶话题','top_topic','school','讨论组','开启本功能后，本组成员便可以置顶当前用户组的下属用户所发布的话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许把话题加入精华','posts_topic','school','讨论组','开启本功能后，本组成员便可以把当前用户组的下属用户所发布的话题加入精华。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许评论话题','Cmt_topic','school','讨论组','开启本功能后，本组成员便可以在讨论组评论话题。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许查看系统日志','school_log','school','其他','开启本功能后，本组成员便可以查看系统日志。');
INSERT INTO `tj_access`(`name`,`action`,`type`,`cate`,`des`)VALUES('允许分配短信','school_smsassign','school','其他','开启本功能后，本组成员便可以对其下属人员进行短信分配操作。');

DROP TABLE IF EXISTS `tj_ann`;
CREATE TABLE `tj_ann` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `title` varchar(200) NOT NULL default '',
  `bid` int(11) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `author` varchar(50) NOT NULL default '',
  `pageview` int(10) NOT NULL default '0',
  `dateline` int(10) NOT NULL default '0',
  `available` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='公告';
INSERT INTO `tj_ann`(`id`,`title`,`bid`,`content`,`author`,`pageview`,`dateline`,`available`)VALUES('27','欢迎使用家校通系统！','111','欢迎使用家校通系统！','chenzhibin','0','1357436421','1');

DROP TABLE IF EXISTS `tj_area`;
CREATE TABLE `tj_area` (
  `aid` mediumint(8) unsigned NOT NULL auto_increment,
  `pid` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(16) NOT NULL default '',
  `mappoint` varchar(50) NOT NULL default '',
  `level` tinyint(1) unsigned NOT NULL default '0',
  `listorder` smallint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (`aid`),
  KEY `pid` (`pid`),
  KEY `level` (`level`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COMMENT='地区';
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('1','0','宁波市','121.565151,29.877309','1','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('2','1','江东区','','2','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('5','2','天伦广场','','3','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('3','1','海曙区','','2','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('6','3','东门口','','3','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('4','1','江北区','','2','0');
INSERT INTO `tj_area`(`aid`,`pid`,`name`,`mappoint`,`level`,`listorder`)VALUES('7','4','老外滩','','3','0');

DROP TABLE IF EXISTS `tj_branch`;
CREATE TABLE `tj_branch` (
  `bid` smallint(6) NOT NULL auto_increment,
  `btype` enum('system','school','grade','class','group','other') default 'other',
  `bname` char(16) default '',
  `pid` int(10) NOT NULL default '0',
  `order` int(10) NOT NULL default '0',
  `isjxt` tinyint(1) NOT NULL default '1',
  `access` text NOT NULL,
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM AUTO_INCREMENT=114 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='部门';
INSERT INTO `tj_branch`(`bid`,`btype`,`bname`,`pid`,`order`,`isjxt`,`access`)VALUES('1','system','北京市教育局','0','0','1','');
INSERT INTO `tj_branch`(`bid`,`btype`,`bname`,`pid`,`order`,`isjxt`,`access`)VALUES('113','class','一班','112','0','1','');
INSERT INTO `tj_branch`(`bid`,`btype`,`bname`,`pid`,`order`,`isjxt`,`access`)VALUES('112','grade','一年级','111','0','1','');
INSERT INTO `tj_branch`(`bid`,`btype`,`bname`,`pid`,`order`,`isjxt`,`access`)VALUES('111','school','北京第一初级中学','1','0','1','');

DROP TABLE IF EXISTS `tj_exam`;
CREATE TABLE `tj_exam` (
  `examid` int(10) unsigned NOT NULL auto_increment,
  `examname` char(225) NOT NULL,
  `bid` int(10) unsigned NOT NULL,
  `description` varchar(500) character set utf8 default NULL,
  `examtypeid` int(10) NOT NULL,
  `isresult` tinyint(1) NOT NULL default '0',
  `author` varchar(225) NOT NULL,
  `addtime` int(11) NOT NULL,
  PRIMARY KEY  (`examid`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=gbk;
INSERT INTO `tj_exam`(`examid`,`examname`,`bid`,`description`,`examtypeid`,`isresult`,`author`,`addtime`)VALUES('45','班级语文测验','112','','13','0','lijichao','1358131526');
INSERT INTO `tj_exam`(`examid`,`examname`,`bid`,`description`,`examtypeid`,`isresult`,`author`,`addtime`)VALUES('43','班级语文测验','112','','13','0','lijichao','1357537459');
INSERT INTO `tj_exam`(`examid`,`examname`,`bid`,`description`,`examtypeid`,`isresult`,`author`,`addtime`)VALUES('44','化学测验','112','','13','0','lijichao','1358129065');

DROP TABLE IF EXISTS `tj_exam_type`;
CREATE TABLE `tj_exam_type` (
  `examtypeid` int(10) NOT NULL auto_increment,
  `bid` int(10) NOT NULL,
  `dztype` varchar(20) NOT NULL,
  `subject` varchar(1024) default NULL,
  `tname` varchar(10) character set gb2312 NOT NULL,
  PRIMARY KEY  (`examtypeid`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=gbk ROW_FORMAT=DYNAMIC COMMENT='考试类型';
INSERT INTO `tj_exam_type`(`examtypeid`,`bid`,`dztype`,`subject`,`tname`)VALUES('13','111','0','1','语文单科考试');

DROP TABLE IF EXISTS `tj_files`;
CREATE TABLE `tj_files` (
  `fileid` mediumint(8) unsigned NOT NULL auto_increment,
  `type` varchar(255) NOT NULL default '',
  `filename` varchar(255) NOT NULL default '',
  `fid` int(10) unsigned NOT NULL default '0',
  `fileurl` varchar(255) NOT NULL,
  `filesize` int(10) unsigned NOT NULL default '0',
  `down_count` int(10) NOT NULL default '0',
  `owned` tinyint(1) NOT NULL default '0' COMMENT '是否私有',
  `author` varchar(255) NOT NULL,
  `addtime` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`fileid`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=gbk ROW_FORMAT=DYNAMIC COMMENT='下载文件';
INSERT INTO `tj_files`(`fileid`,`type`,`filename`,`fid`,`fileurl`,`filesize`,`down_count`,`owned`,`author`,`addtime`)VALUES('25','doc','橙创家校通v4.0使用说明Beta1.doc','24','/dat/upload/2013-01/53_1358935454.doc','2168742','0','0','lichao','1358935454');

DROP TABLE IF EXISTS `tj_folder`;
CREATE TABLE `tj_folder` (
  `fid` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(200) NOT NULL default '',
  `bid` int(11) NOT NULL default '0',
  `uid` int(11) NOT NULL default '0',
  `uptime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文件夹';
INSERT INTO `tj_folder`(`fid`,`name`,`bid`,`uid`,`uptime`)VALUES('24','班级文档共享','113','0','1358676778');

DROP TABLE IF EXISTS `tj_group`;
CREATE TABLE `tj_group` (
  `groupid` int(11) NOT NULL auto_increment COMMENT '小组ID',
  `uid` int(11) NOT NULL default '0' COMMENT '用户ID',
  `bid` int(11) NOT NULL default '0' COMMENT '所属部门',
  `groupname` char(32) NOT NULL default '' COMMENT '群组名字',
  `groupname_en` char(32) NOT NULL default '' COMMENT '小组英文名称',
  `groupdesc` text NOT NULL COMMENT '小组介绍',
  `cateid` int(11) NOT NULL COMMENT '小组分类ID',
  `groupicon` char(100) default '' COMMENT '小组图标',
  `count_topic` int(11) NOT NULL default '0' COMMENT '帖子统计',
  `count_topic_today` int(11) NOT NULL default '0' COMMENT '统计今天发帖',
  `count_user` int(11) NOT NULL default '0' COMMENT '小组成员数',
  `listorder` int(11) NOT NULL default '0' COMMENT '排序',
  `rotj_leader` char(32) NOT NULL default '组长' COMMENT '组长角色名称',
  `rotj_admin` char(32) NOT NULL default '管理员' COMMENT '管理员角色名称',
  `rotj_user` char(32) NOT NULL default '成员' COMMENT '成员角色名称',
  `addtime` int(11) default '0' COMMENT '创建时间',
  `isrecommend` tinyint(1) NOT NULL default '0' COMMENT '是否推荐',
  `isopen` tinyint(1) NOT NULL default '0' COMMENT '是否公开或者私密',
  `isaudit` tinyint(1) NOT NULL default '0' COMMENT '是否审核',
  `ispost` tinyint(1) NOT NULL default '0' COMMENT '是否允许会员发帖',
  `isshow` tinyint(1) NOT NULL default '0' COMMENT '是否显示',
  `uptime` int(11) NOT NULL default '0' COMMENT '最后更新时间',
  PRIMARY KEY  (`groupid`),
  KEY `userid` (`uid`),
  KEY `isshow` (`isshow`),
  KEY `groupname` (`groupname`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8 COMMENT='小组';
INSERT INTO `tj_group`(`groupid`,`uid`,`bid`,`groupname`,`groupname_en`,`groupdesc`,`cateid`,`groupicon`,`count_topic`,`count_topic_today`,`count_user`,`listorder`,`rotj_leader`,`rotj_admin`,`rotj_user`,`addtime`,`isrecommend`,`isopen`,`isaudit`,`ispost`,`isshow`,`uptime`)VALUES('16','1','1','sdasd','','','8','','1','1','0','1','组长','管理员','成员','1358756670','0','0','0','0','0','1358756670');

DROP TABLE IF EXISTS `tj_group_cates`;
CREATE TABLE `tj_group_cates` (
  `cateid` int(11) NOT NULL auto_increment COMMENT '分类ID',
  `bid` int(11) NOT NULL default '0' COMMENT '所属部门',
  `listorder` int(11) NOT NULL default '0' COMMENT '排序',
  `catename` char(32) NOT NULL default '' COMMENT '分类名字',
  `catereferid` int(11) NOT NULL default '0' COMMENT '上级分类ID',
  `count_group` int(11) NOT NULL default '0' COMMENT '群组个数',
  `uptime` int(11) NOT NULL default '0' COMMENT '最后更新时间',
  PRIMARY KEY  (`cateid`),
  KEY `referid` (`catereferid`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='讨论分区';
INSERT INTO `tj_group_cates`(`cateid`,`bid`,`listorder`,`catename`,`catereferid`,`count_group`,`uptime`)VALUES('8','1','1','学校讨论区','0','0','1358233601');

DROP TABLE IF EXISTS `tj_group_cates_index`;
CREATE TABLE `tj_group_cates_index` (
  `groupid` int(11) NOT NULL default '0' COMMENT '小组ID',
  `cateid` int(11) NOT NULL default '0' COMMENT '分类ID',
  UNIQUE KEY `groupid_2` (`groupid`,`cateid`),
  KEY `groupid` (`groupid`),
  KEY `cateid` (`cateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='小组分类索引';

DROP TABLE IF EXISTS `tj_group_links`;
CREATE TABLE `tj_group_links` (
  `groupid` int(11) NOT NULL default '0',
  `linkid` int(11) NOT NULL default '0',
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `tj_group_topics`;
CREATE TABLE `tj_group_topics` (
  `topicid` int(11) NOT NULL auto_increment COMMENT '话题ID',
  `typeid` int(11) NOT NULL default '0' COMMENT '帖子分类ID,0代表普通，1代表主题讨论帖',
  `groupid` int(11) NOT NULL default '0' COMMENT '小组ID',
  `uid` int(11) NOT NULL default '0' COMMENT '用户ID',
  `title` char(64) NOT NULL default '',
  `content` text NOT NULL,
  `count_comment` int(11) NOT NULL default '0' COMMENT '回复统计',
  `count_view` int(11) NOT NULL default '0' COMMENT '帖子展示数',
  `istop` tinyint(1) NOT NULL default '0' COMMENT '是否置顶',
  `isshow` tinyint(1) NOT NULL default '0' COMMENT '是否显示',
  `iscomment` tinyint(1) NOT NULL default '0' COMMENT '是否允许评论',
  `isnotice` tinyint(1) NOT NULL default '0' COMMENT '是否通知',
  `isposts` tinyint(1) NOT NULL default '0' COMMENT '是否精华帖子',
  `isask` tinyint(1) default '0',
  `addtime` int(11) default '0' COMMENT '创建时间',
  `uptime` int(11) NOT NULL default '0' COMMENT '更新时间',
  PRIMARY KEY  (`topicid`),
  KEY `groupid` (`groupid`),
  KEY `userid` (`uid`),
  KEY `title` (`title`),
  KEY `groupid_2` (`groupid`,`isshow`),
  KEY `typeid` (`typeid`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='小组话题';
INSERT INTO `tj_group_topics`(`topicid`,`typeid`,`groupid`,`uid`,`title`,`content`,`count_comment`,`count_view`,`istop`,`isshow`,`iscomment`,`isnotice`,`isposts`,`isask`,`addtime`,`uptime`)VALUES('28','0','16','1','asda','asdasd','0','16','0','0','0','0','0','0','1358756702','1359012378');

DROP TABLE IF EXISTS `tj_group_topics_collects`;
CREATE TABLE `tj_group_topics_collects` (
  `userid` int(11) NOT NULL default '0',
  `topicid` int(11) NOT NULL default '0',
  `addtime` int(11) NOT NULL default '0' COMMENT '收藏时间',
  UNIQUE KEY `userid_2` (`userid`,`topicid`),
  KEY `userid` (`userid`),
  KEY `topicid` (`topicid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子收藏';

DROP TABLE IF EXISTS `tj_group_topics_comments`;
CREATE TABLE `tj_group_topics_comments` (
  `commentid` int(11) NOT NULL auto_increment COMMENT '评论ID',
  `referid` int(11) NOT NULL default '0',
  `topicid` int(11) NOT NULL default '0' COMMENT '话题ID',
  `uid` int(11) NOT NULL default '0' COMMENT '用户ID',
  `content` text NOT NULL COMMENT '回复内容',
  `addtime` int(11) default '0' COMMENT '回复时间',
  PRIMARY KEY  (`commentid`),
  KEY `topicid` (`topicid`),
  KEY `userid` (`uid`),
  KEY `referid` (`referid`,`topicid`)
) ENGINE=MyISAM AUTO_INCREMENT=81 DEFAULT CHARSET=utf8 COMMENT='话题回复/评论';

DROP TABLE IF EXISTS `tj_group_topics_type`;
CREATE TABLE `tj_group_topics_type` (
  `typeid` int(11) NOT NULL auto_increment COMMENT '帖子分类ID',
  `groupid` int(11) NOT NULL default '0' COMMENT '小组ID',
  `typename` char(32) NOT NULL default '' COMMENT '帖子分类名称',
  `count_topic` int(11) NOT NULL default '0' COMMENT '统计帖子',
  PRIMARY KEY  (`typeid`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='帖子分类';

DROP TABLE IF EXISTS `tj_group_users`;
CREATE TABLE `tj_group_users` (
  `userid` int(11) NOT NULL default '0' COMMENT '用户ID',
  `groupid` int(11) NOT NULL default '0' COMMENT '群组ID',
  `isadmin` int(11) NOT NULL default '0' COMMENT '是否管理员',
  `addtime` int(11) NOT NULL default '0' COMMENT '加入时间',
  UNIQUE KEY `userid_2` (`userid`,`groupid`),
  KEY `userid` (`userid`),
  KEY `groupid` (`groupid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='群组和用户对应关系';

DROP TABLE IF EXISTS `tj_help`;
CREATE TABLE `tj_help` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `title` varchar(200) NOT NULL default '',
  `catid` int(11) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `pageview` int(10) NOT NULL default '0',
  `dateline` int(10) NOT NULL default '0',
  `available` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=80 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='帮助';
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('74','课程表管理','33','班主任有责任编辑本班的课程表： [p][图片74] [br] [/p] [p]编辑后的课程表会显示在本班的所有成员的界面内。 [/p] [p]特别是家长可以方便查询自己的孩子当天的课程信息。 [/p]','2','1358675100','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('75','如何添加一个考试？','33','添加一个考试很简单： [p][图片75] [br] [/p] [p]填写考试名称，选择考试类型。 [/p] [p]这里的考试类型由学校管理员管理的，如果没有可选考试类型，请及时联系学校管理员进行添加。 [/p]','2','1358675278','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('76','如何导入或编辑一个考试的学生成绩？','33','一个考试成功添加后，就可以对学生成绩进行导入或编辑： [p][图片76] [br] [/p] [p]点击一个考试的标题，进入考试成绩编辑界面： [/p] [p][图片77] [br] [/p] [p]1.可以选择使用Excel批量导入成绩。 [/p] [p][图片78] [br] [/p] [p]2.也可以对每个学生手动录入。 [/p] [p]点击编辑成绩按钮，进入录入成绩界面： [/p] [p][图片79] [br] [/p] [p]点击“确定提交”后学生成绩成功导入。 [/p] [p] [br] [/p]','2','1358675611','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('77','给学生家长发送考试成绩？','33','在考试列表界面，点击考试标题，进入查看学生成绩界面： [p][图片80] [br] [/p] [p]如果学生成绩已经全部录入，则可以进行成绩发送，可以选择单个发送，也可以点击全部发送。 [/p] [p][图片81] [br] [/p] [p]点击“未发生”后点个发送成绩。 [/p] [p]还可以根据需求对“短信模版”进行个性化编辑。 [/p] [p]模版内变量： [/p] [p][realname]  [s]  [s]----学生的姓名 [/p] [p][examname]  [s]----考试名称 [/p] [p][subjectname]  [s]----考试科目 [/p] [p][mark]  [s]----成绩 [/p] [p][图片82] [br] [/p] [p]以下一些情况可能导致发送成绩失败： [/p] [p]1.短信余额不足； [/p] [p]2.学生成绩未录入； [/p] [p]3.成绩已经发送； [/p]','3','1358676094','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('78','如何添加学生作业以及发送作业给家长？','33','[图片83] [p][图片84] [br] [/p] [p]其中作业模版：：[content]就是作业内容，在发送的时候进行合并，所以，可以对作业的发送模版进行个性化编辑。 [/p] [p]发送短信： [/p] [p]选择家长进行发送，红色部分代表家长手机号码不存在，无法发送，也就无法选取。 [/p]','3','1358676405','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('79','如何分享文件？文件分享的范围是什么？','34','如何分享文件？ [p]首先，需要建立一个文件夹： [/p] [p][图片85] [br] [/p] [p]对于总管理员来说，他建立的文件夹可被全部用户查看。 [/p] [p]对于学校管理员来说，他建立的文件夹只能被当前学校的所有人员查看。 [/p] [p]对于班主任而言呢，就只能被起管理班级查看。 [/p] [p][图片86] [br] [/p] [p] [br] [/p]','4','1358677169','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('72','学校管理员如何进行短信分配？','31','学校管理员点击个人中心---短信分配。 [p][图片72] [br] [/p] [p]学校管理员只能给本学校的班主任和任课老师进行短信分配。 [/p]','2','1358674767','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('73','班主任可以管理和添加本班人员。','33','班主任类似与一个班级的管理员。 [p]这样其可以导入导出管理本班的学生、家长、任课老师等人员类型。 [/p] [p][图片73] [br] [/p]','2','1358674948','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('68','搜索成员','29','在人员管理界面，搜索人员尽量使用人员的真实姓名进行搜索。','2','1358242842','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('69','如何添加成员？','29','首先要选择添加的人员的所属部门，也可以到添加界面修改部门。 [p][图片67] [br] [/p] [p]在添加界面里面就有了该部门提示 [/p] [p][图片68] [br] [/p] [p]填写相关信息后提交。 [/p]','3','1358673625','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('70','科目设置','31','各学校的科目有所区别，所以，管理员需要进入“校务管理”内设置学校科目： [p][图片69] [br] [/p] [p]除了这些系统科目外，学校管理员可以添加本校的其他科目。 [/p] [p]这些科目的作用在： [/p] [p]1.在添加考试的时候需要选择考试的科目。 [/p] [p]2.在发送考试成绩到家长手机到需要绑定科目。 [/p] [p]3.任课老师的任课科目。 [/p]','2','1358674354','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('71','考试设置','31','考试设置的主要作用在于，在任课老师添加考试的时候选择考试的类型，也就是说 [fontdd0000]如果没有进行考试设置的话，是无法添加考试的 [/font]。‘ [p][图片70] [br] [p]考试设置分为：单科和综合 [/p] [p][图片71] [br] [/p] [p]单科考试即为班级的平时单科测验等。 [/p] [p]综合即为全校性的，综合考试。 [/p] [p]考试类型的选择觉得了添加考试时的科目分类。 [/p] [p] [br] [/p] [/p]','3','1358674627','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('67','如何批量导入成员或批量下载人员数据？','29','用户组为总管理员、学校管理员或者班主任可以使用批量导入导出功能。 [p] [b]批量导入人员 [/b] [br] [p]打开 [b]人员管理 [/b]---点击打开 [b]批量导入 [/b] [br] [p][图片64] [br] [/p] [/p] [/p] [p]可以先下载Excel模板，按照模版进行数据编辑： [/p] [p]各列内容（从左至右）： [s] [/p] [p](1). 真实姓名（必填）； [s] [/p] [p](2). 性别（必填：男/女） [s] [/p] [p](3). 学号（学生用户组必填，其他用户组为空） [s] [/p] [p](4)登录帐号（必填，不可与其他帐号重复）； [s] [/p] [p](5). 密码（选填，最少为6位，默认为：123456）； [s] [/p] [p](7). 用户组（必填，并且该值只能为以下值：系统管理员、学校管理员、班主任、任课老师、学生）) [s] [/p] [p]注：请使用UTF8系列编码保存文件。 [/p] [p] [br] [/p] [p]Excel编辑好后，点击上传文件并提交： [/p] [p][图片65] [br] [/p] [p]根据提示，最后点击“保存数据”即可成功导入到当前部门。 [/p] [p] [b]下载人员数据 [/b] [/p] [p]在人员管理主界面，点击部门名称右侧下拉按钮，点击“下载人员数据”，即可成功下载当前部门下人员数据。 [/p] [p][图片66] [br] [/p]','3','1358242730','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('66','如何创建一个部门？','29',' [b]什么是部门？ [/b] [p]部门的类型包括：学校，年级，班级，小组，其他。这些部门在建立的过程中是按数据建立的。 [/p] [p] [b]创建一个部门 [/b] [/p] [p]学校部门下面只能创建年级或其他，年级类型的部门下只能创建班级或其他，以此类推。 [/p] [p][图片61] [br] [/p] [p][图片62] [br] [/p] [p]一个普通的部门树： [/p] [p][图片63] [br] [/p]','2','1358242062','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('65','什么是学校架构和家长架构？','29',' [p]学校架构主要包含学校用户：学生，班主任，任课老师，学校管理员。 [/p] [p]家长架构是学生对应的家长账户。 [/p][图片60]','2','1358241701','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('58','如何添加一个用户组？','26','系统管理员登录后， [b] [font333333]系统管理 [/b] [/font] [font333333]---- [/font] [b] [font333333]用户组设置----添加 [/b] [/font] [p][图片49] [br] [/p] [p]这里面的 [s] [b] [font333333]组菜单 [s] [/font] [/b]是在  [b]系统管理 [/b]---- [b]菜单管理 [/b] 下设置，是该用户组登录状态下的菜单显示。 [/p]','2','1358238928','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('59','什么是系统短信，有哪些用途？','27','短信在本系统中有着很重要的作用。 [p]是家长和老师或学校与老师之间进行即时便捷的沟通方式。 [/p] [p]短信的主要功能提现在： [/p] [p]1.发送通知： [/p] [p]管理员、班主任或任课老师用户组可以通过 [b]人员管理 [/b]选取用户进行发送短信。 [/p] [p][图片50] [br] [/p] [p][图片51] [br] [/p] [p]2.老师发送考试成绩 [/p] [p][图片52] [br] [/p] [p]3.老师发送作业 [/p] [p][图片53] [br] [/p] [p]4.家长发送短信 [/p] [p] [br] [/p] [p] [br] [/p] [p] [br] [/p]','3','1358239683','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('60','管理员如何配置短信接口？','27','管理员账户登录总后台： [p]在短信设置内设置短信账户： [/p] [p][图片54] [br] [/p] [p]一般如果需要使用新的短信接口需要联系官方人员进行修改。 [/p]','1','1358239897','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('61','什么是短信分配？','27','短信分配是指：上级管理员给下级人员分配短信。 [p]为方便系统短信数量的统计，所有下级用户短信数都统一由总管理分配： [/p] [p][图片55] [br] [/p] [p]总管理员只能给： [b]学校管理员， [/b] [b]班主任, [/b] [b]任课老师 [/b]分配短信。 [/p] [p]而家长或学生账户短信数由班主任分配。 [/p]','2','1358240133','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('62','系统信息设置','28','主要是设置系统的相关信息： [p]系统名称、LOGO、关闭等。 [/p] [p][图片56] [br] [/p] [p]其中 [b] [font333333]安全验证串 [/font] [/b]的主要作用是增强数据提交验证的安全性，建议每一个月修改一次（避免在访问高峰修改）。 [/p] [p] [br] [/p]','1','1358240486','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('63','菜单管理','28','这里的菜单设置是和用户组一一对应的，也就是说，一个用户组到导航菜单显示都在这里配置。 [p]默认的用户组菜单禁止删除，可以进行修改。 [/p] [p]点击菜单名称可查看其下级菜单。 [/p] [p]菜单的主要结构是： [/p] [p]用户组菜单名-----导航菜单-----左侧竖排菜单 [/p] [p][图片57] [br] [/p] [p]增加菜单： [/p] [p][图片58] [br] [/p] [p]模块名称：即导航参数C。利用与每个页面模块名称（标识当前打开的是那个页面）变量对应起来，便可以达到Tab样式菜单的当前页突出显示。 [/p] [p]菜单链接：系统内部链接无需添加网址，如果是外部链接，需填写完整网址，如：http://www.baidu.com [/p]','2','1358241336','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('64','数据库操作','28','恢复备份数据的同时将覆盖原有数据！！！！ [p] [s]数据恢复功能只能恢复由本系统导出的数据文件。 从本地恢复数据需要服务器支持上传并保证数据小于上传上限。 数据还原数据失败时请检查您的系统表前缀与之前安装时的前缀是否一致 如当前前缀为jxt_，之前前缀却为jxtadmin_ [/p] [p][图片59] [br] [/p]','2','1358241505','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('57','用户组分类','26','本系统主要包括：系统用户组、学校用户组、家长用户组、学生用户组、特殊用户组 [p] [b] [fontbb0000]这些基础用户组在设置过程中请勿删除。 [/font] [/b] [/p] [p]设置方法： [/p] [p]使用管理员账户登录系统： [b]系统管理 [/b]---- [b]用户组设置 [/b] [/p] [p] [b][图片48] [br] [/b] [/p]','5','1358238668','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('56','如何创建账户？','25','本系统不支持直接注册账户，所有账户都是由管理员或上级人员添加。 [p]简单的流程是： [/p] [p]总管理（admin）-----创建----- 学校管理员  [s]-----创建-----  [s]班主任或任课老师  [s]-----创建（班主任）-----  [s]学生或者家长 [/p] [p]这些创建过程都可以使用Excel数据表批量导入（具体导入方法可以查看导入导出帮助）。 [/p]','3','1358238407','0');
INSERT INTO `tj_help`(`id`,`title`,`catid`,`content`,`pageview`,`dateline`,`available`)VALUES('55','如何找回密码？','25','1.点击登录界面的“忘记密码”： [p][图片46] [br] [/p] [p]2.然后选择找回方式：通过邮箱找回和通过手机号码找回 [/p] [p][图片47] [br] [/p] [p]3.根据提示进行找回密码操作。 [/p]','3','1358238036','0');

DROP TABLE IF EXISTS `tj_help_cat`;
CREATE TABLE `tj_help_cat` (
  `catid` mediumint(8) NOT NULL auto_increment,
  `name` varchar(60) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`catid`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='帮助分类';
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('34','文件分享下载','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('33','班主任管理','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('31','学校管理员管理','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('29','人员管理','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('28','系统设置','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('27','系统短信','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('26','系统用户组','');
INSERT INTO `tj_help_cat`(`catid`,`name`,`des`)VALUES('25','账户问题','');

DROP TABLE IF EXISTS `tj_homework`;
CREATE TABLE `tj_homework` (
  `homeworkid` int(10) unsigned NOT NULL auto_increment,
  `homeworkname` char(225) collate utf8_unicode_ci NOT NULL,
  `content` text collate utf8_unicode_ci,
  `type` int(10) NOT NULL,
  `bid` int(10) unsigned NOT NULL,
  `author` varchar(225) collate utf8_unicode_ci NOT NULL,
  `addtime` int(11) NOT NULL,
  PRIMARY KEY  (`homeworkid`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('30','asdasd','asdasd','3','112','zhuzhibin','1357441157');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('29','asdasd','asdasd','3','112','zhuzhibin','1357441140');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('28','今天的作业是语文听写一遍！','今天的作业是语文听写一遍！','1','112','zhuzhibin','1357440980');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('31','asdasd','asdasd','3','112','zhuzhibin','1357441168');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('32','asdddddddddddddddddddd','asdddddddddddddddddddd','5','112','zhuzhibin','1357441197');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('33','asdddddddddddddddddddd','asdddddddddddddddddddd','5','112','zhuzhibin','1357441217');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('34',' [font333333]将 [s] [/font]<a href=\\\\\\\"http://zjgwy.dajie.com/\\\\\\\" style=\\\\\\\"text-decoration: initial; color: rgb(19, 87, 162); margin-right: 5px; white-space: nowrap; font-family: verdana; line-height: 20px;\\\\\\',' [font333333]将 [s] [/font]<a href=\\\\\\\\\\\\\\\"http://zjgwy.dajie.com/\\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\\"text-decoration: initial; color: rgb(19, 87, 162); margin-right: 5px; white-space: nowrap; font-family: verdana; line-height: 20px;\\\\\\\\\\\\\\\">浙江公务员</a> [font333333] [s]加为自己关注的企业 [/font]','4','112','zhuzhibin','1357441290');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('35',' [font333333]将 [s] [/font]<a href=\\\\\\\"http://zjgwy.dajie.com/\\\\\\\" style=\\\\\\\"text-decoration: initial; color: rgb(19, 87, 162); margin-right: 5px; white-space: nowrap; font-family: verdana; line-height: 20px;\\\\\\',' [font333333]将 [s] [/font]<a href=\\\\\\\\\\\\\\\"http://zjgwy.dajie.com/\\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\\"text-decoration: initial; color: rgb(19, 87, 162); margin-right: 5px; white-space: nowrap; font-family: verdana; line-height: 20px;\\\\\\\\\\\\\\\">浙江公务员</a> [font333333] [s]加为自己关注的企业 [/font]','4','112','zhuzhibin','1357455613');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('36','asdddddddddddddddddd','asdddddddddddddddddd','3','112','zhuzhibin','1357455666');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('37','asdddddddddddddddddd','asdddddddddddddddddd','3','112','zhuzhibin','1357455729');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('38','asdddddddddddddddddd','asdddddddddddddddddd','3','112','zhuzhibin','1357455737');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('39','zdxfsdfsdf','zdxfsdfsdf','2','112','zhuzhibin','1357455751');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('40','这个是！','这个是！','2','112','lijichao','1357462311');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('41','今天的作业是！','今天的作业是！','3','112','lijichao','1357462366');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('42','今天的语文作业是：默写沁园春！','今天的语文作业是：默写沁园春！','1','112','lijichao','1357462423');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('43','今天的语文作业是：默写沁园春！','今天的语文作业是：默写沁园春！','1','112','lijichao','1357462457');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('44','今天的语文作业是：默写沁园春！','今天的语文作业是：默写沁园春！','1','112','lijichao','1357462473');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('45','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462490');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('46','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462519');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('65','复习第一课！','复习第一课！','0','112','lijichao','1358133052');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('48','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462563');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('49','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462590');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('50','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462628');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('51','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462746');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('52','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462809');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('53','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462832');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('54','今天的语文作业是：默写沁园春','今天的语文作业是：默写沁园春','1','112','lijichao','1357462919');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('63','复习第二课!','复习第二课!','0','112','lijichao','1358132627');
INSERT INTO `tj_homework`(`homeworkid`,`homeworkname`,`content`,`type`,`bid`,`author`,`addtime`)VALUES('56','今天的作业内容是，沁园春忏悔书！','今天的作业内容是，沁园春忏悔书！','3','112','lijichao','1357463262');

DROP TABLE IF EXISTS `tj_image_file`;
CREATE TABLE `tj_image_file` (
  `imageid` int(11) NOT NULL auto_increment,
  `imageurl` char(120) NOT NULL default '',
  `addtime` int(11) NOT NULL default '0',
  PRIMARY KEY  (`imageid`)
) ENGINE=MyISAM AUTO_INCREMENT=87 DEFAULT CHARSET=utf8 ROW_FORMAT=FIXED COMMENT='图片附件表';
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('76','/dat/upload/2013-01/89_1358675386.jpg','1358675386');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('75','/dat/upload/2013-01/97_1358675181.jpg','1358675181');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('74','/dat/upload/2013-01/41_1358675034.jpg','1358675034');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('73','/dat/upload/2013-01/70_1358674945.jpg','1358674945');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('72','/dat/upload/2013-01/2_1358674738.jpg','1358674738');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('71','/dat/upload/2013-01/76_1358674548.jpg','1358674548');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('70','/dat/upload/2013-01/96_1358674528.jpg','1358674528');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('69','/dat/upload/2013-01/52_1358674191.jpg','1358674191');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('68','/dat/upload/2013-01/100_1358672664.jpg','1358672664');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('67','/dat/upload/2013-01/53_1358672591.jpg','1358672591');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('66','/dat/upload/2013-01/43_1358242721.jpg','1358242721');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('65','/dat/upload/2013-01/91_1358242573.jpg','1358242573');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('64','/dat/upload/2013-01/74_1358242280.jpg','1358242280');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('63','/dat/upload/2013-01/54_1358242041.jpg','1358242041');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('62','/dat/upload/2013-01/69_1358242007.jpg','1358242007');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('61','/dat/upload/2013-01/42_1358241989.jpg','1358241989');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('60','/dat/upload/2013-01/58_1358241626.jpg','1358241626');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('59','/dat/upload/2013-01/69_1358241503.jpg','1358241503');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('58','/dat/upload/2013-01/20_1358241003.jpg','1358241003');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('57','/dat/upload/2013-01/80_1358240809.jpg','1358240809');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('56','/dat/upload/2013-01/83_1358240342.jpg','1358240342');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('55','/dat/upload/2013-01/10_1358240030.jpg','1358240030');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('54','/dat/upload/2013-01/30_1358239861.jpg','1358239861');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('53','/dat/upload/2013-01/30_1358239635.jpg','1358239635');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('52','/dat/upload/2013-01/58_1358239583.jpg','1358239583');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('51','/dat/upload/2013-01/66_1358239460.jpg','1358239460');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('50','/dat/upload/2013-01/75_1358239421.jpg','1358239421');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('49','/dat/upload/2013-01/26_1358238819.jpg','1358238819');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('48','/dat/upload/2013-01/42_1358238666.jpg','1358238666');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('47','/dat/upload/2013-01/44_1358238019.jpg','1358238019');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('46','/dat/upload/2013-01/38_1358237964.jpg','1358237964');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('77','/dat/upload/2013-01/93_1358675421.jpg','1358675421');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('78','/dat/upload/2013-01/87_1358675484.jpg','1358675484');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('79','/dat/upload/2013-01/46_1358675555.jpg','1358675555');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('80','/dat/upload/2013-01/58_1358675715.jpg','1358675715');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('81','/dat/upload/2013-01/47_1358675796.jpg','1358675796');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('82','/dat/upload/2013-01/12_1358675984.jpg','1358675984');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('83','/dat/upload/2013-01/92_1358676266.jpg','1358676266');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('84','/dat/upload/2013-01/47_1358676271.jpg','1358676271');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('85','/dat/upload/2013-01/70_1358676559.jpg','1358676559');
INSERT INTO `tj_image_file`(`imageid`,`imageurl`,`addtime`)VALUES('86','/dat/upload/2013-01/66_1358676795.jpg','1358676795');

DROP TABLE IF EXISTS `tj_menus`;
CREATE TABLE `tj_menus` (
  `menuid` smallint(5) unsigned NOT NULL auto_increment,
  `parentid` smallint(5) unsigned NOT NULL default '0',
  `isclosed` tinyint(1) NOT NULL default '0',
  `isfolder` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `scriptnav` varchar(60) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `icon` varchar(60) NOT NULL default '',
  `target` varchar(15) NOT NULL default '',
  `listorder` smallint(5) NOT NULL default '0',
  PRIMARY KEY  (`menuid`)
) ENGINE=MyISAM AUTO_INCREMENT=138 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='菜单';
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('1','0','0','1','系统管理员导航','system','','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('2','0','0','1','学校管理员导航','school','','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('3','0','0','1','班主任导航','school','','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('4','0','0','1','任课老师导航','school','','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('5','0','0','1','学生家长导航','parent','','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('6','0','0','1','学生导航','student','','','','8');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('7','0','0','1','VIP用户组导航','special','','','','9');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('8','1','0','0','系统设置','index','?mod=system','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('9','1','0','0','人员管理','member','?mod=system&do=member','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('10','1','0','0','用户组设置','usergroup','?mod=system&do=usergroup','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('11','1','0','0','系统日志','log','?mod=system&do=log','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('124','4','0','0','人员架构','member','?mod=school&do=member','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('13','1','0','0','公告管理','ann','?mod=system&do=ann','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('14','1','0','0','帮助中心','help','?mod=system&do=help','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('15','2','0','0','首页','index','?mod=school','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('16','2','0','0','人员架构','member','?mod=school&do=member','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('17','2','0','0','校务管理','affairs','?mod=school&do=affairs','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('123','4','0','0','首页','index','?mod=school','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('19','2','0','0','系统日志','log','?mod=school&do=log','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('20','2','0','0','个人中心','setinfo','?mod=school&do=setinfo','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('22','8','0','0','系统信息','index,changeinfo','?mod=system&c=index','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('23','3','0','0','首页','index','?mod=school','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('24','3','0','0','人员架构','member','?mod=school&do=member','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('25','3','0','0','班务管理','class_affairs','?mod=school&do=class_affairs','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('26','3','0','0','考试&作业','exam','?mod=school&do=exam','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('28','3','1','0','考勤管理','attendance','?mod=school&do=attendance','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('29','3','0','0','文件下载','files','?mod=school&do=files','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('30','3','0','0','个人中心','setinfo','?mod=school&do=setinfo','','','8');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('31','8','0','0','修改密码','changepwd','?mod=system&c=changepwd','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('32','8','0','0','短信设置','setsms','?mod=system&c=setsms','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('33','8','0','0','菜单管理','setmenu,add_menu,edit_menu','?mod=system&c=setmenu','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('34','0','0','1','底部菜单','','','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('35','34','0','0','关于橙创','N/U','http://www.tuntron.com/','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('36','34','0','0','帮助中心','help','?mod=help','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('37','8','1','0','分级管理员','setadmin','?mod=system&c=setadmin','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('38','8','0','0','数据库操作','mysql','?mod=system&c=mysql','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('39','8','1','0','功能开关','onoff','?mod=system&c=onoff','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('40','8','1','0','支付设置','setpay','?mod=system&c=setpay','','','8');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('41','10','0','0','系统用户组','system','?mod=system&do=usergroup&c=system','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('42','10','0','0','学校用户组','school','?mod=system&do=usergroup&c=school','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('43','10','0','0','家长用户组','parent','?mod=system&do=usergroup&c=parent','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('44','10','0','0','学生用户组','student','#','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('45','10','0','0','特殊用户组','special','#','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('46','11','1','0','充值记录','index','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('47','11','0','0','短信记录','logsms','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('48','11','0','0','登录记录','loglogin','#','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('49','11','0','0','操作记录','logoper','#','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('50','11','0','0','上传下载记录','logdown','#','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('51','11','0','0','批量任务','logbatch','#','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('52','17','0','0','科目设置','subject','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('53','17','1','0','功能开关','index','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('54','17','0','0','考试设置','exam','#','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('55','17','0','0','考勤管理','attendance','#','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('56','17','0','0','公告管理','ann,ann_content','#','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('57','20','0','0','个人信息','index,edit','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('58','20','0','0','站内信','message,sendmsg,replymsg','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('59','20','0','0','充值记录','logpay','#','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('60','19','0','0','短信发送记录','logsms','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('61','19','0','0','登录记录','loglogin','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('62','19','0','0','操作记录','logoper','#','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('63','19','0','0','上传下载记录','logdown','#','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('64','19','0','0','批量任务','logbatch','#','','','5');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('65','20','0','0','短信记录','logsms','#','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('66','30','0','0','个人信息','index,edit','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('67','30','0','0','站内信','message,sendmsg,replymsg','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('68','30','0','0','短信发送记录','logsms','#','','','3');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('69','25','0','0','课程表','index,eidt_schedule','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('70','25','0','0','公告管理','ann,ann_content','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('71','26','0','0','考试列表','index,result,import_result,eidt_result','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('86','8','0','0','短信分配','smsassign','?mod=system&c=smsassign','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('73','28','0','0','考勤数据','index','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('77','0','0','1','顶部菜单','','','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('79','77','0','0','帮助中心','help','?mod=help','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('84','2','0','0','讨论组','group','?mod=group&do=group','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('82','26','0','0','作业管理','work,work_content','?mod=school&do=work','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('83','1','0','0','讨论组','group','?mod=group&do=group','','','8');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('85','3','0','0','讨论组','group','?mod=group&do=group','','','9');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('87','20','0','0','短信分配','smsassign','?mod=school&c=smsassign','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('88','30','0','0','短信分配','smsassign','?mod=school&c=smsassign','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('89','5','0','0','首页','index','?mod=parent','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('90','5','0','0','课程表','class_affairs','?mod=parent&do=class_affairs&c=index','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('91','90','0','0','课程表','index','?mod=parent&do=class_affairs&c=index','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('92','5','0','0','考试&作业','exam','?mod=parent&do=exam','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('93','92','0','0','考试列表','index,result','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('94','92','0','0','作业列表','work,work_content','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('131','126','0','0','考试列表','index,result','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('96','5','0','0','讨论组','group','?mod=group&do=group','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('97','1','0','0','个人中心','setinfo','?mod=system&do=setinfo','','','9');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('98','97','0','0','个人信息','index,edit','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('99','97','0','0','短信分配','smsassign','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('100','8','1','0','用户组设置','usergroup','?mod=system&do=usergroup','','','9');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('126','4','0','0','考试&作业','exam','?mod=school&do=exam','','','4');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('129','4','0','0','文件下载','files','?mod=school&do=files','','','7');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('130','4','0','0','个人中心','setinfo','?mod=school&do=setinfo','','','8');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('132','126','0','0','作业列表','work,work_content','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('134','5','0','0','个人中心','setinfo','?mod=parent&do=setinfo','','','6');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('135','134','0','0','个人信息','index,edit','#','','','1');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('136','134','0','0','站内信','message,sendmsg,replymsg','#','','','2');
INSERT INTO `tj_menus`(`menuid`,`parentid`,`isclosed`,`isfolder`,`title`,`scriptnav`,`url`,`icon`,`target`,`listorder`)VALUES('137','134','0','0','短信记录','logsms','#','','','3');

DROP TABLE IF EXISTS `tj_pmsgs`;
CREATE TABLE `tj_pmsgs` (
  `pmid` mediumint(8) unsigned NOT NULL auto_increment,
  `senduid` mediumint(8) unsigned NOT NULL default '0',
  `recvuid` mediumint(8) unsigned NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `subject` varchar(60) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `new` tinyint(1) NOT NULL default '1',
  `delflag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`pmid`),
  KEY `senduid` (`senduid`,`posttime`),
  KEY `recvuid` (`recvuid`,`posttime`),
  KEY `new` (`new`,`recvuid`,`posttime`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COMMENT='站内信';

DROP TABLE IF EXISTS `tj_result`;
CREATE TABLE `tj_result` (
  `rid` mediumint(8) unsigned NOT NULL auto_increment,
  `uid` mediumint(8) unsigned NOT NULL default '0',
  `examid` mediumint(8) unsigned NOT NULL default '0',
  `sid` int(11) NOT NULL default '0',
  `mark` varchar(4) NOT NULL default '',
  `is_sms` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rid`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='学生成绩';
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('60','106','43','1','97','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('59','109','43','1','88','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('58','111','43','1','56','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('61','111','44','1','23','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('62','109','44','1','55','0');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('63','106','44','1','76','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('64','111','45','1','89','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('65','109','45','1','90','0');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('66','106','45','1','92','1');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('67','143','45','1','100','0');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('68','141','45','1','89','0');
INSERT INTO `tj_result`(`rid`,`uid`,`examid`,`sid`,`mark`,`is_sms`)VALUES('69','138','45','1','98','0');

DROP TABLE IF EXISTS `tj_rmsgs`;
CREATE TABLE `tj_rmsgs` (
  `rmid` mediumint(8) unsigned NOT NULL auto_increment,
  `replyuid` mediumint(8) unsigned NOT NULL default '0',
  `recvuid` mediumint(8) unsigned NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `subject` varchar(60) NOT NULL default '',
  `replytime` int(10) NOT NULL default '0',
  `new` tinyint(1) NOT NULL default '1',
  `delflag` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`rmid`),
  KEY `replyuid` (`replyuid`,`replytime`),
  KEY `recvuid` (`recvuid`,`replytime`),
  KEY `new` (`new`,`recvuid`,`replytime`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='回复站内信';

DROP TABLE IF EXISTS `tj_schedule`;
CREATE TABLE `tj_schedule` (
  `bid` int(11) NOT NULL default '0',
  `arraystr` text collate utf8_unicode_ci NOT NULL COMMENT '课程数据',
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci ROW_FORMAT=FIXED COMMENT='课程表';

DROP TABLE IF EXISTS `tj_sendsms`;
CREATE TABLE `tj_sendsms` (
  `sendid` mediumint(8) unsigned NOT NULL auto_increment,
  `uid` int(11) NOT NULL,
  `bid` int(11) NOT NULL,
  `mobile` text NOT NULL,
  `content` text NOT NULL,
  `dateline` int(11) NOT NULL,
  PRIMARY KEY  (`sendid`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='短信发送记录';
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('10','114','112','15385593717','你们好！','1357463371');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('7','1','1','15385593717','您好！','1357461602');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('8','114','112','15385593717','你好！','1357461753');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('9','114','112','15385593717','今天的作业内容是，沁园春忏悔书！','1357463289');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('6','1','1','15385593717','您好，我这边！','1357461555');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('11','114','112','15385593717','你们好！asdasdasd','1357463429');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('12','114','112','15385593717','你们好！asdasdasd','1357463433');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('13','114','112','15385593717','你们好！asdasdasd','1357463449');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('14','114','112','15385593715,13912341234,13912341234','111111111','1357537190');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('15','114','112','15385593717','[realname]的家长您好，您的孩子在[examname]的[subjectname]成绩是：[mark]。发送人：','1357543880');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('16','114','112','15385593717','[realname]的家长您好，您的孩子在[examname]的[subjectname]成绩是：[mark]。发送人：','1357544048');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('17','114','112','15385593717','无语的家长您好，您的孩子在班级语文测验的语文成绩是：97。发送人：','1357545456');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('18','114','112','15385593717','无语的家长您好，您的孩子在班级语文测验的语文成绩是：97。发送人：陈晨','1357545887');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('19','114','112','15385593717','无语的家长您好，您的孩子在班级语文测验的语文成绩是：97。发送人：陈晨','1357545889');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('20','114','112','15385593717','无语的家长您好，您的孩子在班级语文测验的语文成绩是：97。发送人：陈晨','1357545901');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('21','114','112','15385593717','无语的家长您好，您的孩子在班级语文测验的语文成绩是：97。发送人：','1357546052');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('22','1','1','15385593715','测试下短信接口！','1357564780');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('23','1','1','15385593717','测试短信发送，刚才号码错了没收到！','1357565024');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('24','1','1','15385593717','测试短信发送，刚才号码错了没收到！','1357565084');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('25','1','1','15385593717','测试发送短信？','1357713785');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('26','1','1','15385593717','侧hi发送端！','1357888691');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('27','114','1','15385593717','您请求重置密码，校验码591061[请勿告知他人]，如非本人操作请致电：400-800-8832','1357891414');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('28','114','112','15385593717','awdasdasd','1357898744');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('29','114','112','15385593717','测试定时发送短信！','1357898848');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('30','114','112','15385593717','测试定时发送短信信333！','1357899035');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('31','114','112','15385593717','侧hi阿斯达斯达斯达！','1357899136');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('32','1','1','15385593717','测试发送统计！','1358128391');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('33','114','112','15385593717','张四的家长您好，您的孩子在化学测验的语文成绩是：23。发送人：李级超','1358130477');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('34','114','112','15385593717','无语的家长您好，您的孩子在化学测验的语文成绩是：76分。发送人：李级超','1358130778');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('35','114','112','15385593717','张四的家长您好，您的孩子在《班级语文测验》的语文成绩是：89分。发送人：李级超','1358131547');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('36','114','112','15385593717','无语的家长您好，您的孩子在《班级语文测验》的语文成绩是：92分。发送人：李级超','1358131626');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('37','114','112','15385593717','各位家长您好，今天的作业是：复习第一课！。','1358133052');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('38','114','1','15385593717','您请求重置密码，校验码525006[请勿告知他人]，如非本人操作请致电：400-800-8832','1358158516');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('39','114','1','15385593717','您请求重置密码，校验码386605[请勿告知他人]，如非本人操作请致电：400-800-8832','1358158599');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('40','114','1','15385593717','您请求重置密码，校验码239855[请勿告知他人]，如非本人操作请致电：400-800-8832','1358158670');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('41','114','1','15385593717','您请求重置密码，校验码908126[请勿告知他人]，如非本人操作请致电：400-800-8832','1358158730');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('42','114','1','15385593717','您请求重置密码，校验码300198[请勿告知他人]，如非本人操作请致电：400-800-8832','1358159053');
INSERT INTO `tj_sendsms`(`sendid`,`uid`,`bid`,`mobile`,`content`,`dateline`)VALUES('43','114','1','15385593717','您请求重置密码，校验码339694[请勿告知他人]，如非本人操作请致电：400-800-8832','1358159165');

DROP TABLE IF EXISTS `tj_smsconfig`;
CREATE TABLE `tj_smsconfig` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `smsname` varchar(32) NOT NULL,
  `smspwd` varchar(32) NOT NULL,
  `http` varchar(1000) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='短信接口配置';
INSERT INTO `tj_smsconfig`(`id`,`smsname`,`smspwd`,`http`)VALUES('1','test','123456','');

DROP TABLE IF EXISTS `tj_subject`;
CREATE TABLE `tj_subject` (
  `bid` mediumint(8) unsigned NOT NULL default '0',
  `strsid` varchar(225) NOT NULL default '',
  PRIMARY KEY  (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='学校课程';

DROP TABLE IF EXISTS `tj_subject_item`;
CREATE TABLE `tj_subject_item` (
  `sid` mediumint(8) unsigned NOT NULL auto_increment,
  `sort` mediumint(8) unsigned NOT NULL default '0',
  `bid` varchar(10) NOT NULL,
  `subjectname` varchar(16) NOT NULL default '',
  PRIMARY KEY  (`sid`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='课程种类';
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('1','1','0','语文');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('2','2','0','数学');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('3','3','0','英语');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('4','4','0','物理');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('5','5','0','化学');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('8','0','0','生物');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('9','0','0','地理');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('10','0','0','音乐');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('11','0','0','体育');
INSERT INTO `tj_subject_item`(`sid`,`sort`,`bid`,`subjectname`)VALUES('12','0','0','计算机信息技术');

DROP TABLE IF EXISTS `tj_sysnote`;
CREATE TABLE `tj_sysnote` (
  `sysnoteid` int(10) unsigned NOT NULL auto_increment,
  `sysnote_type` tinyint(1) unsigned NOT NULL COMMENT '日志类型1:人员2:考试3:作业4:公告5:登录退出6：上传下载7：批量操作8：短信',
  `dotype` tinyint(1) unsigned default NULL COMMENT '1:增加2删除3修改0其他',
  `douserid` int(10) unsigned NOT NULL COMMENT '操作者id',
  `dobid` int(10) NOT NULL,
  `other` char(100) collate utf8_unicode_ci default '',
  `addtime` int(11) default '0',
  PRIMARY KEY  (`sysnoteid`)
) ENGINE=MyISAM AUTO_INCREMENT=974 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('576','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('575','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('574','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('573','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('572','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('571','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('570','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('569','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('568','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('567','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('566','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('565','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('564','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('563','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('562','5','0','1','1','127.0.0.1','1358846046');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('561','5','0','1','1','127.0.0.1','1358846030');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('560','5','0','1','1','127.0.0.1','1358845987');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('559','5','0','1','1','127.0.0.1','1358845224');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('558','5','0','1','1','127.0.0.1','1358838061');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('557','5','0','1','1','127.0.0.1','1358837862');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('556','5','0','1','1','127.0.0.1','1358837549');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('555','5','0','1','1','127.0.0.1','1358837524');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('554','5','0','1','1','127.0.0.1','1358837191');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('553','5','0','1','1','127.0.0.1','1358837152');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('552','7','1','114','0','批量导入了 46个成员','1358826042');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('551','5','0','114','113','127.0.0.1','1358825293');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('550','5','0','143','113','127.0.0.1','1358822898');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('549','5','0','143','113','127.0.0.1','1358822882');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('548','5','0','1','1','127.0.0.1','1358822760');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('547','5','0','143','113','127.0.0.1','1358822749');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('132','5','0','41','17','192.168.0.5','1353985992');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('131','5','0','1','1','192.168.0.5','1353985784');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('130','7','1','59','95','批量导入了3组学生成绩','1353985745');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('129','5','0','59','95','192.168.0.5','1353985313');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('128','7','1','41','17','批量导入了 2个成员','1353985303');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('127','5','0','41','17','192.168.0.5','1353984827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('126','5','0','1','1','192.168.0.5','1353984545');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('125','6','1','59','95','下载文件 "IMG_2242.JPG "','1353984527');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('133','5','0','1','1','192.168.0.9','1353998308');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('134','5','0','41','17','192.168.0.9','1353998470');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('135','5','0','41','17','192.168.0.5','1353999035');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('136','5','0','59','95','192.168.0.5','1354000576');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('137','5','0','1','1','192.168.0.5','1354008242');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('138','5','0','41','17','192.168.0.5','1354008372');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('139','5','0','59','95','192.168.0.5','1354008424');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('140','5','0','41','17','192.168.0.8','1354160857');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('141','5','0','1','1','192.168.0.8','1354161022');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('142','5','0','41','17','192.168.0.8','1354161133');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('143','5','0','1','1','192.168.0.8','1354161580');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('144','5','0','41','17','192.168.0.8','1354161592');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('145','5','0','59','95','192.168.0.8','1354161610');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('146','5','0','41','17','192.168.0.8','1354161625');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('147','5','0','73','95','192.168.0.8','1354161660');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('148','5','0','1','1','192.168.0.8','1354161705');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('149','5','0','41','17','192.168.0.8','1354161716');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('150','6','1','41','17','上传文件 "新建 文本文档 (2).txt "','1354161777');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('151','5','0','59','95','192.168.0.8','1354161881');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('152','6','1','59','95','下载文件 " "','1354161944');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('153','1','2','59','95','多个学生','1354167576');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('154','1','2','59','95','多个学生','1354167576');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('546','5','0','1','1','127.0.0.1','1358822706');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('545','5','0','139','113','127.0.0.1','1358822159');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('544','5','0','114','113','127.0.0.1','1358822144');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('543','5','0','143','113','127.0.0.1','1358821593');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('542','5','0','143','113','127.0.0.1','1358821478');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('541','5','0','1','1','127.0.0.1','1358818619');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('540','5','0','1','1','127.0.0.1','1358758311');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('539','5','0','114','113','127.0.0.1','1358757560');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('538','5','0','112','111','127.0.0.1','1358757206');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('537','5','0','1','1','127.0.0.1','1358751631');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('536','5','0','139','113','127.0.0.1','1358749159');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('535','5','0','139','113','127.0.0.1','1358748323');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('534','5','0','1','1','127.0.0.1','1358746657');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('533','5','0','114','113','127.0.0.1','1358676761');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('532','1','3','114','112','李级超|114','1358676714');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('531','5','0','114','112','127.0.0.1','1358674822');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('530','5','0','112','111','127.0.0.1','1358674103');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('529','5','0','114','112','127.0.0.1','1358674015');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('528','5','0','1','1','127.0.0.1','1358673995');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('527','5','0','1','1','127.0.0.1','1358670035');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('526','5','0','114','112','127.0.0.1','1358497020');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('525','5','0','114','112','127.0.0.1','1358488891');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('524','5','0','1','1','127.0.0.1','1358488626');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('523','5','0','1','1','127.0.0.1','1358473525');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('522','5','0','1','1','127.0.0.1','1358414641');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('521','5','0','114','112','127.0.0.1','1358391309');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('520','7','1','1','0','批量导入了 4个成员','1358390595');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('519','7','1','1','0','批量导入了 4个成员','1358390532');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('518','7','1','1','0','批量导入了 4个成员','1358390327');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('517','7','1','1','0','批量导入了 3个成员','1358389862');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('516','5','0','1','1','127.0.0.1','1358389241');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('515','5','0','113','112','127.0.0.1','1358334141');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('514','5','0','1','1','127.0.0.1','1358334123');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('513','5','0','1','1','127.0.0.1','1358239698');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('512','5','0','114','112','127.0.0.1','1358239509');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('511','5','0','1','1','127.0.0.1','1358237815');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('510','5','0','1','1','127.0.0.1','1358231513');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('509','5','0','1','1','127.0.0.1','1358214382');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('508','5','0','1','1','127.0.0.1','1358162215');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('507','5','0','1','1','127.0.0.1','1358162196');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('506','5','0','1','1','127.0.0.1','1358159384');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('505','5','0','1','1','127.0.0.1','1358158924');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('504','5','0','1','1','127.0.0.1','1358156106');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('503','5','0','1','1','127.0.0.1','1358152632');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('502','5','0','1','1','127.0.0.1','1358151775');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('501','5','0','1','1','127.0.0.1','1358150083');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('500','5','0','1','1','127.0.0.1','1358150046');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('499','5','0','1','1','127.0.0.1','1358148646');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('498','5','0','1','1','127.0.0.1','1358146545');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('497','3','2','114','112','asdddddddddddddd','1358146410');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('496','5','0','114','112','127.0.0.1','1358144760');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('495','5','0','1','1','127.0.0.1','1358143747');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('494','5','0','114','112','127.0.0.1','1358141495');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('493','5','0','1','1','127.0.0.1','1358133334');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('492','1','3','114','112','张四的家长|110','1358132998');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('491','3','2','114','112','复习语文第一课！','1358132606');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('490','2','1','114','112','班级语文测验','1358131526');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('489','3','2','114','112','1语文：日记一篇。 [p]2.数学角度比较 [/p]','1358130890');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('488','5','0','114','112','127.0.0.1','1358129168');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('487','1','3','114','112','张四|111','1358129118');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('486','2','1','114','112','化学测验','1358129065');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('485','1','3','114','112','李级超|114','1358128943');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('484','5','0','114','112','127.0.0.1','1358128929');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('483','5','0','1','1','127.0.0.1','1358127942');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('482','5','0','1','1','127.0.0.1','1358068972');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('481','5','0','114','112','127.0.0.1','1357898832');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('480','8','1','1','1','进行了短信分配操作','1357898822');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('479','5','0','1','1','127.0.0.1','1357898813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('478','5','0','114','112','127.0.0.1','1357898018');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('477','5','0','1','1','127.0.0.1','1357894651');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('476','5','0','114','112','127.0.0.1','1357894549');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('475','5','0','1','1','127.0.0.1','1357894243');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('474','5','0','1','1','127.0.0.1','1357891907');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('473','5','0','1','1','127.0.0.1','1357891446');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('472','5','0','1','1','127.0.0.1','1357891146');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('471','5','0','1','1','127.0.0.1','1357890892');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('470','5','0','114','112','127.0.0.1','1357890696');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('469','5','0','114','112','127.0.0.1','1357890553');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('468','5','0','1','1','127.0.0.1','1357888662');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('467','5','0','1','1','127.0.0.1','1357888394');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('466','5','0','1','1','127.0.0.1','1357874056');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('465','5','0','1','1','127.0.0.1','1357815580');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('464','5','0','1','1','127.0.0.1','1357815089');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('463','5','0','1','1','127.0.0.1','1357814809');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('462','5','0','1','1','127.0.0.1','1357813692');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('461','5','0','1','1','127.0.0.1','1357813433');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('460','5','0','117','1','127.0.0.1','1357813193');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('459','5','0','1','1','127.0.0.1','1357812186');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('458','5','0','1','1','127.0.0.1','1357807332');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('457','5','0','1','1','127.0.0.1','1357803975');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('245','5','0','41','17','127.0.0.1','1355130064');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('246','5','0','59','95','127.0.0.1','1355130155');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('247','5','0','1','1','127.0.0.1','1355187549');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('248','5','0','59','95','127.0.0.1','1355187646');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('249','2','0','59','95','导出成绩表 test002_英语成绩Excel数据表.xls','1355187789');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('250','2','0','59','95','导出成绩表 test002_英语成绩Excel数据表.xls','1355187891');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('251','2','0','59','95','导出成绩表 test002_英语成绩表.xls','1355187991');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('252','5','0','41','17','127.0.0.1','1355189019');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('253','5','0','1','1','127.0.0.1','1355189077');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('254','5','0','1','1','127.0.0.1','1355189102');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('255','5','0','59','95','127.0.0.1','1355189495');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('256','5','0','1','1','127.0.0.1','1355191005');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('257','5','0','59','95','127.0.0.1','1355191232');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('258','7','1','59','95','批量导入了 5个成员','1355191249');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('259','1','0','59','95','导出数据到Excel表：无效成绩列表.xls','1355193886');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('260','1','0','59','95','导出数据到Excel表：无效成绩列表.xls','1355194153');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('261','1','0','59','95','导出数据到Excel表：有效成绩列表.xls','1355194401');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('262','1','0','59','95','导出数据到Excel表：有效成绩列表.xls','1355194450');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('263','1','0','59','95','导出数据到Excel表：有效成绩列表.xls','1355194505');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('264','1','0','59','95','导出数据到Excel表：有效成绩列表.xls','1355194505');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('265','1','0','59','95','导出数据到Excel表：有效成绩列表.xls','1355194505');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('266','1','0','59','95','导出数据到Excel表：','1355194548');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('267','1','0','59','95','导出数据到Excel表：','1355194548');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('268','1','0','59','95','导出数据到Excel表：','1355194548');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('269','1','0','59','95','导出数据到Excel表：','1355194564');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('270','1','0','59','95','导出数据到Excel表：','1355195087');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('271','1','0','59','95','导出数据到Excel表：','1355195087');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('272','1','0','59','95','导出数据到Excel表：','1355195087');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('273','5','0','59','95','192.168.0.10','1355195308');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('274','1','0','59','95','导出数据到Excel表：','1355195356');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('456','5','0','1','1','127.0.0.1','1357800442');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('455','5','0','1','1','127.0.0.1','1357800412');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('454','5','0','1','1','127.0.0.1','1357800349');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('453','5','0','1','1','127.0.0.1','1357800305');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('452','5','0','1','1','127.0.0.1','1357800200');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('451','5','0','1','1','127.0.0.1','1357799889');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('450','5','0','114','112','127.0.0.1','1357784820');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('449','5','0','1','1','127.0.0.1','1357783414');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('448','5','0','116','1','127.0.0.1','1357783393');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('447','5','0','116','1','127.0.0.1','1357783374');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('446','5','0','1','1','127.0.0.1','1357717278');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('445','5','0','1','1','127.0.0.1','1357715476');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('444','5','0','1','1','127.0.0.1','1357713769');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('443','5','0','1','1','127.0.0.1','1357563421');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('442','5','0','115','113','127.0.0.1','1357553065');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('441','5','0','1','1','127.0.0.1','1357552986');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('440','5','0','115','113','127.0.0.1','1357552963');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('439','5','0','1','1','127.0.0.1','1357552946');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('438','5','0','1','1','127.0.0.1','1357552679');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('437','5','0','110','113','127.0.0.1','1357551575');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('436','5','0','1','1','127.0.0.1','1357551562');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('435','5','0','1','1','127.0.0.1','1357551533');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('434','5','0','110','113','127.0.0.1','1357550269');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('433','5','0','1','1','127.0.0.1','1357550143');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('432','5','0','114','112','127.0.0.1','1357547873');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('431','5','0','114','112','127.0.0.1','1357546716');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('430','5','0','1','1','127.0.0.1','1357546678');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('429','5','0','114','112','127.0.0.1','1357546643');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('428','5','0','1','1','127.0.0.1','1357546605');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('427','5','0','114','112','127.0.0.1','1357545542');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('426','5','0','1','1','127.0.0.1','1357545487');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('425','5','0','114','112','127.0.0.1','1357545447');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('424','5','0','1','1','127.0.0.1','1357545410');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('423','2','1','114','112','班级语文测验','1357537459');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('422','5','0','114','112','127.0.0.1','1357537451');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('421','5','0','112','111','127.0.0.1','1357537418');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('420','5','0','1','1','127.0.0.1','1357537407');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('419','5','0','114','112','127.0.0.1','1357537076');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('418','5','0','1','1','127.0.0.1','1357530222');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('417','5','0','115','113','127.0.0.1','1357530210');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('416','5','0','115','113','127.0.0.1','1357529318');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('415','5','0','115','113','127.0.0.1','1357528951');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('414','5','0','1','1','127.0.0.1','1357527696');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('413','5','0','114','112','127.0.0.1','1357527687');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('412','5','0','1','1','127.0.0.1','1357527381');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('411','5','0','1','1','127.0.0.1','1357526630');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('410','5','0','1','1','127.0.0.1','1357467202');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('409','5','0','114','112','127.0.0.1','1357466483');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('408','5','0','1','1','127.0.0.1','1357466294');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('407','5','0','1','1','127.0.0.1','1357464563');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('406','1','3','114','112','李级超|114','1357464547');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('405','1','3','114','112','李级超|114','1357464539');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('404','3','2','114','112','今天的语文作业是：默写沁园春','1357463521');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('403','3','2','114','112','今天的作业内容是，沁园春忏悔书！','1357463517');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('402','3','2','114','112','你们好！','1357463473');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('401','3','2','114','112','你们好！asdasdasd','1357463471');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('400','3','2','114','112','你们好！asdasdasd','1357463467');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('399','3','2','114','112','你们好！asdasdasd','1357463464');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('398','5','0','114','112','127.0.0.1','1357463042');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('397','5','0','1','1','127.0.0.1','1357463016');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('396','5','0','114','112','127.0.0.1','1357462346');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('395','8','1','1','1','进行了短信分配操作','1357462336');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('394','5','0','1','1','127.0.0.1','1357462327');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('393','5','0','114','112','127.0.0.1','1357461697');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('392','8','1','1','1','进行了短信分配操作','1357461686');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('391','5','0','1','1','127.0.0.1','1357461667');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('390','5','0','114','112','127.0.0.1','1357461635');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('389','5','0','1','1','127.0.0.1','1357461625');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('388','5','0','1','1','127.0.0.1','1357461479');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('387','1','1','113','112','李级超(北京第一初级中学/一年级)','1357461458');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('386','3','1','113','112','asdddddddddddddddddddd','1357441217');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('385','3','1','113','112','今天的作业是语文听写一遍！','1357440980');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('384','5','0','113','112','127.0.0.1','1357439080');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('383','5','0','1','1','127.0.0.1','1357439004');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('382','5','0','113','112','127.0.0.1','1357438901');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('381','1','1','112','111','朱志斌(北京第一初级中学/一年级)','1357438891');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('380','5','0','112','111','127.0.0.1','1357438849');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('379','5','0','112','111','127.0.0.1','1357436145');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('378','5','0','1','1','127.0.0.1','1357436077');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('377','5','0','111','113','127.0.0.1','1357436064');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('376','5','0','1','1','127.0.0.1','1357435980');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('375','5','0','107','113','127.0.0.1','1357286570');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('374','5','0','1','1','127.0.0.1','1357286558');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('373','5','0','111','113','127.0.0.1','1357286510');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('372','5','0','1','1','127.0.0.1','1357286498');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('371','5','0','1','1','127.0.0.1','1357286404');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('370','5','0','1','1','127.0.0.1','1356505824');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('369','5','0','107','113','127.0.0.1','1356505709');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('368','5','0','1','1','127.0.0.1','1356505692');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('367','5','0','110','113','127.0.0.1','1356505157');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('366','7','1','1','0','批量导入了 4个成员','1356505136');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('577','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('578','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('579','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('580','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('581','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('582','1','2','1','1','多个学生','1358846088');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('583','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('584','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('585','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('586','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('587','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('588','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('589','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('590','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('591','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('592','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('593','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('594','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('595','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('596','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('597','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('598','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('599','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('600','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('601','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('602','1','2','1','1','多个学生','1358846097');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('603','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('604','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('605','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('606','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('607','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('608','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('609','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('610','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('611','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('612','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('613','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('614','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('615','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('616','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('617','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('618','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('619','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('620','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('621','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('622','1','2','1','1','多个学生','1358846122');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('623','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('624','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('625','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('626','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('627','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('628','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('629','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('630','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('631','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('632','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('633','1','2','1','1','多个学生','1358846140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('634','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('635','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('636','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('637','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('638','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('639','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('640','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('641','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('642','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('643','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('644','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('645','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('646','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('647','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('648','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('649','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('650','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('651','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('652','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('653','1','2','1','1','多个学生','1358846154');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('654','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('655','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('656','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('657','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('658','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('659','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('660','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('661','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('662','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('663','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('664','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('665','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('666','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('667','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('668','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('669','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('670','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('671','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('672','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('673','1','2','1','1','多个学生','1358846169');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('674','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('675','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('676','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('677','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('678','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('679','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('680','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('681','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('682','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('683','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('684','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('685','1','2','1','1','多个学生','1358846181');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('686','5','0','1','1','127.0.0.1','1358846528');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('687','5','0','1','1','127.0.0.1','1358846687');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('688','7','1','1','0','批量导入了 46个成员','1358846718');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('689','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('690','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('691','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('692','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('693','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('694','1','2','1','1','多个学生','1358846808');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('695','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('696','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('697','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('698','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('699','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('700','1','2','1','1','多个学生','1358846813');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('701','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('702','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('703','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('704','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('705','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('706','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('707','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('708','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('709','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('710','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('711','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('712','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('713','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('714','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('715','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('716','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('717','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('718','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('719','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('720','1','2','1','1','多个学生','1358846821');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('721','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('722','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('723','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('724','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('725','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('726','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('727','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('728','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('729','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('730','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('731','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('732','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('733','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('734','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('735','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('736','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('737','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('738','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('739','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('740','1','2','1','1','多个学生','1358846827');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('741','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('742','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('743','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('744','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('745','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('746','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('747','1','2','1','1','多个学生','1358846833');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('748','5','0','1','1','127.0.0.1','1358846863');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('749','7','1','1','0','批量导入了 46个成员','1358846881');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('750','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('751','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('752','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('753','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('754','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('755','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('756','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('757','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('758','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('759','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('760','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('761','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('762','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('763','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('764','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('765','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('766','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('767','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('768','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('769','1','2','1','1','多个学生','1358846894');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('770','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('771','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('772','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('773','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('774','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('775','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('776','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('777','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('778','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('779','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('780','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('781','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('782','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('783','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('784','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('785','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('786','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('787','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('788','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('789','1','2','1','1','多个学生','1358846906');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('790','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('791','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('792','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('793','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('794','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('795','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('796','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('797','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('798','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('799','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('800','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('801','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('802','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('803','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('804','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('805','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('806','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('807','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('808','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('809','1','2','1','1','多个学生','1358846917');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('810','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('811','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('812','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('813','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('814','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('815','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('816','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('817','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('818','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('819','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('820','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('821','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('822','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('823','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('824','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('825','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('826','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('827','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('828','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('829','1','2','1','1','多个学生','1358846935');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('830','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('831','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('832','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('833','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('834','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('835','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('836','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('837','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('838','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('839','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('840','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('841','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('842','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('843','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('844','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('845','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('846','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('847','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('848','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('849','1','2','1','1','多个学生','1358846940');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('850','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('851','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('852','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('853','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('854','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('855','1','2','1','1','多个学生','1358846965');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('856','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('857','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('858','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('859','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('860','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('861','1','2','1','1','多个学生','1358846976');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('862','5','0','1','1','127.0.0.1','1358904365');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('863','5','0','114','113','127.0.0.1','1358920851');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('864','5','0','1','1','127.0.0.1','1358921275');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('865','5','0','114','113','127.0.0.1','1358921295');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('866','5','0','1','1','127.0.0.1','1358921681');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('867','5','0','112','111','127.0.0.1','1358921693');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('868','5','0','1','1','127.0.0.1','1358921701');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('869','5','0','112','111','127.0.0.1','1358921717');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('870','5','0','1','1','127.0.0.1','1358921734');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('871','5','0','112','111','127.0.0.1','1358921766');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('872','5','0','1','1','127.0.0.1','1358922253');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('873','5','0','1','1','127.0.0.1','1358935165');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('874','5','0','114','113','127.0.0.1','1358935206');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('875','1','3','114','113','李老师|139','1358935211');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('876','7','1','114','0','批量导入了 46个成员','1358935313');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('877','6','1','114','113','上传文件 "1605555u41b416bwts3u6e.rar "','1358935445');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('878','6','1','114','113','上传文件 "橙创家校通v4.0使用说明Beta1.doc "','1358935454');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('879','5','0','1','1','127.0.0.1','1358992343');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('880','5','0','511','113','127.0.0.1','1358994229');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('881','5','0','1','1','127.0.0.1','1358994616');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('882','5','0','511','113','127.0.0.1','1358994625');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('883','5','0','510','113','127.0.0.1','1358994752');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('884','5','0','1','1','127.0.0.1','1358995117');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('885','5','0','500','113','127.0.0.1','1358995127');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('886','5','0','500','113','127.0.0.1','1358995140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('887','5','0','114','113','127.0.0.1','1358995286');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('888','1','1','114','113','陈波(北京第一初级中学/一年级/一班)','1358995822');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('889','5','0','512','113','127.0.0.1','1358995950');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('890','5','0','114','113','127.0.0.1','1358996069');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('891','1','2','114','113','陈波','1358996985');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('892','1','2','114','113','陈雨璐','1358996991');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('893','1','2','114','113','韦温娜的家长','1358996998');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('894','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('895','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('896','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('897','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('898','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('899','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('900','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('901','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('902','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('903','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('904','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('905','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('906','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('907','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('908','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('909','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('910','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('911','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('912','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('913','1','2','114','113','多个学生','1358997220');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('914','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('915','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('916','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('917','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('918','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('919','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('920','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('921','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('922','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('923','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('924','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('925','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('926','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('927','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('928','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('929','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('930','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('931','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('932','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('933','1','2','114','113','多个学生','1358997226');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('934','1','2','114','113','多个学生','1358997230');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('935','1','2','114','113','多个学生','1358997230');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('936','1','2','114','113','多个学生','1358997230');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('937','1','2','114','113','多个学生','1358997230');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('938','7','1','114','0','批量导入了 5个成员','1358997550');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('939','5','0','522','113','127.0.0.1','1358997581');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('940','5','0','1','1','127.0.0.1','1358997618');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('941','1','2','1','1','多个学生','1358997990');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('942','1','2','1','1','多个学生','1358997990');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('943','1','2','1','1','多个学生','1358997990');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('944','1','2','1','1','多个学生','1358997990');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('945','1','2','1','1','多个学生','1358997990');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('946','5','0','1','1','127.0.0.1','1358998006');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('947','7','1','1','0','批量导入了 5个成员','1358998016');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('948','1','2','1','1','多个学生','1358998031');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('949','1','2','1','1','多个学生','1358998031');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('950','1','2','1','1','多个学生','1358998031');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('951','1','2','1','1','多个学生','1358998031');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('952','1','2','1','1','多个学生','1358998031');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('953','7','1','1','0','批量导入了 5个成员','1358998527');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('954','5','0','1','1','127.0.0.1','1359010396');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('955','5','0','542','113','127.0.0.1','1359010412');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('956','5','0','542','113','127.0.0.1','1359010424');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('957','5','0','1','1','127.0.0.1','1359011140');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('958','5','0','542','113','127.0.0.1','1359011354');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('959','5','0','1','1','127.0.0.1','1359011520');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('960','5','0','542','113','127.0.0.1','1359011541');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('961','5','0','1','1','127.0.0.1','1359079510');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('962','7','1','1','0','批量导入了 46个成员','1359080072');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('963','5','0','114','113','127.0.0.1','1359080205');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('964','5','0','1','1','127.0.0.1','1359081526');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('965','5','0','1','1','127.0.0.1','1359082044');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('966','5','0','112','111','127.0.0.1','1359082061');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('967','5','0','1','1','127.0.0.1','1359082195');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('968','5','0','1','1','127.0.0.1','1359087182');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('969','5','0','114','113','127.0.0.1','1359094996');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('970','5','0','1','1','127.0.0.1','1359193602');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('971','5','0','1','1','127.0.0.1','1359198090');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('972','5','0','634','113','127.0.0.1','1359199342');
INSERT INTO `tj_sysnote`(`sysnoteid`,`sysnote_type`,`dotype`,`douserid`,`dobid`,`other`,`addtime`)VALUES('973','5','0','1','1','127.0.0.1','1359342270');

DROP TABLE IF EXISTS `tj_sysnote_type`;
CREATE TABLE `tj_sysnote_type` (
  `id` int(1) unsigned NOT NULL auto_increment,
  `type` varchar(40) collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;
INSERT INTO `tj_sysnote_type`(`id`,`type`)VALUES('1','人员日志');
INSERT INTO `tj_sysnote_type`(`id`,`type`)VALUES('2','作业日志');
INSERT INTO `tj_sysnote_type`(`id`,`type`)VALUES('3','考试日志');
INSERT INTO `tj_sysnote_type`(`id`,`type`)VALUES('4','公告日志');
INSERT INTO `tj_sysnote_type`(`id`,`type`)VALUES('5','短信记录');

DROP TABLE IF EXISTS `tj_system`;
CREATE TABLE `tj_system` (
  `variable` varchar(32) NOT NULL default '',
  `value` text NOT NULL,
  `mod` varchar(20) NOT NULL,
  PRIMARY KEY  (`variable`,`mod`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统配置';
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('cfg_if_site_open','1','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('cfg_site_open_reason','系统升级中，请稍后再试...','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('Logintips','请使用您的家校通账户或手机号登录','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteTel','0559-2324349','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteBeian','ICP备1234567号','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteLogo','http://127.0.0.1/jxt/public/images/logo.gif','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('Sitekey','橙创,家校通,家校互动平台','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('Sitedesc','橙创家校通系统采用PHP+MYSQL开发的一套方便、快速、安全、高效的学校管理系统。本系统已在全国超过100所中小学校成功应用，并得到了多方一致好评，是国内首个开放型并支持独立运营的优秀系统，一直以来为中国的在线教育事业提供源动力。','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteVerifyCode','1','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteUrl','http://127.0.0.1/jxt/','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SiteName','橙创家校通系统V4.0','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('SafeCode','1ac4ef0c55bebda4cf66f69d2f97af71','system');
INSERT INTO `tj_system`(`variable`,`value`,`mod`)VALUES('StatisticalCode','<script src="http://s13.cnzz.com/stat.php?id=4844992&web_id=4844992" language="JavaScript"></script>','system');

DROP TABLE IF EXISTS `tj_usergroups`;
CREATE TABLE `tj_usergroups` (
  `groupid` smallint(6) NOT NULL auto_increment,
  `grouptype` enum('school','parent','student','special','system') default 'school',
  `groupname` char(16) default '',
  `point` int(10) NOT NULL default '0',
  `color` varchar(7) NOT NULL default '',
  `menuid` int(11) NOT NULL default '0',
  `access` text NOT NULL,
  PRIMARY KEY  (`groupid`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户组';
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('1','system','系统管理员','0','#808080','1','a:25:{s:16:"member_forbidden";s:1:"0";s:16:"system_usergroup";s:1:"1";s:9:"set_mysql";s:1:"1";s:13:"system_setsms";s:1:"1";s:8:"set_menu";s:1:"1";s:16:"system_smsassign";s:1:"1";s:17:"system_changeinfo";s:1:"1";s:10:"set_member";s:1:"1";s:12:"baned_member";s:1:"1";s:8:"send_sms";s:1:"1";s:8:"send_msg";s:1:"1";s:13:"export_member";s:1:"1";s:10:"set_branch";s:1:"1";s:16:"edit_other_topic";s:1:"1";s:15:"edit_self_topic";s:1:"1";s:9:"add_topic";s:1:"1";s:9:"add_group";s:1:"1";s:13:"add_groupcate";s:1:"1";s:14:"del_self_topic";s:1:"1";s:15:"del_other_topic";s:1:"1";s:9:"top_topic";s:1:"1";s:11:"posts_topic";s:1:"1";s:9:"Cmt_topic";s:1:"1";s:10:"system_ann";s:1:"1";s:8:"set_help";s:1:"1";}');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('2','school','学校管理员','0','#808080','2','a:35:{s:16:"member_forbidden";s:1:"0";s:10:"set_branch";s:1:"1";s:13:"export_member";s:1:"1";s:8:"send_msg";s:1:"1";s:8:"send_sms";s:1:"1";s:12:"baned_member";s:1:"1";s:10:"set_member";s:1:"1";s:11:"set_subject";s:1:"1";s:8:"set_exam";s:1:"1";s:14:"set_attendance";s:1:"1";s:10:"school_ann";s:1:"1";s:12:"set_schedule";s:1:"0";s:9:"class_ann";s:1:"0";s:8:"add_exam";s:1:"0";s:11:"show_result";s:1:"0";s:10:"add_result";s:1:"0";s:11:"send_result";s:1:"0";s:11:"down_result";s:1:"0";s:8:"add_work";s:1:"0";s:9:"send_work";s:1:"0";s:10:"add_folder";s:1:"1";s:11:"upload_file";s:1:"1";s:9:"down_file";s:1:"1";s:13:"add_groupcate";s:1:"1";s:9:"add_group";s:1:"1";s:9:"add_topic";s:1:"1";s:15:"edit_self_topic";s:1:"1";s:16:"edit_other_topic";s:1:"1";s:14:"del_self_topic";s:1:"1";s:15:"del_other_topic";s:1:"1";s:9:"top_topic";s:1:"1";s:11:"posts_topic";s:1:"1";s:9:"Cmt_topic";s:1:"1";s:10:"school_log";s:1:"1";s:16:"school_smsassign";s:1:"1";}');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('3','school','班主任','0','#808080','3','a:34:{s:16:"member_forbidden";s:1:"0";s:10:"set_branch";s:1:"1";s:13:"export_member";s:1:"1";s:8:"send_msg";s:1:"1";s:8:"send_sms";s:1:"1";s:12:"baned_member";s:1:"1";s:10:"set_member";s:1:"1";s:11:"set_subject";s:1:"0";s:8:"set_exam";s:1:"0";s:14:"set_attendance";s:1:"0";s:12:"set_schedule";s:1:"1";s:9:"class_ann";s:1:"1";s:8:"add_exam";s:1:"1";s:11:"show_result";s:1:"1";s:10:"add_result";s:1:"1";s:11:"send_result";s:1:"1";s:11:"down_result";s:1:"1";s:8:"add_work";s:1:"1";s:9:"send_work";s:1:"1";s:10:"add_folder";s:1:"1";s:11:"upload_file";s:1:"1";s:9:"down_file";s:1:"1";s:13:"add_groupcate";s:1:"0";s:9:"add_group";s:1:"1";s:9:"add_topic";s:1:"1";s:15:"edit_self_topic";s:1:"1";s:16:"edit_other_topic";s:1:"1";s:14:"del_self_topic";s:1:"1";s:15:"del_other_topic";s:1:"1";s:9:"top_topic";s:1:"1";s:11:"posts_topic";s:1:"1";s:9:"Cmt_topic";s:1:"1";s:10:"school_ann";s:1:"0";s:16:"school_smsassign";s:1:"1";}');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('4','school','任课老师','0','#808080','4','a:33:{s:16:"member_forbidden";s:1:"0";s:10:"set_branch";s:1:"0";s:13:"export_member";s:1:"1";s:8:"send_msg";s:1:"1";s:8:"send_sms";s:1:"1";s:12:"baned_member";s:1:"0";s:10:"set_member";s:1:"0";s:11:"set_subject";s:1:"0";s:8:"set_exam";s:1:"0";s:14:"set_attendance";s:1:"0";s:12:"set_schedule";s:1:"0";s:9:"class_ann";s:1:"0";s:8:"add_exam";s:1:"1";s:11:"show_result";s:1:"1";s:10:"add_result";s:1:"1";s:11:"send_result";s:1:"0";s:11:"down_result";s:1:"1";s:8:"add_work";s:1:"0";s:9:"send_work";s:1:"0";s:10:"add_folder";s:1:"0";s:11:"upload_file";s:1:"1";s:9:"down_file";s:1:"1";s:13:"add_groupcate";s:1:"0";s:9:"add_group";s:1:"0";s:9:"add_topic";s:1:"1";s:15:"edit_self_topic";s:1:"1";s:16:"edit_other_topic";s:1:"0";s:14:"del_self_topic";s:1:"1";s:15:"del_other_topic";s:1:"0";s:9:"top_topic";s:1:"0";s:11:"posts_topic";s:1:"0";s:9:"Cmt_topic";s:1:"1";s:10:"school_ann";s:1:"0";}');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('5','parent','家长','300','#808080','5','');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('6','student','学生','0','#808080','6','');
INSERT INTO `tj_usergroups`(`groupid`,`grouptype`,`groupname`,`point`,`color`,`menuid`,`access`)VALUES('24','system','副管理员','0','','1','a:25:{s:16:"member_forbidden";s:1:"0";s:16:"system_usergroup";s:1:"1";s:9:"set_mysql";s:1:"0";s:13:"system_setsms";s:1:"0";s:8:"set_menu";s:1:"0";s:16:"system_smsassign";s:1:"0";s:17:"system_changeinfo";s:1:"0";s:10:"set_member";s:1:"0";s:12:"baned_member";s:1:"0";s:8:"send_sms";s:1:"0";s:8:"send_msg";s:1:"0";s:13:"export_member";s:1:"0";s:10:"set_branch";s:1:"0";s:16:"edit_other_topic";s:1:"0";s:15:"edit_self_topic";s:1:"0";s:9:"add_topic";s:1:"0";s:9:"add_group";s:1:"0";s:13:"add_groupcate";s:1:"0";s:14:"del_self_topic";s:1:"0";s:15:"del_other_topic";s:1:"0";s:9:"top_topic";s:1:"0";s:11:"posts_topic";s:1:"0";s:9:"Cmt_topic";s:1:"0";s:10:"system_ann";s:1:"0";s:8:"set_help";s:1:"0";}');

DROP TABLE IF EXISTS `tj_users`;
CREATE TABLE `tj_users` (
  `uid` mediumint(8) unsigned NOT NULL auto_increment,
  `email` varchar(60) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  `username` varchar(16) NOT NULL default '',
  `realname` varchar(20) NOT NULL default '',
  `face` char(64) NOT NULL default '',
  `stu_num` varchar(50) NOT NULL default '' COMMENT '学号',
  `sex` int(1) unsigned NOT NULL default '1',
  `phonenum` varchar(13) NOT NULL default '0',
  `newmsg` smallint(5) unsigned NOT NULL default '0',
  `regdate` int(10) unsigned NOT NULL default '0',
  `logintime` int(10) unsigned NOT NULL default '0',
  `loginip` varchar(16) NOT NULL default '',
  `logincount` mediumint(8) unsigned NOT NULL default '0',
  `groupid` smallint(2) NOT NULL default '1',
  `isbaned` smallint(2) NOT NULL default '1',
  `nexttime` int(10) unsigned NOT NULL default '0',
  `subjects` int(10) unsigned NOT NULL default '0',
  `bid` int(10) unsigned NOT NULL default '0',
  `responds` int(10) unsigned NOT NULL default '0',
  `flowers` int(10) unsigned NOT NULL default '0',
  `pictures` int(10) unsigned NOT NULL default '0',
  `sms_balance` int(10) unsigned NOT NULL default '0' COMMENT '短信剩余条数',
  `h_send_sms` int(11) NOT NULL default '0',
  `parent_id` int(11) NOT NULL default '0' COMMENT '学生家长ID',
  `cpwd` tinyint(1) NOT NULL default '1' COMMENT '修改初始密码',
  `resetpwd` char(32) NOT NULL COMMENT '重置密码',
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `groupid` (`groupid`),
  KEY `point` (`realname`),
  KEY `coin` (`phonenum`)
) ENGINE=MyISAM AUTO_INCREMENT=636 DEFAULT CHARSET=utf8 COMMENT='用户基础';
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('1','1121251729@qq.com','e10adc3949ba59abbe56e057f20f883e','admin','管理员','','','1','13912341234','0','0','1359342270','','112','1','1','0','0','1','0','0','0','7754','1','0','0','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('114','','e10adc3949ba59abbe56e057f20f883e','lichao','李超','','','0','15385593717','0','0','1359080205','','14','3','1','0','0','113','0','0','0','1','2','0','0','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('552','','e10adc3949ba59abbe56e057f20f883e','pyanghe5','龙曾靖的家长','','5','0','13707720794','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','550','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('112','','e10adc3949ba59abbe56e057f20f883e','chenzhibin','陈志斌','','','0','13344544568','0','0','1359082061','','6','2','1','0','0','111','0','0','0','0','0','0','0','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('635','','e10adc3949ba59abbe56e057f20f883e','yanghe46','陈雨璐','','46','0','18777247797','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','634','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('634','','e10adc3949ba59abbe56e057f20f883e','pyanghe46','陈雨璐的家长','','46','0','18777247797','0','0','1359199342','','1','5','1','0','0','113','0','0','0','0','0','632','0','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('631','','e10adc3949ba59abbe56e057f20f883e','yanghe44','潘安妮','','44','0','15278876401','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','630','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('548','','e10adc3949ba59abbe56e057f20f883e','pyanghe3','蒙诗阳的家长','','3','0','18776292951','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','546','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('544','','e10adc3949ba59abbe56e057f20f883e','pyanghe1','韦灏格的家长','','1','0','13481225620','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','0','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('545','','e10adc3949ba59abbe56e057f20f883e','yanghe1','韦灏格','','1','0','13481225620','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','544','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('546','','e10adc3949ba59abbe56e057f20f883e','pyanghe2','覃思甜的家长','','2','0','18978019659','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','544','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('547','','e10adc3949ba59abbe56e057f20f883e','yanghe2','覃思甜','','2','0','18978019659','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','546','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('551','','e10adc3949ba59abbe56e057f20f883e','yanghe4','韦慧婷','','4','0','13481274606','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','550','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('549','','e10adc3949ba59abbe56e057f20f883e','yanghe3','蒙诗阳','','3','0','18776292951','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','548','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('550','','e10adc3949ba59abbe56e057f20f883e','pyanghe4','韦慧婷的家长','','4','0','13481274606','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','548','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('139','','e10adc3949ba59abbe56e057f20f883e','xiaoli','李老师','','0','0','13867788776','0','0','1358822159','','2','4','1','0','0','113','0','0','0','0','0','0','0','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('633','','e10adc3949ba59abbe56e057f20f883e','yanghe45','韦温娜','','45','0','13647726631','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','632','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('632','','e10adc3949ba59abbe56e057f20f883e','pyanghe45','韦温娜的家长','','45','0','13647726631','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','630','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('630','','e10adc3949ba59abbe56e057f20f883e','pyanghe44','潘安妮的家长','','44','0','15278876401','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','628','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('553','','e10adc3949ba59abbe56e057f20f883e','yanghe5','龙曾靖','','5','0','13707720794','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','552','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('554','','e10adc3949ba59abbe56e057f20f883e','pyanghe6','欧阳美姿的家长','','6','0','13481222397','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','552','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('555','','e10adc3949ba59abbe56e057f20f883e','yanghe6','欧阳美姿','','6','0','13481222397','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','554','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('556','','e10adc3949ba59abbe56e057f20f883e','pyanghe7','姜田馨怡的家长','','7','0','13877277679','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','554','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('557','','e10adc3949ba59abbe56e057f20f883e','yanghe7','姜田馨怡','','7','0','13877277679','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','556','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('558','','e10adc3949ba59abbe56e057f20f883e','pyanghe8','覃媛媛的家长','','8','0','13768324018','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','556','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('559','','e10adc3949ba59abbe56e057f20f883e','yanghe8','覃媛媛','','8','0','13768324018','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','558','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('560','','e10adc3949ba59abbe56e057f20f883e','pyanghe9','覃琦钰的家长','','9','0','13481218668','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','558','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('561','','e10adc3949ba59abbe56e057f20f883e','yanghe9','覃琦钰','','9','0','13481218668','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','560','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('562','','e10adc3949ba59abbe56e057f20f883e','pyanghe10','梁锦添的家长','','10','1','13768879448','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','560','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('563','','e10adc3949ba59abbe56e057f20f883e','yanghe10','梁锦添','','10','1','13768879448','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','562','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('564','','e10adc3949ba59abbe56e057f20f883e','pyanghe11','覃元振的家长','','11','1','13617823899','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','562','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('565','','e10adc3949ba59abbe56e057f20f883e','yanghe11','覃元振','','11','1','13617823899','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','564','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('566','','e10adc3949ba59abbe56e057f20f883e','pyanghe12','龙志辉的家长','','12','1','13788528495','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','564','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('567','','e10adc3949ba59abbe56e057f20f883e','yanghe12','龙志辉','','12','1','13788528495','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','566','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('568','','e10adc3949ba59abbe56e057f20f883e','pyanghe13','姚李杰的家长','','13','1','13299600813','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','566','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('569','','e10adc3949ba59abbe56e057f20f883e','yanghe13','姚李杰','','13','1','13299600813','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','568','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('570','','e10adc3949ba59abbe56e057f20f883e','pyanghe14','郑仪鹏的家长','','14','1','15878896130','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','568','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('571','','e10adc3949ba59abbe56e057f20f883e','yanghe14','郑仪鹏','','14','1','15878896130','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','570','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('572','','e10adc3949ba59abbe56e057f20f883e','pyanghe15','梁海峰的家长','','15','1','15277282394','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','570','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('573','','e10adc3949ba59abbe56e057f20f883e','yanghe15','梁海峰','','15','1','15277282394','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','572','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('574','','e10adc3949ba59abbe56e057f20f883e','pyanghe16','蒙祖佳勒的家长','','16','1','13471243607','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','572','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('575','','e10adc3949ba59abbe56e057f20f883e','yanghe16','蒙祖佳勒','','16','1','13471243607','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','574','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('576','','e10adc3949ba59abbe56e057f20f883e','pyanghe17','韦星宇的家长','','17','1','13978053870','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','574','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('577','','e10adc3949ba59abbe56e057f20f883e','yanghe17','韦星宇','','17','1','13978053870','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','576','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('578','','e10adc3949ba59abbe56e057f20f883e','pyanghe18','覃海峰的家长','','18','1','13877207742','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','576','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('579','','e10adc3949ba59abbe56e057f20f883e','yanghe18','覃海峰','','18','1','13877207742','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','578','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('580','','e10adc3949ba59abbe56e057f20f883e','pyanghe19','龙俊霖的家长','','19','1','13457218008','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','578','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('581','','e10adc3949ba59abbe56e057f20f883e','yanghe19','龙俊霖','','19','1','13457218008','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','580','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('582','','e10adc3949ba59abbe56e057f20f883e','pyanghe20','覃俊迪的家长','','20','1','13597028006','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','580','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('583','','e10adc3949ba59abbe56e057f20f883e','yanghe20','覃俊迪','','20','1','13597028006','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','582','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('584','','e10adc3949ba59abbe56e057f20f883e','pyanghe21','覃宝全的家长','','21','1','13978060292','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','582','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('585','','e10adc3949ba59abbe56e057f20f883e','yanghe21','覃宝全','','21','1','13978060292','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','584','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('586','','e10adc3949ba59abbe56e057f20f883e','pyanghe22','梁博云的家长','','22','1','13788022975','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','584','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('587','','e10adc3949ba59abbe56e057f20f883e','yanghe22','梁博云','','22','1','13788022975','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','586','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('588','','e10adc3949ba59abbe56e057f20f883e','pyanghe23','覃春溪的家长','','23','0','13788129573','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','586','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('589','','e10adc3949ba59abbe56e057f20f883e','yanghe23','覃春溪','','23','0','13788129573','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','588','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('590','','e10adc3949ba59abbe56e057f20f883e','pyanghe24','龙莹莹的家长','','24','0','15877269549','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','588','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('591','','e10adc3949ba59abbe56e057f20f883e','yanghe24','龙莹莹','','24','0','15877269549','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','590','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('592','','e10adc3949ba59abbe56e057f20f883e','pyanghe25','韦胤伊的家长','','25','0','13977236488','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','590','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('593','','e10adc3949ba59abbe56e057f20f883e','yanghe25','韦胤伊','','25','0','13977236488','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','592','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('594','','e10adc3949ba59abbe56e057f20f883e','pyanghe26','龙  杭的家长','','26','1','15078258169','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','592','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('595','','e10adc3949ba59abbe56e057f20f883e','yanghe26','龙  杭','','26','1','15078258169','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','594','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('596','','e10adc3949ba59abbe56e057f20f883e','pyanghe27','覃佳宝的家长','','27','1','13407878804','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','594','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('597','','e10adc3949ba59abbe56e057f20f883e','yanghe27','覃佳宝','','27','1','13407878804','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','596','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('598','','e10adc3949ba59abbe56e057f20f883e','pyanghe28','韦柳楠的家长','','28','0','15577258173','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','596','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('599','','e10adc3949ba59abbe56e057f20f883e','yanghe28','韦柳楠','','28','0','15577258173','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','598','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('600','','e10adc3949ba59abbe56e057f20f883e','pyanghe29','肖韦平的家长','','29','1','18978043027','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','598','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('601','','e10adc3949ba59abbe56e057f20f883e','yanghe29','肖韦平','','29','1','18978043027','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','600','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('602','','e10adc3949ba59abbe56e057f20f883e','pyanghe30','李致如的家长','','30','0','13659669221','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','600','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('603','','e10adc3949ba59abbe56e057f20f883e','yanghe30','李致如','','30','0','13659669221','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','602','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('604','','e10adc3949ba59abbe56e057f20f883e','pyanghe31','黄健美的家长','','31','0','13597098656','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','602','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('605','','e10adc3949ba59abbe56e057f20f883e','yanghe31','黄健美','','31','0','13597098656','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','604','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('606','','e10adc3949ba59abbe56e057f20f883e','pyanghe32','莫佳烩的家长','','32','0','13737248207','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','604','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('607','','e10adc3949ba59abbe56e057f20f883e','yanghe32','莫佳烩','','32','0','13737248207','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','606','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('608','','e10adc3949ba59abbe56e057f20f883e','pyanghe33','甘玉婷的家长','','33','0','15277297816','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','606','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('609','','e10adc3949ba59abbe56e057f20f883e','yanghe33','甘玉婷','','33','0','15277297816','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','608','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('610','','e10adc3949ba59abbe56e057f20f883e','pyanghe34','王春燕的家长','','34','0','13132627723','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','608','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('611','','e10adc3949ba59abbe56e057f20f883e','yanghe34','王春燕','','34','0','13132627723','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','610','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('612','','e10adc3949ba59abbe56e057f20f883e','pyanghe35','邓云喜的家长','','35','1','13647725795','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','610','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('613','','e10adc3949ba59abbe56e057f20f883e','yanghe35','邓云喜','','35','1','13647725795','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','612','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('614','','e10adc3949ba59abbe56e057f20f883e','pyanghe36','李国良的家长','','36','1','13407893055','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','612','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('615','','e10adc3949ba59abbe56e057f20f883e','yanghe36','李国良','','36','1','13407893055','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','614','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('616','','e10adc3949ba59abbe56e057f20f883e','pyanghe37','蒙弘杰的家长','','37','1','13607803781','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','614','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('617','','e10adc3949ba59abbe56e057f20f883e','yanghe37','蒙弘杰','','37','1','13607803781','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','616','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('618','','e10adc3949ba59abbe56e057f20f883e','pyanghe38','韦  思的家长','','38','1','15907820967','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','616','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('619','','e10adc3949ba59abbe56e057f20f883e','yanghe38','韦  思','','38','1','15907820967','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','618','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('620','','e10adc3949ba59abbe56e057f20f883e','pyanghe39','廖  霜的家长','','39','0','13667805238','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','618','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('621','','e10adc3949ba59abbe56e057f20f883e','yanghe39','廖  霜','','39','0','13667805238','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','620','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('622','','e10adc3949ba59abbe56e057f20f883e','pyanghe40','梁淑萱的家长','','40','0','18777253587','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','620','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('623','','e10adc3949ba59abbe56e057f20f883e','yanghe40','梁淑萱','','40','0','18777253587','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','622','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('624','','e10adc3949ba59abbe56e057f20f883e','pyanghe41','覃仁宁的家长','','41','1','13078003519','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','622','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('625','','e10adc3949ba59abbe56e057f20f883e','yanghe41','覃仁宁','','41','1','13078003519','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','624','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('626','','e10adc3949ba59abbe56e057f20f883e','pyanghe42','何志敏的家长','','42','1','13737259334','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','624','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('627','','e10adc3949ba59abbe56e057f20f883e','yanghe42','何志敏','','42','1','13737259334','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','626','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('628','','e10adc3949ba59abbe56e057f20f883e','pyanghe43','蓝宇才的家长','','43','1','15676271158','0','0','0','','0','5','1','0','0','113','0','0','0','0','0','626','1','');
INSERT INTO `tj_users`(`uid`,`email`,`password`,`username`,`realname`,`face`,`stu_num`,`sex`,`phonenum`,`newmsg`,`regdate`,`logintime`,`loginip`,`logincount`,`groupid`,`isbaned`,`nexttime`,`subjects`,`bid`,`responds`,`flowers`,`pictures`,`sms_balance`,`h_send_sms`,`parent_id`,`cpwd`,`resetpwd`)VALUES('629','','e10adc3949ba59abbe56e057f20f883e','yanghe43','蓝宇才','','43','1','15676271158','0','0','0','','0','6','1','0','0','113','0','0','0','0','0','628','1','');

