CREATE TABLE `stcms_admin` (
  `admin_id` int(10) NOT NULL auto_increment,
  `admin_name` varchar(15) NOT NULL,
  `admin_password` varchar(16) NOT NULL,
  `admin_right` varchar(255) NOT NULL,
  `admin_email` varchar(50) NOT NULL,
  `admin_qq` varchar(12) NOT NULL,
  `admin_comment` varchar(255) NOT NULL,
  PRIMARY KEY  (`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_article` (
  `article_id` int(11) NOT NULL auto_increment,
  `article_sort_id` int(255) NOT NULL,
  `article_title` varchar(255) NOT NULL,
  `article_content` longtext,
  `article_author` varchar(255) NOT NULL,
  `article_source` varchar(255) NOT NULL,
  `article_add_time` varchar(255) NOT NULL,
  `article_add_user` varchar(255) NOT NULL,
  `article_hit` int(255) NOT NULL default '0',
  `article_is_recommend` int(255) NOT NULL default '0',
  `article_is_top` int(255) NOT NULL default '0',
  `article_is_locked` int(255) NOT NULL default '0',
  PRIMARY KEY  (`article_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_channel` (
  `channel_id` int(11) NOT NULL auto_increment,
  `channel_name` varchar(255) NOT NULL,
  `channel_order` int(255) NOT NULL default '0',
  `channel_hit` int(255) NOT NULL default '0',
  PRIMARY KEY  (`channel_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_file` (
  `file_id` int(11) NOT NULL auto_increment,
  `file_name` varchar(255) NOT NULL,
  `file_url` varchar(255) NOT NULL,
  `file_size` varchar(255) default NOT NULL,
  `file_extention` varchar(255) NOT NULL,
  `file_add_time` varchar(255) NOT NULL,
  `file_add_user` varchar(255) NOT NULL,
  PRIMARY KEY  (`file_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_fsite` (
  `site_id` int(11) NOT NULL auto_increment,
  `site_name` varchar(255) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `site_logo` varchar(255) NOT NULL,
  `site_comment` longtext NOT NULL,
  PRIMARY KEY  (`site_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_gbook` (
  `gbook_id` int(11) NOT NULL auto_increment,
  `gbook_guest` varchar(255) NOT NULL,
  `gbook_email` varchar(255) NOT NULL,
  `gbook_title` varchar(255) NOT NULL,
  `gbook_content` longtext NOT NULL,
  `gbook_add_time` varchar(255) NOT NULL,
  `gbook_reply_user` varchar(255) NOT NULL,
  `gbook_reply_time` varchar(255) NOT NULL,
  `gbook_reply_content` longtext NOT NULL,
  PRIMARY KEY  (`gbook_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_log` (
  `log_id` int(11) NOT NULL auto_increment,
  `log_admin_name` varchar(255) NOT NULL,
  `log_msg` varchar(255) NOT NULL,
  `log_time` varchar(255) NOT NULL,
  PRIMARY KEY  (`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_news` (
  `news_id` int(11) NOT NULL auto_increment,
  `news_title` varchar(255) NOT NULL,
  `news_content` longtext,
  `news_add_user` varchar(255) NOT NULL,
  `news_add_time` varchar(255) NOT NULL,
  `news_hit` int(255) NOT NULL default '0',
  PRIMARY KEY  (`news_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_sort` (
  `sort_id` int(11) NOT NULL auto_increment,
  `sort_channel_id` int(255) NOT NULL,
  `sort_name` varchar(255) NOT NULL,
  `sort_order` int(255) NOT NULL default '0',
  `sort_hit` int(255) NOT NULL default '0',
  PRIMARY KEY  (`sort_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8<{|}>

CREATE TABLE `stcms_comment` (
  `id` int(11) NOT NULL auto_increment,
  `guest` varchar(255) NOT NULL,
  `content` longtext,
  `mail` varchar(255) NOT NULL,
  `qq` int(11) NOT NULL,
  `time` datetime NOT NULL,
  `type` int(11) NOT NULL,
  `typeid` int(11) NOT NULL,
  `ip` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8<{|}>

