<?php
/**
* ļĿ¼
*
* һĿ¼ļб飬һļбһĿ¼б
* ʹò Lock  BaseDir Ŀ¼
* 
* @author  @@ <hubin999421@gmail.com>
* @copyright http://www.ppframe.com
* @version $id
*/

class FileManager {
	/**
	 * ļĿ¼
	 *
	 * @var string $BaseDir
	 */
	var $BaseDir;
	/**
	 * ǰҪ/ļ
	 *
	 * @var string $File
	 */
	var $File;
	/**
	 * Ŀ¼Ŀ¼ΪĿ¼
	 *
	 * @var string $Dir
	 */
	var $Dir;
	/**
	 * Ŀ¼Ŀ¼ΪĿ¼ڸĿ¼ $BaseDir
	 *
	 * @var unknown_type
	 */
	var $XDir;
	/**
	 * Ŀ¼б
	 *
	 * @var array $DirData
	 * @access  private
	 */
	var $DirData=array();
	/**
	 * ļб
	 *
	 * @var array $FileData
	 * @access  private
	 */
	var $FileData=array();
	/**
	 * ĵĿ¼׼
	 *
	 * @var bool $Lock ǷĿ¼־
	 * @access  private
	 */
	var $Lock = true;
	/**
	 * Ŀ¼Сļ,0,1ظĿ¼ļĴС.
	 *
	 * @var bool
	 */
	var $DirSizeLvel = 0;
	/**
	 * PHP5캯ָһ趨Ŀ¼
	 *
	 * @param string $dir òʹ realpath 
	 */
	function __construct($dir="") {
		if($dir) {
			$this->SetBaseDir($dir);
		}else {
			$this->SetBaseDir(ROOT);
		}
	}
	/**
	 * PHP4캯ֱʹPHP5캯
	 *
	 * @param string $dir òʹ realpath 
	 */
	function FileManager($dir="") {
		$this->__construct($dir);
	}
	/**
	 * ļĿ¼
	 *
	 * @param string $basedir Ŀ¼ʹrealpath
	 * @access private
	 */
	function SetBaseDir($basedir) {
		$this->BaseDir = realpath($basedir);
	}
	/**
	 * ļǰĿ¼
	 *
	 * @param string $dir Ŀ¼ʹrealpath˸Ŀ¼Ŀ¼ֲڸĿ¼½óɿĿ¼
	 * @access private
	 */
	function SetDir($dir) {
		$this->Dir = realpath($this->BaseDir."/".$dir."/");
		$this->XDir = str_replace($this->BaseDir,'',$this->Dir)."/";
		$this->XDir = str_replace('\\','/',$this->XDir);
		$this->XDir = ereg_replace("\/{2,}","/",$this->XDir);
		if($this->Lock) {
			if(!preg_match("|".addslashes($this->BaseDir)."|i",$this->Dir)) {
				$this->Dir = $this->BaseDir;
				$this->XDir = '';
			}
		}
		$dir = str_replace('\\','/',str_replace($this->BaseDir,'',$this->Dir));
//		$this -> XDir = $this->EncodeDir($this->XDir);
	}
	/**
	 * òǰļĿ¼ļұȶԵȡ߶Եǰļв
	 *
	 * @param string $file ļļȫ·
	 * @access private
	 */
	function SetFile($file) {
		if(!$file) return ;
		if($this->Dir) {
			$this->File = realpath($this->Dir."/".$file);
			!file_exists($this->File) && $this->File = null;
		}
		else $this->File = null;
	}
	/**
	 * ǷļĿ¼úScan ֮ǰ
	 *
	 * @param bool $lock
	 * @access private
	 */
	function EnableLock($lock=true) {
		if($lock) $this->Lock = true;
		else $this->Lock = false;
	}
	/**
	 * ɨһĿ¼øĿ¼µļбĿ¼б
	 * 
	 * 
	 * @see SetDir()
	 * @param string $dir @see SetDir() Ŀ¼!
	 * @param string $file @see SetFile()
	 * @access private
	 * @todo ļ,˵ϵͳļ
	 */
	function Scan($dir='',$file=null) {
		$this->SetDir($dir);
		$this->SetFile($file);
		if(!is_dir($this->Dir)) return ;
		$dh = opendir($this->Dir);
		while (false !== ($filename = readdir($dh))) {
			//ļĿ¼
			if(ereg('^\.',$filename) && $filename!='..') continue;
			if(ereg('^_',$filename)) continue;
			//ļĿ¼
			if(is_dir($this->Dir.'/'.$filename)){
				if($this->Dir == $this->BaseDir && $filename=='..') continue;
				$this->DirData[] = array(
					'name' => $filename,
					'usesize' => $this->DirSize($filename),
				);
			}else {
				//ļ
				
				//ļ
				$this->FileData[] = array(
					'name' => $filename,
					'size' => sprintf("%.3f",filesize($this->Dir.'/'.$filename)/1024),
					'mtime' => strftime("%y-%m-%d %H:%M:%S",filemtime($this->Dir.'/'.$filename)),
					'text' => ereg('(.php|.txt|.htm|.html|.tpl)$',$filename) && 'text',
				);
			}
		}
		is_resource($dh) && closedir($dh);
	}
	/**
	 * 㼶Ŀ¼ļռÿռС λ KB
	 *
	 * @param string $dir
	 * @return float
	 */
	function DirSize($dir) {
		if($dir=='..') return 0;
		if(!$this->DirSizeLvel) return 0;
		else if($this->DirSizeLvel) return $this->EasyDirSize($dir);
	}
	/**
	 * ݹļһĿ¼µļܴС KB.ѷ
	 * 
	 * @param string $dir
	 * @return float
	 */
	function HardDirSize($dir) {
		$fm = new FileManager($this->Dir.'/'.$dir);
		$fm -> DirSizeLvel = true;
		$root = '';
		$fm -> Scan($root);
		$rval = 0;
		if(is_array($fm->FileData)){
			foreach ($fm->FileData as $v) {
				$rval += $v['size'];
			}
		}
		//Scan ݹµøú
		if(is_array($fm->DirData)) {
			foreach ($fm->DirData as $v) {
				$rval += $v['size'];
			}
		}
		return $rval;
	}
	/**
	 * ݹķһĿ¼µļСܺ,KB
	 * 
	 * @param string $dir
	 * @return float
	 */
	function EasyDirSize($dir) {
		$fm = new FileManager($this->Dir.'/'.$dir);
		$fm -> DirSizeLvel = false;
		$root = '';
		$fm -> Scan($root);
		$rval = 0;
		if(is_array($fm->FileData)){
			foreach ($fm->FileData as $v) {
				$rval += $v['size'];
			}
		}
		//Scan ݹµøú
		if(is_array($fm->DirData)) {
			foreach ($fm->DirData as $v) {
				$rval += $v['size'];
			}
		}
		return $rval;
	}
	/**
	 * һļļ
	 *
	 * @param string $oldname ļĿ¼
	 * @param string $newname ļĿ¼
	 * @return bool
	 * @access public
	 */
	function Rename($oldname,$newname) {
		if (empty($oldname) || empty($newname) || !file_exists($oldname)) {
			return false;
		}
		return @rename($oldname,$newname);
	}
	/**
	 * ɾһļĿ¼ԶжļĿ¼
	 *
	 * @param string $file ļĿ¼
	 * @return bool
	 * @access public
	 */
	function Delete($file="") {
		if(!$file) return false;
		if(is_file($file) && file_exists($file)) return @unlink($file);
		if(is_dir($file)) return @rmdir($file);
	}
	/**
	 * ȡһļΪսĬ϶ȡǰļ ::File
	 * ļڣؿִ
	 *
	 * @param string $file ļ
	 * @return string
	 * @access public
	 */
	function View($file="") {
		empty($file) && $file = $this->File;
		if(!file_exists($file)) return "";
		return readfile($file);
	}
	/**
	 * ༭һļɹ򷵻true򷵻false
	 * ļڽԴ֮
	 *
	 * @param string $str ĵַ
	 * @param string $file ļĬϵǰļ::File @see SetFile()
	 * @return bool
	 */
	function Edit($str,$file="") {
		empty($file) && $file = $this->File;
		$hd = fopen($file,'wb');
		@flock($hd,LOCK_EX);
		$rt = fwrite($hd,$str);
		@flock($hd,LOCK_UN);
		fclose($hd);
		return !($rt===false);
	}
	/**
	 * һĿ¼·URLENCODE׼ǰ.
	 * ԱĳЩ֧URL500.
	 *
	 * @param string $url
	 * @return unknown
	 */
	function EncodeDir($url) {
		if(!$url) return '';
		if($url=='/') return '/';
		$urls = explode('/',$url);
		foreach ($urls as $key => $value) {
			if($value) $urls[$key] = urlencode($value);
			else $urls[$key] = '';
		}
		$url = implode('/',$urls);
		return $url;
	}
}
?>