<?php
/**
* 溯
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id: cache.func.php 14 2008-10-12 03:34 $
*/
!defined('IN_MUDDER') && exit('Access Denied');

function cache_inputlimit() {
	global $db, $dbpre;

	$row = $db->get_value("SELECT value FROM {$dbpre}config WHERE variable='inputlimit'");
    if(!$row) return;
    $inputlimit = unserialize($row);
    if(!$inputlimit) {
        unset($inputlimit);
        return;
    } else {
        extract($inputlimit, EXTR_SKIP);
        $contents = '';
        $contents .= "var inputlimit_review_min = {$review['min']}; \r\n";
        $contents .= "var inputlimit_review_max = {$review['max']}; \r\n";
        $contents .= "var inputlimit_respond_min = {$respond['min']}; \r\n";
        $contents .= "var inputlimit_respond_max = {$respond['max']};";

        write_cache('inputlimit', $contents, 'js');
    }
}

function cache_config() {
	global $db, $dbpre;

    $without_arr = array(
        'batchmsg', 'regrule'
    );
    $where = "WHERE variable NOT IN ('".implode("','", $without_arr)."')";
	$query = $db->query("SELECT variable, value FROM {$dbpre}config $where ORDER BY variable");
    $serialize_arr = array(
        'auditing', 'cache', 'cache_num', 'expleve','picture_thumb', 'space',
        'seccode', 'membercard', 'jstransfer', 'passport', 'exchange',
        'inputlimit', 'search', 'googlesearch', 'rewrite', 'video', 'mail', 'outextcredits', 'coupon',
    );
    $result = array();
    while ($config = $db->fetch_array($query)) {
        if(in_array($config['variable'], $serialize_arr)) {
            $config['value'] = @unserialize($config['value']);
        }
        $result[$config['variable']] = $config['value'];
    }

    $contents = "\$_config = ".arrayeval($result).";";

	write_cache('config', $contents);
}

function cache_panels() {
    global $db, $dbpre;

    $query = $db->query("SELECT cid,classname,classcode,config FROM {$dbpre}classcode WHERE classsort=1 ORDER BY classorder");
    $contents = "\$_panels = array(\r\n";
    $option = "\$_panels_option = \r\n";
    $config = "\$_panel_config = array(\r\n";
    while($panelcode = $db->fetch_array($query)) {
        $contents .= "\t'".$panelcode['classcode']."' => '".add_cs_lashes($panelcode['classname'])."',\r\n";
        $uz_config = unserialize($panelcode['config']);
        if($uz_config['suitplaces']) {
            $uz_config['suitplaces'] = html_special_chars(explode("\r\n",$uz_config['suitplaces']));
        }
        $config .= "'{$panelcode['classcode']}' => ".var_export($uz_config, true).",\r\n";
        $option .= "\t'<option value=\"{$panelcode['classcode']}\">".add_cs_lashes($panelcode['classname'])."</option>'.\"\\r\\n\".\r\n";
    }
	$contents .= ");\r\n\n";
    $option .= "'';\r\n\n";
    $config .= ');';
	write_cache('panels', $contents.$option.$config);
}

function cache_areacode() {
    global $db, $dbpre;

    $query = $db->query("SELECT areacode,areaname,default_mappoint,areasort FROM {$dbpre}areacode");
    $contents = "\$_areacodes = array(\r\n";
	while ($areacode = $db->fetch_array($query)) {
		$contents.="\t'".$areacode['areacode']."' => '".add_cs_lashes($areacode['areaname'])."',\r\n";
        $default_mappoints[$areacode['areacode']] = $areacode['default_mappoint'];
        if($areacode['areasort'] == 1) {
            $citys[] = $areacode;
        } elseif($areacode['areasort'] == 2) {
            $boroughs[] = $areacode;
        } elseif($areacode['areasort'] == 3) {
            $streets[] = $areacode;
        }
	}
	$contents .= ");\r\n";

    if($boroughs) {
        $contents .= "\$_boroughs = array(\r\n";
        foreach($boroughs as $val) {
            $contents.="\t'".$val['areacode']."' => '".add_cs_lashes($val['areaname'])."',\r\n";
        }
        $contents .= ");\r\n";
    }

    if($streets) {
        foreach($streets as $val) {
            $contents .= "\$_streets['".substr($val['areacode'],0,4)."']['".$val['areacode']."'] = '".add_cs_lashes($val['areaname'])."';\r\n";
        }
        $contents .= "\r\n";
    }

    if($default_mappoints) {
        $contents .= "\$_default_mappoints = array(\r\n";
        foreach($default_mappoints as $key => $val) {
            $contents.="\t'".$key."' => '".add_cs_lashes($val)."',\r\n";
        }
        $contents .= ");\r\n";
    }

    if($citys) foreach($citys as $city) {
        $contents .= "\$_areacode_option['{$city['areacode']}'] = \r\n";
        if($boroughs) foreach($boroughs as $borough) {
            if(substr($borough['areacode'], 0, 2) == $city['areacode']) {
                $contents .= "\t'<option value=\"{$borough['areacode']}\">".add_cs_lashes($borough['areaname'])."</option>'.\"\\r\\n\".\r\n";
            }
            if($streets) foreach($streets as $street) {
                if(substr($street['areacode'], 0, 4) == $borough['areacode']) {
                    $contents .= "\t'<option value=\"{$street['areacode']}\">&nbsp;-".add_cs_lashes($street['areaname'])."</option>'.\"\\r\\n\".\r\n";
                }
            }
        }
        $contents .= "'';\r\n\r\n";
    }
	write_cache('areacode', $contents);
}

function cache_classcode() {
    global $db, $dbpre, $_config;

    $orderby = $_config['classorder'] == 'total' ? 'total DESC' : 'classorder';
    $query = $db->query("SELECT cid,classcode,classname,classsort,total FROM {$dbpre}classcode ORDER BY $orderby");
    $contents = "\$_classcodes = array(\r\n";
	while ($classcode = $db->fetch_array($query)) {
        $contents .= "\t'{$classcode['classcode']}' =>\r\n".
            "\tarray ( \r\n".
                "\t\t'cid' => '".$classcode['cid']."',\r\n".
                "\t\t'classname' => '".add_cs_lashes($classcode['classname'])."',\r\n".
            "\t),\r\n";
        if($classcode['classsort'] == 1) {
            $panels[] = $classcode;
        } elseif($classcode['classsort'] == 2) {
            $classes[] = $classcode;
        }
	}
	$contents .= ");\r\n\r\n";

    if($classes) {
        foreach($classes as $val) {
            $contents .= "\$_classes['".substr($val['classcode'],0,2)."']['".$val['classcode']."'] = '".$val['classname']."';\r\n";
        }
        $contents .= "\r\n";
    }

    if($panels) foreach($panels as $panel) {
        $contents .= "\$_classcode_option['{$panel['classcode']}'] = \r\n";
        if($classes) foreach($classes as $class) {
            if(substr($class['classcode'], 0, 2) == $panel['classcode']) {
                $contents .= "\t'<option value=\"{$class['classcode']}\">".add_cs_lashes($class['classname'])."</option>'.\"\\r\\n\".\r\n";
            }
        }
        $contents .= "'';\r\n";
    }
    write_cache('classcode', $contents);
}

function cache_webtotal() {
    global $db,$dbpre;

    $_webtotal = array();
    $_webtotal['totalmember'] = $db->get_value("SELECT COUNT(*) FROM {$dbpre}members");
    $_webtotal['totalshop'] = $db->get_value("SELECT COUNT(*) FROM {$dbpre}shops");
    $_webtotal['totalreview'] = $db->get_value("SELECT COUNT(*) FROM {$dbpre}reviews");
    $_webtotal['totalrespond'] = $db->get_value("SELECT COUNT(*) FROM {$dbpre}responds");

    $contents = "\$_webtotal = \r\n".arrayeval($_webtotal);
    write_cache('webtotal', $contents);
}

function cache_templates() {
    global $db,$dbpre;

    $query = $db->query("SELECT * FROM {$dbpre}templates ORDER BY tpltype,templateid");
    $contents = '';
    while($row = $db->fetch_array($query)) {
        $contents .= "\$_templates['{$row['tpltype']}']['{$row['templateid']}'] = ".arrayeval($row).";\r\n";
    }
    write_cache('templates', $contents);
}

function cache_usergroups() {
    global $db, $dbpre;

    $query = $db->query("SELECT groupid,groupname FROM {$dbpre}usergroups");
    $contents = "\$_usergroups = array(\r\n";
    $option = "\$_usergroups_option = \r\n";
    while($usergroup = $db->fetch_array($query)) {
        $contents .= "\t'".$usergroup['groupid']."' => '".add_cs_lashes($usergroup['groupname'])."',\r\n";
        $option .= "'<option value=\"{$usergroup['groupid']}\">".add_cs_lashes($usergroup['groupname'])."</option>'.\"\\r\\n\".\r\n";
    }
	$contents .= ");\r\n\r\n";
    $option .= "'';\r\n";
	write_cache('usergroups', $contents.$option);
}

function cache_userranks() {
    global $db, $dbpre;

    $query = $db->query("SELECT rankid,rankname,point FROM {$dbpre}userranks ORDER BY point DESC");
    $contents = "\$_userranks = array(\r\n";
    $i = 1;
    while($userrank = $db->fetch_array($query)) {
        $contents .= "\t'$i' =>\r\n".
            "\tarray ( \r\n".
                "\t\t'point' => '".$userrank['point']."',\r\n".
                "\t\t'rankname' => '".add_cs_lashes($userrank['rankname'])."',\r\n".
            "\t\t),\r\n";
        $i++;
    }
	$contents .= ");\r\n";
	write_cache('userranks', $contents.$option);
}

function cache_faces() {

    if ($handle = opendir(MUDDER_ROOT.'images/faces')) {
        while (false !== ($file = readdir($handle))) {
            if (preg_match('/^(.+?).(gif|jpg|png|jpeg)$/ie', $file, $name)) {
                $faces[] = html_special_chars_ex($name[0]);
            }
        }
        closedir($handle);
    } else {
        $faces = array('noface.gif');
    }

    $contents = "\$_faces = ".arrayeval($faces).";\r\n";
	write_cache('faces', $contents);
}

function cache_plugins() {
    global $db, $dbpre;

    $query = $db->query("SELECT * FROM {$dbpre}plugins WHERE available=1 ORDER BY orders DESC");
    $result = array();
    while($row = $db->fetch_array($query)) {
        $row['actionlist'] = $row['actionlist'] ? @unserialize($row['actionlist']) : '';
        $row['menu'] = $row['menu'] ? @unserialize($row['menu']) : '';
        $row['config'] = $row['config'] ? @unserialize($row['config']) : '';
        $result[$row['module']] = $row;
    }
    $contents = "\$_plugins = ".arrayeval($result).";";
	write_cache('plugins', $contents);
}

function cache_datacall() {
    global $db, $dbpre;

    $query = $db->query("SELECT * FROM {$dbpre}datacall WHERE closed=0 ORDER BY callid");
    $result = array();
    while($row = $db->fetch_array($query)) {
        $row['expression'] = empty($row['expression'])?'':unserialize($row['expression']);
        $result[$row['callid']] = $row;
    }
    $contents = "\$_datacall = ".arrayeval($result).";";
	write_cache('datacall', $contents);
}

function cache_filters() {
    global $db, $dbpre;

    $query = $db->query("SELECT * FROM {$dbpre}words");
    $result = $filter = $block = $check = array();
    while($row = $db->fetch_array($query)) {
        if($row['expression'] == '{CHECK}') {
            $check[] = $row['keyword'];
        } elseif($row['expression'] == '{BLOCK}') {
            $block[] = $row['keyword'];
        } else {
            $filter['search'][] = "/".$row['keyword']."/i";
            $filter['replace'][] = str_replace("'","\'",$row['expression']);
        }
    }
    $result['filter'] = $filter;
    $result['block'] = $block ? "/(".implode('|',$block).")/i" : '';
    $result['check'] = $check ? "/(".implode('|',$check).")/i" : '';
    $contents = "\$_filters = ".arrayeval($result).";";
	write_cache('filters', $contents);
}

function cache_modules() {
    global $db, $dbpre, $_config;

    if(!$_config['siteurl']) {
        $siteurl = $db->get_value("SELECT value FROM {$dbpre}config WHERE variable='siteurl'");
        $siteurl = $siteurl.(substr($siteurl,-1) != '/' ? '/' : '');
    } else {
        $siteurl = $_config['siteurl'];
    }
        $result = array();
    $query = $db->query("SELECT flag,name,directory FROM {$dbpre}modules WHERE disable=0");
    while($row = $db->fetch_array($query)) {
        $row['url'] = $siteurl.$row['directory'].'/';
        $result[$row['flag']] = $row;
    }
    $contents = "\$_modules = ".arrayeval($result).";";
	write_cache('modules', $contents);
}

function cache_module($flag) {
    global $db, $dbpre;

    if(!$flag) return;
    $siteurl = $db->get_value("SELECT value FROM {$dbpre}config WHERE variable='siteurl'");
    $siteurl = $siteurl.(substr($siteurl,-1) != '/' ? '/' : '');
    $result = array();
    $query = $db->query("SELECT moduleid,flag,name,directory,disable,config FROM {$dbpre}modules WHERE flag='$flag'");
    while($row = $db->fetch_array($query)) {
        $row['url'] = $siteurl.$row['directory'].'/';
        $config = $row['config'] ? unserialize($row['config']) : array();
        !is_array($config) && $config = array();
        unset($row['config']);
        $result = array_merge($row, $config);
    }
    !empty($result) && $db->free_result($query);
    $contents = "return ".arrayeval($result).";";

	write_cache($flag.'_config', $contents);
}

function cache_menus() {
    global $db, $dbpre, $_modules;

    $siteurl = $db->get_value("SELECT value FROM {$dbpre}config WHERE variable='siteurl'");
    $siteurl = $siteurl.(substr($siteurl,-1) != '/' ? '/' : '');
    $result = array();
    $query = $db->query("SELECT * FROM {$dbpre}menus WHERE isclosed=0 ORDER BY flag,listorder,menuid");
    $search = array('{SITE}');
    $replace = array($siteurl);
    if(empty($_modules)) { require MUDDER_ROOT.'/data/cachefiles/cache_modules.php'; }
    if(is_array($_modules)) foreach($_modules as $value) {
        $search[] = '{'.$value['flag'].'-name}';
        $replace[] = $value['name'];
        $search[] = '{'.$value['flag'].'-url}';
        $replace[] = $value['url'];
    }
    while($row = $db->fetch_array($query)) {
        foreach($row as $key => $val) {
            $row[$key] = str_replace($search,$replace,$val);
        }
        $result[$row['flag']][$row['menuid']] = $row;
    }
    $db->free_result($query);
    $contents = "\$_menus = ".arrayeval($result).";";
	write_cache('menus', $contents);
}

function cache($file, $parma = '') {

    $fun = 'cache_'.$file;
    if(empty($parmas)) {
        $fun();
    } else {
        $fun($parma);
    }
}

function cache_all() {
    $cachenames = array(
        'config', 'panels', 'areacode', 'classcode', 'templates', 'usergroups', 'userranks', 'faces',
        'webtotal', 'inputlimit', 'plugins', 'datacall', 'filters', 'modules','menus',
    );
    foreach($cachenames as $cachename) {
        cache($cachename);
    }
}

/////////////
function updateCache($fname) {
    $fun = 'update_'.$fname;
    $fun();
}

function update_webtotal() {
    global $_webtotal;
    write_cache('webtotal', "\$_webtotal = \r\n".arrayeval($_webtotal));
}

function update_config() {
    global $_config;
    write_cache('config', "\$_config = \r\n".arrayeval($_config));
}
?>