<?php
namespace CSSTidy;

class Container
{
    /** @var object[] */
    protected $services = array();

    /**
     * Service definition
     */
    public function __construct()
    {
        $cont = $this;
        $this->services = array(
            'logger' => function() {
                require_once __DIR__ . '/Logger.php';
                return new Logger;
            },
            'configuration' => function() {
                require_once __DIR__ . '/Configuration.php';
                return new Configuration;
            },
            'parser' => function() use ($cont) {
                require_once __DIR__ . '/Parser.php';
                return new Parser(
                    $cont->logger,
                    $cont->configuration->getDiscardInvalidProperties(),
                    $cont->configuration->getCssLevel(),
                    $cont->configuration->getRemoveBackSlash()
                );
            },
            'selectorManipulate' => function() {
                require_once __DIR__ . '/SelectorManipulate.php';
                return new SelectorManipulate;
            },
            'sorter' => function() {
                require_once __DIR__ . '/Sorter.php';
                return new Sorter;
            },
            'optimiseValue' => function() use ($cont) {
                require_once __DIR__ . '/optimise/Value.php';
                return new \CSSTidy\Optimise\Value(
                    $cont->logger,
                    $cont->configuration,
                    $cont->optimiseColor,
                    $cont->optimiseNumber
                );
            },
            'optimiseColor' => function() use($cont) {
                require_once __DIR__ . '/optimise/Color.php';
                return new \CSSTidy\Optimise\Color($cont->logger, $cont->optimiseNumber);
            },
            'optimiseNumber' => function() use($cont) {
                require_once __DIR__ . '/optimise/Number.php';
                return new \CSSTidy\Optimise\Number($cont->logger, $cont->configuration->getConvertUnit());
            },
            'optimiseShorthand' => function() use($cont) {
                require_once __DIR__ . '/optimise/Shorthand.php';
                return new \CSSTidy\Optimise\Shorthand($cont->configuration->getOptimiseShorthands());
            },
            'optimiseLineAt' => function() use($cont) {
                require_once __DIR__ . '/optimise/LineAt.php';
                return new \CSSTidy\Optimise\LineAt($cont->logger);
            },
            'optimiseSelector' => function() use($cont) {
                require_once __DIR__ . '/optimise/Selector.php';
                return new \CSSTidy\Optimise\Selector($cont->logger);
            },
        );
    }

    /**
     * @param string $name
     * @return object
     * @throws \Exception
     */
    public function __get($name)
    {
        if (isset($this->services[$name])) {
            return $this->$name = $this->services[$name]();
        }

        throw new \Exception("Service with name '$name' not exists");
    }

    /**
     * @param string $name
     * @param object $value
     * @throws \Exception
     */
    public function __set($name, $value)
    {
        if (!is_object($value)) {
            throw new \Exception("Service '$name' must be object");
        }

        $this->$name = $value;
    }
}