<?php

namespace CSSTidy;

class Logger
{
    const MESSAGE = 'm',
        TYPE = 't';

    // Constants for log type
    const ERROR = 'Error',
        WARNING = 'Warning',
        INFORMATION = 'Information';

    /** @var array */
    protected $log = array();

    /**
     * Add a message to the message log
     * @param string $message
     * @param string $type
     * @param integer $line
     */
    public function log($message, $type, $line = ' ')
    {
        $add = array(self::MESSAGE => $message, self::TYPE => $type);
        if (!isset($this->log[$line]) || !in_array($add, $this->log[$line])) {
            $this->log[$line][] = $add;
        }
    }

    /**
     * @return array
     */
    public function getMessages()
    {
        return $this->log;
    }
}
?>