<?php

namespace CSSTidy;

class Template
{
    /** @var string */
    public $beforeAtRule;

    /** @var string */
    public $atRuleClosingBracket;

    /** @var string */
    public $indentInAtRule;

    /** @var string */
    public $lastLineInAtRule;

    /** @var string */
    public $bracketAfterAtRule;

    /** @var string */
    public $beforeSelector;

    /** @var string */
    public $selectorOpeningBracket;

    /** @var string */
    public $beforeProperty;

    /** @var string */
    public $beforeValue;

    /** @var string */
    public $afterValueWithSemicolon;

    /** @var string */
    public $selectorClosingBracket;

    /** @var string */
    public $spaceBetweenBlocks;

    /** @var string */
    public $beforeComment;

    /** @var string */
    public $afterComment;

    /**
     * Returns template clone without HTML tags for plain output
     * @return Template
     */
    public function getWithoutHtml()
    {
        $return = clone $this;
        foreach ($return as &$value) {
            $value = strip_tags($value);
        }

        return $return;
    }

    /**
     * Convert string template separated with '|' character to instance of Template class
     *
     * @static
     * @param string $content
     * @return Template
     * @throws \Exception
     */
    public static function loadFromString($content)
    {
        $content = strip_tags($content, '<span>');
        $content = str_replace("\r\n", "\n", $content); // Unify newlines (because the output also only uses \n)
        $parts = explode('|', $content);

        if (count($parts) !== 14) {
            throw new \Exception("Template must contains 14 parts");
        }

        $template = new self;
        $template->beforeAtRule = $parts[0];
        $template->bracketAfterAtRule = $parts[1];
        $template->beforeSelector = $parts[2];
        $template->selectorOpeningBracket = $parts[3];
        $template->beforeProperty = $parts[4];
        $template->beforeValue = $parts[5];
        $template->afterValueWithSemicolon = $parts[6];
        $template->selectorClosingBracket = $parts[7];
        $template->spaceBetweenBlocks = $parts[8];
        $template->atRuleClosingBracket = $parts[9];
        $template->indentInAtRule = $parts[10];
        $template->beforeComment = $parts[11];
        $template->afterComment = $parts[12];
        $template->lastLineInAtRule = $parts[13];

        return $template;
    }
}